/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskListModel
extends AbstractTableModel
implements TaskList.Listener {
    protected TaskList list;
    protected static final int COL_GROUP = 0;
    protected static final int COL_DESCRIPTION = 1;
    protected static final int COL_FILE = 2;
    protected static final int COL_LOCATION = 4;
    protected static final int COL_LINE = 3;
    protected int sortingCol = -1;
    protected boolean ascending = true;

    public TaskListModel(TaskList taskList) {
        this.list = taskList;
        this.sortingCol = Settings.getDefault().getSortingColumn();
        this.ascending = Settings.getDefault().isAscendingSort();
        this.sortTaskList();
    }

    @Override
    public int getRowCount() {
        return null == this.list ? 0 : this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (0 == n) {
            return TaskGroup.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Description");
            }
            case 2: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_File");
            }
            case 4: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Location");
            }
            case 3: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Line");
            }
        }
        return super.getColumnName(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Task task = this.getTaskAtRow(n);
        if (null != task) {
            switch (n2) {
                case 0: {
                    return Accessor.getGroup(task);
                }
                case 1: {
                    return Accessor.getDescription(task);
                }
                case 2: {
                    FileObject fileObject = Accessor.getResource(task);
                    if (null == fileObject || fileObject.isFolder()) {
                        return null;
                    }
                    return fileObject.getNameExt();
                }
                case 4: {
                    FileObject fileObject = Accessor.getResource(task);
                    if (null == fileObject || fileObject.isFolder()) {
                        return FileUtil.getFileDisplayName((FileObject)fileObject);
                    }
                    return FileUtil.getFileDisplayName((FileObject)fileObject.getParent());
                }
                case 3: {
                    int n3 = Accessor.getLine(task);
                    return n3 > 0 ? String.valueOf(n3) : null;
                }
            }
        }
        return null;
    }

    protected Task getTaskAtRow(int n) {
        return this.list.getTask(n);
    }

    @Override
    public void tasksAdded(List<? extends Task> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = this.list.indexOf(list.get(0));
        int n2 = this.list.indexOf(list.get(list.size() - 1));
        this.fireTableRowsInserted(n, n2);
    }

    @Override
    public void tasksRemoved(List<? extends Task> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = this.list.indexOf(list.get(0));
        int n2 = this.list.indexOf(list.get(list.size() - 1));
        this.fireTableRowsDeleted(n, n2);
    }

    @Override
    public void cleared() {
        this.fireTableDataChanged();
    }

    public void toggleSort(int n) {
        if (n != this.sortingCol) {
            this.sortingCol = n;
            this.ascending = true;
        } else if (this.ascending) {
            this.ascending = false;
        } else {
            this.sortingCol = -1;
        }
        this.sortTaskList();
    }

    protected void sortTaskList() {
        Comparator<Task> comparator = null;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLineComparator(this.ascending);
                break;
            }
            case 4: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        this.list.setComparator(comparator);
        Settings.getDefault().setSortingColumn(this.sortingCol);
        Settings.getDefault().setAscendingSort(this.ascending);
        this.fireTableDataChanged();
    }

    public int getSortingColumnn() {
        return this.sortingCol;
    }

    public boolean isAscendingSort() {
        return this.ascending;
    }

    public void setAscendingSort(boolean bl) {
        if (this.sortingCol >= 0) {
            this.ascending = bl;
            this.sortTaskList();
        }
    }

    void attach() {
        this.list.addListener(this);
    }

    void detach() {
        this.list.removeListener(this);
    }
}

