/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

class TypesFilter {
    private Set<String> enabledProviders = new HashSet<String>();
    private int countLimit = 100;

    public TypesFilter() {
        this.addDefaultTypes();
    }

    private TypesFilter(TypesFilter typesFilter) {
        this.countLimit = typesFilter.countLimit;
        this.enabledProviders.addAll(typesFilter.enabledProviders);
    }

    public boolean isEnabled(String string) {
        return this.enabledProviders.contains(string);
    }

    public void setEnabled(String string, boolean bl) {
        if (bl) {
            this.enabledProviders.add(string);
        } else {
            this.enabledProviders.remove(string);
        }
    }

    public boolean isTaskCountLimitReached(int n) {
        return n >= this.countLimit;
    }

    public void setTaskCountLimit(int n) {
        this.countLimit = n;
    }

    public int getTaskCountLimit() {
        return this.countLimit;
    }

    public TypesFilter clone() {
        return new TypesFilter(this);
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        this.countLimit = preferences.getInt(string + "_countLimit", 100);
        this.enabledProviders.clear();
        String string2 = preferences.get(string + "_enabled", "");
        if (string2.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.enabledProviders.add(stringTokenizer.nextToken());
            }
        } else {
            this.addDefaultTypes();
        }
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        preferences.putInt(string + "_countLimit", this.countLimit);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.enabledProviders.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        preferences.put(string + "_enabled", stringBuffer.toString());
    }

    private void addDefaultTypes() {
        this.enabledProviders.add("org.netbeans.modules.java.source.tasklist.JavaTaskProvider");
        this.enabledProviders.add("org.netbeans.modules.tasklist.todo.TodoTaskScanner");
        this.enabledProviders.add("org.netbeans.modules.csl.core.GsfTaskProvider");
    }
}

