/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterUpdateProvider
implements UpdateProvider {
    private static File cluster = null;
    private static Logger LOG = Logger.getLogger(ClusterUpdateProvider.class.getName());
    private static final String ELEMENT_MODULE = "module";

    public static void attachCluster(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cluster cannot be null!");
        }
        cluster = file;
    }

    public String getName() {
        return "ClusterUpdateProvider";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ClusterUpdateProvider.class, (String)"ClusterUpdateProvider_DisplayName", (Object)cluster);
    }

    public String getDescription() {
        return NbBundle.getMessage(ClusterUpdateProvider.class, (String)"ClusterUpdateProvider_Description");
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.STANDARD;
    }

    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        for (File file : ClusterUpdateProvider.readModules(cluster)) {
            String string = file.getName().substring(0, file.getName().length() - ".xml".length()).replaceAll("-", ".");
            HashMap<String, String> hashMap2 = new HashMap<String, String>(7);
            ClusterUpdateProvider.readConfigFile(file, hashMap2);
            File file2 = new File(cluster, (String)hashMap2.get("jar"));
            if (!file2.exists()) {
                LOG.info("Jar file " + file2 + " doesn't exists. Skip checking " + string);
                continue;
            }
            Manifest manifest = new JarFile(file2).getManifest();
            UpdateItem updateItem = UpdateItem.createModule((String)string, (String)((String)hashMap2.get("specversion")), null, (String)cluster.getName(), (String)"0", (String)"", (String)"", (String)"", (Manifest)manifest, (Boolean)Boolean.valueOf((String)hashMap2.get("eager")), (Boolean)Boolean.valueOf((String)hashMap2.get("autoload")), null, null, (String)"", (UpdateLicense)UpdateLicense.createUpdateLicense((String)"unknown-license", (String)"none"));
            hashMap.put(string + '_' + (String)hashMap2.get("specversion"), updateItem);
        }
        return hashMap;
    }

    public boolean refresh(boolean bl) throws IOException {
        return true;
    }

    private static Collection<File> readModules(File file) {
        if (file == null || !file.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        File file2 = new File(new File(file, "config"), "Modules");
        if (file2.listFiles() == null) {
            return Collections.emptySet();
        }
        for (File file3 : file2.listFiles()) {
            if (file3.getName().endsWith(".xml_hidden")) continue;
            assert (file3.getName().endsWith(".xml")) : file3 + " is XML file";
            if (!file3.getName().endsWith(".xml")) continue;
            hashSet.add(file3);
        }
        return hashSet;
    }

    private static void readConfigFile(File file, Map<String, String> map) {
        Object object;
        Document document = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            object = new InputSource(bufferedInputStream);
            document = XMLUtil.parse((InputSource)object, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            LOG.log(Level.WARNING, sAXException.getLocalizedMessage(), sAXException);
            return;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain document element.";
        object = document.getDocumentElement();
        assert (ELEMENT_MODULE.equals(object.getTagName())) : "The root element is: module but was: " + object.getTagName();
        NodeList nodeList = object.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)node;
            String string = element.getAttributes().getNamedItem("name").getNodeValue();
            String string2 = element.getChildNodes().item(0).getNodeValue();
            map.put(string, string2);
        }
    }
}

