/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.progress.ui.ListComponent;
import org.netbeans.modules.progress.ui.NbProgressBar;
import org.netbeans.modules.progress.ui.PopupPane;
import org.netbeans.progress.module.ProgressListAction;
import org.netbeans.progress.spi.InternalHandle;
import org.netbeans.progress.spi.ProgressEvent;
import org.netbeans.progress.spi.ProgressUIWorkerWithModel;
import org.netbeans.progress.spi.TaskModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class StatusLineComponent
extends JPanel
implements ProgressUIWorkerWithModel {
    private NbProgressBar bar;
    private JLabel label;
    private JSeparator separator;
    private InternalHandle handle;
    private boolean showingPopup = false;
    private TaskModel model;
    private MouseListener mouseListener;
    private HideAWTListener hideListener;
    private Popup popup;
    private JWindow popupWindow;
    private PopupPane pane;
    private Map<InternalHandle, ListComponent> handleComponentMap = new HashMap<InternalHandle, ListComponent>();
    private final int prefferedHeight;
    private JButton closeButton;

    public StatusLineComponent() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(1);
        flowLayout.setHgap(5);
        this.setLayout(flowLayout);
        this.mouseListener = new MListener();
        this.addMouseListener(this.mouseListener);
        this.hideListener = new HideAWTListener();
        this.createLabel();
        this.createBar();
        this.bar.setStringPainted(true);
        this.bar.setString("XXX");
        this.label.setText("XXX");
        this.prefferedHeight = Math.max(this.label.getPreferredSize().height, this.bar.getPreferredSize().height) + 2;
        this.discardLabel();
        this.discardBar();
        this.pane = new PopupPane();
        this.pane.getActionMap().put("HidePopup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusLineComponent.this.hidePopup();
            }
        });
        this.pane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
    }

    private void createLabel() {
        this.discardLabel();
        this.label = new JLabel();
        this.label.setCursor(Cursor.getPredefinedCursor(12));
        this.label.addMouseListener(this.mouseListener);
    }

    private void discardLabel() {
        if (this.label != null) {
            this.label.removeMouseListener(this.mouseListener);
            this.label = null;
        }
    }

    private void createBar() {
        this.discardBar();
        this.bar = new NbProgressBar();
        this.bar.setUseInStatusBar(true);
        this.bar.setCursor(Cursor.getPredefinedCursor(12));
        this.bar.addMouseListener(this.mouseListener);
    }

    private void discardBar() {
        if (this.bar != null) {
            this.bar.removeMouseListener(this.mouseListener);
            this.bar = null;
        }
    }

    private void createCloseButton() {
        this.discardCloseButton();
        this.closeButton = new JButton();
        this.closeButton.setBorderPainted(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setOpaque(false);
        this.closeButton.setContentAreaFilled(false);
        Image image = (Image)UIManager.get("nb.progress.cancel.icon");
        if (null != image) {
            this.closeButton.setIcon(new ImageIcon(image));
        }
        if (null != (image = (Image)UIManager.get("nb.progress.cancel.icon.mouseover"))) {
            this.closeButton.setRolloverEnabled(true);
            this.closeButton.setRolloverIcon(new ImageIcon(image));
        }
        if (null != (image = (Image)UIManager.get("nb.progress.cancel.icon.pressed"))) {
            this.closeButton.setPressedIcon(new ImageIcon(image));
        }
        this.closeButton.setToolTipText(NbBundle.getMessage(ListComponent.class, (String)"ListComponent.btnClose.tooltip"));
    }

    private void discardCloseButton() {
        this.closeButton = null;
    }

    private void createSeparator() {
        this.discardSeparator();
        this.separator = new JSeparator(1);
        this.separator.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
    }

    private void discardSeparator() {
        this.separator = null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public void setModel(TaskModel taskModel) {
        this.model = taskModel;
        this.model.addListDataListener((ListDataListener)new Listener());
        this.model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StatusLineComponent.this.pane.updateBoldFont(StatusLineComponent.this.model.getSelectedHandle());
            }
        });
    }

    private void setTooltipForAll() {
        int n = this.model.getSize();
        String string = "NbProgressBar.tooltip1";
        if (n == 1) {
            string = "NbProgressBar.tooltip2";
        }
        String string2 = NbBundle.getMessage(StatusLineComponent.class, (String)string, (Object)new Integer(n));
        this.setToolTipText(string2);
        if (this.label != null) {
            this.label.setToolTipText(string2);
        }
        if (this.bar != null) {
            this.bar.setToolTipText(string2);
        }
    }

    public void processProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0) {
            this.createListItem(progressEvent.getSource());
        } else if (progressEvent.getType() == 1 || progressEvent.getType() == 5 || progressEvent.getType() == 6) {
            ListComponent listComponent = this.handleComponentMap.get(progressEvent.getSource());
            if (listComponent == null) {
                this.createListItem(progressEvent.getSource());
                listComponent = this.handleComponentMap.get(progressEvent.getSource());
            }
            listComponent.processProgressEvent(progressEvent);
        } else if (progressEvent.getType() == 4) {
            this.removeListItem(progressEvent.getSource());
            if (this.model.getSelectedHandle() != null && this.handle != this.model.getSelectedHandle()) {
                ProgressEvent progressEvent2 = this.model.getSelectedHandle().requestStateSnapshot();
                this.initiateComponent(progressEvent2);
                if (progressEvent2.getSource().isInSleepMode()) {
                    this.bar.setString(progressEvent2.getMessage());
                }
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0) {
            this.initiateComponent(progressEvent);
            return;
        }
        if (progressEvent.getType() == 4) {
            this.hidePopup();
            this.removeAll();
            this.discardSeparator();
            this.discardCloseButton();
            this.discardBar();
            this.discardLabel();
            this.revalidate();
            this.repaint();
            return;
        }
        if (progressEvent.getSource() != this.handle || progressEvent.isSwitched() || progressEvent.getType() == 6 || progressEvent.getSource().isInSleepMode() != (this.bar.getClientProperty("sleepy") != null)) {
            this.initiateComponent(progressEvent);
        }
        if (progressEvent.getWorkunitsDone() > 0) {
            this.bar.setValue(progressEvent.getWorkunitsDone());
        }
        this.bar.setString(StatusLineComponent.getBarString(progressEvent.getPercentageDone(), progressEvent.getEstimatedCompletion()));
        if (progressEvent.getDisplayName() != null) {
            this.label.setText(progressEvent.getDisplayName());
        }
        if (progressEvent.getSource().isInSleepMode()) {
            this.bar.setString(progressEvent.getMessage());
        }
    }

    static String formatEstimate(long l) {
        long l2 = l / 60L;
        long l3 = l - l2 * 60L;
        return "" + l2 + (l3 < 10L ? ":0" : ":") + l3;
    }

    static String getBarString(double d, long l) {
        if (l != -1L) {
            return StatusLineComponent.formatEstimate(l);
        }
        if (d != -1.0) {
            int n = (int)Math.round(d);
            if (n > 100) {
                n = 100;
            }
            return "" + n + "%";
        }
        return "";
    }

    private void initiateComponent(ProgressEvent progressEvent) {
        this.handle = progressEvent.getSource();
        boolean bl = false;
        if (this.label == null) {
            this.createLabel();
            this.add(this.label);
            bl = true;
            this.label.setToolTipText(this.getToolTipText());
        }
        this.label.setText(this.handle.getDisplayName());
        if (this.bar == null) {
            this.createBar();
            this.add(this.bar);
            bl = true;
            this.bar.setToolTipText(this.getToolTipText());
        }
        NbProgressBar.setupBar(progressEvent.getSource(), this.bar);
        if (this.closeButton == null) {
            this.createCloseButton();
            this.add(this.closeButton);
            bl = true;
        }
        if (this.separator == null) {
            this.createSeparator();
            this.add(this.separator);
            bl = true;
        }
        if (this.handle.isAllowCancel()) {
            this.closeButton.setAction(new CancelAction(false));
        } else {
            this.closeButton.setAction(new EmptyCancelAction());
        }
        if (bl) {
            this.revalidate();
            this.repaint();
        }
    }

    public void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeComponentListener(this.hideListener);
        this.showingPopup = false;
    }

    private void createListItem(InternalHandle internalHandle) {
        ListComponent listComponent;
        if (this.handleComponentMap.containsKey(internalHandle)) {
            listComponent = this.handleComponentMap.get(internalHandle);
        } else {
            listComponent = new ListComponent(internalHandle);
            this.handleComponentMap.put(internalHandle, listComponent);
        }
        this.pane.addListComponent(listComponent);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    private void removeListItem(InternalHandle internalHandle) {
        this.handleComponentMap.remove(internalHandle);
        this.pane.removeListComponent(internalHandle);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    public void showPopup() {
        if (this.showingPopup) {
            return;
        }
        InternalHandle[] internalHandleArray = this.model.getHandles();
        if (internalHandleArray.length == 0) {
            return;
        }
        this.showingPopup = true;
        if (this.popupWindow == null) {
            this.popupWindow = new JWindow(WindowManager.getDefault().getMainWindow());
            this.popupWindow.getContentPane().add(this.pane);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.hideListener, 16L);
        WindowManager.getDefault().getMainWindow().addWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().addComponentListener(this.hideListener);
        this.resizePopup();
        this.popupWindow.setVisible(true);
        this.pane.requestFocus();
    }

    private void resizePopup() {
        this.popupWindow.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        Dimension dimension = this.popupWindow.getSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n = this.separator != null ? this.separator.getSize().width : 0;
        Point point2 = new Point(point.x + this.getSize().width - dimension.width - n - 10, point.y - dimension.height - 5);
        if (!rectangle.contains(point2)) {
            point2 = new Point(point2.x, point.y + 5 + this.getSize().height);
        }
        this.popupWindow.setLocation(point2);
    }

    private void showMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)new ProgressListAction(NbBundle.getMessage(StatusLineComponent.class, (String)"StatusLineComponent.ShowProcessList")));
        jPopupMenu.add(new ViewAction());
        jPopupMenu.add(new CancelAction(true));
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    private class EmptyCancelAction
    extends AbstractAction {
        public EmptyCancelAction() {
            this.setEnabled(false);
            this.putValue("SmallIcon", new Icon(){

                public int getIconHeight() {
                    return 12;
                }

                public int getIconWidth() {
                    return 12;
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }
            });
            this.putValue("Name", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            this.putValue("Name", NbBundle.getMessage(StatusLineComponent.class, (String)"StatusLineComponent.View"));
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowView());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusLineComponent.this.handle != null) {
                StatusLineComponent.this.handle.requestView();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(boolean bl) {
            if (bl) {
                this.putValue("Name", NbBundle.getMessage(StatusLineComponent.class, (String)"StatusLineComponent.Cancel"));
            } else {
                Image image = (Image)UIManager.get("nb.progress.cancel.icon");
                if (image == null) {
                    image = ImageUtilities.loadImage((String)"org/netbeans/progress/module/resources/buton.png");
                }
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowCancel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InternalHandle internalHandle = StatusLineComponent.this.handle;
            if (internalHandle != null && internalHandle.getState() == 1) {
                String string = NbBundle.getMessage(StatusLineComponent.class, (String)"Cancel_Question", (Object)StatusLineComponent.this.handle.getDisplayName());
                String string2 = NbBundle.getMessage(StatusLineComponent.class, (String)"Cancel_Question_Title");
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, 0, 3, null, null);
                Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
                if (object == NotifyDescriptor.YES_OPTION && internalHandle.getState() == 1) {
                    internalHandle.requestCancel();
                }
            }
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                StatusLineComponent.this.showMenu(mouseEvent);
            } else if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.hidePopup();
            } else {
                StatusLineComponent.this.showPopup();
            }
        }
    }

    private class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getClickCount() > 0) {
                if (!(aWTEvent.getSource() instanceof Component)) {
                    return;
                }
                Component component = (Component)aWTEvent.getSource();
                Container container = SwingUtilities.getAncestorNamed("progresspopup", component);
                Container container2 = SwingUtilities.getAncestorOfClass(StatusLineComponent.class, component);
                if (container == null && container2 == null) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            if (StatusLineComponent.this.showingPopup) {
                int n = windowEvent.getOldState();
                int n2 = windowEvent.getNewState();
                if ((n & 1) == 0 && (n2 & 1) == 1) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }
    }
}

