/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.updateprovider.DownloadListener;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutoupdateCatalogCache {
    private File cacheDir;
    private static AutoupdateCatalogCache INSTANCE;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public static AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
            INSTANCE.initCacheDirectory();
        }
        return INSTANCE;
    }

    private synchronized File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists());
        return this.cacheDir;
    }

    private void initCacheDirectory() {
        assert (this.cacheDir == null) : "Do initCacheDirectory only once!";
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            this.cacheDir = new File(new File(new File(string, "var"), "cache"), "catalogcache");
        } else {
            File file = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            this.cacheDir = new File(file, "catalogcache");
        }
        this.cacheDir.mkdirs();
        this.getLicenseDir().mkdirs();
        this.err.log(Level.FINE, "getCacheDirectory: " + this.cacheDir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL writeCatalogToCache(String string, URL uRL) throws IOException {
        String string2 = string.intern();
        synchronized (string2) {
            File file;
            File file2;
            URL uRL2;
            block8: {
                uRL2 = null;
                file2 = this.getCatalogCache();
                assert (file2 != null && file2.exists()) : "Cache directory must exist.";
                file = new File(file2, string);
                this.copy(uRL, file, false);
                try {
                    uRL2 = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            assert (new File(file2, string).exists()) : "Cache " + file + " exists.";
            this.err.log(Level.FINER, "Cache file " + file + " was wrote from original URL " + uRL);
            if (file.exists() && file.length() == 0L) {
                this.err.log(Level.INFO, "Written cache size is zero bytes");
            }
            return uRL2;
        }
    }

    public synchronized URL getCatalogURL(String string) {
        File file = this.getCatalogCache();
        assert (file != null && file.exists()) : "Cache directory must exist.";
        File file2 = new File(file, string);
        if (file2 != null && file2.exists()) {
            URL uRL;
            block5: {
                if (file2.length() == 0L) {
                    this.err.log(Level.INFO, "Cache file " + file2 + " exists and of zero size");
                    return null;
                }
                uRL = null;
                try {
                    uRL = file2.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            return uRL;
        }
        return null;
    }

    private File getLicenseDir() {
        return new File(this.getCatalogCache(), "licenses");
    }

    private File getLicenseFile(String string) {
        return new File(this.getLicenseDir(), string);
    }

    public String getLicense(String string) {
        return this.getLicense(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense(String string, URL uRL) {
        String string2 = string.intern();
        synchronized (string2) {
            File file = this.getLicenseFile(string);
            if (!file.exists()) {
                if (uRL == null) {
                    return null;
                }
                try {
                    this.copy(uRL, file, true);
                }
                catch (IOException iOException) {
                    this.err.log(Level.INFO, "Can`t store license from " + uRL + " to " + file, iOException);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                    }
                    catch (IOException iOException2) {
                        this.err.log(Level.INFO, "Can`t create empty license file", iOException2);
                    }
                }
            }
            return this.readFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLicense(String string, String string2) {
        String string3 = string.intern();
        synchronized (string3) {
            File file = this.getLicenseFile(string);
            if (file.exists() || string2 == null) {
                return;
            }
            this.writeToFile(string2, file);
        }
    }

    private String readFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[8192];
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = fileInputStream.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n, "utf-8"));
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            this.err.log(Level.INFO, "Can`t read license from file " + file, iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String string, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes("utf-8"));
        }
        catch (IOException iOException) {
            this.err.log(Level.INFO, "Can`t write to " + file, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.err.log(Level.INFO, "Can`t output stream for " + file, iOException);
                }
            }
        }
    }

    private void copy(URL uRL, File file, boolean bl) throws IOException {
        this.err.log(Level.INFO, "Processing URL: " + uRL);
        String string = "";
        while (string.length() < 3) {
            string = string + file.getName();
        }
        File file2 = File.createTempFile(string, null, file.getParentFile());
        file2.deleteOnExit();
        DownloadListener downloadListener = new DownloadListener(uRL, file, file2, bl);
        NetworkAccess.Task task = NetworkAccess.createNetworkAcessTask(uRL, AutoupdateSettings.getOpenConnectionTimeout(), downloadListener);
        task.waitFinished();
        downloadListener.notifyException();
    }
}

