/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.updater.UpdaterFrame;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSupportImpl {
    private InstallSupport support;
    private boolean progressRunning = false;
    private static Logger err = Logger.getLogger(InstallSupportImpl.class.getName());
    private static final String AUTOUPDATE_SERVICES_MODULE = "org.netbeans.modules.autoupdate.services";
    private Map<UpdateElementImpl, File> element2Clusters = null;
    private Set<File> downloadedFiles = null;
    private boolean isGlobal;
    private int wasDownloaded = 0;
    private Future<Boolean> runningTask;
    private STEP currentStep = STEP.NOTSTARTED;
    private Collection<UpdateElementImpl> trusted = new ArrayList<UpdateElementImpl>();
    private Collection<UpdateElementImpl> signed = new ArrayList<UpdateElementImpl>();
    private Map<UpdateElement, Collection<Certificate>> certs = new HashMap<UpdateElement, Collection<Certificate>>();
    private List<? extends OperationContainer.OperationInfo> infos = null;
    private ExecutorService es = null;
    private Set<ModuleUpdateElementImpl> affectedModuleImpls = null;
    private Set<FeatureUpdateElementImpl> affectedFeatureImpls = null;

    public InstallSupportImpl(InstallSupport installSupport) {
        this.support = installSupport;
    }

    public boolean doDownload(final ProgressHandle progressHandle, boolean bl) throws OperationException {
        this.isGlobal = bl;
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                1 var1_1 = this;
                synchronized (var1_1) {
                    InstallSupportImpl.this.currentStep = STEP.DOWNLOAD;
                }
                InstallSupportImpl.this.infos = InstallSupportImpl.this.support.getContainer().listAll();
                int n = 0;
                for (Object object : InstallSupportImpl.this.infos) {
                    n += ((OperationContainer.OperationInfo)object).getUpdateElement().getDownloadSize();
                }
                if (progressHandle != null) {
                    progressHandle.start();
                    progressHandle.progress(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Estabilish"));
                    InstallSupportImpl.this.progressRunning = false;
                }
                int n2 = 0;
                try {
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        if (InstallSupportImpl.this.cancelled()) {
                            Boolean bl = false;
                            return bl;
                        }
                        int n3 = InstallSupportImpl.this.doDownload(operationInfo, progressHandle, n2, n);
                        if (n3 == -1) {
                            Boolean bl = false;
                            return bl;
                        }
                        n2 += n3;
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                assert (n == n2) : "Was downloaded " + n2 + ", planned was " + n;
                InstallSupportImpl.this.wasDownloaded = n2;
                return true;
            }
        };
        boolean bl2 = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl2 = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doDownload was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof OperationException)) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            throw (OperationException)executionException.getCause();
        }
        return bl2;
    }

    public boolean doValidate(InstallSupport.Validator validator, final ProgressHandle progressHandle) throws OperationException {
        assert (validator != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                2 var1_1 = this;
                synchronized (var1_1) {
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.VALIDATION;
                }
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                if (progressHandle != null) {
                    progressHandle.start(InstallSupportImpl.this.wasDownloaded);
                }
                int n = 0;
                try {
                    for (OperationContainer.OperationInfo operationInfo : InstallSupportImpl.this.infos) {
                        boolean bl;
                        Object object;
                        if (InstallSupportImpl.this.cancelled()) {
                            object = false;
                            return object;
                        }
                        object = Trampoline.API.impl(operationInfo.getUpdateElement());
                        boolean bl2 = bl = ((UpdateElementImpl)object).getInstallInfo().getCustomInstaller() != null;
                        if (bl) {
                            assert (false) : "InstallSupportImpl cannot support CustomInstaller!";
                            continue;
                        }
                        n += InstallSupportImpl.this.doValidate(operationInfo, progressHandle, n);
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                return true;
            }
        };
        boolean bl = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doValidate was cancelled", cancellationException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            if (interruptedException.getCause() instanceof OperationException) {
                throw (OperationException)interruptedException.getCause();
            }
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doInstall(InstallSupport.Installer installer, final ProgressHandle progressHandle) throws OperationException {
        assert (installer != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                boolean bl2;
                block43: {
                    Object object;
                    Object object22;
                    3 var1_1 = this;
                    // MONITORENTER : var1_1
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED) : (Object)((Object)InstallSupportImpl.access$100(InstallSupportImpl.this)) + " != STEP.FINISHED";
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        // MONITOREXIT : var1_1
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.INSTALLATION;
                    // MONITOREXIT : var1_1
                    assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : InstallSupportImpl.access$000(InstallSupportImpl.this) + ".listInvalid().isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                    InstallSupportImpl.this.addTrustedCertificates();
                    InstallSupportImpl.this.affectedModuleImpls = new HashSet();
                    InstallSupportImpl.this.affectedFeatureImpls = new HashSet();
                    if (progressHandle != null) {
                        progressHandle.start();
                    }
                    block20: for (Object object22 : InstallSupportImpl.this.infos) {
                        object = Trampoline.API.impl(((OperationContainer.OperationInfo)object22).getUpdateElement());
                        switch (((UpdateElementImpl)object).getType()) {
                            case KIT_MODULE: 
                            case MODULE: {
                                InstallSupportImpl.this.affectedModuleImpls.add((ModuleUpdateElementImpl)object);
                                continue block20;
                            }
                            case STANDALONE_MODULE: 
                            case FEATURE: {
                                InstallSupportImpl.this.affectedFeatureImpls.add((FeatureUpdateElementImpl)object);
                                InstallSupportImpl.this.affectedModuleImpls.addAll(((FeatureUpdateElementImpl)object).getContainedModuleElements());
                                continue block20;
                            }
                        }
                        assert (false) : "Unsupported type " + object;
                    }
                    bl2 = false;
                    object22 = null;
                    object = null;
                    File file = null;
                    File file2 = null;
                    for (Iterator iterator : InstallSupportImpl.this.affectedModuleImpls) {
                        Object object3 = this;
                        // MONITORENTER : object3
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            // MONITOREXIT : object3
                            return false;
                        }
                        // MONITOREXIT : object3
                        if (Utilities.isElementInstalled(((UpdateElementImpl)((Object)iterator)).getUpdateElement())) continue;
                        object3 = ((UpdateElementImpl)((Object)iterator)).getUpdateUnit().getInstalled();
                        file2 = InstallSupportImpl.this.getTargetCluster((UpdateElement)object3, (UpdateElementImpl)((Object)iterator), InstallSupportImpl.this.isGlobal);
                        URL uRL = ((ModuleUpdateElementImpl)((Object)iterator)).getInstallInfo().getDistribution();
                        err.log(Level.FINE, "Source URL for " + ((ModuleUpdateElementImpl)((Object)iterator)).getCodeName() + " is " + uRL);
                        boolean bl3 = uRL.getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
                        File file3 = InstallSupportImpl.getDestination(file2, ((ModuleUpdateElementImpl)((Object)iterator)).getCodeName(), bl3);
                        assert (file3 != null) : "Destination file exists for " + iterator + " in " + file2;
                        if (InstallSupportImpl.AUTOUPDATE_SERVICES_MODULE.equals(((ModuleUpdateElementImpl)((Object)iterator)).getCodeName())) {
                            err.log(Level.FINEST, "org.netbeans.modules.autoupdate.services is being installed, check if contains netbeans/modules/ext/updater.jar");
                            JarFile jarFile = new JarFile(file3);
                            try {
                                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                                    if (!"netbeans/modules/ext/updater.jar".equals(jarEntry.toString())) continue;
                                    err.log(Level.FINE, "netbeans/modules/ext/updater.jar is being installed from " + ((ModuleUpdateElementImpl)((Object)iterator)).getCodeName());
                                    object22 = jarEntry;
                                    object = jarFile;
                                    file = file2;
                                    bl2 = true;
                                    break;
                                }
                            }
                            finally {
                                if (jarFile != null && !jarFile.equals(object)) {
                                    jarFile.close();
                                }
                            }
                        }
                        bl2 |= InstallSupportImpl.this.needsRestart(object3 != null, iterator, file3);
                    }
                    try {
                        Utilities.writeAdditionalInformation(InstallSupportImpl.this.getElement2Clusters());
                        if (object != null) {
                            Utilities.writeUpdateOfUpdaterJar((JarEntry)object22, (JarFile)object, file);
                        }
                        if (bl2) break block43;
                        Object object4 = this;
                        // MONITORENTER : object4
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            Iterator iterator;
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            iterator = false;
                            // MONITOREXIT : object4
                            return iterator;
                        }
                        // MONITOREXIT : object4
                        if (progressHandle != null) {
                            progressHandle.switchToDeterminate(InstallSupportImpl.this.affectedModuleImpls.size());
                        }
                        if (!InstallSupportImpl.this.getDownloadedFiles().isEmpty()) {
                            object4 = UpdaterFrame.runFromIDE(InstallSupportImpl.this.getDownloadedFiles(), new RefreshModulesListener(progressHandle), NbBundle.getBranding(), false);
                            try {
                                ((Thread)object4).join();
                                for (Object object3 : InstallSupportImpl.this.affectedModuleImpls) {
                                    int n;
                                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)object3).getCodeName(), ((ModuleUpdateElementImpl)object3).getSpecificationVersion());
                                    for (n = 0; n < 100 && module == null; ++n) {
                                        Thread.sleep(100L);
                                        module = Utilities.toModule(((ModuleUpdateElementImpl)object3).getCodeName(), ((ModuleUpdateElementImpl)object3).getSpecificationVersion());
                                    }
                                    if (n != 100) continue;
                                    err.log(Level.INFO, "Timeout waiting for loading module " + ((ModuleUpdateElementImpl)object3).getCodeName() + '/' + ((ModuleUpdateElementImpl)object3).getSpecificationVersion());
                                    ((Thread)object4).interrupt();
                                    InstallSupportImpl.this.afterInstall();
                                    InstallSupportImpl.this.downloadedFiles = null;
                                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_TurnOnTimeout", (Object)((UpdateElementImpl)object3).getUpdateElement()));
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                err.log(Level.INFO, interruptedException.getMessage(), interruptedException);
                                ((Thread)object4).interrupt();
                            }
                        }
                        InstallSupportImpl.this.afterInstall();
                        InstallSupportImpl.this.downloadedFiles = null;
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.progress("");
                            progressHandle.finish();
                        }
                    }
                }
                if (bl2) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        };
        boolean bl = false;
        try {
            this.runningTask = this.getExecutionService().submit(callable);
            bl = this.runningTask.get();
        }
        catch (CancellationException cancellationException) {
            err.log(Level.FINE, "InstallSupport.doInstall was cancelled", cancellationException);
            Boolean bl2 = false;
            return bl2;
        }
        catch (InterruptedException interruptedException) {
            err.log(Level.INFO, interruptedException.getLocalizedMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            err.log(Level.INFO, executionException.getLocalizedMessage(), executionException);
        }
        finally {
            if (!bl) {
                this.getElement2Clusters().clear();
            }
        }
        return bl;
    }

    private void afterInstall() {
        UpdateElement updateElement;
        UpdateUnit updateUnit;
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl updateElementImpl : this.affectedModuleImpls) {
                updateUnit = updateElementImpl.getUpdateUnit();
                updateElement = updateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedModuleImpls = null;
        }
        if (this.affectedFeatureImpls != null) {
            for (FeatureUpdateElementImpl featureUpdateElementImpl : this.affectedFeatureImpls) {
                updateUnit = featureUpdateElementImpl.getUpdateUnit();
                updateElement = featureUpdateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedFeatureImpls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            assert (this.currentStep != STEP.FINISHED);
            this.currentStep = STEP.RESTART;
        }
        Utilities.deleteAllDoLater();
        this.getElement2Clusters().clear();
        LifecycleManager.getDefault().exit();
        this.doRestartLater(restarter);
    }

    public void doRestartLater(OperationSupport.Restarter restarter) {
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.affectedModuleImpls) {
                UpdateUnitFactory.getDefault().scheduleForRestart(moduleUpdateElementImpl.getUpdateElement());
            }
        }
        Utilities.writeInstallLater(new HashMap<UpdateElementImpl, File>(this.getElement2Clusters()));
        this.getElement2Clusters().clear();
        this.downloadedFiles = null;
    }

    public String getCertificate(InstallSupport.Installer installer, UpdateElement updateElement) {
        Collection<Certificate> collection = this.certs.get(updateElement);
        if (collection != null) {
            String string = "";
            for (Certificate certificate : collection) {
                string = string + certificate;
            }
            return string;
        }
        return null;
    }

    public boolean isTrusted(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.trusted.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.trusted.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    public boolean isSigned(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.signed.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.signed.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    private void addTrustedCertificates() {
        HashSet<UpdateElementImpl> hashSet = new HashSet<UpdateElementImpl>(this.signed);
        hashSet.removeAll(this.trusted);
        if (hashSet.isEmpty()) {
            return;
        }
        HashSet<Certificate> hashSet2 = new HashSet<Certificate>();
        for (UpdateElementImpl updateElementImpl : hashSet) {
            hashSet2.addAll(this.certs.get(updateElementImpl.getUpdateElement()));
        }
        if (!hashSet2.isEmpty()) {
            Utilities.addCertificates(hashSet2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            this.currentStep = STEP.CANCEL;
        }
        if (this.runningTask != null && !this.runningTask.isDone() && !this.runningTask.isCancelled()) {
            boolean bl = this.runningTask.cancel(true);
            assert (bl) : this.runningTask + " was cancelled.";
        }
        for (File file : this.getDownloadedFiles()) {
            if (file == null || !file.exists()) continue;
            file.delete();
        }
        this.getDownloadedFiles().clear();
        Utilities.cleanUpdateOfUpdaterJar();
        if (this.affectedFeatureImpls != null) {
            this.affectedFeatureImpls = null;
        }
        if (this.affectedModuleImpls != null) {
            this.affectedModuleImpls = null;
        }
        this.getElement2Clusters().clear();
    }

    private int doDownload(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n3 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n3 += this.doDownload(updateElementImpl, progressHandle, n, n2);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n4 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n5 = this.doDownload(moduleUpdateElementImpl, progressHandle, n4, n2);
                    if (n5 == -1) {
                        return -1;
                    }
                    n4 += n5;
                    n3 += n5;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n3;
    }

    private int doDownload(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        if (this.cancelled()) {
            return -1;
        }
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal);
        assert (file != null) : "Target cluster for " + updateElementImpl + " must exist.";
        if (file == null) {
            file = InstallManager.getUserDir();
        }
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        err.log(Level.FINE, "Source URL for " + updateElementImpl.getCodeName() + " is " + uRL);
        if (uRL == null) {
            String string = NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_NullSource", (Object)updateElementImpl.getCodeName());
            err.log(Level.INFO, string);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, string);
        }
        boolean bl = uRL.getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), bl);
        if (file2.exists()) {
            err.log(Level.FINE, "Target NBM file " + file2 + " of " + updateElementImpl.getUpdateElement() + " already downloaded.");
            return updateElementImpl.getDownloadSize();
        }
        int n3 = 0;
        try {
            String string = updateElementImpl.getDisplayName();
            this.getDownloadedFiles().add(FileUtil.normalizeFile((File)file2));
            n3 = this.copy(uRL, file2, progressHandle, updateElementImpl.getDownloadSize(), n, n2, string);
        }
        catch (UnknownHostException unknownHostException) {
            err.log(Level.INFO, unknownHostException.getMessage(), unknownHostException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            err.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        return n3;
    }

    private int doValidate(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n2 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n2 = this.doValidate(updateElementImpl, progressHandle, n);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n3 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n4 = this.doValidate(moduleUpdateElementImpl, progressHandle, n3);
                    n3 += n4;
                    n2 += n4;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n2;
    }

    private int doValidate(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal);
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        boolean bl = uRL.getFile().toLowerCase(Locale.US).endsWith(".nbm".toLowerCase(Locale.US));
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), bl);
        assert (file2.exists()) : file2.getAbsolutePath();
        int n2 = 0;
        n2 = this.verifyNbm(updateElementImpl.getUpdateElement(), file2, progressHandle, n);
        return n2;
    }

    static File getDestination(File file, String string, boolean bl) {
        err.log(Level.FINE, "Target cluster for " + string + " is " + file);
        File file2 = new File(file, Utilities.DOWNLOAD_DIR);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = string.replace('.', '-');
        File file3 = new File(file2, string2 + (bl ? ".nbm" : ""));
        err.log(Level.FINE, "Destination file for " + string + " is " + file3);
        return file3;
    }

    private static File getDestination(File file, String string) {
        return InstallSupportImpl.getDestination(file, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelled() {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            return STEP.CANCEL == this.currentStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(URL uRL, File file, ProgressHandle progressHandle, int n, int n2, int n3, String string) throws MalformedURLException, IOException {
        int n4 = 0;
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        int n5 = -1;
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(AutoupdateSettings.getOpenConnectionTimeout());
            inputStream = uRLConnection.getInputStream();
            n5 = uRLConnection.getContentLength();
        }
        catch (FileNotFoundException fileNotFoundException) {
            err.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            throw new IOException(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Unavailable", (Object)uRL));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = null;
        err.log(Level.FINEST, "Copy " + uRL + " to " + file + "[" + n + "]");
        try {
            int n6;
            byte[] byArray = new byte[1024];
            int n7 = 0;
            while (!this.cancelled() && (n6 = bufferedInputStream.read(byArray)) != -1) {
                if (bufferedOutputStream == null) {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                }
                bufferedOutputStream.write(byArray, 0, n6);
                n4 += n6;
                n7 += n6;
                if (!this.progressRunning && progressHandle != null) {
                    progressHandle.switchToDeterminate(n3);
                    this.progressRunning = true;
                }
                if (n7 <= 1024) continue;
                if (progressHandle != null) {
                    assert (this.progressRunning);
                    progressHandle.switchToDeterminate(n3);
                    int n8 = n2 + (n4 < n ? n4 : n);
                    progressHandle.progress(string, n8 < n3 ? n8 : n3);
                }
                n7 = 0;
            }
            if (n != n4) {
                err.log(Level.FINEST, "Increment (" + n4 + ") of is not equal to estimatedSize (" + n + ").");
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        if (n5 != -1 && n4 != n5) {
            err.log(Level.INFO, "Content length was reported as " + n5 + " byte(s) but read " + n4 + " byte(s)");
            if (bufferedOutputStream != null && file.exists()) {
                err.log(Level.INFO, "Deleting not fully downloaded file " + file);
                file.delete();
                this.getDownloadedFiles().remove(FileUtil.normalizeFile((File)file));
            }
            throw new IOException("Server closed connection unexpectedly");
        }
        err.log(Level.FINE, "Destination " + file + " is successfully wrote. Size " + file.length());
        return n;
    }

    private int verifyNbm(UpdateElement updateElement, File file, ProgressHandle progressHandle, int n) throws OperationException {
        String string = null;
        try {
            n += updateElement.getDownloadSize();
            if (progressHandle != null) {
                progressHandle.progress(updateElement.getDisplayName(), n < this.wasDownloaded ? n : this.wasDownloaded);
            }
            Collection<Certificate> collection = InstallSupportImpl.getNbmCertificates(file);
            assert (collection != null);
            if (collection.size() > 0) {
                this.certs.put(updateElement, collection);
            }
            if (collection.isEmpty()) {
                string = "UNSIGNED";
            } else {
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                for (KeyStore keyStore : Utilities.getKeyStore()) {
                    arrayList.addAll(InstallSupportImpl.getCertificates(keyStore));
                }
                KeyStore keyStore = Utilities.loadKeyStore();
                if (keyStore != null) {
                    arrayList.addAll(InstallSupportImpl.getCertificates(keyStore));
                }
                if (arrayList.containsAll(collection)) {
                    string = "TRUSTED";
                    this.trusted.add(updateElementImpl);
                    this.signed.add(updateElementImpl);
                } else {
                    string = "UNTRUSTED";
                    this.signed.add(updateElementImpl);
                }
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            string = "BAD_DOWNLOAD";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        catch (KeyStoreException keyStoreException) {
            err.log(Level.INFO, keyStoreException.getMessage(), keyStoreException);
            string = "CORRUPTED";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        err.log(Level.FINE, "NBM " + file + " was verified as " + string);
        return updateElement.getDownloadSize();
    }

    private static Collection<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (String string : Collections.list(keyStore.aliases())) {
            arrayList.add(keyStore.getCertificate(string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Certificate> getNbmCertificates(File file) throws IOException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        JarFile jarFile = new JarFile(file);
        try {
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                InstallSupportImpl.verifyEntry(jarFile, jarEntry);
                if (jarEntry.getCertificates() == null) continue;
                hashSet.addAll(Arrays.asList(jarEntry.getCertificates()));
            }
        }
        finally {
            jarFile.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = jarFile.getInputStream(jarEntry);
            byte[] byArray = new byte[8192];
            boolean bl = false;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        return InstallManager.needsRestart(bl, updateElementImpl, file);
    }

    private File getTargetCluster(UpdateElement updateElement, UpdateElementImpl updateElementImpl, boolean bl) {
        File file = this.getElement2Clusters().get(updateElementImpl);
        if (file == null && (file = InstallManager.findTargetDirectory(updateElement, updateElementImpl, bl)) != null) {
            this.getElement2Clusters().put(updateElementImpl, file);
        }
        return file;
    }

    private Map<UpdateElementImpl, File> getElement2Clusters() {
        if (this.element2Clusters == null) {
            this.element2Clusters = new HashMap<UpdateElementImpl, File>();
        }
        return this.element2Clusters;
    }

    private ExecutorService getExecutionService() {
        if (this.es == null || this.es.isShutdown()) {
            this.es = Executors.newSingleThreadExecutor();
        }
        return this.es;
    }

    private synchronized Set<File> getDownloadedFiles() {
        if (this.downloadedFiles == null) {
            this.downloadedFiles = new HashSet<File>();
        }
        return this.downloadedFiles;
    }

    private static final class RefreshModulesListener
    implements PropertyChangeListener {
        private ProgressHandle handle;
        private int i;

        public RefreshModulesListener(ProgressHandle progressHandle) {
            this.handle = progressHandle;
            this.i = 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("RUNNING".equals(propertyChangeEvent.getPropertyName())) {
                if (this.handle != null) {
                    this.handle.progress(this.i++);
                }
            } else if ("FINISHED".equals(propertyChangeEvent.getPropertyName())) {
                final FileObject fileObject = FileUtil.getConfigFile((String)"Modules");
                err.log(Level.FINE, "It's a hack: Call refresh on " + fileObject + " file object.");
                if (fileObject != null) {
                    try {
                        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                            public void run() throws IOException {
                                fileObject.getParent().refresh();
                                fileObject.refresh();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else assert (false) : "Unknown property " + propertyChangeEvent.getPropertyName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STEP {
        NOTSTARTED,
        DOWNLOAD,
        VALIDATION,
        INSTALLATION,
        RESTART,
        FINISHED,
        CANCEL;

    }
}

