/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.jpda.projects.FixActionProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePathProviderImpl
extends SourcePathProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.projects");
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private ClassPath originalSourcePath;
    private Set<String> additionalSourceRoots;
    private ClassPath smartSteppingSourcePath;
    private String[] projectSourceRoots;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private PathRegistryListener pathRegistryListener;
    private File baseDir;
    private static boolean CAN_FIX_CLASSES_AUTOMATICALLY = Boolean.getBoolean("debugger.apply-code-changes.on-save");

    public SourcePathProviderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public SourcePathProviderImpl(ContextProvider contextProvider) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        JPDADebugger jPDADebugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        HashSet<FileObject> hashSet = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Have properties = " + map);
        }
        if (map != null) {
            void var7_9;
            this.baseDir = (File)map.get("baseDir");
            this.smartSteppingSourcePath = (ClassPath)map.get("sourcepath");
            object5 = (ClassPath)map.get("jdksources");
            if (object5 == null && JavaPlatform.getDefault() != null) {
                object5 = JavaPlatform.getDefault().getSourceFolders();
            }
            if (this.baseDir != null) {
                object4 = this.getAdditionalClassPath(this.baseDir);
            } else {
                object4 = null;
                Exceptions.printStackTrace((Throwable)new NullPointerException("No base directory is defined. Properties = " + map));
            }
            if (object4 != null) {
                this.smartSteppingSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, object4});
            }
            this.originalSourcePath = this.smartSteppingSourcePath = object5 == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{object5, this.smartSteppingSourcePath});
            if (this.baseDir != null) {
                Set<String> set3 = this.getDisabledSourceRoots(this.baseDir);
            } else {
                Object var7_8 = null;
            }
            if (var7_9 != null && !var7_9.isEmpty()) {
                object3 = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                for (Object object6 : new HashSet(object3)) {
                    if (!var7_9.contains(SourcePathProviderImpl.getRoot((FileObject)object6))) continue;
                    object3.remove(object6);
                }
                this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object3.toArray(new FileObject[0]));
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            object3 = new HashSet();
            object3.addAll(Arrays.asList(this.originalSourcePath.getRoots()));
            object2 = (String)map.get("listeningCP");
            if (object2 != null) {
                for (String string : ((String)object2).split(File.pathSeparator)) {
                    logger.log(Level.FINE, "Listening cp = '" + (String)string + "'");
                    File file = new File(string);
                    file = FileUtil.normalizeFile((File)file);
                    object = FileUtil.urlForArchiveOrDir((File)file);
                    if (object == null) continue;
                    hashSet = new HashSet();
                    for (FileObject fileObject : SourceForBinaryQuery.findSourceRoots((URL)object).getRoots()) {
                        hashSet.add(fileObject);
                    }
                }
            }
        } else {
            Object object6;
            this.pathRegistryListener = new PathRegistryListener();
            GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.pathRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pathRegistryListener, (Object)JavaPlatformManager.getDefault()));
            object5 = new ArrayList();
            object4 = new HashSet();
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
            object3 = OpenProjects.getDefault().getMainProject();
            if (object3 != null) {
                for (SourceGroup sourceGroup : object2 = ProjectUtils.getSources((Project)object3).getSourceGroups("java")) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/execute");
                    if (classPath == null) {
                        classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/source");
                    }
                    if (classPath == null) continue;
                    object = classPath.getRoots();
                    for (FileObject fileObject : object) {
                        if (hashSet2.contains(fileObject)) continue;
                        hashSet2.add(fileObject);
                        try {
                            FileObject[] fileObjectArray;
                            for (FileObject fileObject2 : fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots()) {
                                if (object4.contains(fileObject2)) continue;
                                object5.add(fileObject2);
                                object4.add(fileObject2);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                    }
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: preferred source roots = " + object4 + ")");
            }
            object2 = new TreeSet<FileObject>(new FileObjectComparator());
            object2.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            object6 = object2.iterator();
            while (object6.hasNext()) {
                FileObject fileObject = (FileObject)object6.next();
                if (object4.contains(fileObject)) continue;
                object5.add(fileObject);
            }
            object6 = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < ((Object)object6).length; ++i) {
                FileObject[] fileObjectArray = object6[i].getSourceFolders().getRoots();
                int n = fileObjectArray.length;
                for (int j = 0; j < n; ++j) {
                    if (object5.contains(fileObjectArray[j])) continue;
                    object5.add(fileObjectArray[j]);
                }
            }
            List<FileObject> list = this.getAdditionalRemoteClassPath();
            if (list != null) {
                object5.addAll(list);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: GlobalPathRegistry roots = " + GlobalPathRegistry.getDefault().getSourceRoots() + ")");
                logger.fine("Platform roots:");
                for (int i = 0; i < ((Object)object6).length; ++i) {
                    logger.fine(" " + Arrays.asList(object6[i].getSourceFolders().getRoots()).toString());
                }
                logger.fine("SourcePathProviderImpl: all source roots = " + object5 + ")");
            }
            Set<String> set = this.getRemoteDisabledSourceRoots();
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object5.toArray(new FileObject[object5.size()]));
                this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
                hashSet = new HashSet<FileObject>((Collection<FileObject>)object5);
                this.smartSteppingSourcePath = this.originalSourcePath;
                if (set != null && !set.isEmpty()) {
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                    for (FileObject fileObject : new HashSet<FileObject>(arrayList)) {
                        if (!set.contains(SourcePathProviderImpl.getRoot(fileObject))) continue;
                        arrayList.remove(fileObject);
                    }
                    this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
                }
            }
        }
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
        if (hashSet != null) {
            object5 = new HashSet();
            for (FileObject fileObject : hashSet) {
                try {
                    object5.add(this.addArtifactsUpdateListenerFor(jPDADebugger, fileObject));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            jPDADebugger.addPropertyChangeListener("state", new PropertyChangeListener((Set)object5){
                final /* synthetic */ Set val$artifactsListeners;
                {
                    this.val$artifactsListeners = set;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (4 == (Integer)propertyChangeEvent.getNewValue()) {
                        for (ArtifactsUpdatedImpl artifactsUpdatedImpl : this.val$artifactsListeners) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)artifactsUpdatedImpl.getURL(), (BuildArtifactMapper.ArtifactsUpdated)artifactsUpdatedImpl);
                        }
                    }
                }
            });
        }
    }

    private ClassPath getAdditionalClassPath(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            List list = (List)properties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(string);
            if (list == null || list.isEmpty()) {
                return null;
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(list.size());
            for (String string2 : list) {
                FileObject fileObject = this.getFileObject(string2);
                if (fileObject == null) continue;
                arrayList.add(fileObject);
            }
            this.additionalSourceRoots = new LinkedHashSet<String>(list);
            return ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private List<FileObject> getAdditionalRemoteClassPath() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        List list = (List)properties.getProperties("additional_source_roots").getCollection("src_roots", Collections.emptyList());
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(list.size());
        for (String string : list) {
            FileObject fileObject = this.getFileObject(string);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        this.additionalSourceRoots = new LinkedHashSet<String>(list);
        return arrayList;
    }

    private void storeAdditionalSourceRoots() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String string;
            try {
                string = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return;
            }
            Map map = properties.getProperties("additional_source_roots").getMap("project", new HashMap());
            if (this.additionalSourceRoots != null) {
                map.put(string, new ArrayList<String>(this.additionalSourceRoots));
            } else {
                map.remove(string);
            }
            properties.getProperties("additional_source_roots").setMap("project", map);
        } else if (this.additionalSourceRoots != null) {
            properties.getProperties("additional_source_roots").setCollection("src_roots", new ArrayList<String>(this.additionalSourceRoots));
        } else {
            properties.getProperties("additional_source_roots").setCollection("src_roots", null);
        }
    }

    private Set<String> getDisabledSourceRoots(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            return (Set)properties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private Set<String> getRemoteDisabledSourceRoots() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Set)properties.getProperties("source_roots").getCollection("remote_disabled", Collections.emptySet());
    }

    private void storeDisabledSourceRoots(Set<String> set) {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String string;
            try {
                string = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return;
            }
            Map map = properties.getProperties("source_roots").getMap("project_disabled", new HashMap());
            map.put(string, set);
            properties.getProperties("source_roots").setMap("project_disabled", map);
        } else {
            properties.getProperties("source_roots").setCollection("remote_disabled", set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String string, boolean bl) {
        FileObject fileObject;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        ClassPath classPath = null;
        ClassPath classPath2 = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            if (this.originalSourcePath != null) {
                classPath = this.smartSteppingSourcePath;
                classPath2 = this.originalSourcePath;
            }
        }
        if (classPath != null) {
            fileObject = classPath.findResource(string);
            if (fileObject == null && bl) {
                fileObject = classPath2.findResource(string);
            }
            if (fileObject == null && bl) {
                fileObject = GlobalPathRegistry.getDefault().findResource(string);
            }
        } else {
            fileObject = GlobalPathRegistry.getDefault().findResource(string);
        }
        if (verbose) {
            System.out.println("SPPI:   fo " + fileObject);
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (verbose) {
                System.out.println("SPPI:   FileStateInvalidException");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllURLs(String string, boolean bl) {
        Object object;
        List list;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        if (this.originalSourcePath == null) {
            list = new ArrayList();
            for (Object object2 : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                list.addAll(object2.findAllResources(string));
            }
        } else {
            object = this;
            synchronized (object) {
                if (!bl) {
                    list = this.smartSteppingSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                } else {
                    list = this.originalSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                }
            }
        }
        object = new ArrayList(list.size());
        for (FileObject fileObject : list) {
            try {
                object.add(fileObject.getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                if (!verbose) continue;
                System.out.println("SPPI:   FileStateInvalidException for " + fileObject);
            }
        }
        return object.toArray(new String[0]);
    }

    public String getRelativePath(String string, char c, boolean bl) {
        FileObject fileObject = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + string);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string2 = this.smartSteppingSourcePath.getResourceName(fileObject, c, bl);
        if (string2 == null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            }
            if (classPath == null) {
                return null;
            }
            string2 = classPath.getResourceName(fileObject, c, bl);
        }
        return string2;
    }

    public synchronized String getSourceRoot(String string) {
        ClassPath classPath;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            fileObject = null;
        }
        FileObject[] fileObjectArray = null;
        if (fileObject != null && (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) != null) {
            fileObjectArray = classPath.getRoots();
        }
        if (fileObjectArray == null) {
            fileObjectArray = this.originalSourcePath.getRoots();
        }
        for (ClassPath classPath2 : fileObjectArray) {
            try {
                String string2;
                String string3 = classPath2.getURL().toString();
                if (!string.startsWith(string3) || (string2 = SourcePathProviderImpl.getRoot((FileObject)classPath2)) == null) continue;
                return string2;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] getSourceRoots(ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        ArrayList<String> arrayList = new ArrayList<String>(fileObjectArray.length);
        for (FileObject fileObject : fileObjectArray) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public synchronized String[] getOriginalSourceRoots() {
        return this.getSourceRoots(this.originalSourcePath);
    }

    public synchronized String[] getSourceRoots() {
        return this.getSourceRoots(this.smartSteppingSourcePath);
    }

    synchronized Set<FileObject> getSourceRootsFO() {
        return new HashSet<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
    }

    public String[] getProjectSourceRoots() {
        return this.projectSourceRoots;
    }

    public synchronized String[] getAdditionalSourceRoots() {
        return this.additionalSourceRoots == null ? new String[]{} : this.additionalSourceRoots.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] stringArray) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(stringArray) + ")");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        ClassPath classPath = null;
        ClassPath classPath2 = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            Object object;
            Object object2;
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
            ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>(Arrays.asList(this.originalSourcePath.getRoots()));
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(linkedHashSet);
            for (FileObject object52 : arrayList2) {
                linkedHashSet2.remove(SourcePathProviderImpl.getRoot(object52));
            }
            if (!linkedHashSet2.isEmpty()) {
                for (String string : linkedHashSet2) {
                    FileObject fileObject = this.getFileObject(string);
                    if (fileObject == null) continue;
                    arrayList2.add(fileObject);
                }
                this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList2.toArray(new FileObject[0]));
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new LinkedHashSet<String>();
                }
                this.additionalSourceRoots.addAll(linkedHashSet2);
            }
            LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(linkedHashSet);
            for (FileObject fileObject : arrayList) {
                linkedHashSet3.remove(SourcePathProviderImpl.getRoot(fileObject));
            }
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
            for (FileObject fileObject : arrayList) {
                object2 = SourcePathProviderImpl.getRoot(fileObject);
                if (linkedHashSet.contains(object2)) continue;
                hashSet.add(fileObject);
                if (this.additionalSourceRoots == null || !this.additionalSourceRoots.contains(object2)) continue;
                hashSet2.add(fileObject);
                this.additionalSourceRoots.remove(object2);
                if (this.additionalSourceRoots.size() != 0) continue;
                this.additionalSourceRoots = null;
            }
            if (hashSet2.size() > 0) {
                arrayList2.removeAll(hashSet2);
                this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList2.toArray(new FileObject[0]));
            }
            if (linkedHashSet3.size() > 0 || hashSet.size() > 0) {
                object = linkedHashSet3.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    object2 = this.getFileObject(string);
                    if (object2 == null) continue;
                    arrayList.add((FileObject)object2);
                }
                arrayList.removeAll(hashSet);
                classPath = this.smartSteppingSourcePath;
                classPath2 = this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
            }
            object = new HashSet<FileObject>(arrayList2);
            object.removeAll(arrayList);
            HashSet<String> hashSet3 = new HashSet<String>();
            object2 = object.iterator();
            while (object2.hasNext()) {
                FileObject fileObject = (FileObject)object2.next();
                hashSet3.add(SourcePathProviderImpl.getRoot(fileObject));
            }
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(hashSet3);
        }
        if (classPath != null) {
            this.pcs.firePropertyChange("sourceRoots", classPath, classPath2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static String normalize(String string) {
        Matcher matcher = thisDirectoryPattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = thisDirectoryPattern.matcher(string);
        }
        matcher = parentDirectoryPattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = parentDirectoryPattern.matcher(string);
        }
        return string;
    }

    static String getRoot(FileObject fileObject) {
        File file = null;
        String string = "";
        try {
            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                file = ((JarFileSystem)fileObject.getFileSystem()).getJarFile();
                if (!fileObject.isRoot()) {
                    string = "!/" + fileObject.getPath();
                }
            } else {
                file = FileUtil.toFile((FileObject)fileObject);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (file != null) {
            return file.getAbsolutePath() + string;
        }
        return null;
    }

    private FileObject getFileObject(String string) {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string2 = null;
        if (fileObject == null && string.contains("!/")) {
            int n = string.indexOf("!/");
            file = new File(string.substring(0, n));
            fileObject = FileUtil.toFileObject((File)file);
            string2 = string.substring(n + "!/".length());
        }
        if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            if (string2 != null) {
                fileObject = fileObject.getFileObject(string2);
            }
        }
        return fileObject;
    }

    private ArtifactsUpdatedImpl addArtifactsUpdateListenerFor(JPDADebugger jPDADebugger, FileObject fileObject) throws FileStateInvalidException {
        URL uRL = fileObject.getURL();
        ArtifactsUpdatedImpl artifactsUpdatedImpl = new ArtifactsUpdatedImpl(jPDADebugger, uRL, fileObject);
        BuildArtifactMapper.addArtifactsUpdatedListener((URL)uRL, (BuildArtifactMapper.ArtifactsUpdated)artifactsUpdatedImpl);
        return artifactsUpdatedImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FileObjectComparator
    implements Comparator<FileObject> {
        FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            String string2 = SourcePathProviderImpl.getRoot(fileObject2);
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    private class PathRegistryListener
    implements GlobalPathRegistryListener,
    PropertyChangeListener {
        private PathRegistryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            boolean bl = false;
            SourcePathProviderImpl sourcePathProviderImpl = SourcePathProviderImpl.this;
            synchronized (sourcePathProviderImpl) {
                if (SourcePathProviderImpl.this.originalSourcePath == null) {
                    return;
                }
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                for (JavaPlatform javaPlatform : javaPlatformArray) {
                    FileObject[] fileObjectArray;
                    for (FileObject fileObject : fileObjectArray = javaPlatform.getSourceFolders().getRoots()) {
                        if (arrayList.contains(fileObject)) continue;
                        arrayList.add(fileObject);
                        bl = true;
                    }
                }
                if (bl) {
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
                }
            }
            if (bl) {
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactsUpdatedImpl
    implements BuildArtifactMapper.ArtifactsUpdated {
        private Reference<JPDADebugger> debuggerRef;
        private final URL url;
        private FileObject src;

        public ArtifactsUpdatedImpl(JPDADebugger jPDADebugger, URL uRL, FileObject fileObject) {
            this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
            this.url = uRL;
            this.src = fileObject;
        }

        public URL getURL() {
            return this.url;
        }

        public void artifactsUpdated(Iterable<File> iterable) {
            String string = null;
            JPDADebugger jPDADebugger = this.debuggerRef.get();
            if (jPDADebugger == null) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoJPDADebugger");
            } else if (!jPDADebugger.canFixClasses()) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_CanNotFix");
            } else if (jPDADebugger.getState() == 4) {
                string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoDebug");
            }
            boolean bl = Properties.getDefault().getProperties("debugger.options.JPDA").getBoolean("ApplyCodeChangesOnSave", CAN_FIX_CLASSES_AUTOMATICALLY);
            if (string == null) {
                if (!bl) {
                    for (File file : iterable) {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null) continue;
                        String string2 = ArtifactsUpdatedImpl.fileToClassName(fileObject);
                        FixActionProvider.ClassesToReload.getInstance().addClassToReload(jPDADebugger, this.src, string2, fileObject);
                    }
                    return;
                }
                HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
                for (File file : iterable) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    String string3 = ArtifactsUpdatedImpl.fileToClassName(fileObject);
                    hashMap.put(string3, fileObject);
                }
                FixActionProvider.reloadClasses(jPDADebugger, hashMap);
            } else {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
            if (string != null && bl) {
                FixActionProvider.notifyError(string);
            }
        }

        private static String fileToClassName(FileObject fileObject) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            return classPath.getResourceName(fileObject, '.', false);
        }
    }
}

