/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.web.jsf.JSFCatalog;
import org.netbeans.modules.web.jsf.JSFConfigEditorSupport;
import org.netbeans.modules.web.jsf.JSFConfigLoader;
import org.netbeans.modules.web.jsf.JSFConfigNode;
import org.netbeans.modules.web.jsf.SAXParseError;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class JSFConfigDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static JSFCatalog jsfCatalog = new JSFCatalog();
    private boolean documentDirty = true;
    private boolean documentValid = true;
    protected boolean nodeDirty = false;
    private InputStream inputStream;
    private transient JSFConfigEditorSupport editorSupport;
    private SAXParseError error;
    private FacesConfig lastGoodFacesConfig = null;
    public static final String PROP_DOC_VALID = "documentValid";

    public JSFConfigDataObject(FileObject fileObject, JSFConfigLoader jSFConfigLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)jSFConfigLoader);
        this.init();
    }

    private void init() {
        CookieSet cookieSet = this.getCookieSet();
        this.getCookieSet().add(JSFConfigEditorSupport.class, (CookieSet.Factory)this);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{XmlFileEncodingQueryImpl.singleton()});
    }

    protected synchronized Node createNodeDelegate() {
        return new JSFConfigNode(this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(JSFConfigEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFConfigEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            JSFConfigDataObject jSFConfigDataObject = this;
            synchronized (jSFConfigDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new JSFConfigEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public FacesConfig getFacesConfig() throws IOException {
        if (this.lastGoodFacesConfig == null) {
            this.parsingDocument();
        }
        return this.lastGoodFacesConfig;
    }

    protected InputStream prepareInputSource() throws IOException {
        if (this.getEditorSupport() != null && this.getEditorSupport().isDocumentLoaded()) {
            return this.getEditorSupport().getInputStream();
        }
        return this.getPrimaryFile().getInputStream();
    }

    protected void closeInputSource() {
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        this.error = null;
        try {
            this.error = this.updateNode(this.prepareInputSource());
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (this.error == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
        this.setNodeDirty(false);
    }

    public void setDocumentValid(boolean bl) {
        if (this.documentValid != bl) {
            if (bl) {
                this.repairNode();
            }
            this.documentValid = bl;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void repairNode() {
        StatusDisplayer.getDefault().setStatusText("");
    }

    private Document getDomDocument(InputStream inputStream) throws SAXParseException {
        try {
            Document document = GraphManager.createXmlDocument((InputSource)new InputSource(inputStream), (boolean)false, (EntityResolver)jsfCatalog, (ErrorHandler)new J2eeErrorHandler(this));
            return document;
        }
        catch (Exception exception) {
            throw new SAXParseException(exception.getMessage(), new LocatorImpl());
        }
    }

    protected SAXParseError updateNode(InputStream inputStream) throws IOException {
        try {
            Document document = this.getDomDocument(inputStream);
        }
        catch (SAXParseException sAXParseException) {
            return new SAXParseError(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new IOException();
        }
        return null;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setNodeDirty(boolean bl) {
        this.nodeDirty = bl;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private void createSAXParseError(SAXParseException sAXParseException) {
        this.error = new SAXParseError(sAXParseException);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private JSFConfigDataObject dataObject;

        public J2eeErrorHandler(JSFConfigDataObject jSFConfigDataObject) {
            this.dataObject = jSFConfigDataObject;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }
    }
}

