/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CndFileUtils {
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static final Lock maRefLock;
    private static final Lock mapFoldersRefLock;
    private static final Lock mapNormalizedRefLock;
    private static Reference<Map<String, Boolean>> mapRef;
    private static Reference<Map<String, Boolean>> mapFoldersRef;
    private static Reference<Map<String, String>> normalizedRef;

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static void clearFileExistenceCache() {
        mapRef.clear();
        mapFoldersRef.clear();
    }

    public static File normalizeFile(File file) {
        String string;
        String string2;
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole(file.isAbsolute(), "Is it OK to normalize not absolute file? [" + file + "] during this session it is [" + file.getAbsolutePath() + "] but will be different if start IDE from another folder");
        }
        return (string2 = file.getPath()).equals(string = CndFileUtils.normalizeAbsolutePath(file.getAbsolutePath())) ? file : new File(string);
    }

    public static String normalizeAbsolutePath(String string) {
        Map<String, String> map;
        String string2;
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole(new File(string).isAbsolute(), "path for normalization must be absolute " + string);
        }
        if ((string2 = (map = CndFileUtils.getNormalizedFilesMap()).get(string)) == null) {
            boolean bl = CndFileUtils.isSystemCaseSensitive();
            string2 = !bl || string.endsWith("/.") || string.endsWith("\\.") || string.contains("..") || string.contains("./") || string.contains(".\\") ? FileUtil.normalizeFile((File)new File(string)).getAbsolutePath() : string;
            map.put(string, string2);
        }
        return string2;
    }

    public static boolean exists(File file) {
        String string = file.getAbsolutePath();
        Map<String, Boolean> map = CndFileUtils.getFilesMap();
        Boolean bl = map.get(string);
        if (bl == null) {
            bl = file.exists();
            map.put(string, bl);
        }
        return bl;
    }

    public static boolean isDirectory(File file) {
        String string = file.getAbsolutePath();
        Map<String, Boolean> map = CndFileUtils.getFoldersMap();
        Boolean bl = map.get(string);
        if (bl == null) {
            bl = file.isDirectory();
            map.put(string, bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Boolean> getFilesMap() {
        Map<String, Boolean> map = mapRef.get();
        if (map == null) {
            try {
                maRefLock.lock();
                map = mapRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Boolean>();
                    mapRef = new SoftReference<Map<String, Boolean>>(map);
                }
            }
            finally {
                maRefLock.unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Boolean> getFoldersMap() {
        Map<String, Boolean> map = mapFoldersRef.get();
        if (map == null) {
            try {
                mapFoldersRefLock.lock();
                map = mapFoldersRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Boolean>();
                    mapFoldersRef = new SoftReference<Map<String, Boolean>>(map);
                }
            }
            finally {
                mapFoldersRefLock.unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNormalizedFilesMap() {
        Map<String, String> map = normalizedRef.get();
        if (map == null) {
            try {
                mapNormalizedRefLock.lock();
                map = normalizedRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, String>();
                    normalizedRef = new SoftReference<Map<String, String>>(map);
                }
            }
            finally {
                mapNormalizedRefLock.unlock();
            }
        }
        return map;
    }

    static {
        boolean bl;
        try {
            File file = File.createTempFile("CaseSensitiveFile", ".check");
            String string = file.getAbsolutePath();
            string = string.toUpperCase();
            bl = !new File(string).exists();
            file.delete();
        }
        catch (IOException iOException) {
            bl = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = bl;
        maRefLock = new ReentrantLock();
        mapFoldersRefLock = new ReentrantLock();
        mapNormalizedRefLock = new ReentrantLock();
        mapRef = new SoftReference(new ConcurrentHashMap());
        mapFoldersRef = new SoftReference(new ConcurrentHashMap());
        normalizedRef = new SoftReference(new ConcurrentHashMap());
    }
}

