/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.spi;

import java.awt.Image;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public abstract class JspContextInfo {
    public static final String CONTEXT_NAME = "/J2EE/JSPSyntaxColoring/";
    private static Hashtable<String, JspContextInfo> instances = new Hashtable();

    public static synchronized JspContextInfo getContextInfo(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        JspContextInfo jspContextInfo = instances.get(fileObject.getMIMEType());
        if (jspContextInfo == null) {
            FileObject fileObject2 = FileUtil.getConfigFile((String)(CONTEXT_NAME + fileObject.getMIMEType()));
            if (fileObject2 != null) {
                try {
                    DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject2).getCookie(DataFolder.class);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
                        Object object = instanceCookie.instanceCreate();
                        if (!(object instanceof JspContextInfo)) continue;
                        jspContextInfo = (JspContextInfo)object;
                        instances.put(fileObject.getMIMEType(), jspContextInfo);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger("global").log(Level.WARNING, null, dataObjectNotFoundException);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, null, iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger("global").log(Level.WARNING, null, classNotFoundException);
                }
            }
            if (jspContextInfo == null) {
                Logger.getLogger("global").log(Level.WARNING, null, new Exception(NbBundle.getBundle(JspContextInfo.class).getString("EXC_JspContextInfoNotInstalled") + "; instance path = " + CONTEXT_NAME + fileObject.getMIMEType() + "; fileObject = " + fileObject.getPath()));
            }
        }
        return jspContextInfo;
    }

    public abstract JspColoringData getJSPColoringData(FileObject var1);

    public abstract JspParserAPI.ParseResult getCachedParseResult(FileObject var1, boolean var2, boolean var3, boolean var4);

    public abstract JspParserAPI.ParseResult getCachedParseResult(FileObject var1, boolean var2, boolean var3);

    public abstract JspParserAPI.JspOpenInfo getCachedOpenInfo(FileObject var1, boolean var2);

    public abstract URLClassLoader getModuleClassLoader(FileObject var1);

    public abstract FileObject guessWebModuleRoot(FileObject var1);

    public abstract Map getTaglibMap(FileObject var1);

    public abstract Image getIcon(FileObject var1);
}

