/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.core.syntax.IncludedJSPFileProcessor;
import org.netbeans.modules.web.core.syntax.JSPProcessor;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifiedJspServlet
extends JSPProcessor {
    private static final String CLASS_HEADER = "\nclass SimplifiedJSPServlet extends %s {\n\tprivate static final long serialVersionUID = 1L;\n";
    private static final String METHOD_HEADER = "\n\tvoid mergedScriptlets(\n\t\tHttpServletRequest request,\n\t\tHttpServletResponse response,\n\t\tHttpSession session,\n\t\tServletContext application,\n\t\tJspWriter out,\n\t\tServletConfig config,\n\t\tJspContext jspContext,\n\t\tObject page,\n\t\tPageContext pageContext,\n\t\tThrowable exception\n\t) throws Throwable {\n";
    private static final String CLASS_FOOTER = "\n\t}\n}";
    private CharSequence charSequence;
    private final Snapshot snapshot;
    private final ArrayList<Embedding> codeBlocks = new ArrayList();
    private List<String> localImportsFound = new ArrayList<String>();
    private List<String> localBeansFound = new ArrayList<String>();
    private Embedding header;
    private List<Embedding> scriptlets = new LinkedList<Embedding>();
    private List<Embedding> declarations = new LinkedList<Embedding>();
    private List<Embedding> localImports = new LinkedList<Embedding>();
    List<Embedding> beanDeclarations = new LinkedList<Embedding>();
    private List<Embedding> implicitImports = new LinkedList<Embedding>();
    private int expressionIndex = 1;

    public SimplifiedJspServlet(Snapshot snapshot, Document document) {
        this(snapshot, document, null);
    }

    public SimplifiedJspServlet(Snapshot snapshot, Document document, CharSequence charSequence) {
        this.doc = document;
        this.charSequence = charSequence == null ? snapshot.getText() : charSequence;
        if (document != null) {
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
            this.fobj = dataObject != null ? NbEditorUtilities.getDataObject((Document)document).getPrimaryFile() : null;
        } else {
            logger.log(Level.SEVERE, "Unable to find FileObject for document");
            this.fobj = null;
        }
        this.snapshot = snapshot;
    }

    @Override
    protected void renderProcess() throws BadLocationException {
        if (!this.isServletAPIOnClasspath()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimplifiedJspServlet.this.displayServletAPIMissingWarning();
                }
            });
            this.processingSuccessful = false;
            return;
        }
        this.processIncludes();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)this.charSequence, (Language)JspTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (!tokenSequence.moveNext()) {
            return;
        }
        do {
            List<Embedding> list;
            Token token;
            if ((token = tokenSequence.token()).id() != JspTokenId.SCRIPTLET) continue;
            int n = token.offset(tokenHierarchy);
            JspTokenId.JavaCodeType javaCodeType = (JspTokenId.JavaCodeType)token.getProperty((Object)"JAVA_CODE_TYPE");
            List<Embedding> list2 = list = javaCodeType == JspTokenId.JavaCodeType.DECLARATION ? this.declarations : this.scriptlets;
            if (javaCodeType == JspTokenId.JavaCodeType.EXPRESSION) {
                list.add(this.snapshot.create((CharSequence)String.format("\t\tObject expr%1$d = \"\" + (", this.expressionIndex++), "text/x-java"));
                list.add(this.snapshot.create(n, token.length(), "text/x-java"));
                list.add(this.snapshot.create((CharSequence)");\n", "text/x-java"));
                continue;
            }
            list.add(this.snapshot.create(n, token.length(), "text/x-java"));
            list.add(this.snapshot.create((CharSequence)"\n", "text/x-java"));
        } while (tokenSequence.moveNext());
        this.processImportsAndBeanDeclarations();
        this.header = this.snapshot.create((CharSequence)this.getClassHeader(), "text/x-java");
        this.implicitImports.add(this.snapshot.create((CharSequence)this.createImplicitImportStatements(this.localImportsFound), "text/x-java"));
        this.beanDeclarations.add(this.snapshot.create((CharSequence)("\n" + this.createBeanVarDeclarations(this.localBeansFound)), "text/x-java"));
    }

    private boolean consumeWS(TokenSequence tokenSequence) {
        if (tokenSequence.token().id() == JspTokenId.WHITESPACE) {
            return tokenSequence.moveNext();
        }
        return true;
    }

    private void processImportsAndBeanDeclarations() {
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)this.charSequence, (Language)JspTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            Object object;
            PieceOfCode pieceOfCode = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("page", "tag"), Arrays.asList("import"));
            if (pieceOfCode != null) {
                object = pieceOfCode.getContent();
                int n = 0;
                boolean bl = true;
                do {
                    int n2;
                    if ((n2 = ((String)object).indexOf(44, n)) == -1) {
                        n2 = ((String)object).length();
                        bl = false;
                    }
                    this.localImports.add(this.snapshot.create((CharSequence)"import ", "text/x-java"));
                    this.localImports.add(this.snapshot.create(pieceOfCode.getStartOffset() + n, n2 - n, "text/x-java"));
                    this.localImports.add(this.snapshot.create((CharSequence)";\n", "text/x-java"));
                    String string = ((String)object).substring(n, n2).trim();
                    this.localImportsFound.add(string);
                    n = n2 + 1;
                } while (bl);
                continue;
            }
            pieceOfCode = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("jsp:useBean"), Arrays.asList("class", "type"));
            if (pieceOfCode == null || (object = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("jsp:useBean"), Arrays.asList("id"))) == null) continue;
            this.beanDeclarations.add(this.snapshot.create(pieceOfCode.getStartOffset(), pieceOfCode.getLength(), "text/x-java"));
            this.beanDeclarations.add(this.snapshot.create((CharSequence)" ", "text/x-java"));
            this.beanDeclarations.add(this.snapshot.create(((PieceOfCode)object).getStartOffset(), ((PieceOfCode)object).getLength(), "text/x-java"));
            this.beanDeclarations.add(this.snapshot.create((CharSequence)";\n", "text/x-java"));
            String string = ((PieceOfCode)object).getContent();
            this.localBeansFound.add(string);
        }
    }

    private PieceOfCode extractCodeFromTagAttribute(TokenSequence tokenSequence, List<String> list, List<String> list2) {
        PieceOfCode pieceOfCode = null;
        if (tokenSequence.token().id() == JspTokenId.TAG && list.contains(((Object)tokenSequence.token().text()).toString())) {
            int n = tokenSequence.offset();
            while (tokenSequence.moveNext() && this.consumeWS(tokenSequence) && (tokenSequence.token().id() != JspTokenId.SYMBOL || !TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)"%>"))) {
                String string;
                if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE || !list2.contains(((Object)tokenSequence.token().text()).toString()) || !tokenSequence.moveNext() || !this.consumeWS(tokenSequence) || tokenSequence.token().id() != JspTokenId.SYMBOL || !TokenUtilities.equals((CharSequence)"=", (Object)tokenSequence.token().text()) || !tokenSequence.moveNext() || !this.consumeWS(tokenSequence) || tokenSequence.token().id() != JspTokenId.ATTR_VALUE || (string = ((Object)tokenSequence.token().text()).toString()).length() <= 2 || string.charAt(0) != '\"' && string.charAt(0) != '\'' || string.charAt(string.length() - 1) != string.charAt(0)) continue;
                int n2 = tokenSequence.offset() + 1;
                int n3 = string.length() - 1;
                String string2 = string.substring(1, n3);
                pieceOfCode = new PieceOfCode(string2, n2, string2.length());
                break;
            }
            tokenSequence.move(n);
            tokenSequence.moveNext();
        }
        return pieceOfCode;
    }

    private boolean isServletAPIOnClasspath() {
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.fobj, (String)"classpath/compile");
        return classPath != null && classPath.findResource("javax/servlet/http/HttpServlet.class") != null;
    }

    @Override
    protected void processIncludedFile(IncludedJSPFileProcessor includedJSPFileProcessor) {
        this.implicitImports.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getImports(), "text/x-java"));
        this.declarations.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getDeclarations(), "text/x-java"));
        this.scriptlets.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getScriptlets(), "text/x-java"));
    }

    private void displayServletAPIMissingWarning() {
        if (this.fobj == null) {
            return;
        }
        try {
            JEditorPane jEditorPane;
            DataObject dataObject = DataObject.find((FileObject)this.fobj);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null && editorCookie.getOpenedPanes() != null && (jEditorPane = editorCookie.getOpenedPanes()[0]) != null) {
                Utilities.setStatusBoldText((JTextComponent)jEditorPane, (String)NbBundle.getMessage(SimplifiedJspServlet.class, (String)"MSG_MissingServletAPI"));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private String getClassHeader() {
        String string = null;
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            string = pageInfo.getExtends();
        }
        if (string == null || "org.apache.jasper.runtime.HttpJspBase".equals(string)) {
            string = "HttpServlet";
        }
        return String.format(CLASS_HEADER, string);
    }

    public Embedding getSimplifiedServlet() {
        this.assureProcessCalled();
        if (!this.processingSuccessful) {
            return null;
        }
        if (this.localImports.isEmpty() && this.declarations.isEmpty() && this.scriptlets.isEmpty()) {
            return null;
        }
        LinkedList<Embedding> linkedList = new LinkedList<Embedding>();
        linkedList.addAll(this.implicitImports);
        linkedList.addAll(this.localImports);
        linkedList.add(this.header);
        linkedList.addAll(this.declarations);
        linkedList.addAll(this.beanDeclarations);
        linkedList.add(this.snapshot.create((CharSequence)METHOD_HEADER, "text/x-java"));
        linkedList.addAll(this.scriptlets);
        linkedList.add(this.snapshot.create((CharSequence)CLASS_FOOTER, "text/x-java"));
        Embedding embedding = Embedding.create(linkedList);
        if (logger.isLoggable(Level.FINEST)) {
            String string = "---\n" + embedding.getSnapshot().getText() + "\n---";
            logger.finest(string);
        }
        return embedding;
    }

    private class PieceOfCode {
        private String content;
        private int startOffset;
        private int length;

        public PieceOfCode(String string, int n, int n2) {
            this.content = string;
            this.startOffset = n;
            this.length = n2;
        }

        public String getContent() {
            return this.content;
        }

        public int getLength() {
            return this.length;
        }

        public int getStartOffset() {
            return this.startOffset;
        }
    }

    public static abstract class VirtualJavaClass {
        public final void create(Document document, String string) {
            FileObject fileObject = null;
            Object var4_4 = null;
            try {
                FileSystem fileSystem = FileUtil.createMemoryFileSystem();
                fileObject = fileSystem.getRoot().createData("SimplifiedJSPServlet", "java");
                PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream());
                printWriter.print(string);
                printWriter.close();
                Source source = Source.create((FileObject)fileObject);
                this.process(fileObject, source);
            }
            catch (IOException iOException) {
                JSPProcessor.logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }

        protected abstract void process(FileObject var1, Source var2);
    }
}

