/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.IncludedJSPFileProcessor;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSPProcessor {
    protected Document doc;
    protected FileObject fobj;
    protected static final Logger logger = Logger.getLogger(JSPProcessor.class.getName());
    protected boolean processCalled = false;
    protected boolean processingSuccessful = true;

    protected String createBeanVarDeclarations(List<String> list) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            object = this.getBeanData();
            if (object != null) {
                for (Object object2 : object) {
                    if (list.contains(object2.getId())) continue;
                    stringBuilder.append(object2.getClassName() + " " + object2.getId() + ";\n");
                }
            }
            if (pageInfo.isTagFile()) {
                for (TagAttributeInfo tagAttributeInfo : pageInfo.getTagInfo().getAttributes()) {
                    if (tagAttributeInfo.getTypeName() == null || list.contains(tagAttributeInfo.getName())) continue;
                    stringBuilder.append(tagAttributeInfo.getTypeName() + " " + tagAttributeInfo.getName() + ";\n");
                }
            }
        }
        object = JspSyntaxSupport.get(this.doc);
        JspColoringData jspColoringData = JspUtils.getJSPColoringData(this.fobj);
        if (jspColoringData != null && jspColoringData.getPrefixMapper() != null) {
            Set set = jspColoringData.getPrefixMapper().keySet();
            TagData tagData = new TagData((Object[][])null);
            for (String string : set) {
                List list2 = ((JspSyntaxSupport)((Object)object)).getAllTags(string, false);
                for (TagInfo tagInfo : list2) {
                    VariableInfo[] variableInfoArray;
                    if (tagInfo == null || (variableInfoArray = tagInfo.getVariableInfo(tagData)) == null) continue;
                    for (VariableInfo variableInfo : variableInfoArray) {
                        if (variableInfo.getVarName() == null || variableInfo.getClassName() == null || !variableInfo.getDeclare()) continue;
                        String string2 = variableInfo.getClassName() + " " + variableInfo.getVarName() + ";\n";
                        stringBuilder.append(string2);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    protected PageInfo getPageInfo() {
        JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult(this.fobj, true, false);
        if (parseResult != null) {
            return parseResult.getPageInfo();
        }
        logger.log(Level.INFO, null, "PageInfo obtained from JspParserAPI.ParseResult is null");
        return null;
    }

    private PageInfo.BeanData[] getBeanData() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            return pageInfo.getBeans();
        }
        return null;
    }

    protected void assureProcessCalled() {
        if (!this.processCalled) {
            throw new IllegalStateException("process() method must be called first!");
        }
    }

    protected void processIncludes() {
        Object object2;
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo == null) {
            return;
        }
        final TreeSet<String> treeSet = new TreeSet<String>(Collections.singleton(this.fobj.getPath()));
        if (pageInfo.getIncludePrelude() != null) {
            for (Object object2 : pageInfo.getIncludePrelude()) {
                this.processIncludedFile((String)object2, treeSet);
            }
        }
        Node.Visitor visitor = new Node.Visitor(){

            public void visit(Node.IncludeDirective includeDirective) throws JspException {
                String string = includeDirective.getAttributeValue("file");
                JSPProcessor.this.processIncludedFile(string, treeSet);
            }
        };
        object2 = JspSyntaxSupport.get(this.doc);
        try {
            JspParserAPI.ParseResult parseResult = ((JspSyntaxSupport)((Object)object2)).getParseResult();
            if (parseResult != null && parseResult.getNodes() != null) {
                parseResult.getNodes().visit(visitor);
            }
        }
        catch (JspException jspException) {
            Exceptions.printStackTrace((Throwable)jspException);
        }
    }

    private void processIncludedFile(String string, Collection<String> collection) {
        FileObject fileObject = JspUtils.getFileObject(this.doc, string);
        if (fileObject != null && fileObject.canRead() && !collection.contains(fileObject.getPath())) {
            collection.add(fileObject.getPath());
            try {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                String string2 = fileObject.getMIMEType();
                if (("text/x-jsp".equals(string2) || "text/x-tag".equals(string2)) && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                    IncludedJSPFileProcessor includedJSPFileProcessor = new IncludedJSPFileProcessor((BaseDocument)editorCookie.openDocument());
                    includedJSPFileProcessor.process();
                    this.processIncludedFile(includedJSPFileProcessor);
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    public void process() throws BadLocationException {
        this.processCalled = true;
        if (DocumentUtilities.isWriteLocked((Document)this.doc)) {
            this.processingSuccessful = false;
            return;
        }
        this.fobj = NbEditorUtilities.getFileObject((Document)this.doc);
        if (this.fobj == null) {
            this.processingSuccessful = false;
            return;
        }
        JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult(this.fobj, false, false);
        if (parseResult == null || !parseResult.isParsingSuccess()) {
            this.processingSuccessful = false;
            return;
        }
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    JSPProcessor.this.renderProcess();
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    protected abstract void processIncludedFile(IncludedJSPFileProcessor var1);

    protected abstract void renderProcess() throws BadLocationException;

    protected String createImplicitImportStatements(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getImportsFromJspParser();
        if (stringArray == null || stringArray.length == 0) {
            this.processingSuccessful = false;
        } else {
            for (String string : stringArray) {
                if (list.contains(string)) continue;
                stringBuilder.append("import " + string + ";\n");
            }
        }
        return stringBuilder.toString();
    }

    private String[] getImportsFromJspParser() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo == null) {
            return new String[]{"javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*"};
        }
        List list = pageInfo.getImports();
        return list.toArray(new String[list.size()]);
    }
}

