/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static final int HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);
    public static final int OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reparce.delay", 300);
    public static final int RESCHEDULE_OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 300);
    public static final int SEMANTIC_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_SEMANTIC_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);
    private static final Set<CsmReferenceKind> FUN_DECLARATION_KINDS = EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION);

    private ModelUtils() {
    }

    private static int getInt(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    static List<CsmReference> collect(final CsmFile csmFile, final ReferenceCollector referenceCollector) {
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext csmReferenceContext) {
                referenceCollector.visit(csmReferenceContext.getReference(), csmFile);
            }
        });
        return referenceCollector.getReferences();
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile);
    }

    static List<CsmReference> getMacroBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
    }

    private static class ReferenceCounter {
        private CsmReference reference;
        private int count;

        public ReferenceCounter(CsmReference csmReference) {
            this.reference = csmReference;
            this.count = 1;
        }

        public CsmReference getFirstReference() {
            return this.reference;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
            this.reference = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnusedVariableCollector
    implements ReferenceCollector {
        private final Map<CsmUID, ReferenceCounter> counters = new LinkedHashMap<CsmUID, ReferenceCounter>();
        private Set<CsmUID> parameters;

        public String getEntityName() {
            return "unused-variables";
        }

        @Override
        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (this.isWanted(csmObject, csmFile)) {
                CsmUID csmUID = UIDs.get((Object)csmObject);
                ReferenceCounter referenceCounter = this.counters.get(csmUID);
                if (referenceCounter == null) {
                    referenceCounter = new ReferenceCounter(csmReference);
                    this.counters.put(csmUID, referenceCounter);
                } else {
                    referenceCounter.increment();
                }
            }
        }

        @Override
        public List<CsmReference> getReferences() {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
            for (ReferenceCounter referenceCounter : this.counters.values()) {
                if (referenceCounter.getCount() != 1) continue;
                arrayList.add(referenceCounter.getFirstReference());
            }
            return arrayList;
        }

        private boolean isWanted(CsmObject csmObject, CsmFile csmFile) {
            if (!CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) {
                return false;
            }
            CsmVariable csmVariable = (CsmVariable)csmObject;
            if (!csmVariable.getContainingFile().equals(csmFile)) {
                return false;
            }
            if (CsmKindUtilities.isParameter((CsmObject)csmObject)) {
                Set<CsmUID> set = this.getFunctionDefinitionParameters(csmFile);
                return set.contains(UIDs.get((Object)csmVariable));
            }
            return true;
        }

        private Set<CsmUID> getFunctionDefinitionParameters(CsmFile csmFile) {
            if (this.parameters == null) {
                this.parameters = new HashSet<CsmUID>();
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION});
                Iterator iterator = CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
                while (iterator.hasNext()) {
                    CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)iterator.next();
                    for (CsmParameter csmParameter : csmFunctionDefinition.getParameters()) {
                        this.parameters.add(UIDs.get((Object)csmParameter));
                    }
                }
            }
            return this.parameters;
        }
    }

    static class FunctionReferenceCollector
    extends AbstractReferenceCollector {
        FunctionReferenceCollector() {
        }

        public String getEntityName() {
            return "functions-names";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            if (this.isWanted(csmReference, csmFile)) {
                this.list.add(csmReference);
            }
        }

        private boolean isWanted(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                return CsmReferenceResolver.getDefault().isKindOf(csmReference, FUN_DECLARATION_KINDS);
            }
            return false;
        }
    }

    static class TypedefReferenceCollector
    extends AbstractReferenceCollector {
        TypedefReferenceCollector() {
        }

        public String getEntityName() {
            return "typedefs";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                this.list.add(csmReference);
            }
        }
    }

    static class FieldReferenceCollector
    extends AbstractReferenceCollector {
        FieldReferenceCollector() {
        }

        public String getEntityName() {
            return "class-fields";
        }

        public void visit(CsmReference csmReference, CsmFile csmFile) {
            CsmObject csmObject = csmReference.getReferencedObject();
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                this.list.add(csmReference);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractReferenceCollector
    implements ReferenceCollector {
        protected final List<CsmReference> list = new ArrayList<CsmReference>();

        @Override
        public List<CsmReference> getReferences() {
            return this.list;
        }
    }
}

