/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyUtils {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    private static final Logger LOGGER = Logger.getLogger(RubyUtils.class.getName());
    private static final String S = "s";
    private static final String ES = "es";
    public static final String[] RUBY_KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined?", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    public static final Map<String, String> RUBY_PREDEF_VARS_CLASSES = new HashMap<String, String>();
    static final String[] RUBY_PREDEF_VAR;
    private static final String CONTROLLER_SUFFIX = "_controller.rb";
    public static final String[] RUBY_VIEW_EXTS;

    private RubyUtils() {
    }

    public static boolean isRubyFile(FileObject fileObject) {
        return RUBY_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static boolean isMarkabyFile(FileObject fileObject) {
        return "mab".equals(fileObject.getExt());
    }

    public static boolean isRhtmlFile(FileObject fileObject) {
        return "application/x-httpd-eruby".equals(fileObject.getMIMEType());
    }

    public static boolean isRubyDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return RUBY_MIME_TYPE.equals(string);
    }

    public static boolean isRhtmlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "application/x-httpd-eruby".equals(string);
    }

    public static boolean isYamlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "text/x-yaml".equals(string);
    }

    public static boolean isYamlFile(FileObject fileObject) {
        return "text/x-yaml".equals(fileObject.getMIMEType());
    }

    public static boolean isRhtmlOrYamlFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        return "text/x-yaml".equals(string) || "application/x-httpd-eruby".equals(string);
    }

    public static boolean canContainRuby(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        return RUBY_MIME_TYPE.equals(string) || "text/x-yaml".equals(string) || "application/x-httpd-eruby".equals(string);
    }

    public static String camelToUnderlinedName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = Character.isUpperCase(c);
            if (bl2) {
                if (i > 0 && !bl) {
                    stringBuilder.append('_');
                    bl = true;
                }
                c = Character.toLowerCase(c);
            }
            stringBuilder.append(c);
            bl = c == '_';
        }
        return stringBuilder.toString();
    }

    public static String pluralize(String string) {
        char c = string.charAt(string.length() - 1);
        switch (c) {
            case 'T': 
            case 't': {
                if (!RubyUtils.endsWithIgnoreCase(string, "equipment")) break;
                return string;
            }
            case 'P': 
            case 'p': {
                if (!RubyUtils.endsWithIgnoreCase(string, "sheep")) break;
                return string;
            }
            case 'D': 
            case 'd': {
                if (!RubyUtils.endsWithIgnoreCase(string, "child")) break;
                return string + "ren";
            }
            case 'N': 
            case 'n': {
                if (RubyUtils.endsWithIgnoreCase(string, "information")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "man")) {
                    return string.substring(0, string.length() - 2) + "en";
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "person")) break;
                return string.substring(0, string.length() - 5) + "eople";
            }
            case 'S': 
            case 's': {
                if (RubyUtils.endsWithIgnoreCase(string, "species") || RubyUtils.endsWithIgnoreCase(string, "series")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "axis") || RubyUtils.endsWithIgnoreCase(string, "testis")) {
                    return string.substring(0, string.length() - 2) + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "ss")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "alias") || RubyUtils.endsWithIgnoreCase(string, "status")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "us")) {
                    return string.substring(0, string.length() - 2) + "i";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "bus")) {
                    return string.substring(0, string.length() - 1) + "ses";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "sis")) {
                    return string.substring(0, string.length() - 2) + ES;
                }
                return string;
            }
            case 'O': 
            case 'o': {
                if (!RubyUtils.endsWithIgnoreCase(string, "buffalo") && !RubyUtils.endsWithIgnoreCase(string, "tomato")) break;
                return string + ES;
            }
            case 'M': 
            case 'm': {
                if (!RubyUtils.endsWithIgnoreCase(string, "tum") && !RubyUtils.endsWithIgnoreCase(string, "ium")) break;
                return string.substring(0, string.length() - 2) + "a";
            }
            case 'F': 
            case 'f': {
                if (!RubyUtils.endsWithIgnoreCase(string, "lf") && !RubyUtils.endsWithIgnoreCase(string, "rf")) break;
                return string.substring(0, string.length() - 1) + "ves";
            }
            case 'E': 
            case 'e': {
                if (RubyUtils.endsWithIgnoreCase(string, "rice")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "move")) {
                    return string + S;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "mouse") || RubyUtils.endsWithIgnoreCase(string, "louse")) {
                    return string.substring(0, string.length() - 4) + "ice";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "fe") && !RubyUtils.endsWithIgnoreCase(string, "ffe")) {
                    return string.substring(0, string.length() - 2) + "ves";
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "hive")) break;
                return string + S;
            }
            case 'Y': 
            case 'y': {
                if (RubyUtils.endsWithIgnoreCase(string, "money")) {
                    return string;
                }
                if (!string.matches(".*([^aeiouy]|qu)y$")) break;
                return string.substring(0, string.length() - 1) + "ies";
            }
            case 'X': 
            case 'x': {
                if (RubyUtils.endsWithIgnoreCase(string, "sex")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "matrix") || RubyUtils.endsWithIgnoreCase(string, "vertex") || RubyUtils.endsWithIgnoreCase(string, "index")) {
                    return string.substring(0, string.length() - 2) + "ices";
                }
                if (string.equalsIgnoreCase("ox")) {
                    return "oxen";
                }
                return string + ES;
            }
            case 'H': 
            case 'h': {
                if (RubyUtils.endsWithIgnoreCase(string, "fish")) {
                    return string;
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "ch") && !RubyUtils.endsWithIgnoreCase(string, "sh")) break;
                return string + ES;
            }
            case 'Z': 
            case 'z': {
                if (!RubyUtils.endsWithIgnoreCase(string, "quiz")) break;
                return string + "zes";
            }
        }
        return string + S;
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        if (string2.length() > string.length()) {
            return false;
        }
        return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static String tableize(String string) {
        return RubyUtils.pluralize(RubyUtils.camelToUnderlinedName(string));
    }

    public static boolean isOperator(String string) {
        if (string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case '+': {
                return string.equals("+") || string.equals("+@");
            }
            case '-': {
                return string.equals("-") || string.equals("-@");
            }
            case '*': {
                return string.equals("*") || string.equals("**");
            }
            case '<': {
                return string.equals("<") || string.equals("<<") || string.equals("<=") || string.equals("<=>");
            }
            case '>': {
                return string.equals(">") || string.equals(">>") || string.equals(">=");
            }
            case '=': {
                return string.equals("=") || string.equals("==") || string.equals("===") || string.equals("=~");
            }
            case '!': {
                return string.equals("!=") || string.equals("!~");
            }
            case '&': {
                return string.equals("&") || string.equals("&&");
            }
            case '|': {
                return string.equals("|") || string.equals("||");
            }
            case '[': {
                return string.equals("[]") || string.equals("[]=");
            }
            case '%': {
                return string.equals("%");
            }
            case '/': {
                return string.equals("/");
            }
            case '~': {
                return string.equals("~");
            }
            case '^': {
                return string.equals("^");
            }
            case '`': {
                return string.equals("`");
            }
        }
        return false;
    }

    public static boolean isSafeIdentifierName(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        if ("".equals(string.substring(n).trim())) {
            return false;
        }
        for (n2 = n; n2 < n3 && ((c = string.charAt(n2)) == '$' || c == '@' || c == ':'); ++n2) {
            if (n2 > 0 && c != '@') {
                return false;
            }
            if (n2 > 1) {
                return false;
            }
            if (n2 + 1 != n3) continue;
            return false;
        }
        if (Character.isDigit(string.charAt(n2))) {
            return false;
        }
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (!(c >= 'a' && c <= 'z' || c == '_' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '?' || c == '=' || c == '!')) {
                return RubyUtils.isOperator(string);
            }
            ++n2;
        }
        return true;
    }

    public static String getIdentifierWarning(String string, int n) {
        if (RubyUtils.isSafeIdentifierName(string, n)) {
            return null;
        }
        return NbBundle.getMessage(RubyUtils.class, (String)"UnsafeIdentifierName");
    }

    public static String underlinedNameToCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            if (c == '/') {
                bl = true;
                stringBuilder.append("::");
                continue;
            }
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidConstantFQN(String string) {
        String[] stringArray;
        if (string.trim().length() == 0) {
            return false;
        }
        for (String string2 : stringArray = string.split("::")) {
            if (RubyUtils.isValidConstantName(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidConstantName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!RubyUtils.isStrictIdentifierChar(c)) {
                return false;
            }
            if (c != '!' && c != '=' && c != '?') continue;
            return false;
        }
        return true;
    }

    static String[] parseConstantName(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf("::");
        if (n != -1) {
            string3 = string.substring(n + 2);
            string2 = string.substring(0, n);
        } else {
            string3 = string;
            string2 = "Kernel";
        }
        return new String[]{string2, string3};
    }

    public static boolean isValidRubyLocalVarName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyMethodName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (RubyUtils.isOperator(string)) {
            return true;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return i == string.length() - 1 && (c == '!' || c == '=' || c == '?');
        }
        return true;
    }

    public static boolean isValidRubyIdentifier(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRubyKeyword(String string) {
        return Arrays.binarySearch(RUBY_KEYWORDS, string) >= 0;
    }

    public static boolean isRubyPredefVar(String string) {
        return Arrays.binarySearch(RUBY_PREDEF_VAR, string) >= 0;
    }

    public static String getLineCommentPrefix() {
        return "#";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '@' || c == '&' || c == ':' || c == '!' || c == '?' || c == '=';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '!' || c == '?' || c == '=';
    }

    public static String getControllerClass(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            String string = fileObject.getName();
            for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != fileObject2 && fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                string = fileObject3.getName() + "/" + string;
            }
            return RubyUtils.underlinedNameToCamel(string);
        }
        return null;
    }

    public static List<String> getControllerNames(FileObject fileObject, boolean bl) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            RubyUtils.addControllerNames(fileObject2, arrayList, bl);
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static void addControllerNames(FileObject fileObject, List<String> list, boolean bl) {
        String string = fileObject.getNameExt();
        if (string.endsWith(CONTROLLER_SUFFIX)) {
            void var4_6;
            String object = string.substring(0, string.length() - CONTROLLER_SUFFIX.length());
            if (!bl) {
                String string2 = RubyUtils.underlinedNameToCamel(object);
            }
            list.add((String)var4_6);
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            RubyUtils.addControllerNames(fileObject2, list, bl);
        }
    }

    public static String getControllerName(FileObject fileObject) {
        String string;
        String string2 = "_controller";
        String string3 = "controllers";
        String string4 = string = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
        for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (fileObject2.getName().equals(string3) && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                fileObject2 = fileObject2.getParent();
                break;
            }
            string4 = fileObject2.getNameExt() + "/" + string4;
        }
        return string4;
    }

    public static FileObject getRailsViewFor(FileObject fileObject, String string, boolean bl, boolean bl2) {
        String string2 = bl ? "_helper" : "_controller";
        String string3 = bl ? "helpers" : "controllers";
        Object object = null;
        try {
            FileObject fileObject2;
            String string4;
            String string5 = string4 = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
            for (fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                if (fileObject2.getName().equals(string3) && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                    fileObject2 = fileObject2.getParent();
                    break;
                }
                string5 = fileObject2.getNameExt() + "/" + string5;
            }
            if (fileObject2 == null) {
                return null;
            }
            FileObject fileObject3 = fileObject2.getFileObject("views/" + string5);
            if (fileObject3 == null) {
                return null;
            }
            if (string != null) {
                String string6;
                String[] stringArray = RUBY_VIEW_EXTS;
                int n = stringArray.length;
                for (int i = 0; i < n && (object = fileObject3.getFileObject(string, string6 = stringArray[i])) == null; ++i) {
                }
                if (object == null && bl2) {
                    return null;
                }
            }
            if (object == null && (object = fileObject3.getFileObject("index.rhtml")) == null) {
                block4: for (String string6 : fileObject3.getChildren()) {
                    String string7 = string6.getExt();
                    for (String string8 : RUBY_VIEW_EXTS) {
                        if (!string7.equalsIgnoreCase(string8)) continue;
                        object = string6;
                        continue block4;
                    }
                }
            }
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (object == null) {
            return null;
        }
        return object;
    }

    public static FileObject getRailsControllerFor(FileObject fileObject) {
        FileObject fileObject2 = null;
        try {
            FileObject fileObject3;
            fileObject = fileObject.getParent();
            String string = fileObject.getName();
            String string2 = "";
            if (!string.startsWith("_")) {
                string2 = string;
            }
            for (fileObject3 = fileObject.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                if (fileObject3.getName().equals("views") && (fileObject3.getParent() == null || fileObject3.getParent().getName().equals("app"))) {
                    fileObject3 = fileObject3.getParent();
                    break;
                }
                string2 = fileObject3.getNameExt() + "/" + string2;
            }
            if (fileObject3 == null) {
                return null;
            }
            fileObject2 = fileObject3.getFileObject("controllers/" + string2 + CONTROLLER_SUFFIX);
        }
        catch (Exception exception) {
            return null;
        }
        return fileObject2;
    }

    static String join(String[] stringArray, String string) {
        return RubyUtils.join(Arrays.asList(stringArray), string);
    }

    static String join(Iterable<? extends String> iterable, String string) {
        Iterator<? extends String> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static BaseDocument getDocument(Parser.Result result) {
        return RubyUtils.getDocument(result, false);
    }

    public static BaseDocument getDocument(Parser.Result result, boolean bl) {
        return (BaseDocument)result.getSnapshot().getSource().getDocument(bl);
    }

    public static FileObject getFileObject(Parser.Result result) {
        return result.getSnapshot().getSource().getFileObject();
    }

    static boolean isRubyStubsURL(String string) {
        return string != null && string.indexOf("rubystubs") != -1;
    }

    static boolean isPlatformFile(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return true;
        }
        RubyPlatformProvider rubyPlatformProvider = (RubyPlatformProvider)project.getLookup().lookup(RubyPlatformProvider.class);
        return rubyPlatformProvider == null;
    }

    static {
        RUBY_PREDEF_VARS_CLASSES.put("__FILE__", "String");
        RUBY_PREDEF_VARS_CLASSES.put("__LINE__", "Fixnum");
        RUBY_PREDEF_VARS_CLASSES.put("ARGF", "Object");
        RUBY_PREDEF_VARS_CLASSES.put("ARGV", "Array");
        RUBY_PREDEF_VARS_CLASSES.put("DATA", "File");
        RUBY_PREDEF_VARS_CLASSES.put("DATA", "IO");
        RUBY_PREDEF_VARS_CLASSES.put("ENV", "Object");
        RUBY_PREDEF_VARS_CLASSES.put("FALSE", "FalseClass");
        RUBY_PREDEF_VARS_CLASSES.put("NIL", "NilClass");
        RUBY_PREDEF_VARS_CLASSES.put("RUBY_PLATFORM", "String");
        RUBY_PREDEF_VARS_CLASSES.put("RUBY_RELEASE_DATE", "String");
        RUBY_PREDEF_VARS_CLASSES.put("RUBY_VERSION", "String");
        RUBY_PREDEF_VARS_CLASSES.put("SCRIPT_LINES__", "Hash");
        RUBY_PREDEF_VARS_CLASSES.put("STDERR", "IO");
        RUBY_PREDEF_VARS_CLASSES.put("STDIN", "IO");
        RUBY_PREDEF_VARS_CLASSES.put("STDOUT", "IO");
        RUBY_PREDEF_VARS_CLASSES.put("TOPLEVEL_BINDING", "Binding");
        RUBY_PREDEF_VARS_CLASSES.put("TRUE", "TrueClass");
        RUBY_PREDEF_VAR = RUBY_PREDEF_VARS_CLASSES.keySet().toArray(new String[RUBY_PREDEF_VARS_CLASSES.size()]);
        Arrays.sort(RUBY_KEYWORDS);
        Arrays.sort(RUBY_PREDEF_VAR);
        RUBY_VIEW_EXTS = new String[]{"rhtml", "erb", "dryml", "mab", "rjs", "haml", "rxml", "dryml", "html.erb"};
    }
}

