/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ReturnNode;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyMethodTypeInferencer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeAnalyzer;

public final class RubyTypeInferencer {
    private final ContextKnowledge knowledge;
    private RubyTypeAnalyzer analyzer;
    private final boolean fast;

    public static RubyTypeInferencer fast(ContextKnowledge contextKnowledge) {
        return new RubyTypeInferencer(contextKnowledge, true);
    }

    public static RubyTypeInferencer normal(ContextKnowledge contextKnowledge) {
        return new RubyTypeInferencer(contextKnowledge, false);
    }

    private RubyTypeInferencer(ContextKnowledge contextKnowledge, boolean bl) {
        this.knowledge = contextKnowledge;
        this.fast = bl;
    }

    private void initializeAnalyzer() {
        if (this.analyzer == null) {
            assert (this.knowledge != null) : "need ContextKnowledge for RubyTypeAnalyzer";
            this.analyzer = new RubyTypeAnalyzer(this.knowledge);
        }
    }

    public RubyType inferType(String string) {
        Object object;
        this.initializeAnalyzer();
        this.analyzer.analyze();
        RubyType rubyType = this.knowledge.getType(string);
        if (rubyType == null) {
            rubyType = RubyType.createUnknown();
        }
        if (!rubyType.isKnown() && "t".equals(string) && this.knowledge.getRoot().getNodeType() == NodeType.DEFSNODE && ("up".equals(object = AstUtilities.getName(this.knowledge.getRoot())) || "down".equals(object))) {
            return RubyType.create("ActiveRecord::ConnectionAdapters::TableDefinition");
        }
        if (rubyType.isKnown()) {
            for (String string2 : rubyType.getRealTypes()) {
                if (!string2.startsWith("Array<")) continue;
                return RubyType.ARRAY;
            }
        }
        return rubyType;
    }

    RubyType inferTypesOfRHS(Node node) {
        List list = node.childNodes();
        if (list.size() != 1) {
            return RubyType.createUnknown();
        }
        return this.inferType((Node)list.get(0));
    }

    RubyType inferType(Node node) {
        RubyType rubyType = this.knowledge.getType(node);
        if (rubyType != null) {
            return rubyType;
        }
        if (!this.knowledge.wasAnalyzed()) {
            new RubyTypeAnalyzer(this.knowledge).analyze();
        }
        switch (node.getNodeType()) {
            case LOCALVARNODE: 
            case DVARNODE: 
            case INSTVARNODE: 
            case GLOBALVARNODE: 
            case CLASSVARNODE: 
            case COLON2NODE: {
                rubyType = this.knowledge.getType(AstUtilities.getName(node));
                break;
            }
            case RETURNNODE: {
                ReturnNode returnNode = (ReturnNode)node;
                rubyType = this.inferType(returnNode.getValueNode());
            }
        }
        if (rubyType == null && AstUtilities.isCall(node)) {
            rubyType = RubyMethodTypeInferencer.inferTypeFor(node, this.knowledge, this.fast);
        }
        if (rubyType == null) {
            rubyType = RubyTypeInferencer.getTypeForLiteral(node);
        }
        this.knowledge.setType(node, rubyType);
        return rubyType;
    }

    static RubyType getTypeForLiteral(Node node) {
        switch (node.getNodeType()) {
            case ARRAYNODE: 
            case ZARRAYNODE: {
                return RubyType.ARRAY;
            }
            case STRNODE: 
            case DSTRNODE: 
            case XSTRNODE: 
            case DXSTRNODE: {
                return RubyType.STRING;
            }
            case FIXNUMNODE: {
                return RubyType.FIXNUM;
            }
            case BIGNUMNODE: {
                return RubyType.BIGNUM;
            }
            case HASHNODE: {
                return RubyType.HASH;
            }
            case REGEXPNODE: 
            case DREGEXPNODE: {
                return RubyType.REGEXP;
            }
            case SYMBOLNODE: 
            case DSYMBOLNODE: {
                return RubyType.SYMBOL;
            }
            case FLOATNODE: {
                return RubyType.FLOAT;
            }
            case NILNODE: {
                if (node.isInvisible()) break;
                return RubyType.NIL_CLASS;
            }
            case TRUENODE: {
                return RubyType.TRUE_CLASS;
            }
            case FALSENODE: {
                return RubyType.FALSE_CLASS;
            }
        }
        return RubyType.createUnknown();
    }

    public String toString() {
        return "RubyTypeAnalyzer[knowledge:" + this.knowledge + ']';
    }
}

