/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.Map;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyTypeAnalyzer {
    private ContextKnowledge knowledge;
    private boolean analyzed;
    private boolean targetReached;
    private static final String[] RAILS_CONTROLLER_VARS = new String[]{"action_name", "String", "assigns", "Hash", "cookies", "ActionController::CookieJar", "flash", "ActionController::Flash::FlashHash", "headers", "Hash", "params", "Hash", "request", "ActionController::CgiRequest", "session", "CGI::Session", "url", "ActionController::UrlRewriter"};

    RubyTypeAnalyzer(ContextKnowledge contextKnowledge) {
        this.knowledge = contextKnowledge;
    }

    void analyze() {
        if (!this.analyzed) {
            this.knowledge.setAnalyzed(true);
            RubyTypeAnalyzer.initFileTypeVars(this.knowledge);
            RDocAnalyzer.collectTypeAssertions(this.knowledge);
            this.analyze(this.knowledge.getRoot(), this.knowledge.getTypesForSymbols(), true);
            this.analyzed = true;
        }
    }

    private void analyze(Node node, Map<String, RubyType> map, boolean bl) {
        if (node == this.knowledge.getTarget()) {
            this.targetReached = true;
        }
        if (this.targetReached && node.getPosition().getStartOffset() > this.knowledge.getAstOffset()) {
            return;
        }
        switch (node.getNodeType()) {
            case LOCALASGNNODE: 
            case INSTASGNNODE: 
            case GLOBALASGNNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: {
                RubyType rubyType = RubyTypeInferencer.normal(this.knowledge).inferTypesOfRHS(node);
                String string = AstUtilities.getName(node);
                this.maybePutTypeForSymbol(map, string, rubyType, bl);
                break;
            }
        }
        if (node.getNodeType() == NodeType.IFNODE) {
            this.analyzeIfNode((IfNode)node, map);
        } else {
            for (String string : node.childNodes()) {
                if (string.isInvisible()) continue;
                this.analyze((Node)string, map, bl);
            }
        }
    }

    private void analyzeIfNode(IfNode ifNode, Map<String, RubyType> map) {
        Node node = ifNode.getThenBody();
        HashMap<String, RubyType> hashMap = new HashMap<String, RubyType>();
        if (node != null) {
            this.analyze(node, hashMap, true);
        }
        Node node2 = ifNode.getElseBody();
        HashMap<String, RubyType> hashMap2 = new HashMap<String, RubyType>();
        if (node2 != null) {
            this.analyze(node2, hashMap2, true);
        }
        HashMap<String, RubyType> hashMap3 = new HashMap<String, RubyType>();
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.maybePutTypeForSymbol(hashMap3, (String)entry.getKey(), (RubyType)entry.getValue(), false);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.maybePutTypeForSymbol(hashMap3, (String)entry.getKey(), (RubyType)entry.getValue(), false);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            String string = (String)entry.getKey();
            boolean bl = hashMap.containsKey(string) && hashMap2.containsKey(string);
            this.maybePutTypeForSymbol(map, string, (RubyType)entry.getValue(), bl);
        }
    }

    private static void initFileTypeVars(ContextKnowledge contextKnowledge) {
        if (!contextKnowledge.hasFileObject()) {
            return;
        }
        String string = contextKnowledge.getFileObject().getExt();
        if (string.equals("rb")) {
            String string2 = contextKnowledge.getFileObject().getName();
            if (string2.endsWith("_controller")) {
                for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                    String string3 = RAILS_CONTROLLER_VARS[i];
                    String string4 = RAILS_CONTROLLER_VARS[i + 1];
                    contextKnowledge.maybePutTypeForSymbol(string3, string4, true);
                }
            }
        } else if (string.equals("rhtml") || string.equals("erb")) {
            for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                String string5 = RAILS_CONTROLLER_VARS[i];
                String string6 = RAILS_CONTROLLER_VARS[i + 1];
                contextKnowledge.maybePutTypeForSymbol(string5, string6, true);
            }
        } else if (string.equals("rjs")) {
            contextKnowledge.maybePutTypeForSymbol("page", "ActionView::Helpers::PrototypeHelper::JavaScriptGenerator::GeneratorMethods", true);
        } else if (string.equals("builder") || string.equals("rxml")) {
            contextKnowledge.maybePutTypeForSymbol("xml", "Builder::XmlMarkup", true);
        }
    }

    private void maybePutTypeForSymbol(Map<String, RubyType> map, String string, RubyType rubyType, boolean bl) {
        RubyType rubyType2 = map.get(string);
        if (rubyType2 == null || bl) {
            rubyType2 = new RubyType();
            map.put(string, rubyType2);
        }
        rubyType2.append(rubyType);
    }
}

