/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.RubyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyType {
    private static final Logger LOGGER = Logger.getLogger(RubyType.class.getName());
    public static final RubyType ARRAY = new RubyType("Array");
    public static final RubyType BIGNUM = new RubyType("Bignum");
    public static final RubyType FALSE_CLASS = new RubyType("FalseClass");
    public static final RubyType FIXNUM = new RubyType("Fixnum");
    public static final RubyType FLOAT = new RubyType("Float");
    public static final RubyType HASH = new RubyType("Hash");
    public static final RubyType NIL_CLASS = new RubyType("NilClass");
    public static final RubyType OBJECT = new RubyType("Object");
    public static final RubyType RANGE = new RubyType("Range");
    public static final RubyType REGEXP = new RubyType("Regexp");
    public static final RubyType STRING = new RubyType("String");
    public static final RubyType SYMBOL = new RubyType("Symbol");
    public static final RubyType TRUE_CLASS = new RubyType("TrueClass");
    public static final RubyType INTEGER = new RubyType("Integer");
    public static final RubyType BOOLEAN = new RubyType(TRUE_CLASS, FALSE_CLASS);
    private static final Map<String, RubyType> CORE_TYPES = new HashMap<String, RubyType>(16);
    private Set<String> realTypes;
    private boolean hasUnknownMember;

    public static RubyType create(String string) {
        RubyType.checkType(string);
        RubyType rubyType = CORE_TYPES.get(string);
        return rubyType == null ? new RubyType(string) : rubyType;
    }

    public static RubyType createUnknown() {
        RubyType rubyType = new RubyType();
        rubyType.hasUnknownMember = true;
        return rubyType;
    }

    public RubyType() {
        this.realTypes = new LinkedHashSet<String>();
    }

    public RubyType(RubyType ... rubyTypeArray) {
        this.realTypes = new LinkedHashSet<String>();
        for (RubyType rubyType : rubyTypeArray) {
            this.append(rubyType);
        }
    }

    public RubyType(String ... stringArray) {
        assert (!Arrays.asList(stringArray).contains(null)) : "cannot add arrays with null realType member";
        this.realTypes = new LinkedHashSet<String>(Arrays.asList(stringArray));
    }

    private RubyType(String string) {
        assert (string != null) : "cannot add null realType";
        RubyType.checkType(string);
        this.realTypes = Collections.singleton(string);
    }

    public Iterable<? extends String> getRealTypes() {
        return this.realTypes;
    }

    public String first() {
        return this.getRealTypes().iterator().next();
    }

    void append(RubyType rubyType) {
        assert (!rubyType.realTypes.contains(null)) : "cannot add arrays with null realType member";
        if (rubyType.isKnown()) {
            this.realTypes.addAll(rubyType.realTypes);
        }
        if (rubyType.hasUnknownMember()) {
            this.hasUnknownMember = true;
        }
    }

    void add(String string) {
        assert (string != null) : "cannot add null realType";
        RubyType.checkType(string);
        this.realTypes.add(string);
    }

    private static void checkType(String string) {
        if (LOGGER.isLoggable(Level.FINE) && (string.length() == 0 || Character.isLowerCase(string.charAt(0)))) {
            LOGGER.log(Level.FINE, "Likely not a valid type {0}", string);
        }
    }

    public boolean isSingleton() {
        return this.isKnown() && this.realTypes.size() == 1;
    }

    public boolean isKnown() {
        return !this.realTypes.isEmpty();
    }

    boolean hasUnknownMember() {
        return this.hasUnknownMember;
    }

    String asIndexedString() {
        return this.asString("|");
    }

    String asString(String string) {
        return RubyUtils.join(this.realTypes, string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RubyType rubyType = (RubyType)object;
        if (!(this.realTypes == rubyType.realTypes || this.realTypes != null && ((Object)this.realTypes).equals(rubyType.realTypes))) {
            return false;
        }
        return this.hasUnknownMember == rubyType.hasUnknownMember;
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.realTypes != null ? ((Object)this.realTypes).hashCode() : 0);
        n = 97 * n + (this.hasUnknownMember ? 1 : 0);
        return n;
    }

    public String toString() {
        return "RubyType[realTypes:" + this.realTypes + ", hasUnknownMember: " + this.hasUnknownMember + ']';
    }

    static {
        CORE_TYPES.put(ARRAY.first(), ARRAY);
        CORE_TYPES.put(BIGNUM.first(), BIGNUM);
        CORE_TYPES.put(FALSE_CLASS.first(), FALSE_CLASS);
        CORE_TYPES.put(FIXNUM.first(), FIXNUM);
        CORE_TYPES.put(FLOAT.first(), FLOAT);
        CORE_TYPES.put(HASH.first(), HASH);
        CORE_TYPES.put(NIL_CLASS.first(), NIL_CLASS);
        CORE_TYPES.put(OBJECT.first(), OBJECT);
        CORE_TYPES.put(RANGE.first(), RANGE);
        CORE_TYPES.put(REGEXP.first(), REGEXP);
        CORE_TYPES.put(STRING.first(), STRING);
        CORE_TYPES.put(SYMBOL.first(), SYMBOL);
        CORE_TYPES.put(TRUE_CLASS.first(), TRUE_CLASS);
    }
}

