/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyStructureAnalyzer
implements StructureScanner {
    private Set<AstClassElement> haveAccessModifiers;
    private List<AstElement> structure;
    private Map<AstClassElement, Set<InstAsgnNode>> fields;
    private Map<String, GlobalAsgnNode> globals;
    private Set<String> requires;
    private List<AstMethodElement> methods;
    private Map<AstClassElement, Set<AstAttributeElement>> attributes;
    private RubyParseResult result;
    private RubyIndex index;
    private RubyTypeInferencer typeInferencer;
    private boolean isTestFile;
    private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
    private static ImageIcon keywordIcon;
    private static final Map<File, AnalysisResult> cache;
    private static Set<FileObject> currentlyAnalyzingWithIndex;
    private static final int MAX_RUBY_LABEL_LENGTH = 30;
    private static final String DEFAULT_LABEL = "<% %>";

    public List<? extends StructureItem> scan(ParserResult parserResult) {
        if (RubyUtils.isRhtmlOrYamlFile(RubyUtils.getFileObject((Parser.Result)parserResult))) {
            return this.scanRhtml(parserResult);
        }
        this.result = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (this.result == null) {
            return Collections.emptyList();
        }
        AnalysisResult analysisResult = this.result.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
        for (AstElement astElement : list) {
            arrayList.add(new RubyStructureItem(astElement, parserResult));
        }
        return arrayList;
    }

    private AnalysisResult scan(RubyParseResult rubyParseResult) {
        Object object;
        Object object2;
        Set<InstAsgnNode> set;
        AnalysisResult analysisResult = new AnalysisResult();
        Node node = AstUtilities.getRoot((Parser.Result)rubyParseResult);
        if (node == null) {
            return analysisResult;
        }
        this.isTestFile = false;
        String string = RubyUtils.getFileObject((Parser.Result)rubyParseResult).getNameExt();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("test_") || string.endsWith("_test") || string.endsWith("_spec")) {
            this.isTestFile = true;
        }
        this.structure = new ArrayList<AstElement>();
        this.fields = new HashMap<AstClassElement, Set<InstAsgnNode>>();
        this.attributes = new HashMap<AstClassElement, Set<AstAttributeElement>>();
        this.requires = new HashSet<String>();
        this.methods = new ArrayList<AstMethodElement>();
        this.haveAccessModifiers = new HashSet<AstClassElement>();
        AstPath astPath = new AstPath();
        astPath.descend(node);
        ContextKnowledge contextKnowledge = new ContextKnowledge(this.index, node);
        this.typeInferencer = RubyTypeInferencer.normal(contextKnowledge);
        this.scan(node, astPath, null, null, null);
        astPath.ascend();
        HashMap<String, InstAsgnNode> hashMap = new HashMap<String, InstAsgnNode>();
        for (AstClassElement object3 : this.fields.keySet()) {
            set = this.fields.get(object3);
            if (set == null) continue;
            for (InstAsgnNode instAsgnNode : set) {
                hashMap.put(instAsgnNode.getName(), instAsgnNode);
            }
            for (InstAsgnNode instAsgnNode : hashMap.values()) {
                AstFieldElement astFieldElement = new AstFieldElement(rubyParseResult, (Node)instAsgnNode);
                astFieldElement.setIn(object3.getFqn());
                object2 = instAsgnNode.getName();
                if (((String)object2).startsWith("@@")) {
                    object2 = ((String)object2).substring(2);
                } else if (((String)object2).startsWith("@")) {
                    object2 = ((String)object2).substring(1);
                }
                boolean bl = false;
                for (AstElement astElement : object3.getChildren()) {
                    if (astElement.getKind() != ElementKind.ATTRIBUTE || !astElement.getName().equals(object2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object3.addChild(astFieldElement);
            }
            hashMap.clear();
        }
        if (this.globals != null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.globals.keySet());
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                set = (String)iterator.next();
                object = this.globals.get(set);
                AstNameElement astNameElement = new AstNameElement(rubyParseResult, (Node)object, (String)((Object)set), ElementKind.GLOBAL);
                this.structure.add(astNameElement);
            }
            hashMap.clear();
        }
        for (AstClassElement astClassElement : this.haveAccessModifiers) {
            set = new HashSet<InstAsgnNode>();
            object = new HashSet();
            AstUtilities.findPrivateMethods(astClassElement.getNode(), (Set<Node>)set, (Set<Node>)object);
            if (object.size() > 0) {
                for (AstMethodElement astMethodElement : this.methods) {
                    if (!(astMethodElement instanceof AstMethodElement) || !object.contains(((AstElement)(object2 = astMethodElement)).getNode())) continue;
                    ((AstMethodElement)object2).setAccess(Modifier.PRIVATE);
                }
            }
            if (set.size() <= 0) continue;
            for (AstMethodElement astMethodElement : this.methods) {
                if (!(astMethodElement instanceof AstMethodElement) || !set.contains(((AstElement)(object2 = astMethodElement)).getNode())) continue;
                ((AstMethodElement)object2).setAccess(Modifier.PROTECTED);
            }
        }
        analysisResult.setElements(this.structure);
        analysisResult.setAttributes(this.attributes);
        analysisResult.setRequires(this.requires);
        return analysisResult;
    }

    private AnalysisResult getCachedAnalysis(RubyParseResult rubyParseResult) {
        return null;
    }

    private void cacheAnalysis(RubyParseResult rubyParseResult, AnalysisResult analysisResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        HashMap<String, List<OffsetRange>> hashMap;
        block7: {
            if (RubyUtils.isRhtmlFile(RubyUtils.getFileObject((Parser.Result)parserResult))) {
                return Collections.emptyMap();
            }
            Node node = AstUtilities.getRoot((Parser.Result)parserResult);
            if (node == null) {
                return Collections.emptyMap();
            }
            RubyParseResult rubyParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
            AnalysisResult analysisResult = rubyParseResult.getStructure();
            hashMap = new HashMap<String, List<OffsetRange>>();
            ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
            hashMap.put("codeblocks", arrayList);
            try {
                BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
                if (baseDocument == null) break block7;
                try {
                    baseDocument.readLock();
                    this.addFolds(baseDocument, analysisResult.getElements(), hashMap, arrayList);
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return hashMap;
    }

    private void addFolds(BaseDocument baseDocument, List<? extends AstElement> list, Map<String, List<OffsetRange>> map, List<OffsetRange> list2) throws BadLocationException {
        for (AstElement astElement : list) {
            Object object;
            ElementKind elementKind = astElement.getKind();
            switch (elementKind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case CLASS: 
                case MODULE: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRange((Node)object);
                    if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR && offsetRange.getStart() <= Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange.getStart())) break;
                    int n = offsetRange.getStart();
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                    break;
                }
                case TEST: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRange((Node)object);
                    int n = offsetRange.getStart();
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                    break;
                }
            }
            if ((object = astElement.getChildren()) == null || object.size() <= 0) continue;
            this.addFolds(baseDocument, (List<? extends AstElement>)object, map, list2);
        }
    }

    private void scan(Node node, AstPath astPath, String string, Set<String> set, AstElement object) {
        Object object2;
        Object object3;
        switch (node.getNodeType()) {
            case CLASSNODE: {
                object3 = new AstClassElement(this.result, node);
                ((AstElement)object3).setIn(string);
                String string2 = AstUtilities.getFqnName(astPath);
                ((AstClassElement)object3).setFqn(string2);
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node));
                set = new HashSet<String>();
                ((AstClassElement)object3).setIncludes(set);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case MODULENODE: {
                object3 = new AstModuleElement(this.result, node);
                ((AstElement)object3).setIn(string);
                ((AstModuleElement)object3).setFqn(AstUtilities.getFqnName(astPath));
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ModuleNode)node));
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case SCLASSNODE: {
                object3 = new AstClassElement(this.result, node);
                ((AstElement)object3).setIn(string);
                ((AstClassElement)object3).setFqn(AstUtilities.getFqnName(astPath));
                Node node2 = ((SClassNode)node).getReceiverNode();
                string = node2 instanceof INameNode ? AstUtilities.getName(node2) : null;
                set = new HashSet<String>();
                ((AstClassElement)object3).setIncludes(set);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                String string3;
                object3 = new AstMethodElement(this.result, node);
                this.methods.add((AstMethodElement)object3);
                ((AstElement)object3).setIn(string);
                if (node instanceof DefnNode && "initialize".equals(AstUtilities.getName(node))) {
                    ((AstMethodElement)object3).setAccess(Modifier.PRIVATE);
                } else if (object != null && ((AstElement)object).getNode() instanceof SClassNode) {
                    ((AstMethodElement)object3).setModifiers(EnumSet.of(Modifier.STATIC));
                }
                if (node instanceof DefsNode && object instanceof AstModuleElement && "included".equals(AstUtilities.getName(node)) && (string3 = this.getExtendWith((MethodDefNode)((DefsNode)node))) != null) {
                    if (string3.indexOf(58) == -1) {
                        object2 = AstUtilities.getFqnName(astPath);
                        string3 = (String)object2 + "::" + string3;
                    }
                    ((AstModuleElement)object).setExtendWith(string3);
                }
                if (node instanceof DefnNode) {
                    string3 = AstUtilities.getName(node);
                    object2 = (DefnNode)node;
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    AstUtilities.findExitPoints((MethodDefNode)object2, linkedHashSet);
                    RubyType rubyType = new RubyType();
                    for (Node node3 : linkedHashSet) {
                        if (node3.getNodeType() == NodeType.FCALLNODE) continue;
                        rubyType.append(this.typeInferencer.inferType(node3));
                    }
                    ((AstElement)object3).setType(rubyType);
                }
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                    break;
                }
                this.structure.add((AstElement)object3);
                break;
            }
            case CONSTDECLNODE: {
                object3 = (ConstDeclNode)node;
                AstNameElement astNameElement = new AstNameElement(this.result, node, AstUtilities.getName(node), ElementKind.CONSTANT);
                astNameElement.setType(this.typeInferencer.inferTypesOfRHS((Node)object3));
                astNameElement.setIn(string);
                if (object != null) {
                    ((AstElement)object).addChild(astNameElement);
                    break;
                }
                this.structure.add(astNameElement);
                break;
            }
            case CLASSVARDECLNODE: {
                object3 = new AstFieldElement(this.result, node);
                ((AstElement)object3).setIn(string);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                    break;
                }
                this.structure.add((AstElement)object3);
                break;
            }
            case GLOBALASGNNODE: {
                if (this.globals == null) {
                    this.globals = new HashMap<String, GlobalAsgnNode>();
                }
                object3 = (GlobalAsgnNode)node;
                this.globals.put(object3.getName(), (GlobalAsgnNode)object3);
                break;
            }
            case INSTASGNNODE: {
                if (!(object instanceof AstClassElement)) break;
                object3 = this.fields.get(object);
                if (object3 == null) {
                    object3 = new HashSet();
                    this.fields.put((AstClassElement)object, (Set<InstAsgnNode>)object3);
                }
                object3.add((InstAsgnNode)node);
                break;
            }
            case VCALLNODE: {
                object3 = AstUtilities.getName(node);
                if (!"private".equals(object3) && !"protected".equals(object3) || !(object instanceof AstClassElement)) break;
                this.haveAccessModifiers.add((AstClassElement)object);
                break;
            }
            case LOCALASGNNODE: {
                if (object != null || AstUtilities.findMethod(astPath) != null) break;
                object3 = AstUtilities.getName(node);
                boolean bl = false;
                for (AstElement astElement : this.structure) {
                    if (astElement.getKind() != ElementKind.VARIABLE || !((String)object3).equals(astElement.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                object2 = new AstNameElement(this.result, node, (String)object3, ElementKind.VARIABLE);
                assert (node instanceof LocalAsgnNode) : "LocalAsgnNode expected";
                ((AstElement)object2).setType(this.typeInferencer.inferTypesOfRHS(node));
                ((AstElement)object2).setIn(string);
                this.structure.add((AstElement)object2);
                break;
            }
            case FCALLNODE: {
                Object object4;
                Object object5;
                Object object6;
                object3 = AstUtilities.getName(node);
                if (((String)object3).equals("require")) {
                    String string4;
                    Node node4;
                    Node node5 = ((FCallNode)node).getArgsNode();
                    if (!(node5 instanceof ListNode) || (object2 = (ListNode)node5).size() <= 0 || !((node4 = object2.get(0)) instanceof StrNode) || (string4 = ((StrNode)node4).getValue()) == null || string4.length() <= 0) break;
                    this.requires.add(string4.toString());
                    break;
                }
                if (set != null && ((String)object3).equals("include")) {
                    Node node6 = ((FCallNode)node).getArgsNode();
                    if (!(node6 instanceof ListNode) || (object2 = (ListNode)node6).size() <= 0) break;
                    Node node7 = object2.get(0);
                    if (node7 instanceof Colon2Node) {
                        set.add(AstUtilities.getFqn((Colon2Node)node7));
                        break;
                    }
                    if (!(node7 instanceof INameNode)) break;
                    set.add(AstUtilities.getName(node7));
                    break;
                }
                if (("private".equals(object3) || "protected".equals(object3)) && object instanceof AstClassElement) {
                    this.haveAccessModifiers.add((AstClassElement)object);
                    break;
                }
                if (AstUtilities.isAttr(node)) {
                    SymbolNode[] symbolNodeArray = AstUtilities.getAttrSymbols(node);
                    if (symbolNodeArray == null || symbolNodeArray.length <= 0) break;
                    for (SymbolNode symbolNode : symbolNodeArray) {
                        AstAttributeElement astAttributeElement = new AstAttributeElement(this.result, symbolNode, node);
                        if (object instanceof AstClassElement) {
                            object6 = this.attributes.get(object);
                            if (object6 == null) {
                                object6 = new HashSet();
                                this.attributes.put((AstClassElement)object, (Set<AstAttributeElement>)object6);
                            }
                            object6.add(astAttributeElement);
                        }
                        if (object != null) {
                            ((AstElement)object).addChild(astAttributeElement);
                            continue;
                        }
                        this.structure.add(astAttributeElement);
                    }
                    break;
                }
                if (((String)object3).equals("module_function")) {
                    Node node8 = ((FCallNode)node).getArgsNode();
                    if (!(node8 instanceof ListNode)) break;
                    object2 = (ListNode)node8;
                    int n = object2.size();
                    for (int i = 0; i < n; ++i) {
                        AstMethodElement astMethodElement2;
                        String string5;
                        Node node9 = object2.get(i);
                        if (!(node9 instanceof SymbolNode) || (string5 = AstUtilities.getName(node9)) == null || string5.length() <= 0) continue;
                        object6 = null;
                        for (AstMethodElement astMethodElement2 : this.methods) {
                            AstMethodElement astMethodElement3;
                            if (!(astMethodElement2 instanceof AstMethodElement) || !string5.equals((astMethodElement3 = astMethodElement2).getName())) continue;
                            object6 = astMethodElement3;
                            break;
                        }
                        if (object6 == null) continue;
                        object5 = ((AstElement)object6).getNode();
                        astMethodElement2 = new AstMethodElement(this.result, (Node)object5);
                        astMethodElement2.setIn(string);
                        if (object5 instanceof DefnNode && "initialize".equals(AstUtilities.getName((Node)object5))) {
                            astMethodElement2.setAccess(Modifier.PRIVATE);
                        }
                        astMethodElement2.setModifiers(EnumSet.of(Modifier.STATIC));
                        if (object != null) {
                            ((AstElement)object).addChild(astMethodElement2);
                            continue;
                        }
                        this.structure.add(astMethodElement2);
                    }
                    break;
                }
                if (!this.isTestFile || !((String)object3).equals("test") && !((String)object3).equals("describe") && !((String)object3).equals("specify") && !((String)object3).equals("context") && !((String)object3).equals("should") && !((String)object3).equals("it")) break;
                Object object7 = object3;
                object2 = (FCallNode)node;
                if (object2.getIterNode() == null && !"it".equals(object3)) break;
                Node node10 = object2.getArgsNode();
                if (node10 instanceof ListNode) {
                    object4 = (ListNode)node10;
                    int n = object4.size();
                    for (int i = 0; i < n; ++i) {
                        object6 = object4.get(i);
                        if (!(object6 instanceof StrNode)) continue;
                        object5 = ((StrNode)object6).getValue();
                        if (object5 == null || ((String)object5).length() <= 0) break;
                        object7 = object5;
                        if (((String)object3).equals("test")) break;
                        object7 = (String)object3 + ": " + (String)object7;
                        break;
                    }
                }
                object4 = new AstNameElement(this.result, node, (String)object7, ElementKind.TEST);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object4);
                } else {
                    this.structure.add((AstElement)object4);
                }
                object = object4;
                break;
            }
        }
        object3 = node.childNodes();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (Node)iterator.next();
            if (object2.isInvisible()) continue;
            astPath.descend((Node)object2);
            this.scan((Node)object2, astPath, string, set, (AstElement)object);
            astPath.ascend();
        }
    }

    private String getExtendWith(MethodDefNode methodDefNode) {
        ListNode listNode;
        List<String> list = AstUtilities.getDefArgs(methodDefNode, true);
        if (list == null || list.size() != 1) {
            return null;
        }
        String string = list.get(0);
        CallNode callNode = this.findExtendCall((Node)methodDefNode);
        if (callNode == null) {
            return null;
        }
        Node node = callNode.getReceiverNode();
        if (node == null || !(node instanceof INameNode)) {
            return null;
        }
        String string2 = AstUtilities.getName(node);
        if (!string.equals(string2)) {
            return null;
        }
        Node node2 = callNode.getArgsNode();
        if (node2 instanceof ListNode && (listNode = (ListNode)node2).size() == 1) {
            Node node3 = listNode.get(0);
            String string3 = null;
            if (node3 instanceof Colon2Node) {
                string3 = AstUtilities.getName(node3);
            } else if (node3 instanceof ConstNode) {
                string3 = AstUtilities.getName(node3);
            }
            return string3;
        }
        return null;
    }

    private CallNode findExtendCall(Node node) {
        Object object;
        if (node instanceof CallNode && "extend".equals((object = (CallNode)node).getName())) {
            return object;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            CallNode callNode;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || (callNode = this.findExtendCall(node2)) == null) continue;
            return callNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnalysisResult analyze(RubyParseResult rubyParseResult) {
        AnalysisResult analysisResult = this.getCachedAnalysis(rubyParseResult);
        if (analysisResult != null) {
            return analysisResult;
        }
        boolean bl = false;
        FileObject fileObject = RubyUtils.getFileObject((Parser.Result)rubyParseResult);
        try {
            bl = currentlyAnalyzingWithIndex.add(fileObject);
            if (bl && rubyParseResult != null) {
                this.index = RubyIndex.get((Parser.Result)rubyParseResult);
            }
            this.result = rubyParseResult;
            analysisResult = this.scan(rubyParseResult);
            this.cacheAnalysis(rubyParseResult, analysisResult);
            AnalysisResult analysisResult2 = analysisResult;
            return analysisResult2;
        }
        finally {
            if (bl) {
                boolean bl2 = currentlyAnalyzingWithIndex.remove(fileObject);
                assert (bl2) : "consistent state";
            }
        }
    }

    public void addComments(RubyParseResult rubyParseResult) {
        Node node = rubyParseResult.getRootNode();
        if (node == null) {
            return;
        }
        org.jrubyparser.parser.ParserResult parserResult = rubyParseResult.getJRubyResult();
        List list = parserResult.getCommentNodes();
        for (CommentNode commentNode : list) {
            SourcePosition sourcePosition = commentNode.getPosition();
            int n = sourcePosition.getStartOffset();
            int n2 = sourcePosition.getEndOffset();
            Node node2 = this.findClosest(node, n, n2);
            assert (node2 != null);
            node2.addComment(commentNode);
        }
    }

    private Node findClosest(Node node, int n, int n2) {
        List list = node.childNodes();
        SourcePosition sourcePosition = node.getPosition();
        if (n2 < sourcePosition.getStartOffset()) {
            return node;
        }
        if (n > sourcePosition.getEndOffset()) {
            return null;
        }
        for (Node node2 : list) {
            Node node3;
            if (node2.isInvisible() || (node3 = this.findClosest(node2, n, n2)) == null) continue;
            return node3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends StructureItem> scanRhtml(ParserResult parserResult) {
        ArrayList<RhtmlStructureItem> arrayList = new ArrayList<RhtmlStructureItem>();
        BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
        if (baseDocument == null) {
            return Collections.emptyList();
        }
        baseDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence == null) {
                ArrayList<RhtmlStructureItem> arrayList2 = arrayList;
                return arrayList2;
            }
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                TokenId tokenId = tokenSequence.token().id();
                if (!tokenId.name().equals("DELIMITER")) continue;
                int n = tokenSequence.offset();
                if (!tokenSequence.moveNext()) continue;
                Token token = tokenSequence.token();
                int n2 = tokenSequence.offset() + token.length();
                if (!token.id().name().equals("DELIMITER")) {
                    while (tokenSequence.moveNext()) {
                        if (!tokenSequence.token().id().name().equals("DELIMITER")) continue;
                        n2 = tokenSequence.offset() + token.length();
                        break;
                    }
                }
                String string = RubyStructureAnalyzer.navigatorName((Document)baseDocument, tokenHierarchy, n);
                arrayList.add(new RhtmlStructureItem(string, n, n2));
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return arrayList;
    }

    public static String navigatorName(Document document, TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence;
        TokenId tokenId;
        TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
        tokenSequence2.move(n);
        if (tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().equals("DELIMITER") && tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().startsWith("RUBY") && (tokenSequence = tokenSequence2.embedded()) != null) {
            TokenId tokenId2;
            tokenSequence.moveStart();
            if (!tokenSequence.moveNext()) {
                return DEFAULT_LABEL;
            }
            while (tokenSequence.token().id() == RubyTokenId.WHITESPACE && tokenSequence.moveNext()) {
            }
            int n2 = tokenSequence.offset();
            tokenId = tokenSequence.token().id();
            if (tokenId == RubyTokenId.WHITESPACE) {
                return DEFAULT_LABEL;
            }
            if (tokenId == RubyTokenId.IDENTIFIER && TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)"h")) {
                if (!tokenSequence.moveNext()) {
                    int n3 = tokenSequence.offset() + tokenSequence.token().length();
                    return RubyStructureAnalyzer.createName(document, n2, n3);
                }
                while (tokenSequence.token().id() == RubyTokenId.WHITESPACE && tokenSequence.moveNext()) {
                }
                tokenId = tokenSequence.token().id();
            }
            if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) {
                while (tokenSequence.moveNext()) {
                    tokenId = tokenSequence.token().id();
                    if (tokenId != RubyTokenId.STRING_END && tokenId != RubyTokenId.QUOTED_STRING_END && tokenId != RubyTokenId.REGEXP_END) continue;
                    int n4 = tokenSequence.offset() + tokenSequence.token().length();
                    return RubyStructureAnalyzer.createName(document, n2, n4);
                }
            }
            int n5 = tokenSequence.offset() + tokenSequence.token().length();
            if (tokenSequence.moveNext() && ((tokenId2 = tokenSequence.token().id()) == RubyTokenId.DOT || tokenId == RubyTokenId.LPAREN) && tokenSequence.moveNext()) {
                n5 = tokenSequence.offset() + tokenSequence.token().length();
            }
            return RubyStructureAnalyzer.createName(document, n2, n5);
        }
        return DEFAULT_LABEL;
    }

    private static String createName(Document document, int n, int n2) {
        try {
            String string;
            int n3;
            boolean bl = false;
            int n4 = n2 - n;
            if (n + n4 > document.getLength()) {
                n4 = document.getLength() - n;
                bl = true;
            }
            if (n4 > 30) {
                n4 = 30;
                bl = true;
            }
            if ((n3 = (string = document.getText(n, n4)).indexOf(10)) != -1) {
                if (string.startsWith("<%\n") || string.startsWith("<%#\n")) {
                    if ((n3 = (string = string.substring(n3 + 1)).indexOf(10)) != -1) {
                        string = string.substring(0, n3);
                    }
                } else {
                    boolean bl2 = true;
                    for (int i = 0; i < n3; ++i) {
                        if (Character.isWhitespace(string.charAt(i))) continue;
                        bl2 = false;
                        break;
                    }
                    string = bl2 ? string.substring(n3 + 1) : string.substring(0, n3);
                }
            }
            if (bl) {
                return string + "...";
            }
            return string;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return DEFAULT_LABEL;
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    static {
        cache = new HashMap<File, AnalysisResult>();
        currentlyAnalyzingWithIndex = new HashSet<FileObject>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RhtmlStructureItem
    implements StructureItem {
        private final String name;
        private final int start;
        private final int end;

        public RhtmlStructureItem(String string, int n, int n2) {
            this.name = string;
            this.start = n;
            this.end = n2;
        }

        public String getName() {
            return this.name;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.name);
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.start;
        }

        public long getEndPosition() {
            return this.end;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            return this.getName().equals(rubyStructureItem.getName());
        }

        public ImageIcon getCustomIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)RubyStructureAnalyzer.RUBY_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RubyStructureItem
    implements StructureItem {
        AstElement node;
        ElementKind kind;
        ParserResult result;

        private RubyStructureItem(AstElement astElement, ParserResult parserResult) {
            this.node = astElement;
            this.result = parserResult;
            this.kind = astElement.getKind();
        }

        public String getName() {
            return this.node.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            Object object;
            List<String> list;
            htmlFormatter.reset();
            htmlFormatter.appendText(this.node.getName());
            if ((this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) && (list = ((AstMethodElement)(object = (AstMethodElement)this.node)).getParameters()) != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                htmlFormatter.parameters(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    htmlFormatter.appendText(string);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendHtml(", ");
                }
                htmlFormatter.parameters(false);
                htmlFormatter.appendHtml(")");
            }
            if (((RubyType)(object = this.node.getType())).isKnown()) {
                htmlFormatter.appendHtml("<font color='#777777'>");
                htmlFormatter.appendHtml(" : ");
                htmlFormatter.appendText(this.typeAsString((RubyType)object));
                htmlFormatter.appendHtml("</font>");
            }
            return htmlFormatter.getText();
        }

        private String typeAsString(RubyType rubyType) {
            String string = rubyType.asString(", ");
            if (rubyType.hasUnknownMember()) {
                NbBundle.getMessage(RubyStructureAnalyzer.class, (String)"RubyUnknownType");
                string = string + ", " + NbBundle.getMessage(RubyStructureAnalyzer.class, (String)"RubyUnknownType");
            }
            return string;
        }

        public ElementHandle getElementHandle() {
            return this.node;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.node.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case GLOBAL: 
                case OTHER: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
                case TEST: {
                    List<AstElement> list = this.node.getChildren();
                    return list == null || list.size() == 0;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.node.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
                for (AstElement astElement : list) {
                    arrayList.add(new RubyStructureItem(astElement, this.result));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.node.getNode().getPosition().getStartOffset();
        }

        public long getEndPosition() {
            return this.node.getNode().getPosition().getEndOffset();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            if (this.kind != rubyStructureItem.kind) {
                return false;
            }
            if (!this.getName().equals(rubyStructureItem.getName())) {
                return false;
            }
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity;
                Arity arity2 = Arity.getDefArity(this.node.getNode());
                if (!arity2.equals(arity = Arity.getDefArity(rubyStructureItem.node.getNode()))) {
                    return false;
                }
                if (!((Object)this.getModifiers()).equals(rubyStructureItem.getModifiers())) {
                    return false;
                }
                List<String> list = ((AstMethodElement)this.node).getParameters();
                List<String> list2 = ((AstMethodElement)rubyStructureItem.node).getParameters();
                if (list == null) {
                    return list2 == null;
                }
                return ((Object)list).equals(list2);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity = Arity.getDefArity(this.node.getNode());
                n = 37 * n + arity.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.getName() + " (kind: " + this.kind + ')';
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        public String getSortText() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisResult {
        private List<? extends AstElement> elements;
        private Map<AstClassElement, Set<AstAttributeElement>> attributes;
        private Set<String> requires;

        private AnalysisResult() {
        }

        public AstElement getElementFor(Node node) {
            for (AstElement astElement : this.getElements()) {
                AstElement astElement2 = this.findElement(astElement, node);
                if (astElement2 == null) continue;
                return astElement2;
            }
            return null;
        }

        public AstElement findElement(AstElement astElement, Node node) {
            if (astElement.getNode() == node) {
                return astElement;
            }
            for (AstElement astElement2 : astElement.getChildren()) {
                if (astElement2.getNode() == node) {
                    return astElement2;
                }
                AstElement astElement3 = this.findElement(astElement2, node);
                if (astElement3 == null) continue;
                return astElement3;
            }
            return null;
        }

        public Set<String> getRequires() {
            return this.requires;
        }

        public void setRequires(Set<String> set) {
            this.requires = set;
        }

        private void setElements(List<? extends AstElement> list) {
            this.elements = list;
        }

        private void setAttributes(Map<AstClassElement, Set<AstAttributeElement>> map) {
            this.attributes = map;
        }

        public Map<AstClassElement, Set<AstAttributeElement>> getAttributes() {
            return this.attributes;
        }

        public List<? extends AstElement> getElements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return this.elements;
        }
    }
}

