/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.Ruby18Parser;
import org.jrubyparser.parser.Ruby19Parser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.ruby.AstNodeAdapter;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RubyParser
extends Parser {
    private RubyParseResult lastResult;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        Context context = new Context(snapshot, sourceModificationEvent);
        final ArrayList arrayList = new ArrayList();
        context.errorHandler = new ParseErrorHandler(){

            public void error(Error error) {
                arrayList.add(error);
            }
        };
        this.lastResult = this.parseBuffer(context, Sanitize.NONE);
        this.lastResult.setErrors(arrayList);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        if (sanitize == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + ";end";
            int n = context.source.length();
            context.sanitizedRange = new OffsetRange(n, n + 4);
            context.sanitizedContents = "";
            return true;
        }
        int n = context.caretOffset;
        if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
            n = context.errorOffset;
        }
        if (n == -1) {
            return false;
        }
        String string = context.source;
        if (n > string.length()) {
            return false;
        }
        if (sanitize == Sanitize.BLOCK_START) {
            try {
                int n2 = GsfUtilities.getRowFirstNonWhite((CharSequence)string, (int)n);
                if (n2 != -1 && n2 + 2 < string.length() && string.regionMatches(n2, "if", 0, 2)) {
                    char c = '\u0000';
                    if (n2 + 2 < string.length()) {
                        c = string.charAt(n2 + 2);
                    }
                    if (!Character.isLetter(c)) {
                        int n3 = n2;
                        int n4 = n3 + 2;
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string.substring(0, n3));
                        for (int i = n3; i < n4; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n4 < string.length()) {
                            stringBuilder.append(string.substring(n4, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n3, n4);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n3, n4);
                        return true;
                    }
                }
                return false;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return false;
            }
        }
        try {
            if ((GsfUtilities.isRowEmpty((CharSequence)string, (int)n) || GsfUtilities.isRowWhite((CharSequence)string, (int)n)) && (n = GsfUtilities.getRowStart((CharSequence)string, (int)n) - 1) < 0) {
                n = 0;
            }
            if (!GsfUtilities.isRowEmpty((CharSequence)string, (int)n) && !GsfUtilities.isRowWhite((CharSequence)string, (int)n)) {
                if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                    int n5 = GsfUtilities.getRowLastNonWhite((CharSequence)string, (int)n);
                    if (n5 != -1) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        int n6 = GsfUtilities.getRowStart((CharSequence)string, (int)n);
                        int n7 = n6 + 1;
                        stringBuilder.append(string.substring(0, n6));
                        stringBuilder.append('#');
                        if (n7 < string.length()) {
                            stringBuilder.append(string.substring(n7, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n6, n5);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n6, n5);
                        return true;
                    }
                } else {
                    int n8;
                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                    int n9 = GsfUtilities.getRowStart((CharSequence)string, (int)n);
                    for (n8 = n - 1; n8 >= n9 && n8 < string.length() && Character.isWhitespace(string.charAt(n8)); --n8) {
                    }
                    if (n8 > n9) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        String string2 = string.substring(n9, n8 + 1);
                        int n10 = 0;
                        int n11 = n8 + 1;
                        if (string2.endsWith(".") || string2.endsWith("(")) {
                            n10 = 1;
                        } else if (string2.endsWith(",")) {
                            n10 = 1;
                        } else if (string2.endsWith(",:")) {
                            n10 = 2;
                        } else if (string2.endsWith(", :")) {
                            n10 = 3;
                        } else if (string2.endsWith(", ")) {
                            n10 = 2;
                        } else if (string2.endsWith("=> :")) {
                            n10 = 4;
                        } else if (string2.endsWith("=>:")) {
                            n10 = 3;
                        } else if (string2.endsWith("=>")) {
                            n10 = 2;
                        } else if (string2.endsWith("::")) {
                            n10 = 2;
                        } else if (string2.endsWith(":")) {
                            n10 = 1;
                        } else if (string2.endsWith("@@")) {
                            n10 = 2;
                        } else if (string2.endsWith("@") || string2.endsWith("$")) {
                            n10 = 1;
                        } else if (string2.endsWith(",)")) {
                            n10 = 1;
                            --n11;
                        } else if (string2.endsWith(", )")) {
                            n10 = 1;
                            n11 -= 2;
                        }
                        if (n10 == 0) {
                            return false;
                        }
                        int n12 = n11 - n10;
                        stringBuilder.append(string.substring(0, n12));
                        for (int i = 0; i < n10; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n11 < string.length()) {
                            stringBuilder.append(string.substring(n11, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n12, n11);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n12, n11);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return false;
    }

    private RubyParseResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.snapshot, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.BLOCK_START);
                }
            }
            case BLOCK_START: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.snapshot, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyError(Context context, IRubyWarnings.ID iD, Severity severity, String string, int n, Sanitize sanitize, Object[] objectArray) {
        char c;
        char c2;
        if (string.startsWith(", ")) {
            string = string.substring(2);
        }
        if (string.startsWith("unexpected k")) {
            string = "Unexpected keyword " + string.substring(12);
        }
        if (string.startsWith("syntax error, expecting\t")) {
            void rubyError;
            int c22 = string.indexOf(" but found ");
            assert (c22 != -1);
            int n2 = string.indexOf("instead", (int)(rubyError += 11));
            assert (n2 != -1);
            String string2 = string.substring((int)rubyError, n2);
            string = NbBundle.getMessage(RubyParser.class, (String)"UnexpectedError", (Object)string2);
        }
        if (string.length() > 0 && (c2 = string.charAt(0)) != (c = Character.toUpperCase(c2))) {
            string = c + string.substring(1);
        }
        RubyError rubyError = new RubyError(string, iD, context.snapshot.getSource().getFileObject(), n, n, severity, objectArray);
        context.errorHandler.error(rubyError);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n;
        }
    }

    protected RubyParseResult parseBuffer(final Context context, final Sanitize sanitize) {
        Object object;
        Object object2;
        org.jrubyparser.parser.RubyParser rubyParser;
        IRubyWarnings iRubyWarnings;
        org.jrubyparser.parser.ParserResult parserResult;
        String string;
        block11: {
            boolean bl = false;
            string = context.source;
            if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
                boolean bl2 = this.sanitizeSource(context, sanitize);
                if (bl2) {
                    assert (context.sanitizedSource != null);
                    bl = true;
                    string = context.sanitizedSource;
                } else {
                    return this.sanitize(context, sanitize);
                }
            }
            parserResult = null;
            final boolean bl3 = bl;
            try {
                iRubyWarnings = new IRubyWarnings(){

                    public boolean isVerbose() {
                        return false;
                    }

                    public void warn(IRubyWarnings.ID iD, SourcePosition sourcePosition, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, sourcePosition.getStartOffset(), sanitize, objectArray);
                        }
                    }

                    public void warn(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string2, -1, sanitize, objectArray);
                        }
                    }

                    public void warn(IRubyWarnings.ID iD, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, -1, sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, -1, sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, SourcePosition sourcePosition, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, sourcePosition.getStartOffset(), sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string2, -1, sanitize, objectArray);
                        }
                    }
                };
                rubyParser = RubyParser.getParserFor(context);
                rubyParser.setWarnings(iRubyWarnings);
                if (sanitize == Sanitize.NONE) {
                    context.errorOffset = -1;
                }
                object2 = "";
                object = context.snapshot.getSource().getFileObject();
                if (object != null) {
                    object2 = object.getNameExt();
                }
                ParserConfiguration parserConfiguration = new ParserConfiguration();
                final String string2 = string;
                final int n = string2.length();
                Reader reader = new Reader(){
                    int offset = 0;

                    public int read() throws IOException {
                        int n2;
                        if (this.offset == n) {
                            return -1;
                        }
                        if ((n2 = string2.charAt(this.offset++)) > 255) {
                            n2 = 63;
                        }
                        return n2;
                    }

                    public int read(char[] cArray, int n3, int n2) throws IOException {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void close() throws IOException {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
                LexerSource lexerSource = LexerSource.getSource((String)object2, (Reader)reader, (ParserConfiguration)parserConfiguration);
                parserResult = rubyParser.parse(parserConfiguration, lexerSource);
            }
            catch (SyntaxException syntaxException) {
                int n = syntaxException.getPosition().getStartOffset();
                if (n >= string.length() && (n = string.length() - 1) < 0) {
                    n = 0;
                }
                if (bl3) break block11;
                this.notifyError(context, IRubyWarnings.ID.SYNTAX_ERROR, Severity.ERROR, syntaxException.getMessage(), n, sanitize, new Object[]{syntaxException.getPid(), syntaxException});
            }
        }
        iRubyWarnings = parserResult != null ? parserResult.getAST() : null;
        rubyParser = null;
        if (iRubyWarnings instanceof RootNode) {
            rubyParser = (RootNode)iRubyWarnings;
            iRubyWarnings = rubyParser.getBodyNode();
        }
        if (iRubyWarnings != null) {
            context.sanitized = sanitize;
            object2 = new AstNodeAdapter(null, (Node)iRubyWarnings);
            object = this.createParseResult(context.snapshot, (Node)iRubyWarnings);
            ((RubyParseResult)((Object)object)).setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            ((RubyParseResult)((Object)object)).setSource(string);
            return object;
        }
        return this.sanitize(context, sanitize);
    }

    private static org.jrubyparser.parser.RubyParser getParserFor(Context context) {
        FileObject fileObject = context.snapshot.getSource().getFileObject();
        if (fileObject == null) {
            return new Ruby18Parser();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new Ruby18Parser();
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (rubyPlatform == null) {
            return new Ruby18Parser();
        }
        if (rubyPlatform.isJRuby()) {
            return RubyParser.getParserForJRuby(project);
        }
        String string = rubyPlatform.getVersion();
        if (string == null) {
            return new Ruby18Parser();
        }
        if (string.startsWith("1.9")) {
            return new Ruby19Parser();
        }
        return new Ruby18Parser();
    }

    private static org.jrubyparser.parser.RubyParser getParserForJRuby(Project project) {
        String string;
        PropertyEvaluator propertyEvaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (propertyEvaluator != null && (string = propertyEvaluator.getProperty("jvm.args")) != null) {
            return string.contains("jruby.compat.version=RUBY1_9") ? new Ruby19Parser() : new Ruby18Parser();
        }
        return new Ruby18Parser();
    }

    protected RubyParseResult createParseResult(Snapshot snapshot, Node node) {
        return new RubyParseResult(this, snapshot, node);
    }

    public static RubyElement resolveHandle(ParserResult parserResult, ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            AstElement astElement = (AstElement)elementHandle;
            ParserResult parserResult2 = astElement.getInfo();
            if (parserResult2 == parserResult) {
                return astElement;
            }
            Node node = astElement.getNode();
            Node node2 = AstUtilities.getRoot((Parser.Result)parserResult2);
            Node node3 = AstUtilities.getRoot((Parser.Result)parserResult);
            if (node3 == null) {
                return null;
            }
            Node node4 = RubyParser.find(node2, node, node3);
            if (node4 != null) {
                AstElement astElement2 = AstElement.create(parserResult, node4);
                return astElement2;
            }
        } else if (elementHandle instanceof RubyElement) {
            return (RubyElement)elementHandle;
        }
        return null;
    }

    private static Node find(Node node, Node node2, Node node3) {
        List list = node.childNodes();
        List list2 = node3.childNodes();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return null;
            }
            Node node4 = (Node)iterator.next();
            Node node5 = (Node)iterator2.next();
            if (node4 == node2) {
                return node5;
            }
            Node node6 = RubyParser.find(node4, node2, node5);
            if (node6 == null) continue;
            return node6;
        }
        if (iterator2.hasNext()) {
            return null;
        }
        return null;
    }

    public static class RubyError
    implements Error {
        private final String displayName;
        private final IRubyWarnings.ID id;
        private final FileObject file;
        private final int startPosition;
        private final int endPosition;
        private final Severity severity;
        private final Object[] parameters;

        public RubyError(String string, IRubyWarnings.ID iD, FileObject fileObject, int n, int n2, Severity severity, Object[] objectArray) {
            this.displayName = string;
            this.id = iD;
            this.file = fileObject;
            this.startPosition = n;
            this.endPosition = n2;
            this.severity = severity;
            this.parameters = objectArray;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public FileObject getFile() {
            return this.file;
        }

        public String getKey() {
            return this.id != null ? this.id.name() : "";
        }

        public IRubyWarnings.ID getId() {
            return this.id;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "RubyError:" + this.displayName;
        }

        public String getDescription() {
            return null;
        }

        public boolean isLineError() {
            return true;
        }
    }

    private static interface ParseErrorHandler {
        public void error(Error var1);
    }

    public static class Context {
        private final Snapshot snapshot;
        private final SourceModificationEvent event;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private ParseErrorHandler errorHandler;

        public Context(Snapshot snapshot, SourceModificationEvent sourceModificationEvent) {
            this.snapshot = snapshot;
            this.event = sourceModificationEvent;
            this.source = RubyParser.asString(snapshot.getText());
            this.caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)sourceModificationEvent);
        }

        public String toString() {
            return "RubyParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    extends ParserFactory {
        private Factory() {
        }

        public Parser createParser(Collection<Snapshot> collection) {
            return new RubyParser();
        }
    }
}

