/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditorOptions;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ReflowParagraphAction;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyKeystrokeHandler
implements KeystrokeHandler {
    private static final boolean REFLOW_COMMENTS = Boolean.getBoolean("ruby.autowrap.comments");
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("ruby.cont.comment");
    private static final TokenId[] STRING_TOKENS = new TokenId[]{RubyTokenId.STRING_LITERAL, RubyTokenId.QUOTED_STRING_LITERAL, RubyTokenId.STRING_END, RubyTokenId.QUOTED_STRING_END};
    private static final TokenId[] REGEXP_TOKENS = new TokenId[]{RubyTokenId.REGEXP_LITERAL, RubyTokenId.REGEXP_END};
    private static final String EQ_BEGIN = "=begin";
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument baseDocument) {
        EditorOptions editorOptions = EditorOptions.get((String)"text/x-ruby");
        if (editorOptions != null) {
            return editorOptions.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        int n2;
        int n3;
        boolean bl;
        StringBuilder stringBuilder;
        Object object;
        Object object2;
        Object object3;
        TokenId tokenId;
        Object object4;
        TokenSequence<? extends RubyTokenId> tokenSequence;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        boolean bl2 = this.isInsertMatchingEnabled(baseDocument);
        int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n4 == n && n5 == n) {
            return -1;
        }
        if (n4 != -1 && n5 != -1 && (tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n)) != null) {
            tokenSequence.move(n4);
            object4 = new StringBuilder();
            while (tokenSequence.moveNext() && tokenSequence.offset() <= n5) {
                char c;
                tokenId = tokenSequence.token();
                object3 = tokenId.id();
                if (object3 != RubyTokenId.STRING_BEGIN || !((String)(object2 = (Object)((Object)tokenId.text()).toString())).startsWith("<<") || !bl2) continue;
                object = new StringBuilder();
                int n6 = ((String)object2).length();
                for (int i = 2; i < n6 && (c = ((String)object2).charAt(i)) != '\n' && c != '\r'; ++i) {
                    ((StringBuilder)object).append(c);
                }
                String string = ((StringBuilder)object).toString();
                if (string.startsWith("-")) {
                    string = string.substring(1);
                }
                if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 2);
                }
                TokenSequence<? extends RubyTokenId> tokenSequence2 = LexUtilities.getRubyTokenSequence(baseDocument, n);
                tokenSequence2.move(n);
                stringBuilder = LexUtilities.findHeredocEnd(tokenSequence2, (Token<? extends RubyTokenId>)tokenId);
                if (stringBuilder != OffsetRange.NONE) continue;
                ((StringBuilder)object4).append("\n");
                ((StringBuilder)object4).append(string);
            }
            if (((StringBuilder)object4).length() > 0) {
                if (n5 == baseDocument.getLength()) {
                    ((StringBuilder)object4).append("\n");
                }
                baseDocument.insertString(n5, ((StringBuilder)object4).toString(), null);
                caret.setDot(n5);
                return -1;
            }
        }
        if ((tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n)) == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        object4 = tokenSequence.token();
        tokenId = object4.id();
        if (bl2 && (tokenId == RubyTokenId.ERROR && tokenSequence.offset() == n - 6 && ((Object)object4.text()).toString().startsWith(EQ_BEGIN) || tokenId == RubyTokenId.BEGIN && tokenSequence.offset() == Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + 1 && EQ_BEGIN.equals(baseDocument.getText(tokenSequence.offset() - 1, EQ_BEGIN.length())) || tokenId == RubyTokenId.NONUNARY_OP && tokenSequence.offset() + EQ_BEGIN.length() <= baseDocument.getLength() && EQ_BEGIN.equals(baseDocument.getText(tokenSequence.offset(), EQ_BEGIN.length())))) {
            baseDocument.insertString(n, "\n=end", null);
            caret.setDot(n);
            return -1;
        }
        object3 = new boolean[1];
        object2 = new boolean[1];
        object = new int[1];
        boolean bl3 = bl = bl2 && RubyKeystrokeHandler.isEndMissing(baseDocument, n, false, object3, (boolean[])object2, null, (int[])object);
        if (bl) {
            boolean bl4 = object3[0];
            Object object5 = object2[0];
            int n7 = object[0];
            int n8 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (n > n8) {
                stringBuilder2.append("\n");
                stringBuilder2.append(IndentUtils.createIndentString((Document)baseDocument, (int)n7));
            } else {
                String string = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8) - n);
                stringBuilder2.append(string);
                stringBuilder2.append("\n");
                stringBuilder2.append(IndentUtils.createIndentString((Document)baseDocument, (int)n7));
                baseDocument.remove(n, string.length());
            }
            if (bl4) {
                stringBuilder2.append("end");
            } else {
                assert (object5 != false);
                stringBuilder2.append("}");
            }
            int n9 = n;
            baseDocument.insertString(n9, stringBuilder2.toString(), null);
            caret.setDot(n9);
            return -1;
        }
        if ((tokenId == RubyTokenId.RBRACE || tokenId == RubyTokenId.RBRACKET) && Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) == n) {
            int n10 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
            stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n10));
            n3 = n;
            baseDocument.insertString(n3, stringBuilder.toString(), null);
            caret.setDot(n3);
        }
        if (tokenId == RubyTokenId.WHITESPACE && (n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1 && n < n2) {
            tokenSequence.move(n2);
            if (tokenSequence.moveNext() && (tokenId = tokenSequence.token().id()) == RubyTokenId.LINE_COMMENT) {
                n = n2;
            }
        }
        if (tokenId == RubyTokenId.LINE_COMMENT) {
            Token<? extends RubyTokenId> token;
            int n11;
            boolean bl5 = false;
            int n12 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            n3 = 0;
            int n13 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n13 > 0 && (n11 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n13 - 1))) != -1 && (token = LexUtilities.getToken(baseDocument, n11)) != null && token.id() == RubyTokenId.LINE_COMMENT) {
                n3 = 1;
            }
            if (n3 != 0 || n > n12) {
                Token<? extends RubyTokenId> token2;
                int n14;
                int n15;
                Token<? extends RubyTokenId> token3;
                if (tokenSequence.offset() + object4.length() > n + 1) {
                    String string = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) - n);
                    if (string.trim().length() != 0) {
                        bl5 = true;
                    }
                } else if (CONTINUE_COMMENTS && (token3 = LexUtilities.getToken(baseDocument, n12)) != null && token3.id() == RubyTokenId.LINE_COMMENT) {
                    bl5 = true;
                }
                if (!bl5 && (n15 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) < baseDocument.getLength() && (n14 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n15)) != -1 && (token2 = LexUtilities.getToken(baseDocument, n14)) != null && token2.id() == RubyTokenId.LINE_COMMENT) {
                    bl5 = true;
                }
            }
            if (bl5) {
                int n16;
                int n17;
                int n18 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append(IndentUtils.createIndentString((Document)baseDocument, (int)n18));
                stringBuilder3.append("#");
                int n19 = n12 + 1;
                String string = baseDocument.getText(n19, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n19) - n19);
                for (n17 = 0; n17 < string.length() && ((n16 = string.charAt(n17)) == 32 || n16 == 9); ++n17) {
                    stringBuilder3.append((char)n16);
                }
                n17 = n;
                if (n == n12 && n17 > 0) {
                    n17 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n16 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder3.length();
                    baseDocument.insertString(n17, stringBuilder3.toString(), null);
                    caret.setDot(n16);
                    return n16;
                }
                baseDocument.insertString(n17, stringBuilder3.toString(), null);
                caret.setDot(n17);
                return n17 + stringBuilder3.length() + 1;
            }
        }
        return -1;
    }

    static boolean isEndMissing(BaseDocument baseDocument, int n, boolean bl, boolean[] blArray, boolean[] blArray2, int[] nArray, int[] nArray2) throws BadLocationException {
        int n2 = baseDocument.getLength();
        if (nArray != null) {
            nArray[0] = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        }
        int n3 = LexUtilities.getBeginEndLineBalance(baseDocument, n, true);
        int n4 = LexUtilities.getLineBalance(baseDocument, n, RubyTokenId.LBRACE, RubyTokenId.RBRACE);
        if (n3 == 1 || n4 == 1) {
            int n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
            boolean bl2 = n3 > 0;
            boolean bl3 = n4 > 0;
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1;
            while (n6 < n2) {
                if (!(Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n6) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n6) || LexUtilities.isCommentOnlyLine(baseDocument, n6))) {
                    int n7 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n6);
                    if (n7 > n5) {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    if (n7 != n5) break;
                    if (bl2) {
                        if (LexUtilities.getBeginEndLineBalance(baseDocument, n6, false) < 0) {
                            bl2 = false;
                            break;
                        }
                        int n8 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n6);
                        Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n8);
                        if (token == null || !LexUtilities.isIndentToken(token.id()) || LexUtilities.isBeginToken(token.id(), baseDocument, n8)) break;
                        bl2 = false;
                        break;
                    }
                    if (!bl3 || LexUtilities.getLineBalance(baseDocument, n6, RubyTokenId.LBRACE, RubyTokenId.RBRACE) >= 0) break;
                    bl3 = false;
                    break;
                }
                n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6) + 1;
            }
            if (blArray != null) {
                blArray[0] = bl2;
            }
            if (blArray2 != null) {
                blArray2[0] = bl3;
            }
            if (nArray2 != null) {
                nArray2[0] = n5;
            }
            return bl2 || bl3;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        String string;
        TokenSequence<? extends RubyTokenId> tokenSequence;
        TokenSequence<? extends RubyTokenId> tokenSequence2;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(baseDocument)) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != -1) {
            String string2;
            char c2;
            if (GsfUtilities.isCodeTemplateEditing((Document)baseDocument)) {
                int n2 = jTextComponent.getSelectionStart();
                if (n2 < (c2 = jTextComponent.getSelectionEnd())) {
                    jTextComponent.setSelectionStart(n2);
                    jTextComponent.setSelectionEnd(n2);
                    n = n2;
                    caret.setDot(n);
                    baseDocument.remove(n2, c2 - n2);
                }
            } else if (c == '\"' || c == '\'' || c == '(' || c == '{' || c == '[' || c == '/') {
                String string3 = jTextComponent.getSelectedText();
                if (string3 != null && string3.length() > 0 && (c2 = (char)string3.charAt(0)) != c) {
                    int n3 = jTextComponent.getSelectionStart();
                    int n4 = jTextComponent.getSelectionEnd();
                    tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, n3);
                    if (tokenSequence2 != null && tokenSequence2.token().id() != RubyTokenId.STRING_LITERAL && tokenSequence2.token().id() != RubyTokenId.QUOTED_STRING_LITERAL && tokenSequence2.token().id() != RubyTokenId.REGEXP_LITERAL) {
                        char c3 = string3.charAt(string3.length() - 1);
                        if (string3.length() > 1 && (c2 == '\"' || c2 == '\'' || c2 == '(' || c2 == '{' || c2 == '[' || c2 == '/') && c3 == this.matching(c2)) {
                            baseDocument.remove(n4 - 1, 1);
                            baseDocument.insertString(n4 - 1, Character.toString(this.matching(c)), null);
                            baseDocument.remove(n3, 1);
                            baseDocument.insertString(n3, Character.toString(c), null);
                            jTextComponent.getCaret().setDot(n4);
                        } else {
                            baseDocument.remove(n3, n4 - n3);
                            baseDocument.insertString(n3, c + string3 + this.matching(c), null);
                            jTextComponent.getCaret().setDot(n3 + string3.length() + 2);
                        }
                        return true;
                    }
                }
            } else if ((c == '#' && LexUtilities.isInsideQuotedString(baseDocument, jTextComponent.getSelectionStart()) && LexUtilities.isInsideQuotedString(baseDocument, jTextComponent.getSelectionEnd()) || LexUtilities.isInsideRegexp(baseDocument, jTextComponent.getSelectionStart()) && LexUtilities.isInsideRegexp(baseDocument, jTextComponent.getSelectionEnd())) && (string2 = jTextComponent.getSelectedText()) != null && string2.length() > 0 && string2.charAt(0) != c) {
                int n5 = jTextComponent.getSelectionStart();
                baseDocument.remove(n5, jTextComponent.getSelectionEnd() - n5);
                baseDocument.insertString(n5, "#{" + string2 + "}", null);
                jTextComponent.getCaret().setDot(n5 + string2.length() + 3);
                return true;
            }
        }
        if ((tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n)) == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        TokenSequence<? extends RubyTokenId> tokenSequence3 = token.id();
        TokenId[] tokenIdArray = null;
        tokenSequence2 = null;
        if (tokenSequence3 == RubyTokenId.LINE_COMMENT && jTextComponent.getSelectionStart() != -1 && (c == '*' || c == '+' || c == '_') && (string = jTextComponent.getSelectedText()) != null && string.length() > 0 && string.charAt(0) != c && string.indexOf(32) == -1) {
            int n6 = jTextComponent.getSelectionStart();
            baseDocument.remove(n6, jTextComponent.getSelectionEnd() - n6);
            baseDocument.insertString(n6, c + string + this.matching(c), null);
            jTextComponent.getCaret().setDot(n6 + string.length() + 2);
            return true;
        }
        if (c == '\"') {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = RubyTokenId.QUOTED_STRING_BEGIN;
        } else if (c == '\'') {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = RubyTokenId.STRING_BEGIN;
        } else if (tokenSequence3 == RubyTokenId.ERROR) {
            string = ((Object)token.text()).toString();
            if (string.equals("%")) {
                if (!Character.isLetter(c)) {
                    tokenIdArray = STRING_TOKENS;
                    tokenSequence2 = RubyTokenId.QUOTED_STRING_BEGIN;
                }
            } else if (string.length() == 2 && string.charAt(0) == '%' && Character.isLetter(string.charAt(1))) {
                char c4 = string.charAt(1);
                switch (c4) {
                    case 'q': {
                        tokenIdArray = STRING_TOKENS;
                        tokenSequence2 = RubyTokenId.STRING_BEGIN;
                        break;
                    }
                    case 'Q': {
                        tokenIdArray = STRING_TOKENS;
                        tokenSequence2 = RubyTokenId.QUOTED_STRING_BEGIN;
                        break;
                    }
                    case 'r': {
                        tokenIdArray = REGEXP_TOKENS;
                        tokenSequence2 = RubyTokenId.REGEXP_BEGIN;
                        break;
                    }
                    default: {
                        tokenIdArray = STRING_TOKENS;
                        tokenSequence2 = RubyTokenId.QUOTED_STRING_BEGIN;
                        break;
                    }
                }
            } else {
                tokenSequence.movePrevious();
                TokenId tokenId = tokenSequence.token().id();
                if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                    tokenIdArray = STRING_TOKENS;
                    tokenSequence2 = tokenId;
                } else if (tokenId == RubyTokenId.REGEXP_BEGIN) {
                    tokenIdArray = REGEXP_TOKENS;
                    tokenSequence2 = RubyTokenId.REGEXP_BEGIN;
                }
            }
        } else if ((tokenSequence3 == RubyTokenId.STRING_BEGIN || tokenSequence3 == RubyTokenId.QUOTED_STRING_BEGIN) && n == tokenSequence.offset() + 1) {
            if (!Character.isLetter(c)) {
                tokenIdArray = STRING_TOKENS;
                tokenSequence2 = tokenSequence3;
            }
        } else if (tokenSequence3 == RubyTokenId.STRING_BEGIN && n == tokenSequence.offset() + 2 || tokenSequence3 == RubyTokenId.STRING_END) {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = RubyTokenId.STRING_BEGIN;
        } else if (tokenSequence3 == RubyTokenId.QUOTED_STRING_BEGIN && n == tokenSequence.offset() + 2 || tokenSequence3 == RubyTokenId.QUOTED_STRING_END) {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = RubyTokenId.QUOTED_STRING_BEGIN;
        } else if (tokenSequence3 == RubyTokenId.REGEXP_BEGIN && n == tokenSequence.offset() + 2 || tokenSequence3 == RubyTokenId.REGEXP_END) {
            tokenIdArray = REGEXP_TOKENS;
            tokenSequence2 = RubyTokenId.REGEXP_BEGIN;
        }
        if (tokenIdArray != null) {
            boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, (TokenId)tokenSequence2);
            if (bl) {
                caret.setDot(n + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenId tokenId;
        Token<? extends RubyTokenId> token;
        this.isAfter = true;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (REFLOW_COMMENTS && (token = LexUtilities.getToken(baseDocument, n)) != null && ((tokenId = token.id()) == RubyTokenId.LINE_COMMENT || tokenId == RubyTokenId.DOCUMENTATION)) {
            ReflowParagraphAction.reflowEditedComment(jTextComponent);
        }
        if (this.previousAdjustmentOffset != -1) {
            if (n == this.previousAdjustmentOffset && (token = LexUtilities.getRubyTokenSequence(baseDocument, n)) != null) {
                token.move(n);
                if (token.moveNext() && token.offset() < n) {
                    GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (c) {
            case '#': {
                token = LexUtilities.getToken(baseDocument, n);
                if (token == null) {
                    return true;
                }
                tokenId = token.id();
                if (tokenId != RubyTokenId.QUOTED_STRING_LITERAL && tokenId != RubyTokenId.REGEXP_LITERAL) break;
                document.insertString(n + 1, "{}", null);
                caret.setDot(n + 2);
                break;
            }
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                char c2;
                char c3;
                String string;
                Object object;
                Token<? extends RubyTokenId> token2;
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                token = LexUtilities.getToken(baseDocument, n);
                if (token == null) {
                    return true;
                }
                tokenId = token.id();
                if (c == '{' && tokenId == RubyTokenId.ERROR && n > 0 && (token2 = LexUtilities.getToken(baseDocument, n - 1)) != null && ((object = token2.id()) == RubyTokenId.STRING_LITERAL || object == RubyTokenId.REGEXP_LITERAL) && n > 1 && "#{".equals(string = baseDocument.getText(n - 2, 2))) {
                    baseDocument.remove(n, 1);
                    caret.setDot(n);
                    return true;
                }
                if (c == '}' && (tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.REGEXP_LITERAL) && (token2 = LexUtilities.getToken(baseDocument, n - 1)) != null && (object = token2.id()) == RubyTokenId.EMBEDDED_RUBY && n < baseDocument.getLength() - 1 && (c3 = baseDocument.getText(n + 1, 1).charAt(0)) == '}') {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                    return true;
                }
                if (c == '}' && tokenId == RubyTokenId.EMBEDDED_RUBY && n < baseDocument.getLength() - 1 && (c2 = baseDocument.getText(n + 1, 1).charAt(0)) == '}') {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                    return true;
                }
                if (tokenId == RubyTokenId.ANY_OPERATOR) {
                    int n2 = token.length();
                    object = ((Object)token.text()).toString();
                    if (n2 == 2 && "[]".equals(object) || "[]=".equals(object)) {
                        this.skipClosingBracket(baseDocument, caret, c, RubyTokenId.RBRACKET);
                        return true;
                    }
                }
                if (tokenId == RubyTokenId.IDENTIFIER && token.length() == 1 || tokenId == RubyTokenId.LBRACKET || tokenId == RubyTokenId.RBRACKET || tokenId == RubyTokenId.LBRACE || tokenId == RubyTokenId.RBRACE || tokenId == RubyTokenId.LPAREN || tokenId == RubyTokenId.RPAREN) {
                    if (c == ']') {
                        this.skipClosingBracket(baseDocument, caret, c, RubyTokenId.RBRACKET);
                    } else if (c == ')') {
                        this.skipClosingBracket(baseDocument, caret, c, RubyTokenId.RPAREN);
                    } else if (c == '}') {
                        this.skipClosingBracket(baseDocument, caret, c, RubyTokenId.RBRACE);
                    } else if (c == '[' || c == '(' || c == '{') {
                        this.completeOpeningBracket(baseDocument, n, caret, c);
                    }
                }
                if (c == '}') {
                    this.reindent(baseDocument, n, RubyTokenId.RBRACE, caret);
                    break;
                }
                if (c != ']') break;
                this.reindent(baseDocument, n, RubyTokenId.RBRACKET, caret);
                break;
            }
            case 'd': {
                this.reindent(baseDocument, n, RubyTokenId.END, caret);
                break;
            }
            case 'e': {
                this.reindent(baseDocument, n, RubyTokenId.ELSE, caret);
                this.reindent(baseDocument, n, RubyTokenId.ENSURE, caret);
                this.reindent(baseDocument, n, RubyTokenId.RESCUE, caret);
                break;
            }
            case 'f': {
                this.reindent(baseDocument, n, RubyTokenId.ELSIF, caret);
                break;
            }
            case 'n': {
                this.reindent(baseDocument, n, RubyTokenId.WHEN, caret);
                break;
            }
            case '/': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                token = LexUtilities.getToken(baseDocument, n);
                if (token == null || (tokenId = token.id()) != RubyTokenId.REGEXP_BEGIN && tokenId != RubyTokenId.REGEXP_END) break;
                TokenId[] tokenIdArray = REGEXP_TOKENS;
                RubyTokenId rubyTokenId = RubyTokenId.REGEXP_BEGIN;
                boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, rubyTokenId);
                if (bl) {
                    caret.setDot(n + 1);
                }
                return bl;
            }
            case '|': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                token = LexUtilities.getToken(baseDocument, n);
                if (token == null) {
                    return true;
                }
                tokenId = token.id();
                if (tokenId == RubyTokenId.NONUNARY_OP && token.length() == 2 && "||".equals(((Object)token.text()).toString())) {
                    if (!this.isBlockDefinition(baseDocument, n)) break;
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                    return true;
                }
                if (tokenId != RubyTokenId.IDENTIFIER || token.length() != 1 || !"|".equals(((Object)token.text()).toString())) break;
                if (this.isBlockDefinition(baseDocument, n)) {
                    boolean bl = false;
                    int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    if (n3 > n + 1) {
                        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n + 1);
                        tokenSequence.move(n + 1);
                        while (tokenSequence.moveNext() && tokenSequence.offset() < n3) {
                            Token token3 = tokenSequence.token();
                            if (token3.id() != RubyTokenId.IDENTIFIER || token3.length() != 1 || !"|".equals(((Object)token3.text()).toString())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        baseDocument.insertString(n + 1, "|", null);
                        caret.setDot(n + 1);
                    }
                }
                return true;
            }
        }
        return true;
    }

    private boolean isBlockDefinition(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        tokenSequence.move(n + 1);
        while (tokenSequence.movePrevious() && tokenSequence.offset() >= n2) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == RubyTokenId.DO || tokenId == RubyTokenId.LBRACE) {
                return true;
            }
            if (tokenId != RubyTokenId.END && tokenId != RubyTokenId.RBRACE) continue;
            break;
        }
        return false;
    }

    private void reindent(BaseDocument baseDocument, int n, TokenId tokenId, Caret caret) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == tokenId) {
                Object object;
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (tokenSequence.offset() > n2) {
                    if (RubyUtils.isRhtmlDocument((Document)baseDocument)) {
                        object = baseDocument.getText(n2, tokenSequence.offset() - n2);
                        if (!((String)object).matches("<%\\s*")) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if ((object = tokenId == RubyTokenId.RBRACE ? LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.LBRACE, RubyTokenId.RBRACE) : (tokenId == RubyTokenId.RBRACKET ? LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET) : LexUtilities.findBegin(baseDocument, tokenSequence))) != OffsetRange.NONE) {
                    int n3 = object.getStart();
                    int n4 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n3);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
                    GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n, (int)n4);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return OffsetRange.NONE;
            }
            Token token = tokenSequence.token();
            if (token == null) {
                return OffsetRange.NONE;
            }
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.WHITESPACE) {
                tokenSequence.move(++n);
                if (tokenSequence.moveNext() && tokenSequence.offset() <= n) {
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
            }
            if (tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                if (((Object)token.text()).toString().startsWith("<<")) {
                    return LexUtilities.findHeredocEnd(tokenSequence, (Token<? extends RubyTokenId>)token);
                }
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.QUOTED_STRING_BEGIN, RubyTokenId.QUOTED_STRING_END);
            }
            if (tokenId == RubyTokenId.QUOTED_STRING_END) {
                String string = ((Object)token.text()).toString();
                if (!("\"".equals(string) || "'".equals(string) || ")".equals(string))) {
                    OffsetRange offsetRange = LexUtilities.findHeredocBegin(tokenSequence, (Token<? extends RubyTokenId>)token);
                    if (offsetRange != OffsetRange.NONE) {
                        return offsetRange;
                    }
                    tokenSequence.move(n);
                }
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.QUOTED_STRING_BEGIN, RubyTokenId.QUOTED_STRING_END);
            }
            if (tokenId == RubyTokenId.STRING_BEGIN) {
                if (((Object)token.text()).toString().startsWith("<<")) {
                    return LexUtilities.findHeredocEnd(tokenSequence, (Token<? extends RubyTokenId>)token);
                }
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.STRING_BEGIN, RubyTokenId.STRING_END);
            }
            if (tokenId == RubyTokenId.STRING_END) {
                String string = ((Object)token.text()).toString();
                if (!("\"".equals(string) || "'".equals(string) || ")".equals(string))) {
                    OffsetRange offsetRange = LexUtilities.findHeredocBegin(tokenSequence, (Token<? extends RubyTokenId>)token);
                    if (offsetRange != OffsetRange.NONE) {
                        return offsetRange;
                    }
                    tokenSequence.move(n);
                }
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.STRING_BEGIN, RubyTokenId.STRING_END);
            }
            if (tokenId == RubyTokenId.REGEXP_BEGIN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.REGEXP_BEGIN, RubyTokenId.REGEXP_END);
            }
            if (tokenId == RubyTokenId.REGEXP_END) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.REGEXP_BEGIN, RubyTokenId.REGEXP_END);
            }
            if (tokenId == RubyTokenId.LPAREN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.LPAREN, RubyTokenId.RPAREN);
            }
            if (tokenId == RubyTokenId.RPAREN) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.LPAREN, RubyTokenId.RPAREN);
            }
            if (tokenId == RubyTokenId.LBRACE) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.LBRACE, RubyTokenId.RBRACE);
            }
            if (tokenId == RubyTokenId.RBRACE) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.LBRACE, RubyTokenId.RBRACE);
            }
            if (tokenId == RubyTokenId.LBRACKET) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET);
            }
            if (tokenId == RubyTokenId.DO && !LexUtilities.isEndmatchingDo(baseDocument, tokenSequence.offset())) {
                return OffsetRange.NONE;
            }
            if (tokenId == RubyTokenId.RBRACKET) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET);
            }
            if (tokenId.primaryCategory().equals("keyword")) {
                if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                    return LexUtilities.findEnd(baseDocument, tokenSequence);
                }
                if (tokenId == RubyTokenId.END || LexUtilities.isIndentToken(tokenId)) {
                    return LexUtilities.findBegin(baseDocument, tokenSequence);
                }
            }
        }
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)document;
        switch (c) {
            case ' ': {
                TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious() || tokenSequence.offset() != n - 1 || tokenSequence.token().id() != RubyTokenId.LINE_COMMENT) break;
                baseDocument.remove(n - 1, 1);
                jTextComponent.getCaret().setDot(n - 1);
                return true;
            }
            case '{': {
                String string;
                Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n - 1);
                if (token != null && (token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.REGEXP_LITERAL) && "#}".equals(string = document.getText(n - 1, 2))) {
                    baseDocument.remove(n, 1);
                    jTextComponent.getCaret().setDot(n);
                }
            }
            case '(': 
            case '[': {
                char c2 = LexUtilities.getTokenChar(baseDocument, n);
                if (!(c2 == ']' && LexUtilities.getTokenBalance(baseDocument, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET, n) != 0 || c2 == ')' && LexUtilities.getTokenBalance(baseDocument, RubyTokenId.LPAREN, RubyTokenId.RPAREN, n) != 0) && (c2 != '}' || LexUtilities.getTokenBalance(baseDocument, RubyTokenId.LBRACE, RubyTokenId.RBRACE, n) == 0)) break;
                baseDocument.remove(n, 1);
                break;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '|': {
                char[] cArray = baseDocument.getChars(n, 1);
                if (cArray == null || cArray[0] != c) break;
                baseDocument.remove(n, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c, TokenId tokenId) throws BadLocationException {
        int n = caret.getDot();
        if (this.isSkipClosingBracket(baseDocument, n, tokenId)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument baseDocument, int n, TokenId tokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null && token.id() == tokenId) {
            int n2 = tokenId.ordinal();
            int n3 = n2 == RubyTokenId.RPAREN.ordinal() ? RubyTokenId.LPAREN.ordinal() : RubyTokenId.LBRACKET.ordinal();
            tokenSequence.moveNext();
            Token token2 = tokenSequence.token();
            while (token2 != null && token2.id() == tokenId) {
                token = token2;
                if (!tokenSequence.moveNext()) break;
                token2 = tokenSequence.token();
            }
            int n4 = 0;
            int n5 = -1;
            Token token3 = token;
            tokenSequence.movePrevious();
            token = tokenSequence.token();
            boolean bl2 = false;
            while (!bl2 && token != null) {
                int n6 = ((RubyTokenId)token.id()).ordinal();
                if (token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.LBRACKET) {
                    if (n6 == n2 && ++n5 == 0) {
                        if (n4 != 0) {
                            n5 = 1;
                        }
                        bl2 = true;
                    }
                } else if (token.id() == RubyTokenId.RPAREN || token.id() == RubyTokenId.RBRACKET) {
                    if (n6 == n2) {
                        --n5;
                    }
                } else if (token.id() == RubyTokenId.LBRACE) {
                    if (++n4 > 0) {
                        bl2 = true;
                    }
                } else if (token.id() == RubyTokenId.RBRACE) {
                    --n4;
                }
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
            if (n5 != 0) {
                bl = true;
            } else {
                n4 = 0;
                n5 = 1;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n7 = token3.offset(tokenHierarchy);
                tokenSequence.move(n7);
                tokenSequence.moveNext();
                token = tokenSequence.token();
                bl2 = false;
                while (!bl2 && token != null) {
                    if (token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.LBRACKET) {
                        if (((RubyTokenId)token.id()).ordinal() == n3) {
                            ++n5;
                        }
                    } else if (token.id() == RubyTokenId.RPAREN || token.id() == RubyTokenId.RBRACKET) {
                        if (((RubyTokenId)token.id()).ordinal() == n2 && --n5 == 0) {
                            if (n4 != 0) {
                                n5 = -1;
                            }
                            bl2 = true;
                        }
                    } else if (token.id() == RubyTokenId.LBRACE) {
                        ++n4;
                    } else if (token.id() == RubyTokenId.RBRACE && --n4 < 0) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) break;
                    token = tokenSequence.token();
                }
                bl = n5 == 0;
            }
        }
        return bl;
    }

    private void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (this.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + this.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private boolean completeQuote(BaseDocument baseDocument, int n, Caret caret, char c, TokenId[] tokenIdArray, TokenId tokenId) throws BadLocationException {
        int n2;
        boolean bl;
        if (this.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        if (baseDocument.getLength() < n) {
            return false;
        }
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token<? extends RubyTokenId> token = tokenSequence.token();
        Token token2 = null;
        if (tokenSequence.movePrevious()) {
            token2 = tokenSequence.token();
        }
        boolean bl2 = bl = (n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) < n;
        if (token.id() == RubyTokenId.BLOCK_COMMENT || token.id() == RubyTokenId.LINE_COMMENT || token.id() == RubyTokenId.DOCUMENTATION) {
            return false;
        }
        if (token.id() == RubyTokenId.WHITESPACE && bl && n - 1 > 0 && (token = LexUtilities.getToken(baseDocument, n - 1)) != null && token.id() == RubyTokenId.LINE_COMMENT) {
            return false;
        }
        boolean bl3 = this.isQuoteCompletablePosition(baseDocument, n);
        boolean bl4 = false;
        TokenId tokenId2 = token.id();
        for (TokenId tokenId3 : tokenIdArray) {
            if (tokenId2 != tokenId3) continue;
            bl4 = true;
            break;
        }
        if (tokenId2 == RubyTokenId.ERROR && token2 != null && token2.id() == tokenId) {
            bl4 = true;
        }
        if (!bl4 && token.id() == RubyTokenId.WHITESPACE && bl && n - 1 > 0) {
            token = LexUtilities.getToken(baseDocument, n - 1);
            boolean bl5 = bl4 = token != null && token.id() == RubyTokenId.STRING_LITERAL;
        }
        if (bl4) {
            if (bl) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c) {
                if (!this.isAfter) {
                    baseDocument.insertString(n, "" + c, null);
                } else if (n >= baseDocument.getLength() - 1 || baseDocument.getText(n + 1, 1).charAt(0) != c) {
                    return true;
                }
                baseDocument.remove(n, 1);
                return true;
            }
        }
        if (bl3 && !bl4 || bl) {
            baseDocument.insertString(n, "" + c + (this.isAfter ? "" : Character.valueOf(this.matching(c))), null);
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private boolean isQuoteCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n == n2 || n2 == -1) {
            return false;
        }
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n2);
        if (n3 == -1) {
            return false;
        }
        char c = baseDocument.getChars(n3, 1)[0];
        if (c == '%' && (RubyUtils.isRhtmlDocument((Document)baseDocument) || RubyUtils.isYamlDocument((Document)baseDocument))) {
            return true;
        }
        return c == ')' || c == ',' || c == '+' || c == '}' || c == ';' || c == ']' || c == '/';
    }

    private char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return c;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult parserResult, int n) {
        OffsetRange offsetRange;
        int n2;
        Object object;
        Node node = AstUtilities.getRoot((Parser.Result)parserResult);
        if (node == null) {
            return Collections.emptyList();
        }
        int n3 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (n3 == -1) {
            return Collections.emptyList();
        }
        AstPath astPath = new AstPath(node, n3);
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        try {
            int n6;
            TokenSequence tokenSequence;
            object = RubyUtils.getDocument((Parser.Result)parserResult);
            if (object == null) {
                return arrayList;
            }
            n2 = object.getLength();
            if (RubyUtils.isRhtmlDocument((Document)object) || RubyUtils.isYamlDocument((Document)object)) {
                Token token;
                offsetRange = TokenHierarchy.get((Document)object);
                tokenSequence = offsetRange.tokenSequence();
                tokenSequence.move(n);
                if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && (token = tokenSequence.token()).id().primaryCategory().startsWith("ruby")) {
                    n4 = tokenSequence.offset();
                    n5 = n4 + token.length();
                    if (tokenSequence.movePrevious() && "ruby-delimiter".equals((token = tokenSequence.token()).id().primaryCategory())) {
                        n4 = tokenSequence.offset();
                        if (tokenSequence.moveNext() && tokenSequence.moveNext() && "ruby-delimiter".equals((token = tokenSequence.token()).id().primaryCategory())) {
                            n5 = tokenSequence.offset() + token.length();
                        }
                    }
                }
            }
            if ((offsetRange = LexUtilities.getToken((BaseDocument)object, n)) != null && offsetRange.id() == RubyTokenId.LINE_COMMENT) {
                int n7;
                int n8 = Utilities.getRowStart((BaseDocument)object, (int)n);
                int n9 = Utilities.getRowEnd((BaseDocument)object, (int)n);
                if (LexUtilities.isCommentOnlyLine((BaseDocument)object, n)) {
                    int n10;
                    arrayList.add(new OffsetRange(Utilities.getRowFirstNonWhite((BaseDocument)object, (int)n8), Utilities.getRowLastNonWhite((BaseDocument)object, (int)n9) + 1));
                    n6 = n8;
                    n7 = n9;
                    while (n8 > 0) {
                        n10 = Utilities.getRowStart((BaseDocument)object, (int)(n8 - 1));
                        if (n10 < 0 || !LexUtilities.isCommentOnlyLine((BaseDocument)object, n10)) {
                            n8 = Utilities.getRowFirstNonWhite((BaseDocument)object, (int)n8);
                            break;
                        }
                        n8 = n10;
                    }
                    while (true) {
                        if ((n10 = Utilities.getRowEnd((BaseDocument)object, (int)(n9 + 1))) >= n2 || !LexUtilities.isCommentOnlyLine((BaseDocument)object, n10)) break;
                        n9 = n10;
                    }
                    n9 = Utilities.getRowLastNonWhite((BaseDocument)object, (int)n9) + 1;
                    if (n6 > n8 || n7 < n9) {
                        arrayList.add(new OffsetRange(n8, n9));
                    }
                } else {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)object);
                    n7 = offsetRange.offset(tokenHierarchy);
                    arrayList.add(new OffsetRange(n7, n7 + offsetRange.length()));
                }
            } else if (offsetRange != null && offsetRange.id() == RubyTokenId.DOCUMENTATION) {
                tokenSequence = TokenHierarchy.get((Document)object);
                int n11 = offsetRange.offset((TokenHierarchy)tokenSequence);
                n6 = n11 + offsetRange.length();
                arrayList.add(new OffsetRange(n11, n6));
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return arrayList;
        }
        object = astPath.leafToRoot();
        offsetRange = OffsetRange.NONE;
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2.getNodeType() == NodeType.NEWLINENODE) continue;
            OffsetRange offsetRange2 = AstUtilities.getRange(node2);
            if (node2.getNodeType() == NodeType.CALLNODE && arrayList.size() == 0 && node2 == astPath.leaf()) {
                Node node3 = ((CallNode)node2).getReceiverNode();
                OffsetRange offsetRange3 = AstUtilities.getRange(node3);
                if (node3 != null && n3 > offsetRange3.getEnd() && offsetRange3.getEnd() + 1 < offsetRange2.getEnd()) {
                    arrayList.add(new OffsetRange(offsetRange3.getEnd() + 1, offsetRange2.getEnd()));
                }
            }
            if (!offsetRange2.containsInclusive(n3) || offsetRange2.equals((Object)offsetRange) || (offsetRange2 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, offsetRange2)) == OffsetRange.NONE) continue;
            if (offsetRange2.getStart() < n4) {
                arrayList.add(new OffsetRange(n4, n5));
                arrayList.add(new OffsetRange(0, n2));
                break;
            }
            arrayList.add(offsetRange2);
            offsetRange = offsetRange2;
        }
        return arrayList;
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (bl && tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == RubyTokenId.WHITESPACE) {
            int n2;
            if (bl && tokenSequence.offset() < n || !bl && tokenSequence.offset() > n) {
                return tokenSequence.offset();
            }
            while (tokenId == RubyTokenId.WHITESPACE) {
                if (bl && !tokenSequence.movePrevious()) {
                    return -1;
                }
                if (!bl && !tokenSequence.moveNext()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (bl ? (n2 = tokenSequence.offset() + token.length()) < n : (n2 = tokenSequence.offset()) > n) {
                return n2;
            }
        }
        if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.TYPE_SYMBOL || tokenId == RubyTokenId.CONSTANT || tokenId == RubyTokenId.GLOBAL_VAR || tokenId == RubyTokenId.INSTANCE_VAR) {
            char c;
            int n3;
            String string = ((Object)token.text()).toString();
            int n4 = string.length();
            int n5 = n - tokenSequence.offset();
            if (bl) {
                int n6 = n - 1 - tokenSequence.offset();
                if (n6 < 0) {
                    return -1;
                }
                if (n6 < n4 && Character.isUpperCase(string.charAt(n6))) {
                    for (int i = n6 - 1; i >= 0; --i) {
                        char c2 = string.charAt(i);
                        if (c2 == '_') {
                            return tokenSequence.offset() + i + 1;
                        }
                        if (Character.isUpperCase(c2)) continue;
                        return tokenSequence.offset() + i + 1;
                    }
                    return tokenSequence.offset();
                }
                for (int i = n6 - 1; i >= 0; --i) {
                    char c3 = string.charAt(i);
                    if (c3 == '_') {
                        return tokenSequence.offset() + i + 1;
                    }
                    if (!Character.isUpperCase(c3)) continue;
                    for (int j = i; j >= 0; --j) {
                        char c4 = string.charAt(j);
                        if (c4 == '_') {
                            return tokenSequence.offset() + j + 1;
                        }
                        if (Character.isUpperCase(c4)) continue;
                        return tokenSequence.offset() + j + 1;
                    }
                    return tokenSequence.offset();
                }
                return tokenSequence.offset();
            }
            int n7 = n5 + 1;
            if (n5 < 0 || n5 >= string.length()) {
                return -1;
            }
            if (Character.isUpperCase(string.charAt(n5))) {
                for (n3 = n7; n3 < n4 && Character.isUpperCase(c = string.charAt(n3)); ++n3) {
                    if (string.charAt(n3) == '_') {
                        return tokenSequence.offset() + n3;
                    }
                    ++n7;
                }
            }
            for (n3 = n7; n3 < n4; ++n3) {
                c = string.charAt(n3);
                if (c != '_' && !Character.isUpperCase(c)) continue;
                return tokenSequence.offset() + n3;
            }
        }
        return -1;
    }
}

