/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.MethodElement;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.spi.lexer.LanguageProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RDocFormatter {
    private boolean inVerbatim;
    private boolean inBulletedList;
    private boolean inLabelledList;
    private boolean inNumberedList;
    private List<String> code;
    private boolean firstVerbatim = true;
    private String seqName;
    private boolean wroteSignature = false;
    private boolean noComment;
    private final StringBuilder sb = new StringBuilder(500);

    public void setSeqName(String string) {
        this.seqName = string;
    }

    public boolean wroteSignature() {
        return this.wroteSignature;
    }

    public void appendLine(String string) {
        if (string.equals("#--")) {
            this.noComment = true;
            return;
        }
        if (string.equals("#++")) {
            this.noComment = false;
            return;
        }
        if (string.startsWith("#:arg:") || string.startsWith("#:return:=>")) {
            return;
        }
        if (this.noComment) {
            return;
        }
        if (string.startsWith("# ")) {
            string = string.substring(2);
        } else if (string.equals("#")) {
            string = "";
        }
        this.process(string);
    }

    private void process(String string) {
        if (string.length() == 0) {
            this.finishSection();
            int n = this.sb.length();
            if (this.sb.length() > 1 && this.sb.charAt(this.sb.length() - 1) == '\n' && (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</pre>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h1>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h2>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h3>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h4>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h5>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</ul>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</ol>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</table>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<hr>\n"))) {
                return;
            }
            if (this.sb.length() > 0) {
                if (n <= 4 || !GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.append("<br>");
                }
                this.sb.append("<br>");
            }
            return;
        }
        if (string.startsWith("* ") || string.startsWith("- ")) {
            if (!this.inBulletedList) {
                this.sb.append("<ul>\n");
                this.inBulletedList = true;
            }
            this.sb.append("<li>");
            this.appendTokenized(string.substring(string.indexOf(32) + 1));
            return;
        }
        if (string.matches("^[0-9]+\\.\\s*( .*)?")) {
            if (!this.inNumberedList) {
                this.sb.append("<ol>\n");
                this.inNumberedList = true;
            }
            this.sb.append("<li value=\"");
            Matcher matcher = Pattern.compile("^([0-9]+)\\.\\s*( .*)?").matcher(string);
            if (matcher.matches()) {
                this.sb.append(matcher.group(1));
            }
            this.sb.append("\">");
            int n = string.indexOf(32);
            if (n != -1) {
                this.appendTokenized(string.substring(n + 1));
            }
            return;
        }
        if (string.matches("^\\[[\\S]+\\]\\s*( .+)?")) {
            if (!this.inLabelledList) {
                this.sb.append("<table>\n");
                this.inLabelledList = true;
            } else {
                this.sb.append("</td></tr>\n");
            }
            this.sb.append("<tr><td valign=\"top\">");
            int n = string.indexOf("]");
            this.appendTokenized(string.substring(1, n));
            this.sb.append("</td><td>");
            this.appendTokenized(string.substring(n + 1));
            return;
        }
        if (string.matches("^[\\S]+::\\s*( .*)?")) {
            if (!this.inLabelledList) {
                this.sb.append("<table>\n");
                this.inLabelledList = true;
            } else {
                this.sb.append("</td></tr>\n");
            }
            this.sb.append("<tr><td valign=\"top\">");
            int n = string.indexOf("::");
            this.appendTokenized(string.substring(0, n));
            this.sb.append("</td><td>");
            this.appendTokenized(string.substring(n + 2));
            return;
        }
        if (!this.inBulletedList && !this.inNumberedList && !this.inLabelledList && string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
            if (!this.inVerbatim) {
                if (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.setLength(this.sb.length() - 4);
                }
                this.inVerbatim = true;
                this.code = new ArrayList<String>();
            }
            this.appendTokenized(string);
            return;
        }
        if (string.startsWith("=")) {
            int n;
            for (n = 0; n < string.length() && string.charAt(n) == '='; ++n) {
            }
            if (n <= 6) {
                if (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.setLength(this.sb.length() - 4);
                }
                this.sb.append("<h");
                this.sb.append(Integer.toString(n));
                this.sb.append(">");
                this.sb.append(string.substring(n));
                this.sb.append("</h");
                this.sb.append(Integer.toString(n));
                this.sb.append(">\n");
                return;
            }
            this.appendTokenized(string);
            return;
        }
        if (string.startsWith("#---") || string.startsWith("---")) {
            int n;
            int n2 = string.length();
            for (n = 1; n < n2 && string.charAt(n) == '-'; ++n) {
            }
            if (n == n2) {
                this.sb.append("<hr>\n");
                return;
            }
            this.appendTokenized(string);
            return;
        }
        if (string.startsWith("####")) {
            int n;
            int n3 = string.length();
            for (n = 1; n < n3 && string.charAt(n) == '#'; ++n) {
            }
            if (n == n3) {
                this.sb.append("<hr>\n");
                return;
            }
        } else if (this.inVerbatim) {
            this.finishSection();
        }
        this.appendTokenized(string);
    }

    private void appendTokenized(String string) {
        if (this.inVerbatim) {
            this.code.add(string);
            return;
        }
        this.firstVerbatim = false;
        this.appendTokenized(this.sb, string);
        if (this.inVerbatim) {
            this.sb.append("<br>");
        } else {
            this.sb.append(" ");
        }
    }

    private void appendTokenized(StringBuilder stringBuilder, String string) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, RubyCommentTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        int n = 0;
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            do {
                char c;
                String string2;
                Token token;
                if ((token = tokenSequence.token()).id() == RubyCommentTokenId.COMMENT_TEXT || token.id() == RubyCommentTokenId.COMMENT_TODO) {
                    try {
                        string2 = ((Object)token.text()).toString();
                        string2 = XMLUtil.toElementContent((String)string2);
                        if (string2.indexOf("---") != -1) {
                            string2 = string2.replace("---", "&#8212;");
                        }
                        stringBuilder.append(string2);
                    }
                    catch (CharConversionException charConversionException) {
                        Exceptions.printStackTrace((Throwable)charConversionException);
                    }
                    continue;
                }
                if (token.id() == RubyCommentTokenId.COMMENT_HTMLTAG) {
                    string2 = ((Object)token.text()).toString();
                    c = string2.charAt(0);
                    if (c == '+') {
                        stringBuilder.append("<tt>");
                        stringBuilder.append(string2.substring(1, string2.length() - 1));
                        stringBuilder.append("</tt>");
                        continue;
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                if (token.id() == RubyCommentTokenId.COMMENT_LINK) {
                    string2 = ((Object)token.text()).toString();
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append("\">");
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append("</a>");
                    continue;
                }
                if (token.id() == RubyCommentTokenId.COMMENT_ITALIC) {
                    stringBuilder.append("<i>");
                    string2 = ((Object)token.text()).toString();
                    c = string2.charAt(0);
                    if (c == '_') {
                        stringBuilder.append(string2.substring(1, string2.length() - 1));
                    } else {
                        stringBuilder.append(token.text());
                    }
                    stringBuilder.append("</i>");
                    continue;
                }
                if (token.id() == RubyCommentTokenId.COMMENT_BOLD) {
                    stringBuilder.append("<b>");
                    string2 = ((Object)token.text()).toString();
                    c = string2.charAt(0);
                    if (c == '*') {
                        stringBuilder.append(string2.substring(1, string2.length() - 1));
                    } else {
                        stringBuilder.append(token.text());
                    }
                    stringBuilder.append("</b>");
                    continue;
                }
                if (token.id() != RubyCommentTokenId.COMMENT_RDOC) continue;
            } while (tokenSequence.moveNext());
        }
    }

    private void finishSection() {
        if (this.inVerbatim) {
            boolean bl = false;
            if (this.code != null && this.code.size() > 0) {
                if (this.formatAsRuby(this.code)) {
                    String string = this.getRubyHtml(this.code);
                    if (string != null) {
                        this.sb.append(string);
                    } else {
                        this.sb.append("<pre>\n");
                        for (String string2 : this.code) {
                            try {
                                this.sb.append(XMLUtil.toElementContent((String)string2));
                            }
                            catch (CharConversionException charConversionException) {
                                Exceptions.printStackTrace((Throwable)charConversionException);
                            }
                            this.sb.append("<br>");
                        }
                        this.sb.append("</pre>\n");
                    }
                } else {
                    this.sb.append("<pre>\n");
                    if (this.isCallSeq(this.code)) {
                        String string = this.getCallSeqHtml(this.code);
                        this.sb.append(string);
                        bl = true;
                        this.wroteSignature = true;
                    } else {
                        for (String string : this.code) {
                            this.appendTokenized(this.sb, string);
                            this.sb.append("<br>");
                        }
                    }
                    this.sb.append("</pre>\n");
                }
                this.code = null;
            }
            if (bl) {
                this.sb.append("<hr>\n");
            }
            this.inVerbatim = false;
            this.firstVerbatim = false;
        }
        if (this.inBulletedList) {
            this.sb.append("</ul>\n");
            this.inBulletedList = false;
        }
        if (this.inNumberedList) {
            this.sb.append("</ol>\n");
            this.inBulletedList = false;
        }
        if (this.inLabelledList) {
            this.sb.append("</td></tr>\n</table>\n");
            this.inLabelledList = false;
        }
    }

    public String toHtml() {
        this.finishSection();
        return this.sb.toString();
    }

    private String getRubyHtml(List<String> list) {
        Object object;
        String string2;
        StringBuilder stringBuilder = new StringBuilder(500);
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        Language language = RubyTokenId.language();
        string2 = "text/x-ruby";
        if (stringBuilder.indexOf(" <%") != -1) {
            LanguageProvider languageProvider;
            string2 = "application/x-httpd-eruby";
            object = Lookup.getDefault().lookupAll(LanguageProvider.class);
            Iterator iterator = object.iterator();
            while (iterator.hasNext() && (language = (languageProvider = (LanguageProvider)iterator.next()).findLanguage(string2)) == null) {
            }
            if (language == null) {
                string2 = "text/x-ruby";
                language = RubyTokenId.language();
            }
        } else if (list.get(0).trim().startsWith("<")) {
            return null;
        }
        object = new StringBuilder(1500);
        boolean bl = this.appendSequence((StringBuilder)object, stringBuilder.toString(), language, string2, true);
        return bl ? null : ((StringBuilder)object).toString();
    }

    private boolean appendSequence(StringBuilder stringBuilder, String string, Language<?> language, String string2, boolean bl) {
        Object object;
        Object object2;
        MimePath mimePath = MimePath.parse((String)string2);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        if (bl) {
            Color color;
            stringBuilder.append("<pre style=\"");
            object2 = fontColorSettings.getTokenFontColors("default");
            object = (Color)object2.getAttribute(StyleConstants.Foreground);
            if (object != null) {
                stringBuilder.append("color:");
                stringBuilder.append(RDocFormatter.getHtmlColor((Color)object));
                stringBuilder.append(";");
            }
            if ((color = (Color)object2.getAttribute(StyleConstants.Background)) != null && color.getRed() < 128) {
                stringBuilder.append("background:");
                stringBuilder.append(RDocFormatter.getHtmlColor(color));
            }
            stringBuilder.append("\">\n");
        }
        object2 = TokenHierarchy.create((CharSequence)string, language);
        object = object2.tokenSequence();
        int n = 0;
        object.move(n);
        if (object.moveNext()) {
            do {
                Serializable serializable;
                Color color;
                Object object3;
                TokenSequence tokenSequence;
                Token token = object.token();
                String string3 = ((Object)token.text()).toString();
                String string4 = token.id().name();
                String string5 = token.id().primaryCategory();
                if ("error".equals(string5)) {
                    return true;
                }
                AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string4);
                String string6 = string3;
                try {
                    string6 = XMLUtil.toElementContent((String)string3);
                }
                catch (CharConversionException charConversionException) {
                    Exceptions.printStackTrace((Throwable)charConversionException);
                }
                if (attributeSet == null) {
                    string4 = string5;
                    attributeSet = fontColorSettings.getTokenFontColors(string4);
                }
                if ((tokenSequence = object.embedded()) != null) {
                    object3 = MimePath.parse((String)tokenSequence.languagePath().mimePath()).getPath();
                    color = null;
                    serializable = null;
                    if (attributeSet != null) {
                        color = (Color)attributeSet.getAttribute(StyleConstants.Background);
                        serializable = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
                        if (serializable != null || color != null) {
                            stringBuilder.append("<span style=\"");
                            if (color != null) {
                                stringBuilder.append("background:");
                                stringBuilder.append(RDocFormatter.getHtmlColor(color));
                                stringBuilder.append(";");
                            }
                            if (serializable != null) {
                                stringBuilder.append("color:");
                                stringBuilder.append(RDocFormatter.getHtmlColor((Color)serializable));
                            }
                            stringBuilder.append("\">");
                        }
                    }
                    this.appendSequence(stringBuilder, string3, tokenSequence.language(), (String)object3, false);
                    if (serializable == null && color == null) continue;
                    stringBuilder.append("</span>");
                    continue;
                }
                if (attributeSet == null) {
                    stringBuilder.append(string6);
                    continue;
                }
                if (string6.indexOf(10) != -1) {
                    string6 = string6.replace("\n", "<br>");
                }
                if (token.id() == RubyTokenId.WHITESPACE) {
                    stringBuilder.append(string6);
                    continue;
                }
                stringBuilder.append("<span style=\"");
                object3 = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
                if (object3 != null) {
                    stringBuilder.append("color:");
                    stringBuilder.append(RDocFormatter.getHtmlColor((Color)object3));
                    stringBuilder.append(";");
                }
                if ((color = (Color)attributeSet.getAttribute(StyleConstants.Background)) != null) {
                    stringBuilder.append("background:");
                    stringBuilder.append(RDocFormatter.getHtmlColor(color));
                    stringBuilder.append(";");
                }
                if ((serializable = (Boolean)attributeSet.getAttribute(StyleConstants.Bold)) != null && ((Boolean)serializable).booleanValue()) {
                    stringBuilder.append("font-weight:bold;");
                }
                if ((serializable = (Boolean)attributeSet.getAttribute(StyleConstants.Italic)) != null && ((Boolean)serializable).booleanValue()) {
                    stringBuilder.append("font-style:italic;");
                }
                stringBuilder.append("\">");
                stringBuilder.append(string6);
                stringBuilder.append("</span>");
            } while (object.moveNext());
        }
        if (bl) {
            stringBuilder.append("</pre>\n");
        }
        return false;
    }

    private String getCallSeqHtml(List<String> list) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Integer.MAX_VALUE;
        block2: for (String string : list) {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == ' ') continue;
                if (n >= n2) continue block2;
                n2 = n;
                continue block2;
            }
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0;
        }
        for (String string : list) {
            if (n2 > 0 && string.length() >= n2) {
                string = string.substring(n2);
            }
            if (this.seqName != null) {
                char c;
                n = string.indexOf(this.seqName);
                if (n != -1 && string.length() > n + this.seqName.length() && (c = string.charAt(n + this.seqName.length())) != ' ' && c != '(' && c != '{' && c != '[') {
                    n = -1;
                }
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = "";
                    if (string.length() > n + this.seqName.length()) {
                        string3 = string.substring(n + this.seqName.length());
                    }
                    try {
                        stringBuilder.append(XMLUtil.toElementContent((String)string2));
                        stringBuilder.append("<b>");
                        stringBuilder.append(XMLUtil.toElementContent((String)this.seqName));
                        stringBuilder.append("</b>");
                        stringBuilder.append(XMLUtil.toElementContent((String)string3));
                        stringBuilder.append("<br>");
                    }
                    catch (CharConversionException charConversionException) {
                        Exceptions.printStackTrace((Throwable)charConversionException);
                    }
                    continue;
                }
            }
            this.appendTokenized(stringBuilder, string);
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    public String getSignature(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<pre>");
        if (element instanceof MethodElement) {
            Object object;
            MethodElement methodElement = (MethodElement)element;
            if (element.getIn() != null) {
                object = element.getIn();
                stringBuilder.append("<i>");
                stringBuilder.append((String)object);
                stringBuilder.append("</i>");
                stringBuilder.append("<br>");
            }
            stringBuilder.append("<b>");
            stringBuilder.append(element.getName());
            stringBuilder.append("</b>");
            object = methodElement.getParameters();
            if (object != null && object.size() > 0) {
                stringBuilder.append("(");
                stringBuilder.append("<font color=\"#808080\">");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    stringBuilder.append(string);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("</font>");
                stringBuilder.append(")");
            }
        } else if (element instanceof ClassElement) {
            ClassElement classElement = (ClassElement)element;
            String string = element.getName();
            String string2 = classElement.getFqn();
            if (string2 != null && !string.equals(string2)) {
                stringBuilder.append("<i>");
                stringBuilder.append(string2);
                stringBuilder.append("</i>");
                stringBuilder.append("<br>");
            }
            stringBuilder.append("<b>");
            stringBuilder.append(string);
            stringBuilder.append("</b>");
        } else {
            stringBuilder.append(element.getName());
        }
        stringBuilder.append("</pre>\n");
        return stringBuilder.toString();
    }

    private static String getHtmlColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#');
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (n < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        if (n2 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        if (n3 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private boolean isCallSeq(List<String> list) {
        String string;
        return this.firstVerbatim && ((string = list.get(0)).indexOf("=>") != -1 || string.indexOf("->") != -1);
    }

    private boolean formatAsRuby(List<String> list) {
        if (this.isCallSeq(list)) {
            return false;
        }
        for (String string : list) {
            if (string.indexOf("---") != -1) {
                return false;
            }
            if (string.indexOf(" | ") == -1) continue;
            return false;
        }
        return true;
    }
}

