/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.KillableProcess;
import org.netbeans.modules.groovy.grails.RuntimeHelper;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.server.GrailsInstance;
import org.netbeans.modules.groovy.grails.server.GrailsInstanceProvider;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsRuntime {
    private static final Logger LOGGER = Logger.getLogger(GrailsRuntime.class.getName());
    private static final Set<String> GUARDED_COMMANDS = new HashSet<String>();
    private static GrailsRuntime instance;
    private boolean initialized;
    private String version;

    private GrailsRuntime() {
    }

    public static synchronized GrailsRuntime getInstance() {
        if (instance == null) {
            instance = new GrailsRuntime();
            GrailsSettings.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("grailsBase".equals(propertyChangeEvent.getPropertyName())) {
                        instance.reload();
                        GrailsInstanceProvider.getInstance().runtimeChanged();
                    }
                }
            });
            instance.reload();
        }
        return instance;
    }

    public Callable<Process> createCommand(CommandDescriptor commandDescriptor) {
        Parameters.notNull((CharSequence)"descriptor", (Object)commandDescriptor);
        if (!this.isConfigured()) {
            throw new IllegalStateException("Grails not configured");
        }
        return new GrailsCallable(commandDescriptor);
    }

    public boolean isConfigured() {
        String string = GrailsSettings.getInstance().getGrailsBase();
        if (string == null) {
            return false;
        }
        return RuntimeHelper.isValidRuntime(new File(string));
    }

    public File getGrailsHome() {
        String string = GrailsSettings.getInstance().getGrailsBase();
        if (string == null || !RuntimeHelper.isValidRuntime(new File(string))) {
            throw new IllegalStateException("Grails not configured");
        }
        return new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        GrailsRuntime grailsRuntime = this;
        synchronized (grailsRuntime) {
            if (this.initialized) {
                return this.version;
            }
            String string = GrailsSettings.getInstance().getGrailsBase();
            if (string != null) {
                this.version = RuntimeHelper.getRuntimeVersion(new File(string));
            }
            this.initialized = true;
            return this.version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        GrailsRuntime grailsRuntime = this;
        synchronized (grailsRuntime) {
            this.initialized = false;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrailsRuntime grailsRuntime = GrailsRuntime.this;
                synchronized (grailsRuntime) {
                    if (GrailsRuntime.this.initialized) {
                        return;
                    }
                    String string = GrailsSettings.getInstance().getGrailsBase();
                    if (string != null) {
                        GrailsRuntime.this.version = RuntimeHelper.getRuntimeVersion(new File(string));
                    }
                    GrailsRuntime.this.initialized = true;
                }
            }
        });
    }

    private static String createJvmArguments(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            if (n > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("-D").append(string);
            stringBuilder.append("=");
            stringBuilder.append(string2);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static String createCommandArguments(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static void checkForServer(CommandDescriptor commandDescriptor, Process process) {
        Project project;
        if (("run-app".equals(commandDescriptor.getName()) || "run-app-https".equals(commandDescriptor.getName()) || "run-war".equals(commandDescriptor.getName())) && (project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)commandDescriptor.getDirectory()))) != null) {
            GrailsInstanceProvider.getInstance().serverStarted(project, process);
        }
    }

    static {
        GrailsInstance.Accessor.DEFAULT = new GrailsInstance.Accessor(){

            public String getVersion(GrailsRuntime grailsRuntime) {
                return grailsRuntime.getVersion();
            }
        };
        Collections.addAll(GUARDED_COMMANDS, "run-app", "shell");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrailsCallable
    implements Callable<Process> {
        private final CommandDescriptor descriptor;

        public GrailsCallable(CommandDescriptor commandDescriptor) {
            this.descriptor = commandDescriptor;
        }

        @Override
        public Process call() throws Exception {
            String[] stringArray;
            String string = Utilities.isWindows() ? "\\bin\\grails.bat" : "/bin/grails";
            File file = new File(GrailsSettings.getInstance().getGrailsBase(), string);
            if (!file.exists()) {
                LOGGER.log(Level.WARNING, "Executable doesn't exist: " + file.getAbsolutePath());
                return null;
            }
            LOGGER.log(Level.FINEST, "About to run: {0}", this.descriptor.getName());
            Properties properties = new Properties(this.descriptor.getProps());
            if (this.descriptor.getEnvironment() != null && this.descriptor.getEnvironment().isCustom()) {
                properties.setProperty("grails.env", this.descriptor.getEnvironment().toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(GrailsRuntime.createJvmArguments(properties));
            if (this.descriptor.getEnvironment() != null && !this.descriptor.getEnvironment().isCustom()) {
                stringBuilder.append(" ").append(this.descriptor.getEnvironment().toString());
            }
            stringBuilder.append(" ").append(this.descriptor.getName());
            stringBuilder.append(" ").append(GrailsRuntime.createCommandArguments(this.descriptor.getArguments()));
            if (Utilities.isWindows() && GUARDED_COMMANDS.contains(this.descriptor.getName())) {
                stringBuilder.append(" ").append("REM NB:" + this.descriptor.getDirectory().getAbsolutePath());
            }
            LOGGER.log(Level.FINEST, "Command is: {0}", stringBuilder.toString());
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(file.getAbsolutePath(), stringBuilder.toString());
            String string2 = null;
            Collection collection = JavaPlatformManager.getDefault().getDefaultPlatform().getInstallFolders();
            if (collection.size() == 1 && (stringArray = FileUtil.toFile((FileObject)((FileObject)collection.iterator().next()))) != null) {
                string2 = stringArray.getAbsolutePath();
            }
            if (string2 == null) {
                string2 = System.getProperty("java.home");
            }
            stringArray = new String[]{"GRAILS_HOME=" + GrailsSettings.getInstance().getGrailsBase(), "JAVA_HOME=" + string2};
            KillableProcess killableProcess = new KillableProcess(nbProcessDescriptor.exec(null, stringArray, true, this.descriptor.getDirectory()), this.descriptor.getDirectory(), this.descriptor.getName());
            GrailsRuntime.checkForServer(this.descriptor, killableProcess);
            return killableProcess;
        }
    }

    public static final class CommandDescriptor {
        private final String name;
        private final File directory;
        private final GrailsEnvironment environment;
        private final String[] arguments;
        private final Properties props;

        public CommandDescriptor(String string, File file, GrailsEnvironment grailsEnvironment) {
            this(string, file, grailsEnvironment, new String[0], new Properties());
        }

        public CommandDescriptor(String string, File file, GrailsEnvironment grailsEnvironment, String[] stringArray) {
            this(string, file, grailsEnvironment, stringArray, new Properties());
        }

        public CommandDescriptor(String string, File file, GrailsEnvironment grailsEnvironment, String[] stringArray, Properties properties) {
            this.name = string;
            this.directory = file;
            this.environment = grailsEnvironment;
            this.arguments = (String[])stringArray.clone();
            this.props = new Properties(properties);
        }

        public String getName() {
            return this.name;
        }

        public File getDirectory() {
            return this.directory;
        }

        public GrailsEnvironment getEnvironment() {
            return this.environment;
        }

        public String[] getArguments() {
            return (String[])this.arguments.clone();
        }

        public Properties getProps() {
            return new Properties(this.props);
        }
    }
}

