/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EntityWizardPanel
extends JPanel {
    private Project project;
    private ChangeListener listener;
    private PersistenceUnit persistenceUnit;
    static final String IS_VALID = "EntityWizardPanel_isValid";
    private ButtonGroup accessTypeGroup;
    private JButton createPUButton;
    private JLabel createPUWarningLabel;
    private JLabel jLabel1;
    private ButtonGroup persistenceGroup;
    private JTextField primaryKeyTextField;
    private JButton searchButton;

    public EntityWizardPanel(ChangeListener changeListener) {
        this.setProject(this.project);
        this.listener = changeListener;
        this.initComponents();
        this.setPersistenceUnitButtonVisibility(false, null);
        this.primaryKeyTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }
        });
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyTextField.getText();
    }

    void setPersistenceUnitButtonVisibility(boolean bl, String string) {
        this.createPUButton.setVisible(bl);
        ImageIcon imageIcon = null;
        if (string != null) {
            imageIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif"));
        } else {
            string = " ";
        }
        this.createPUWarningLabel.setIcon(imageIcon);
        this.createPUWarningLabel.setText(string);
        this.createPUWarningLabel.setToolTipText(string);
    }

    void setProject(Project project) {
        this.project = project;
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    private void initComponents() {
        this.persistenceGroup = new ButtonGroup();
        this.accessTypeGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.primaryKeyTextField = new JTextField();
        this.createPUButton = new JButton();
        this.searchButton = new JButton();
        this.createPUWarningLabel = new ShyLabel();
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/entity/Bundle").getString("MN_PrimaryKeyType").charAt(0));
        this.jLabel1.setLabelFor(this.primaryKeyTextField);
        this.jLabel1.setText(NbBundle.getBundle(EntityWizardPanel.class).getString("LBL_PrimaryKeyClass"));
        this.primaryKeyTextField.setText("Long");
        this.createPUButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/entity/Bundle").getString("MN_CreatePersistenceUnit").charAt(0));
        this.createPUButton.setText(NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntityWizardPanel.this.createPUButtonActionPerformed(actionEvent);
            }
        });
        this.searchButton.setText("...");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntityWizardPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.createPUWarningLabel.setText(" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.primaryKeyTextField, -1, 173, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.searchButton)).add((Component)this.createPUButton).add((Component)this.createPUWarningLabel));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.searchButton).add((Component)this.primaryKeyTextField, -2, -1, -2)).addPreferredGap(0, 30, Short.MAX_VALUE).add((Component)this.createPUWarningLabel).addPreferredGap(0).add((Component)this.createPUButton)));
        this.primaryKeyTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_PrimaryKeyClass"));
        this.createPUButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_CreatePersistenceUnit"));
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ElementHandle elementHandle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
                    }

                    public boolean accept(ElementHandle<TypeElement> elementHandle) {
                        return true;
                    }
                });
                if (elementHandle != null) {
                    EntityWizardPanel.this.primaryKeyTextField.setText(elementHandle.getQualifiedName());
                }
            }
        });
    }

    private void createPUButtonActionPerformed(ActionEvent actionEvent) {
        this.persistenceUnit = Util.buildPersistenceUnitUsingWizard(this.project, null, PersistenceUnitWizardPanel.TableGeneration.CREATE);
        if (this.persistenceUnit != null) {
            this.firePropertyChange(IS_VALID, false, true);
            this.setPersistenceUnitButtonVisibility(false, null);
        }
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 0;
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width = 0;
            return dimension;
        }
    }
}

