/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.schema.AbstractSchemaSearchVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindAllChildrenSchemaVisitor
extends AbstractSchemaSearchVisitor {
    private boolean mLookForElements;
    private boolean mLookForAttributes;
    private boolean mSupportAny;
    private List<SchemaComponent> myFound = new ArrayList<SchemaComponent>();
    private boolean mHasAny = false;
    private boolean mHasAnyAttribute = false;

    public FindAllChildrenSchemaVisitor(boolean bl, boolean bl2, boolean bl3) {
        assert (bl || bl2) : "one of the flags has to be true";
        this.mLookForElements = bl;
        this.mLookForAttributes = bl2;
        this.mSupportAny = bl3;
    }

    public List<SchemaComponent> getFound() {
        return this.myFound;
    }

    public boolean hasAny() {
        return this.mHasAny;
    }

    public boolean hasAnyAttribute() {
        return this.mHasAnyAttribute;
    }

    public void lookForSubcomponents(SchemaComponent schemaComponent) {
        this.myFound.clear();
        if (schemaComponent instanceof Element) {
            NamedComponentReference namedComponentReference;
            if (schemaComponent instanceof TypeContainer) {
                GlobalType globalType;
                NamedComponentReference namedComponentReference2 = ((TypeContainer)schemaComponent).getType();
                if (namedComponentReference2 != null && (globalType = (GlobalType)namedComponentReference2.get()) != null) {
                    globalType.accept((SchemaVisitor)this);
                }
                if ((globalType = ((TypeContainer)schemaComponent).getInlineType()) != null) {
                    globalType.accept((SchemaVisitor)this);
                }
            } else if (schemaComponent instanceof ElementReference && (namedComponentReference = ((ElementReference)schemaComponent).getRef()) != null) {
                GlobalElement globalElement = (GlobalElement)namedComponentReference.get();
                this.lookForSubcomponents((SchemaComponent)globalElement);
            }
        } else if (schemaComponent instanceof ComplexType) {
            this.visitChildren(schemaComponent);
        } else if (schemaComponent instanceof Schema) {
            this.visitChildren(schemaComponent);
        }
    }

    @Override
    protected void checkComponent(SchemaComponent schemaComponent) {
        if (this.mLookForElements && schemaComponent instanceof Element) {
            if (schemaComponent instanceof ElementReference) {
                return;
            }
            this.addSchemaComponent(schemaComponent);
            return;
        }
        if (this.mLookForAttributes && schemaComponent instanceof Attribute) {
            this.myFound.add(schemaComponent);
            return;
        }
        if (schemaComponent instanceof AnyElement) {
            this.mHasAny = true;
            if (this.mSupportAny) {
                this.myFound.add(schemaComponent);
            }
        }
        if (schemaComponent instanceof AnyAttribute) {
            this.mHasAnyAttribute = true;
            if (this.mSupportAny) {
                this.myFound.add(schemaComponent);
            }
        }
    }

    private void addSchemaComponent(SchemaComponent schemaComponent) {
        if (!(schemaComponent instanceof Named)) {
            this.myFound.add(schemaComponent);
            return;
        }
        boolean bl = true;
        for (SchemaComponent schemaComponent2 : this.myFound) {
            if (!(schemaComponent2 instanceof Named)) continue;
            String string = ((Named)schemaComponent2).getName();
            String string2 = ((Named)schemaComponent).getName();
            String string3 = schemaComponent.getModel().getEffectiveNamespace(schemaComponent);
            String string4 = schemaComponent2.getModel().getEffectiveNamespace(schemaComponent2);
            if (string == null || !string.equals(string2) || !this.equalsNemeSpase(string3, string4)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.myFound.add(schemaComponent);
        }
    }

    private boolean equalsNemeSpase(Object object, Object object2) {
        if (object == null || object2 == null) {
            return true;
        }
        return object.equals(object2);
    }
}

