/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.Parser;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathAxis;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelFactory;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.impl.XPathModelFactoryImpl;
import org.netbeans.modules.xml.xpath.ext.impl.XPathTreeCompiler;
import org.netbeans.modules.xml.xpath.ext.metadata.AbstractArgument;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.CoreFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.ExtFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.GeneralFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.OperationMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.StubExtFunction;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathMetadataUtils;
import org.netbeans.modules.xml.xpath.ext.schema.CachingSchemaSearchVisitor;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.CastSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.MultiCompSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SimpleSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.VariableSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.WildcardSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.ExtensionFunctionResolver;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.netbeans.modules.xml.xpath.ext.spi.VariableResolver;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCast;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCastResolver;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathProblem;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathValidationContext;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathModelTracerVisitor;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathModelImpl
implements XPathModel {
    private XPathModelFactory mFactory = new XPathModelFactoryImpl(this);
    private XPathExpression mRootXPathExpression;
    private boolean isInExprResolveMode = false;
    private boolean isInResolveMode = false;
    private boolean isResolved = false;
    private XPathCastResolver myXPathCastResolver;
    private VariableResolver mVarResilver;
    private ExternalModelResolver mExternalModelResolver;
    private NamespaceContext mNamespaceContext;
    private XPathSchemaContext mRootSchemaContext;
    private XPathValidationContext mValidationContext;
    private ExtensionFunctionResolver mExtFuncResolver;
    private static FilInStubVisitor sFilInStubVisitor = new FilInStubVisitor();
    private CachingSchemaSearchVisitor mCachingSchemaSearchVisitor;
    private boolean myWasFunctionOrOperation;
    private SchemaComponent myLastSchemaComponent;
    private boolean ENABLE;

    @Override
    public XPathModelFactory getFactory() {
        return this.mFactory;
    }

    @Override
    public XPathExpression parseExpression(String string) throws XPathException {
        this.myWasFunctionOrOperation = false;
        try {
            XPathTreeCompiler xPathTreeCompiler = new XPathTreeCompiler(this);
            Object object = Parser.parseExpression((String)string, (Compiler)xPathTreeCompiler);
            if (object instanceof XPathExpression) {
                this.mRootXPathExpression = (XPathExpression)object;
                return this.mRootXPathExpression;
            }
            String string2 = XPathProblem.BAD_XPATH_EXPRESSION.getMsgTemplate();
            String string3 = MessageFormat.format(string2, string);
            if (this.mValidationContext != null) {
                this.mValidationContext.addResultItem(null, Validator.ResultType.ERROR, XPathProblem.BAD_XPATH_EXPRESSION, string3);
            }
            XPathException xPathException = new XPathException(string3);
            throw xPathException;
        }
        catch (JXPathException jXPathException) {
            if (this.mValidationContext != null) {
                Throwable throwable = XPathModelImpl.getInitialCause(jXPathException);
                if (throwable == null) {
                    String string4 = XPathProblem.BAD_XPATH_EXPRESSION.getMsgTemplate();
                    String string5 = MessageFormat.format(string4, string);
                    this.mValidationContext.addResultItem(null, Validator.ResultType.ERROR, XPathProblem.BAD_XPATH_EXPRESSION, string5);
                } else {
                    String string6 = XPathProblem.XPATH_PARSING_EXCEPTION.getMsgTemplate();
                    String string7 = MessageFormat.format(string6, string, throwable.getMessage());
                    this.mValidationContext.addResultItem(null, Validator.ResultType.ERROR, XPathProblem.XPATH_PARSING_EXCEPTION, string7);
                }
            }
            throw new XPathException((Exception)((Object)jXPathException));
        }
    }

    @Override
    public XPathExpression getRootExpression() {
        return this.mRootXPathExpression;
    }

    @Override
    public void setRootExpression(XPathExpression xPathExpression) {
        this.mRootXPathExpression = xPathExpression;
    }

    @Override
    public void fillInStubs(XPathExpression xPathExpression) {
        if (xPathExpression == null) {
            xPathExpression = this.getRootExpression();
        }
        if (xPathExpression != null) {
            xPathExpression.accept(sFilInStubVisitor);
        }
    }

    @Override
    public VariableResolver getVariableResolver() {
        return this.mVarResilver;
    }

    @Override
    public void setVariableResolver(VariableResolver variableResolver) {
        this.mVarResilver = variableResolver;
    }

    @Override
    public ExternalModelResolver getExternalModelResolver() {
        return this.mExternalModelResolver;
    }

    @Override
    public void setExternalModelResolver(ExternalModelResolver externalModelResolver) {
        this.mExternalModelResolver = externalModelResolver;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.mNamespaceContext;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.mNamespaceContext = namespaceContext;
    }

    @Override
    public XPathSchemaContext getSchemaContext() {
        return this.mRootSchemaContext;
    }

    @Override
    public void setSchemaContext(XPathSchemaContext xPathSchemaContext) {
        this.mRootSchemaContext = xPathSchemaContext;
    }

    @Override
    public XPathValidationContext getValidationContext() {
        return this.mValidationContext;
    }

    @Override
    public void setValidationContext(XPathValidationContext xPathValidationContext) {
        this.mValidationContext = xPathValidationContext;
    }

    @Override
    public ExtensionFunctionResolver getExtensionFunctionResolver() {
        return this.mExtFuncResolver;
    }

    @Override
    public void setExtensionFunctionResolver(ExtensionFunctionResolver extensionFunctionResolver) {
        this.mExtFuncResolver = extensionFunctionResolver;
    }

    @Override
    public void setCachingSchemaSearchVisitor(CachingSchemaSearchVisitor cachingSchemaSearchVisitor) {
        this.mCachingSchemaSearchVisitor = cachingSchemaSearchVisitor;
    }

    @Override
    public XPathCastResolver getXPathCastResolver() {
        return this.myXPathCastResolver;
    }

    @Override
    public void setXPathCastResolver(XPathCastResolver xPathCastResolver) {
        this.myXPathCastResolver = xPathCastResolver;
    }

    private String resolveNamespace(QName qName, boolean bl) throws StopResolutionException {
        String string = qName.getNamespaceURI();
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = qName.getPrefix();
            if (!(bl || string2 != null && string2.length() != 0)) {
                return null;
            }
            NamespaceContext namespaceContext = this.getNamespaceContext();
            if (namespaceContext == null) {
                throw new RuntimeException("A NamespaceContext has to be specified for the XPath model");
            }
            string = namespaceContext.getNamespaceURI(string2);
        }
        if (string == null && this.mValidationContext != null) {
            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNKNOWN_NAMESPACE_PREFIX, string2);
            throw new StopResolutionException("Unknown namespace prefix: " + string2);
        }
        return string;
    }

    private Set<XPathSchemaContext.SchemaCompPair> resolveChildComponents(XPathSchemaContext xPathSchemaContext, QName qName, boolean bl, boolean bl2) {
        Object object;
        HashSet<XPathSchemaContext.SchemaCompPair> hashSet;
        String string;
        block22: {
            String string2;
            block21: {
                assert (qName != null);
                string = this.resolveNamespace(qName, bl2);
                string2 = qName.getLocalPart();
                hashSet = new HashSet<XPathSchemaContext.SchemaCompPair>();
                this.myLastSchemaComponent = null;
                if (bl2) break block21;
                object = xPathSchemaContext.getSchemaCompPairs();
                switch (object.size()) {
                    case 0: {
                        assert (false) : "Parent context must always contain parent schema component!";
                        break block22;
                    }
                    case 1: {
                        List<SchemaCompHolder> list;
                        XPathSchemaContext.SchemaCompPair schemaCompPair = (XPathSchemaContext.SchemaCompPair)object.iterator().next();
                        SchemaCompHolder schemaCompHolder = schemaCompPair.getCompHolder();
                        if (schemaCompHolder == null || (list = XPathUtils.getChildren(this, xPathSchemaContext, schemaCompHolder.getSchemaComponent(), string2, string, bl, this.mCachingSchemaSearchVisitor)) == null) break block22;
                        for (SchemaCompHolder schemaCompHolder2 : list) {
                            XPathSchemaContext.SchemaCompPair schemaCompPair2 = new XPathSchemaContext.SchemaCompPair(schemaCompHolder2, schemaCompHolder);
                            this.addPair(hashSet, schemaCompPair2);
                        }
                        break block22;
                    }
                    default: {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            XPathSchemaContext.SchemaCompPair schemaCompPair = (XPathSchemaContext.SchemaCompPair)iterator.next();
                            SchemaCompHolder schemaCompHolder = schemaCompPair.getCompHolder();
                            List<SchemaCompHolder> list = XPathUtils.getChildren(this, xPathSchemaContext, schemaCompHolder.getSchemaComponent(), string2, string, bl, this.mCachingSchemaSearchVisitor);
                            for (SchemaCompHolder schemaCompHolder3 : list) {
                                XPathSchemaContext.SchemaCompPair schemaCompPair3 = new XPathSchemaContext.SchemaCompPair(schemaCompHolder3, schemaCompHolder);
                                this.addPair(hashSet, schemaCompPair3);
                            }
                        }
                        break block22;
                    }
                }
            }
            object = this.getExternalModelResolver();
            if (object != null) {
                Collection<SchemaModel> collection = null;
                collection = string == null || string.length() == 0 ? object.getVisibleModels() : object.getModels(string);
                if (collection == null) {
                    throw new StopResolutionException("It didn't manage to find any external schema model to rosolve the \"" + string2 + "\" step.");
                }
                for (SchemaModel schemaModel : collection) {
                    Schema schema = schemaModel.getSchema();
                    List<SchemaCompHolder> list = XPathUtils.getChildren(this, xPathSchemaContext, (SchemaComponent)schema, string2, string, bl, this.mCachingSchemaSearchVisitor);
                    for (SchemaCompHolder schemaCompHolder : list) {
                        assert (schemaCompHolder instanceof SchemaCompHolder.ElementHolder || schemaCompHolder instanceof SchemaCompHolder.AttributeHolder);
                        XPathSchemaContext.SchemaCompPair schemaCompPair = new XPathSchemaContext.SchemaCompPair(schemaCompHolder, null);
                        this.addPair(hashSet, schemaCompPair);
                    }
                }
            }
        }
        if (this.mValidationContext != null && hashSet.isEmpty()) {
            object = XPathUtils.qNameObjectToString(qName);
            if (bl) {
                if (string == null || string.length() == 0) {
                    this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNKNOWN_ATTRIBUTE, object);
                } else {
                    this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNKNOWN_ATTRIBUTE_WITH_NAMESPACE, object, string);
                }
            } else if (string == null || string.length() == 0) {
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNKNOWN_ELEMENT, object);
            } else {
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNKNOWN_ELEMENT_WITH_NAMESPACE, object, string);
            }
        }
        return hashSet;
    }

    private void addPair(HashSet<XPathSchemaContext.SchemaCompPair> hashSet, XPathSchemaContext.SchemaCompPair schemaCompPair) {
        hashSet.add(schemaCompPair);
        this.myLastSchemaComponent = schemaCompPair.getCompHolder().getSchemaComponent();
    }

    @Override
    public SchemaComponent getLastSchemaComponent() {
        if (this.myWasFunctionOrOperation) {
            return null;
        }
        return this.myLastSchemaComponent;
    }

    private void checkResolvedSchemaContext(LocationStep locationStep, boolean bl, boolean bl2, ResourceCollector resourceCollector) {
        Object object;
        if (this.mValidationContext == null) {
            return;
        }
        XPathSchemaContext xPathSchemaContext = locationStep.getSchemaContext();
        if (xPathSchemaContext == null) {
            return;
        }
        Set<XPathSchemaContext.SchemaCompPair> set = null;
        set = bl2 ? xPathSchemaContext.getSchemaCompPairs() : xPathSchemaContext.getUsedSchemaCompPairs();
        if (set.isEmpty()) {
            return;
        }
        StepNodeTest stepNodeTest = locationStep.getNodeTest();
        XPathAxis xPathAxis = locationStep.getAxis();
        QName qName = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stepNodeTest instanceof StepNodeNameTest && !((StepNodeNameTest)(object = (StepNodeNameTest)stepNodeTest)).isWildcard()) {
            bl4 = true;
            switch (xPathAxis) {
                case ATTRIBUTE: {
                    bl3 = true;
                }
                case CHILD: {
                    qName = ((StepNodeNameTest)object).getNodeName();
                    break;
                }
            }
        }
        if (qName != null) {
            if (set.size() == 1) {
                object = set.iterator().next();
                SchemaComponent schemaComponent = ((XPathSchemaContext.SchemaCompPair)object).getCompHolder().getSchemaComponent();
                this.checkNsPrefixes(schemaComponent, qName.getPrefix(), resourceCollector, xPathSchemaContext);
            } else {
                object = qName.getPrefix();
                if ((object == null || ((String)object).length() == 0) && bl && bl4) {
                    this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.AMBIGUOUS_ABSOLUTE_PATH_BEGINNING, qName.getLocalPart());
                } else {
                    this.checkMultiNsPrefixes(set, qName, bl3, xPathSchemaContext);
                }
            }
        }
    }

    private void checkNsPrefixes(SchemaComponent schemaComponent, String string, ResourceCollector resourceCollector, XPathSchemaContext xPathSchemaContext) {
        assert (this.mValidationContext != null);
        Form form = null;
        boolean bl = false;
        if (schemaComponent instanceof LocalElement) {
            form = ((LocalElement)schemaComponent).getFormEffective();
        } else if (schemaComponent instanceof LocalAttribute) {
            form = ((LocalAttribute)schemaComponent).getFormEffective();
        } else {
            form = Form.QUALIFIED;
            bl = true;
        }
        String string2 = null;
        Set<String> set = XPathSchemaContext.Utilities.getEffectiveNamespaces(schemaComponent, xPathSchemaContext.getParentContext());
        if (set.size() != 1) {
            return;
        }
        string2 = set.iterator().next();
        if (Form.UNQUALIFIED.equals((Object)form) && string != null && string.length() != 0) {
            if (schemaComponent instanceof LocalElement) {
                String string3 = ((LocalElement)schemaComponent).getName();
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.ELEMENT_UNNECESSARY_PREFIX, string3);
            } else if (schemaComponent instanceof LocalAttribute) {
                String string4 = ((LocalAttribute)schemaComponent).getName();
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTRIBUTE_UNNECESSARY_PREFIX, string4);
            }
        } else if (Form.QUALIFIED.equals((Object)form)) {
            if (string != null && string.length() != 0) {
                resourceCollector.addRequiredImport(string2);
            } else {
                Object object;
                String string5 = null;
                if (string2 != null && string2.length() != 0 && (object = this.getNamespaceContext()) != null && (string5 = object.getPrefix(string2)) == null) {
                    resourceCollector.addRequiredPrefixForUri(string2);
                }
                object = ((Named)schemaComponent).getName();
                if (bl) {
                    if (schemaComponent instanceof Element) {
                        if (string5 == null) {
                            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.GLOBAL_ELEMENT_PREFIX_REQUIRED, object);
                        } else {
                            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.GLOBAL_ELEMENT_SPECIFIC_PREFIX_REQUIRED, object, string5);
                        }
                    } else if (schemaComponent instanceof Attribute) {
                        if (string5 == null) {
                            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.GLOBAL_ATTRIBUTE_PREFIX_REQUIRED, object);
                        } else {
                            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.GLOBAL_ATTRIBUTE_SPECIFIC_PREFIX_REQUIRED, object, string5);
                        }
                    }
                } else if (schemaComponent instanceof Element) {
                    if (string5 == null) {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ELEMENT_PREFIX_REQUIRED, object);
                    } else {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ELEMENT_SPECIFIC_PREFIX_REQUIRED, object, string5);
                    }
                } else if (schemaComponent instanceof Attribute) {
                    if (string5 == null) {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTRIBUTE_PREFIX_REQUIRED, object);
                    } else {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTRIBUTE_SPECIFIC_PREFIX_REQUIRED, object, string5);
                    }
                }
            }
        }
    }

    private void checkMultiNsPrefixes(Set<XPathSchemaContext.SchemaCompPair> set, QName qName, boolean bl, XPathSchemaContext xPathSchemaContext) {
        Object object;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HashSet<QName> hashSet = new HashSet<QName>();
        for (XPathSchemaContext.SchemaCompPair object22 : set) {
            object = object22.getCompHolder().getSchemaComponent();
            Form form = null;
            boolean bl5 = false;
            if (object instanceof LocalElement) {
                form = ((LocalElement)object).getFormEffective();
            } else if (object instanceof LocalAttribute) {
                form = ((LocalAttribute)object).getFormEffective();
            } else {
                form = Form.QUALIFIED;
                bl5 = true;
            }
            if (bl5) {
                bl2 = true;
            }
            if (form == Form.QUALIFIED) {
                bl3 = true;
            }
            if (form == Form.UNQUALIFIED) {
                bl4 = true;
            }
            Set<String> set2 = XPathSchemaContext.Utilities.getEffectiveNamespaces(object, xPathSchemaContext.getParentContext());
            for (String string : set2) {
                String string2 = this.mNamespaceContext.getPrefix(string);
                QName qName2 = null;
                qName2 = string2 == null || string2.length() == 0 ? new QName(string, "aaa") : new QName(string, "aaa", string2);
                hashSet.add(qName2);
            }
        }
        String string = qName.getPrefix();
        String string3 = qName.getLocalPart();
        if (string == null || string.length() == 0) {
            if (bl3 || bl2) {
                object = this.prepareNamespaceList(hashSet);
                if (!bl4) {
                    if (bl) {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTR_PREFIX_FROM_LIST_REQUIRED, string3, object);
                    } else {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ELEM_PREFIX_FROM_LIST_REQUIRED, string3, object);
                    }
                } else if (bl3) {
                    if (bl) {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTR_MAYBE_PREFIX_FROM_LIST_REQUIRED, string3, object);
                    } else {
                        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ELEM_MAYBE_PREFIX_FROM_LIST_REQUIRED, string3, object);
                    }
                }
            }
        } else if (!bl3 && !bl2) {
            if (bl) {
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ATTR_PREFIX_REDUNDANT, string3);
            } else {
                this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.ELEM_PREFIX_REDUNDANT, string3);
            }
        }
    }

    private void setUsedComponents(XPathSchemaContext xPathSchemaContext, Set<XPathSchemaContext.SchemaCompPair> set) {
        if (xPathSchemaContext == null || set == null) {
            return;
        }
        HashSet<SchemaCompHolder> hashSet = new HashSet<SchemaCompHolder>();
        for (XPathSchemaContext.SchemaCompPair schemaCompPair : set) {
            SchemaCompHolder schemaCompHolder = schemaCompPair.getParetnCompHolder();
            hashSet.add(schemaCompHolder);
        }
        if (!hashSet.isEmpty()) {
            xPathSchemaContext.setUsedSchemaCompH(hashSet);
        }
        this.setUsedComponents(xPathSchemaContext.getParentContext(), xPathSchemaContext.getUsedSchemaCompPairs());
    }

    public boolean checkExtFunction(XPathExtensionFunction xPathExtensionFunction) {
        Object object;
        if (this.mValidationContext == null || this.mExtFuncResolver == null || this.mNamespaceContext == null) {
            return false;
        }
        QName qName = xPathExtensionFunction.getName();
        String string = qName.getNamespaceURI();
        String string2 = qName.getPrefix();
        String string3 = qName.getLocalPart();
        if ((string == null || string.length() == 0) && (string = this.mNamespaceContext.getNamespaceURI(string2)) == null) {
            this.mValidationContext.addResultItem(this.mRootXPathExpression, Validator.ResultType.ERROR, XPathProblem.UNKNOWN_NAMESPACE_PREFIX, string2);
            return false;
        }
        Collection<QName> collection = this.mExtFuncResolver.getSupportedExtFunctions();
        ArrayList<QName> arrayList = new ArrayList<QName>();
        for (QName qName2 : collection) {
            if (!qName2.getLocalPart().equals(string3)) continue;
            if (string == null) {
                arrayList.add(qName2);
                continue;
            }
            if (qName2.getNamespaceURI().equals(string)) {
                return true;
            }
            arrayList.add(qName2);
        }
        if (arrayList.isEmpty()) {
            object = XPathUtils.qNameObjectToString(qName);
            boolean bl = ((String)object).equals("stringToBytes") || ((String)object).equals("bytesToString") || ((String)object).equals("convert");
            this.mValidationContext.addResultItem(this.mRootXPathExpression, bl ? Validator.ResultType.WARNING : Validator.ResultType.ERROR, XPathProblem.UNKNOWN_EXTENSION_FUNCTION, XPathUtils.qNameObjectToString(qName));
        } else {
            object = this.prepareNamespaceList(arrayList);
            if (string2.length() == 0) {
                boolean bl = string3.equals("current-date") || string3.equals("current-dateTime") || string3.equals("current-time");
                this.mValidationContext.addResultItem(this.mRootXPathExpression, bl ? Validator.ResultType.WARNING : Validator.ResultType.ERROR, XPathProblem.PREFIX_REQUIRED_FOR_EXT_FUNCTION, string3, object);
            } else {
                this.mValidationContext.addResultItem(this.mRootXPathExpression, Validator.ResultType.ERROR, XPathProblem.OTHER_PREFIX_REQUIRED_FOR_EXT_FUNCTION, string3, string, object);
            }
        }
        return false;
    }

    private String prepareNamespaceList(Collection<QName> collection) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (QName qName : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("; ");
            }
            String string = qName.getNamespaceURI();
            String string2 = this.mNamespaceContext.getPrefix(string);
            stringBuilder.append("{").append(string).append("}");
            if (string2 == null || string2.length() == 0) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void warnResourceAbsence(ResourceCollector resourceCollector) {
        if (this.mValidationContext == null || resourceCollector == null) {
            return;
        }
        for (String string : resourceCollector.getRequiredImports()) {
            if (this.mExternalModelResolver != null && string != null && string.length() > 0 && this.mExternalModelResolver.isSchemaVisible(string)) continue;
        }
        for (String string : resourceCollector.getPrefixRequiredForUri()) {
            this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.WARNING, XPathProblem.MISSING_NAMESPACE_PREFIX, string);
        }
    }

    private void warnStub(int n) {
        if (this.mValidationContext == null || n == 0) {
            return;
        }
        this.mValidationContext.addResultItem(this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.EXPR_CONTAINS_STUB, n);
    }

    @Override
    public synchronized void discardResolvedStatus() {
        this.isResolved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resolveExtReferences(boolean bl) {
        if (this.isResolved && !bl) {
            return;
        }
        if (this.mRootXPathExpression != null && !this.isInResolveMode) {
            this.isResolved = false;
            this.isInResolveMode = true;
            try {
                ReferenceResolutionVisitor referenceResolutionVisitor = new ReferenceResolutionVisitor(this.getSchemaContext());
                this.mRootXPathExpression.accept(referenceResolutionVisitor);
                this.warnResourceAbsence(referenceResolutionVisitor.getResourceCollector());
                this.warnStub(referenceResolutionVisitor.getStubCounter());
            }
            catch (StopResolutionException stopResolutionException) {
            }
            finally {
                this.isInResolveMode = false;
                this.isResolved = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resolveExpressionExtReferences(XPathExpression xPathExpression) {
        if (xPathExpression != null && !this.isInExprResolveMode) {
            this.isInExprResolveMode = true;
            try {
                ReferenceResolutionVisitor referenceResolutionVisitor = new ReferenceResolutionVisitor(this.getSchemaContext());
                xPathExpression.accept(referenceResolutionVisitor);
                this.warnResourceAbsence(referenceResolutionVisitor.getResourceCollector());
                this.warnStub(referenceResolutionVisitor.getStubCounter());
            }
            catch (StopResolutionException stopResolutionException) {
            }
            finally {
                this.isInExprResolveMode = false;
            }
        }
    }

    private static Throwable getInitialCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return XPathModelImpl.getInitialCause(throwable2);
    }

    private void out() {
        if (this.ENABLE) {
            System.out.println();
        }
    }

    private void out(Object object) {
        if (this.ENABLE) {
            System.out.println("*** " + object);
        }
    }

    private static class FilInStubVisitor
    extends XPathModelTracerVisitor {
        private FilInStubVisitor() {
        }

        public void visit(XPathCoreFunction xPathCoreFunction) {
            this.visitChildren(xPathCoreFunction);
            CoreFunctionMetadata coreFunctionMetadata = xPathCoreFunction.getFunctionType().getMetadata();
            this.checkChildren(xPathCoreFunction, coreFunctionMetadata);
        }

        public void visit(XPathCoreOperation xPathCoreOperation) {
            this.visitChildren(xPathCoreOperation);
            OperationMetadata operationMetadata = xPathCoreOperation.getOperationType().getMetadata();
            this.checkChildren(xPathCoreOperation, operationMetadata);
        }

        public void visit(XPathExtensionFunction xPathExtensionFunction) {
            this.visitChildren(xPathExtensionFunction);
            ExtFunctionMetadata extFunctionMetadata = xPathExtensionFunction.getMetadata();
            this.checkChildren(xPathExtensionFunction, extFunctionMetadata);
        }

        private void checkChildren(XPathOperationOrFuntion xPathOperationOrFuntion, GeneralFunctionMetadata generalFunctionMetadata) {
            if (generalFunctionMetadata == null) {
                return;
            }
            List<AbstractArgument> list = generalFunctionMetadata.getArguments();
            if (list == null || list.size() == 0) {
                return;
            }
            List<ArgumentDescriptor> list2 = XPathMetadataUtils.getArgDescriptorsList(list, true);
            if (list2 == null || list2.size() == 0) {
                return;
            }
            int n = -1;
            XPathModelFactory xPathModelFactory = null;
            for (ArgumentDescriptor argumentDescriptor : list2) {
                int n2 = argumentDescriptor.getMinOccurs();
                for (int i = 0; i < n2; ++i) {
                    XPathExpression xPathExpression = null;
                    if (++n < xPathOperationOrFuntion.getChildCount()) {
                        xPathExpression = xPathOperationOrFuntion.getChild(n);
                    }
                    if (xPathExpression != null || !argumentDescriptor.isMandatory()) continue;
                    if (xPathModelFactory == null) {
                        xPathModelFactory = xPathOperationOrFuntion.getModel().getFactory();
                    }
                    XPathExtensionFunction xPathExtensionFunction = xPathModelFactory.newXPathExtensionFunction(StubExtFunction.STUB_FUNC_NAME);
                    xPathOperationOrFuntion.insertChild(n, xPathExtensionFunction);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceCollector {
        private HashSet<String> mRequiredNsImports = new HashSet();
        private HashSet<String> mPrefixRequiredForUri = new HashSet();

        private ResourceCollector() {
        }

        public void addRequiredImport(String string) {
            this.mRequiredNsImports.add(string);
        }

        public void addRequiredPrefixForUri(String string) {
            this.mPrefixRequiredForUri.add(string);
        }

        public Set<String> getRequiredImports() {
            return this.mRequiredNsImports;
        }

        public Set<String> getPrefixRequiredForUri() {
            return this.mPrefixRequiredForUri;
        }
    }

    private class StopResolutionException
    extends RuntimeException {
        public StopResolutionException() {
        }

        public StopResolutionException(String string) {
            super(string);
        }
    }

    private class ReferenceResolutionVisitor
    extends XPathVisitorAdapter {
        private XPathSchemaContext parentSchemaContext;
        private ResourceCollector mResourceCollector;
        private int mStubCounter = 0;

        public ReferenceResolutionVisitor(XPathSchemaContext xPathSchemaContext) {
            this.parentSchemaContext = xPathSchemaContext;
            this.mResourceCollector = new ResourceCollector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(XPathLocationPath xPathLocationPath) {
            XPathSchemaContext xPathSchemaContext = this.parentSchemaContext;
            try {
                this.processLocationSteps(xPathLocationPath.getSteps(), xPathLocationPath.getAbsolute());
            }
            catch (StopResolutionException stopResolutionException) {
            }
            finally {
                this.parentSchemaContext = xPathSchemaContext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(LocationStep locationStep) {
            XPathSchemaContext xPathSchemaContext = this.parentSchemaContext;
            try {
                boolean bl = this.parentSchemaContext == null;
                this.processLocationStep(locationStep, bl);
            }
            catch (StopResolutionException stopResolutionException) {
            }
            finally {
                this.parentSchemaContext = xPathSchemaContext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(XPathExpressionPath xPathExpressionPath) {
            Object object;
            if (xPathExpressionPath != null && (object = xPathExpressionPath.toString()) != null && ((String)object).endsWith("]")) {
                XPathModelImpl.this.myWasFunctionOrOperation = true;
            }
            object = this.parentSchemaContext;
            try {
                XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
                if (xPathExpression != null) {
                    xPathExpression.accept(this);
                }
                this.processLocationSteps(xPathExpressionPath.getSteps(), false);
            }
            catch (StopResolutionException stopResolutionException) {
            }
            finally {
                this.parentSchemaContext = object;
            }
        }

        public void visit(XPathVariableReference xPathVariableReference) {
            XPathCast xPathCast;
            ReferenceableSchemaComponent referenceableSchemaComponent = xPathVariableReference.getType();
            XPathModelImpl.this.myLastSchemaComponent = (SchemaComponent)referenceableSchemaComponent;
            if (referenceableSchemaComponent == null) {
                throw new StopResolutionException("It didn't manage to resolve a type of the variable: " + xPathVariableReference);
            }
            XPathSchemaContext xPathSchemaContext = new VariableSchemaContext(xPathVariableReference);
            if (XPathModelImpl.this.myXPathCastResolver != null && (xPathCast = XPathModelImpl.this.myXPathCastResolver.getCast(xPathSchemaContext)) != null) {
                CastSchemaContext castSchemaContext = new CastSchemaContext(xPathSchemaContext, xPathCast);
                xPathSchemaContext = castSchemaContext;
            }
            xPathVariableReference.setSchemaContext(xPathSchemaContext);
            this.parentSchemaContext = xPathSchemaContext;
        }

        public void visit(XPathCoreOperation xPathCoreOperation) {
            XPathModelImpl.this.myWasFunctionOrOperation = true;
            this.visitChildren(xPathCoreOperation);
            if (XPathModelImpl.this.mValidationContext != null && xPathCoreOperation.getOperationType() == CoreOperationType.OP_UNION) {
                XPathModelImpl.this.mValidationContext.addResultItem(XPathModelImpl.this.mRootXPathExpression, Validator.ResultType.WARNING, XPathProblem.RUNTIME_NOT_SUPPORT_OPERATION, CoreOperationType.OP_UNION.getMetadata().getName());
            }
        }

        public void visit(XPathCoreFunction xPathCoreFunction) {
            XPathModelImpl.this.myWasFunctionOrOperation = true;
            this.visitChildren(xPathCoreFunction);
        }

        public void visit(XPathExtensionFunction xPathExtensionFunction) {
            XPathModelImpl.this.myWasFunctionOrOperation = true;
            if (StubExtFunction.STUB_FUNC_NAME.equals(xPathExtensionFunction.getName())) {
                ++this.mStubCounter;
                return;
            }
            if (XPathModelImpl.this.mValidationContext != null) {
                XPathModelImpl.this.checkExtFunction(xPathExtensionFunction);
                if (XPathModelImpl.this.mExtFuncResolver != null) {
                    XPathModelImpl.this.mExtFuncResolver.validateFunction(xPathExtensionFunction, XPathModelImpl.this.mValidationContext);
                }
            }
            this.visitChildren(xPathExtensionFunction);
        }

        public XPathSchemaContext processLocationStep(LocationStep locationStep, boolean bl) {
            Object object;
            XPathPredicateExpression[] xPathPredicateExpressionArray;
            Object object2;
            block30: {
                StepNodeTest stepNodeTest;
                block31: {
                    block32: {
                        object2 = locationStep.getSchemaContext();
                        if (object2 != null) break block30;
                        xPathPredicateExpressionArray = locationStep.getNodeTest();
                        object = locationStep.getAxis();
                        if (!(xPathPredicateExpressionArray instanceof StepNodeNameTest)) break block31;
                        stepNodeTest = (StepNodeNameTest)xPathPredicateExpressionArray;
                        if (!((StepNodeNameTest)stepNodeTest).isWildcard()) break block32;
                        switch (1.$SwitchMap$org$netbeans$modules$xml$xpath$ext$XPathAxis[((Enum)object).ordinal()]) {
                            case 1: {
                                object2 = new WildcardSchemaContext(this.parentSchemaContext, XPathModelImpl.this, false, true);
                                break block30;
                            }
                            case 2: {
                                object2 = new WildcardSchemaContext(this.parentSchemaContext, XPathModelImpl.this, true, false);
                                break block30;
                            }
                            default: {
                                assert (false) : "Only the Attribute and Child axis is allowed with wildcard";
                                break block30;
                            }
                        }
                    }
                    block4 : switch (1.$SwitchMap$org$netbeans$modules$xml$xpath$ext$XPathAxis[((Enum)object).ordinal()]) {
                        case 1: 
                        case 2: {
                            int n = object == XPathAxis.ATTRIBUTE ? 1 : 0;
                            QName object3 = ((StepNodeNameTest)stepNodeTest).getNodeName();
                            Set set = XPathModelImpl.this.resolveChildComponents(this.parentSchemaContext, object3, n != 0, bl);
                            if (set != null) {
                                switch (set.size()) {
                                    case 0: {
                                        break block4;
                                    }
                                    case 1: {
                                        XPathSchemaContext.SchemaCompPair schemaCompPair = (XPathSchemaContext.SchemaCompPair)set.iterator().next();
                                        object2 = new SimpleSchemaContext(this.parentSchemaContext, schemaCompPair);
                                        break block4;
                                    }
                                }
                                object2 = new MultiCompSchemaContext(this.parentSchemaContext, set);
                                break;
                            }
                            break block30;
                        }
                        default: {
                            if (XPathModelImpl.this.mValidationContext != null) {
                                XPathModelImpl.this.mValidationContext.addResultItem(XPathModelImpl.this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.UNSUPPORTED_AXIS, object);
                            }
                            throw new StopResolutionException("Unsupported axis: " + object);
                        }
                    }
                    break block30;
                }
                if (xPathPredicateExpressionArray instanceof StepNodeTypeTest) {
                    stepNodeTest = (StepNodeTypeTest)xPathPredicateExpressionArray;
                    block11 : switch (((StepNodeTypeTest)stepNodeTest).getNodeType()) {
                        case NODETYPE_NODE: {
                            switch (1.$SwitchMap$org$netbeans$modules$xml$xpath$ext$XPathAxis[((Enum)object).ordinal()]) {
                                case 3: {
                                    object2 = this.parentSchemaContext;
                                    break block11;
                                }
                                case 4: {
                                    object2 = this.parentSchemaContext.getParentContext();
                                    if (object2 != null || XPathModelImpl.this.mValidationContext == null) break block11;
                                    XPathModelImpl.this.mValidationContext.addResultItem(XPathModelImpl.this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.ATTEMPT_GO_UPPER_THAN_ROOT, new Object[0]);
                                    break block11;
                                }
                                case 2: {
                                    object2 = new WildcardSchemaContext(this.parentSchemaContext, XPathModelImpl.this, true, true);
                                    break block11;
                                }
                            }
                            assert (false) : "The axis " + object + " isn't supported in such context";
                            break;
                        }
                        case NODETYPE_COMMENT: 
                        case NODETYPE_PI: 
                        case NODETYPE_TEXT: {
                            throw new StopResolutionException("Unsupported node type test: " + (Object)((Object)((StepNodeTypeTest)stepNodeTest).getNodeType()));
                        }
                    }
                }
            }
            if (object2 != null) {
                if (XPathModelImpl.this.myXPathCastResolver != null && (xPathPredicateExpressionArray = XPathModelImpl.this.myXPathCastResolver.getCast((XPathSchemaContext)object2)) != null) {
                    object2 = object = new CastSchemaContext((XPathSchemaContext)object2, (XPathCast)xPathPredicateExpressionArray);
                }
                locationStep.setSchemaContext((XPathSchemaContext)object2);
                xPathPredicateExpressionArray = locationStep.getPredicates();
                if (xPathPredicateExpressionArray != null) {
                    for (XPathPredicateExpression xPathPredicateExpression : xPathPredicateExpressionArray) {
                        this.parentSchemaContext = object2;
                        xPathPredicateExpression.setSchemaContext((XPathSchemaContext)object2);
                        xPathPredicateExpression.accept(this);
                    }
                }
            } else {
                throw new StopResolutionException("Didn't manage to resolve schema context for: " + locationStep);
            }
            this.parentSchemaContext = object2;
            return object2;
        }

        private void processLocationSteps(LocationStep[] locationStepArray, boolean bl) {
            LocationStep locationStep = null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                this.parentSchemaContext = null;
                bl3 = true;
            } else if (this.parentSchemaContext == null) {
                if (XPathModelImpl.this.mValidationContext != null) {
                    XPathModelImpl.this.mValidationContext.addResultItem(XPathModelImpl.this.getRootExpression(), Validator.ResultType.ERROR, XPathProblem.MISSING_PARENT_SCHEMA_CONTEXT, new Object[0]);
                }
                throw new StopResolutionException("A parent schema context must be specified to resolve a relative location path.");
            }
            try {
                for (LocationStep locationStep2 : locationStepArray) {
                    XPathSchemaContext xPathSchemaContext = this.processLocationStep(locationStep2, bl3);
                    if (!(xPathSchemaContext instanceof SimpleSchemaContext)) {
                        bl2 = true;
                    }
                    bl3 = false;
                    locationStep = locationStep2;
                }
            }
            catch (StopResolutionException stopResolutionException) {
                // empty catch block
            }
            if (locationStep != null) {
                this.postProcessLocationPath(locationStepArray, locationStep, bl2, bl);
            }
        }

        private void postProcessLocationPath(LocationStep[] locationStepArray, LocationStep locationStep, boolean bl, boolean bl2) {
            if (bl) {
                XPathSchemaContext xPathSchemaContext = locationStep.getSchemaContext();
                if (xPathSchemaContext == null) {
                    return;
                }
                xPathSchemaContext.setLastInChain(true);
                XPathSchemaContext object = xPathSchemaContext.getParentContext();
                if (object != null) {
                    Set<XPathSchemaContext.SchemaCompPair> set = xPathSchemaContext.getSchemaCompPairs();
                    XPathModelImpl.this.setUsedComponents(object, set);
                }
            }
            boolean bl3 = bl2;
            if (XPathModelImpl.this.mValidationContext != null) {
                for (LocationStep locationStep2 : locationStepArray) {
                    boolean bl4 = locationStep2 == locationStep;
                    XPathModelImpl.this.checkResolvedSchemaContext(locationStep2, bl3, bl4, this.mResourceCollector);
                    bl3 = false;
                    if (bl4) break;
                }
            }
        }

        public ResourceCollector getResourceCollector() {
            return this.mResourceCollector;
        }

        public int getStubCounter() {
            return this.mStubCounter;
        }
    }
}

