/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.incrdeploy;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.ShortCircuitProgressObject;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions.ViewLogAction;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DirectoryDeploymentFacade
extends IncrementalDeployment {
    Object inner = null;
    private File[] resourceDirs = null;
    private DeploymentManager dm;
    private Boolean issue2999Fixed = null;
    private static Map cache = new WeakHashMap();

    public static IncrementalDeployment get(DeploymentManager deploymentManager) {
        IncrementalDeployment incrementalDeployment = (IncrementalDeployment)cache.get(deploymentManager);
        if (null == incrementalDeployment) {
            incrementalDeployment = new DirectoryDeploymentFacade(deploymentManager);
            cache.put(deploymentManager, incrementalDeployment);
        }
        return incrementalDeployment;
    }

    private DirectoryDeploymentFacade(DeploymentManager deploymentManager) {
        try {
            this.setDeploymentManager(deploymentManager);
            Class[] classArray = new Class[]{DeploymentManager.class};
            SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
            ClassLoader classLoader = ServerLocationManager.getNetBeansAndServerClassLoader((File)sunDeploymentManagerInterface.getPlatformRoot());
            Constructor<?> constructor = classLoader.loadClass("org.netbeans.modules.j2ee.sun.bridge.DirectoryDeployment").getConstructor(classArray);
            Object[] objectArray = new Object[]{deploymentManager};
            this.inner = constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        if (null == deploymentManager) {
            throw new IllegalArgumentException("invalid null argumment");
        }
        if (!(deploymentManager instanceof SunDeploymentManagerInterface)) {
            throw new IllegalArgumentException("setDeploymentManager: Invalid manager type, expecting SunDeploymentManager and got " + deploymentManager.getClass().getName());
        }
        this.dm = deploymentManager;
        this.issue2999Fixed = null;
    }

    private void checkIssue2999(DeploymentManager deploymentManager) {
        SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
        if (!sunDeploymentManagerInterface.isLocal()) {
            this.issue2999Fixed = false;
            return;
        }
        this.issue2999Fixed = true;
        if (ServerLocationManager.getAppServerPlatformVersion((File)sunDeploymentManagerInterface.getPlatformRoot()) <= 910) {
            Target[] targetArray = deploymentManager.getTargets();
            TargetModuleID[] targetModuleIDArray = null;
            try {
                targetModuleIDArray = deploymentManager.getRunningModules(ModuleType.EAR, targetArray);
                if (targetModuleIDArray == null || targetModuleIDArray.length < 1) {
                    targetModuleIDArray = deploymentManager.getNonRunningModules(ModuleType.EAR, targetArray);
                }
                boolean bl = false;
                for (TargetModuleID targetModuleID : targetModuleIDArray) {
                    if (!targetModuleID.toString().startsWith("__JWSappclients")) continue;
                    bl = true;
                    TargetModuleID[] targetModuleIDArray2 = targetModuleID.getChildTargetModuleID();
                    if (null != targetModuleIDArray2 && targetModuleIDArray2.length >= 1) continue;
                    this.issue2999Fixed = false;
                }
                if (!bl) {
                    this.issue2999Fixed = false;
                }
            }
            catch (Exception exception) {
                this.issue2999Fixed = false;
            }
        }
    }

    public File getDirectoryForModule(TargetModuleID targetModuleID) {
        File file = null;
        if (null != this.inner) {
            file = ((IncrementalDeployment)this.inner).getDirectoryForModule(targetModuleID);
        }
        return file;
    }

    public String getModuleUrl(TargetModuleID targetModuleID) {
        String string = null;
        if (null != this.inner) {
            string = ((IncrementalDeployment)this.inner).getModuleUrl(targetModuleID);
        }
        return string;
    }

    public ProgressObject incrementalDeploy(TargetModuleID targetModuleID, AppChangeDescriptor appChangeDescriptor) {
        return this.incrementalDeploy(targetModuleID, appChangeDescriptor, true);
    }

    private ProgressObject incrementalDeploy(TargetModuleID targetModuleID, AppChangeDescriptor appChangeDescriptor, boolean bl) {
        if (this.resourceDirs != null && this.dm != null) {
            Utils.registerResources(this.resourceDirs, ((SunDeploymentManagerInterface)this.dm).getManagement());
        }
        if (null != this.dm && bl) {
            ViewLogAction.viewLog((SunDeploymentManagerInterface)this.dm);
        }
        if (appChangeDescriptor.manifestChanged() || appChangeDescriptor.descriptorChanged() || appChangeDescriptor.classesChanged() || appChangeDescriptor.ejbsChanged() || appChangeDescriptor.serverDescriptorChanged()) {
            return ((IncrementalDeployment)this.inner).incrementalDeploy(targetModuleID, appChangeDescriptor);
        }
        return new ShortCircuitProgressObject(CommandType.REDEPLOY, NbBundle.getMessage(ShortCircuitProgressObject.class, (String)"MESS_NO_DEPLOY_NECESSARY"), StateType.COMPLETED, new TargetModuleID[]{targetModuleID});
    }

    public File getDirectoryForNewApplication(String string, Target target, DeploymentConfiguration deploymentConfiguration) {
        if (deploymentConfiguration instanceof SunONEDeploymentConfiguration) {
            SunONEDeploymentConfiguration sunONEDeploymentConfiguration = (SunONEDeploymentConfiguration)deploymentConfiguration;
            sunONEDeploymentConfiguration.setDeploymentModuleName(string);
        }
        return null;
    }

    public ProgressObject initialDeploy(Target target, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration, File file) {
        if (this.resourceDirs != null && this.dm != null) {
            Utils.registerResources(this.resourceDirs, ((SunDeploymentManagerInterface)this.dm).getManagement());
        }
        if (null != this.dm) {
            ViewLogAction.viewLog((SunDeploymentManagerInterface)this.dm);
        }
        return ((IncrementalDeployment)this.inner).initialDeploy(target, j2eeModule, moduleConfiguration, file);
    }

    public boolean canFileDeploy(Target target, J2eeModule j2eeModule) {
        DeploymentManagerProperties deploymentManagerProperties;
        boolean bl = true;
        if (null == this.dm) {
            bl = false;
        }
        if (null == j2eeModule) {
            bl = false;
        } else {
            if (null == this.issue2999Fixed) {
                this.checkIssue2999(this.dm);
            }
            this.resourceDirs = Utils.getResourceDirs(j2eeModule);
            if (j2eeModule.getModuleType() == ModuleType.CAR) {
                bl = false;
            }
            if (bl && !this.issue2999Fixed.booleanValue()) {
                boolean bl2 = bl = j2eeModule.getModuleType() != ModuleType.EAR;
            }
            if (bl && j2eeModule.getModuleType() == ModuleType.EAR) {
                try {
                    deploymentManagerProperties = j2eeModule.getContentDirectory();
                    bl = this.noChildrenWithInitialUnderscores((FileObject)deploymentManagerProperties);
                }
                catch (IOException iOException) {
                    Logger.getLogger(DirectoryDeploymentFacade.class.getName()).log(Level.FINER, "", iOException);
                    bl = false;
                }
            }
            if (bl) {
                bl = ((SunDeploymentManagerInterface)this.dm).isLocal();
            }
        }
        deploymentManagerProperties = new DeploymentManagerProperties(this.dm);
        if (!deploymentManagerProperties.isDirectoryDeploymentPossible()) {
            return false;
        }
        return bl;
    }

    private boolean noChildrenWithInitialUnderscores(FileObject fileObject) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.getName().startsWith("_")) continue;
            return false;
        }
        return true;
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration) {
        return ((IncrementalDeployment)this.inner).getDirectoryForNewApplication(target, j2eeModule, moduleConfiguration);
    }

    public File getDirectoryForNewApplication(String string, Target target, ModuleConfiguration moduleConfiguration) {
        return super.getDirectoryForNewApplication(string, target, moduleConfiguration);
    }

    public File getDirectoryForNewModule(File file, String string, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration) {
        return ((IncrementalDeployment)this.inner).getDirectoryForNewModule(file, string, j2eeModule, moduleConfiguration);
    }

    public void notifyDeployment(TargetModuleID targetModuleID) {
        super.notifyDeployment(targetModuleID);
    }

    public ProgressObject deployOnSave(TargetModuleID targetModuleID, DeploymentChangeDescriptor deploymentChangeDescriptor) {
        return this.incrementalDeploy(targetModuleID, (AppChangeDescriptor)deploymentChangeDescriptor, false);
    }

    public boolean isDeployOnSaveSupported() {
        return true;
    }
}

