/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.ant.UserCancel;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class TranslateClassPath
extends Task {
    private String classpath;
    private String targetProperty;
    private boolean clean;

    public void setClasspath(String cp) {
        this.classpath = cp;
    }

    public void setTargetProperty(String tp) {
        this.targetProperty = tp;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("Classpath must be set.");
        }
        if (this.targetProperty == null) {
            throw new BuildException("Target property must be set.");
        }
        Project p = this.getProject();
        String translated = this.translate(this.classpath);
        p.setProperty(this.targetProperty, translated);
    }

    private String translate(String classpath) {
        StringBuilder cp = new StringBuilder();
        boolean first = true;
        for (String path : PropertyUtils.tokenizePath((String)classpath)) {
            File[] files = this.translateEntry(path);
            if (files.length == 0) continue;
            for (File f : files) {
                if (!first) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(f.getAbsolutePath());
                first = false;
            }
        }
        return cp.toString();
    }

    private File[] translateEntry(String path) throws BuildException {
        File entryFile = new File(path);
        try {
            URL entry = FileUtil.urlForArchiveOrDir((File)entryFile);
            SourceForBinaryQuery.Result2 r = SourceForBinaryQuery.findSourceRoots2((URL)entry);
            boolean appendEntry = false;
            if (r.preferSources() && r.getRoots().length > 0) {
                LinkedList<File> translated = new LinkedList<File>();
                for (FileObject source : r.getRoots()) {
                    Boolean bamiResult;
                    File sourceFile = FileUtil.toFile((FileObject)source);
                    if (sourceFile == null) {
                        this.log("Source URL: " + source.getURL().toExternalForm() + " cannot be translated to file, skipped", 1);
                        appendEntry = true;
                        continue;
                    }
                    Boolean bl = bamiResult = this.clean ? BuildArtifactMapperImpl.clean((URL)sourceFile.toURI().toURL()) : BuildArtifactMapperImpl.ensureBuilt((URL)sourceFile.toURI().toURL(), (boolean)true);
                    if (bamiResult == null) {
                        appendEntry = true;
                        continue;
                    }
                    if (!bamiResult.booleanValue()) {
                        throw new UserCancel();
                    }
                    for (URL binary : BinaryForSourceQuery.findBinaryRoots((URL)source.getURL()).getRoots()) {
                        File cache;
                        FileObject binaryFO = URLMapper.findFileObject((URL)binary);
                        File file = cache = binaryFO != null ? FileUtil.toFile((FileObject)binaryFO) : null;
                        if (cache != null) {
                            translated.add(cache);
                        }
                        if (sourceFile == null) continue;
                        translated.add(sourceFile);
                    }
                }
                if (appendEntry) {
                    translated.add(entryFile);
                }
                return translated.toArray(new File[0]);
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        return new File[]{entryFile};
    }
}

