/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.models.AbstractIDEBridge;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.WatchesModel;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.InitMessage;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DebugSession
implements Runnable {
    private static final int SLEEP_TIME = 100;
    private DebuggerOptions options;
    private Socket mySocket;
    private AtomicBoolean isStopped;
    private Thread mySessionThread;
    private List<DbgpCommand> myCommands;
    private AtomicReference<SessionId> mySessionId;
    private AtomicReference<DebuggerEngine> myEngine;
    private static final AtomicInteger myTransactionId = new AtomicInteger(0);
    private IDESessionBridge myBridge;
    private AtomicReference<String> myFileName;

    DebugSession(DebuggerOptions debuggerOptions) {
        this.init(null);
        this.options = debuggerOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block27: {
            WatchesModel watchesModel;
            VariablesModel variablesModel;
            ThreadsModel threadsModel;
            CallStackModel callStackModel;
            IDESessionBridge iDESessionBridge;
            this.setSessionThread(Thread.currentThread());
            boolean bl = false;
            List<DbgpCommand> list = this.myCommands;
            synchronized (list) {
                bl = this.myCommands.size() > 0;
            }
            while (this.continueDebugging()) {
                try {
                    this.sendCommands();
                    if (!this.continueDebugging()) continue;
                    this.receiveData();
                    this.sleepTillNewCommand();
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
            this.setSessionThread(null);
            try {
                try {
                    this.getSocket().close();
                }
                catch (IOException iOException) {
                    this.log(iOException);
                    Object var5_6 = null;
                    IDESessionBridge iDESessionBridge2 = this.getBridge();
                    if (iDESessionBridge2 != null) {
                        WatchesModel watchesModel2;
                        VariablesModel variablesModel2;
                        ThreadsModel threadsModel2;
                        CallStackModel callStackModel2;
                        iDESessionBridge2.setSuspended(false);
                        iDESessionBridge2.hideAnnotations();
                        BreakpointModel breakpointModel = iDESessionBridge2.getBreakpointModel();
                        if (breakpointModel != null) {
                            breakpointModel.setCurrentStack(null, this);
                        }
                        if ((callStackModel2 = iDESessionBridge2.getCallStackModel()) != null) {
                            callStackModel2.clearModel();
                        }
                        if ((threadsModel2 = iDESessionBridge2.getThreadsModel()) != null) {
                            threadsModel2.update();
                        }
                        if ((variablesModel2 = iDESessionBridge2.getVariablesModel()) != null) {
                            variablesModel2.clearModel();
                        }
                        if ((watchesModel2 = iDESessionBridge2.getWatchesModel()) != null) {
                            watchesModel2.clearModel();
                        }
                    }
                    StartActionProviderImpl.getInstance().removeSession(this);
                    return;
                }
                Object var5_5 = null;
                iDESessionBridge = this.getBridge();
                if (iDESessionBridge == null) break block27;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                IDESessionBridge iDESessionBridge3 = this.getBridge();
                if (iDESessionBridge3 != null) {
                    WatchesModel watchesModel3;
                    VariablesModel variablesModel3;
                    ThreadsModel threadsModel3;
                    CallStackModel callStackModel3;
                    iDESessionBridge3.setSuspended(false);
                    iDESessionBridge3.hideAnnotations();
                    BreakpointModel breakpointModel = iDESessionBridge3.getBreakpointModel();
                    if (breakpointModel != null) {
                        breakpointModel.setCurrentStack(null, this);
                    }
                    if ((callStackModel3 = iDESessionBridge3.getCallStackModel()) != null) {
                        callStackModel3.clearModel();
                    }
                    if ((threadsModel3 = iDESessionBridge3.getThreadsModel()) != null) {
                        threadsModel3.update();
                    }
                    if ((variablesModel3 = iDESessionBridge3.getVariablesModel()) != null) {
                        variablesModel3.clearModel();
                    }
                    if ((watchesModel3 = iDESessionBridge3.getWatchesModel()) != null) {
                        watchesModel3.clearModel();
                    }
                }
                StartActionProviderImpl.getInstance().removeSession(this);
                throw throwable;
            }
            iDESessionBridge.setSuspended(false);
            iDESessionBridge.hideAnnotations();
            BreakpointModel breakpointModel = iDESessionBridge.getBreakpointModel();
            if (breakpointModel != null) {
                breakpointModel.setCurrentStack(null, this);
            }
            if ((callStackModel = iDESessionBridge.getCallStackModel()) != null) {
                callStackModel.clearModel();
            }
            if ((threadsModel = iDESessionBridge.getThreadsModel()) != null) {
                threadsModel.update();
            }
            if ((variablesModel = iDESessionBridge.getVariablesModel()) != null) {
                variablesModel.clearModel();
            }
            if ((watchesModel = iDESessionBridge.getWatchesModel()) != null) {
                watchesModel.clearModel();
            }
        }
        StartActionProviderImpl.getInstance().removeSession(this);
    }

    private boolean continueDebugging() {
        return !this.isStopped.get() && this.mySocket != null && !this.mySocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandLater(DbgpCommand dbgpCommand) {
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (this.getSessionId() == null) {
                return;
            }
            if (this.getSessionThread() == null) {
                return;
            }
            this.addCommand(dbgpCommand);
        }
    }

    public DbgpResponse sendSynchronCommand(DbgpCommand dbgpCommand) {
        Thread thread = this.getSessionThread();
        if (thread == null) {
            return null;
        }
        Thread thread2 = Thread.currentThread();
        if (thread != thread2) {
            assert (thread != null);
            this.printing146558(thread2);
        }
        try {
            DbgpMessage dbgpMessage;
            dbgpCommand.send(this.getSocket().getOutputStream());
            if (dbgpCommand.wantAcknowledgment() && (dbgpMessage = this.receiveData(dbgpCommand)) instanceof DbgpResponse) {
                return (DbgpResponse)dbgpMessage;
            }
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printing146558(Thread thread) {
        Level level = Level.FINE;
        assert ((level = Level.WARNING) != null);
        IllegalStateException illegalStateException = new IllegalStateException("Method incorrect usage. It should be called in handler thread only. Called from thread: " + thread.getName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            illegalStateException.printStackTrace(new PrintStream(byteArrayOutputStream));
            Logger.getLogger(DebugSession.class.getName()).log(level, byteArrayOutputStream.toString());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public String getTransactionId() {
        return myTransactionId.getAndIncrement() + "";
    }

    public void start(Socket socket) {
        this.init(socket);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public void stop() {
        this.isStopped.set(true);
    }

    public void setId(InitMessage initMessage) {
        DebuggerEngine[] debuggerEngineArray;
        this.setSessionFile(initMessage.getFileUri());
        String string = initMessage.getSessionId();
        DebuggerEngine[] debuggerEngineArray2 = debuggerEngineArray = DebuggerManager.getDebuggerManager().getDebuggerEngines();
        int n = debuggerEngineArray2.length;
        for (int i = 0; i < n; ++i) {
            DebuggerEngine debuggerEngine = debuggerEngineArray2[i];
            SessionId sessionId = (SessionId)debuggerEngine.lookupFirst(null, SessionId.class);
            if (sessionId == null || !sessionId.getId().equals(string)) continue;
            this.mySessionId.set(sessionId);
            sessionId.setFileUri(initMessage.getFileUri());
            this.myEngine.set(debuggerEngine);
        }
        assert (this.myEngine.get() != null);
        for (DebuggerEngine debuggerEngine : debuggerEngineArray2 = DebuggerManager.getDebuggerManager().getSessions()) {
            SessionId sessionId = (SessionId)debuggerEngine.lookupFirst(null, SessionId.class);
            if (sessionId == null || !sessionId.getId().equals(string)) continue;
            StartActionProviderImpl.getInstance().attachDebugSession((Session)debuggerEngine, this);
        }
    }

    public SessionId getSessionId() {
        return this.mySessionId.get();
    }

    public IDESessionBridge getBridge() {
        return this.myBridge;
    }

    public String getFileName() {
        return this.myFileName.get();
    }

    private void init(Socket socket) {
        this.mySocket = socket;
        this.isStopped = new AtomicBoolean(false);
        this.myCommands = new LinkedList<DbgpCommand>();
        this.mySessionId = new AtomicReference();
        this.myBridge = new IDESessionBridge();
        this.myFileName = new AtomicReference();
        this.myEngine = new AtomicReference();
    }

    private void setSessionFile(String string) {
        this.myFileName.set(string);
    }

    private void sleepTillNewCommand() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void setSessionThread(Thread thread) {
        this.mySessionThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommands() throws IOException {
        ArrayList<DbgpCommand> arrayList;
        List<DbgpCommand> list = this.myCommands;
        synchronized (list) {
            arrayList = new ArrayList<DbgpCommand>(this.myCommands);
            this.myCommands.clear();
        }
        for (DbgpCommand dbgpCommand : arrayList) {
            if (!this.continueDebugging()) continue;
            try {
                dbgpCommand.send(this.getSocket().getOutputStream());
                if (!this.continueDebugging() || !dbgpCommand.wantAcknowledgment()) continue;
                this.receiveData(dbgpCommand);
            }
            catch (SocketException socketException) {
                Logger.getLogger(DebugSession.class.getName()).log(Level.INFO, null, socketException);
                Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
                SessionId sessionId = this.getSessionId();
                for (Session session : sessionArray) {
                    SessionId sessionId2 = (SessionId)session.lookupFirst(null, SessionId.class);
                    if (sessionId2 == null || !sessionId2.getId().equals(sessionId.getId())) continue;
                    StartActionProviderImpl.getInstance().stop(session);
                }
                this.warnUserInCaseOfSocketException();
            }
        }
    }

    private void warnUserInCaseOfSocketException() {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(DebugSession.class, (String)"MSG_SocketError"), NbBundle.getMessage(DebugSession.class, (String)"MSG_SocketErrorTitle"), 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(DbgpCommand dbgpCommand) {
        List<DbgpCommand> list = this.myCommands;
        synchronized (list) {
            this.myCommands.add(dbgpCommand);
        }
    }

    private synchronized Thread getSessionThread() {
        return this.mySessionThread;
    }

    private void receiveData() throws IOException {
        this.receiveData(null);
    }

    private DbgpMessage receiveData(DbgpCommand dbgpCommand) throws IOException {
        if (dbgpCommand != null || this.getSocket().getInputStream().available() > 0) {
            DbgpMessage dbgpMessage = DbgpMessage.create(this.getSocket().getInputStream());
            this.handleMessage(dbgpCommand, dbgpMessage);
            return dbgpMessage;
        }
        return null;
    }

    private void handleMessage(DbgpCommand dbgpCommand, DbgpMessage dbgpMessage) throws IOException {
        DbgpResponse dbgpResponse;
        String string;
        if (dbgpMessage == null) {
            return;
        }
        if (dbgpCommand == null) {
            dbgpMessage.process(this, null);
            return;
        }
        boolean bl = false;
        if (dbgpMessage instanceof DbgpResponse && (string = (dbgpResponse = (DbgpResponse)dbgpMessage).getTransactionId()).equals(dbgpCommand.getTransactionId())) {
            bl = true;
            dbgpMessage.process(this, dbgpCommand);
        }
        if (!bl) {
            dbgpMessage.process(this, null);
            this.receiveData(dbgpCommand);
        }
    }

    private Socket getSocket() {
        return this.mySocket;
    }

    private void log(IOException iOException) {
        Logger.getLogger(DebugSession.class.getName()).log(Level.SEVERE, null, iOException);
    }

    public DebuggerOptions getOptions() {
        return this.options;
    }

    public class IDESessionBridge
    extends AbstractIDEBridge {
        protected DebuggerEngine getEngine() {
            return (DebuggerEngine)DebugSession.this.myEngine.get();
        }

        protected DebugSession getDebugSession() {
            return DebugSession.this;
        }
    }
}

