/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.jboss;

import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.jboss.AbstractJBossIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.jboss.JBossIntegrationPanelUI;
import org.openide.util.HelpCtx;

public class JBossIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "JBossIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("JBossIntegrationPanel.HelpCtx");
    private JBossIntegrationPanelUI panel = null;
    private Model model = new Model();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        String string = this.getContext().getAttachSettings().getHostOS();
        ValidationResult validationResult = ((AbstractJBossIntegrationProvider)this.getContext().getIntegrationProvider()).validateInstallation(string, this.model.getJbossInstall());
        if (!validationResult.isValid()) {
            this.model.setJbossInstallHint(validationResult.getMessage());
        } else {
            this.model.setJbossInstallHint("");
        }
        return validationResult.isValid() && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return false;
    }

    public boolean canNext(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    public void onEnter(AttachWizardContext attachWizardContext) {
        this.model.setJbossInstall(((AbstractJBossIntegrationProvider)attachWizardContext.getIntegrationProvider()).getInstallationPath());
        String string = ((AbstractJBossIntegrationProvider)attachWizardContext.getIntegrationProvider()).getTargetJava();
        List list = TargetPlatform.getPlatformList((boolean)false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetPlatform targetPlatform = (TargetPlatform)iterator.next();
            if (!targetPlatform.equals((Object)string)) continue;
            this.model.setSelectedPlatform(targetPlatform);
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext attachWizardContext) {
        AbstractJBossIntegrationProvider abstractJBossIntegrationProvider = (AbstractJBossIntegrationProvider)this.getContext().getIntegrationProvider();
        boolean bl = false;
        if (!abstractJBossIntegrationProvider.getInstallationPath().equals(this.model.getJbossInstall())) {
            bl = true;
        } else if (abstractJBossIntegrationProvider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !abstractJBossIntegrationProvider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            bl = true;
        }
        if (bl) {
            attachWizardContext.setConfigChanged();
        }
        abstractJBossIntegrationProvider.setInstallationPath(this.model.getJbossInstall());
        abstractJBossIntegrationProvider.setTargetPlatform(this.model.getSelectedPlatform());
    }

    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new JBossIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private String jbossInstall = "";
        private String jbossInstallHint = "";
        private TargetPlatform javaPlatform;
        private TargetPlatform.TargetPlatformFilter platformFilter = new TargetPlatform.TargetPlatformFilter(){

            public boolean isSupported(TargetPlatform targetPlatform) {
                AttachSettings attachSettings = JBossIntegrationPanel.this.getContext().getAttachSettings();
                TargetPlatformEnum targetPlatformEnum = targetPlatform.getAsEnum();
                if (!attachSettings.isDirect()) {
                    if (attachSettings.isDynamic16()) {
                        if (!targetPlatformEnum.equals((Object)TargetPlatformEnum.JDK6) && !targetPlatformEnum.equals((Object)TargetPlatformEnum.JDK7)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return JBossIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(targetPlatform.getAsEnum(), attachSettings);
            }
        };

        Model() {
        }

        public void setJbossInstall(String string) {
            this.jbossInstall = string;
            JBossIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getJbossInstall() {
            return this.jbossInstall;
        }

        public void setJbossInstallHint(String string) {
            this.jbossInstallHint = string;
        }

        public String getJbossInstallHint() {
            return this.jbossInstallHint;
        }

        public TargetPlatform.TargetPlatformFilter getPlatformFilter() {
            return this.platformFilter;
        }

        public void setSelectedPlatform(TargetPlatform targetPlatform) {
            this.javaPlatform = targetPlatform;
            JBossIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public TargetPlatform getSelectedPlatform() {
            return this.javaPlatform;
        }
    }
}

