/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BasePropertiesPanel
extends JPanel {
    MySQLOptions options = MySQLOptions.getDefault();
    DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }
    };
    private JCheckBox chkSavePassword;
    private JLabel labelHost;
    private JLabel labelPassword;
    private JLabel labelPort;
    private JLabel labelUser;
    private JLabel messageLabel;
    private JTextField txtHost;
    private JPasswordField txtPassword;
    private JTextField txtPort;
    private JTextField txtUser;

    public void validatePanel() {
        if (this.descriptor == null) {
            return;
        }
        String string = null;
        if (this.getHost() == null || this.getHost().length() == 0) {
            string = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyHost");
        }
        if (this.getUser() == null || this.getUser().length() == 0) {
            string = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyUser");
        }
        if (this.getPort() != null && this.getPort().length() > 0) {
            try {
                Integer.valueOf(this.getPort());
            }
            catch (NumberFormatException numberFormatException) {
                string = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_InvalidPortNumber");
            }
        }
        if (string != null) {
            this.messageLabel.setText(string);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    public BasePropertiesPanel(DatabaseServer databaseServer) {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.txtUser.getDocument().addDocumentListener(this.docListener);
        this.txtHost.getDocument().addDocumentListener(this.docListener);
        this.txtPort.getDocument().addDocumentListener(this.docListener);
        String string = databaseServer.getUser();
        if (string == null || string.equals("")) {
            string = MySQLOptions.getDefaultAdminUser();
        }
        this.txtUser.setText(string);
        String string2 = databaseServer.getHost();
        if (string2 == null || string2.equals("")) {
            string2 = MySQLOptions.getDefaultHost();
        }
        this.txtHost.setText(string2);
        String string3 = databaseServer.getPort();
        if (string3 == null || string3.equals("")) {
            string3 = MySQLOptions.getDefaultPort();
        }
        this.txtPort.setText(string3);
        if (databaseServer.isSavePassword()) {
            this.txtPassword.setText(databaseServer.getPassword());
        }
        this.chkSavePassword.setSelected(databaseServer.isSavePassword());
    }

    String getHost() {
        return this.txtHost.getText().trim();
    }

    String getPassword() {
        return new String(this.txtPassword.getPassword()).trim();
    }

    String getPort() {
        return this.txtPort.getText().trim();
    }

    String getUser() {
        return this.txtUser.getText().trim();
    }

    boolean getSavePassword() {
        return this.chkSavePassword.isSelected();
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validatePanel();
    }

    private void initComponents() {
        this.chkSavePassword = new JCheckBox();
        this.messageLabel = new JLabel();
        this.txtHost = new JTextField();
        this.labelHost = new JLabel();
        this.labelPort = new JLabel();
        this.txtPort = new JTextField();
        this.labelUser = new JLabel();
        this.txtUser = new JTextField();
        this.labelPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.setAutoscrolls(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSavePassword, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.text"));
        this.chkSavePassword.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.AccessibleContext.accessibleDescription"));
        this.chkSavePassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasePropertiesPanel.this.chkSavePasswordActionPerformed(actionEvent);
            }
        });
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.messageLabel.text"));
        this.txtHost.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.text"));
        this.txtHost.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.AccessibleContext.accessibleDescription"));
        this.labelHost.setLabelFor(this.txtHost);
        Mnemonics.setLocalizedText((JLabel)this.labelHost, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.labelHost.text"));
        this.labelPort.setLabelFor(this.txtPort);
        Mnemonics.setLocalizedText((JLabel)this.labelPort, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.labelPort.text"));
        this.txtPort.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.text"));
        this.txtPort.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.AccessibleContext.accessibleDescription"));
        this.labelUser.setLabelFor(this.txtUser);
        Mnemonics.setLocalizedText((JLabel)this.labelUser, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.labelUser.text"));
        this.txtUser.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.text"));
        this.txtUser.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.AccessibleContext.accessibleDescription"));
        this.labelPassword.setLabelFor(this.txtPassword);
        Mnemonics.setLocalizedText((JLabel)this.labelPassword, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.labelPassword.text"));
        this.txtPassword.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPassword.text"));
        this.txtPassword.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPassword.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.labelHost, -2, 181, -2)).add(1, (GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.labelPort, -2, 181, -2)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.labelPassword, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelUser, -1, 181, Short.MAX_VALUE))))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.txtHost, -1, 291, Short.MAX_VALUE).add(1, (Component)this.txtPassword, -1, 291, Short.MAX_VALUE).add(1, (Component)this.txtPort, -1, 291, Short.MAX_VALUE).add(1, (Component)this.txtUser, -1, 291, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(50, 50, 50).add((Component)this.chkSavePassword)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel, -1, 482, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelHost).add((Component)this.txtHost, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelPort).add((Component)this.txtPort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelUser).add((Component)this.txtUser, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelPassword).add((Component)this.txtPassword, -2, -1, -2)).addPreferredGap(0).add((Component)this.chkSavePassword).addPreferredGap(1).add((Component)this.messageLabel).addContainerGap(36, Short.MAX_VALUE)));
        this.chkSavePassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.AccessibleContext.accessibleDescription"));
    }

    private void chkSavePasswordActionPerformed(ActionEvent actionEvent) {
    }
}

