/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.openide.util.NbBundle;

public class UnknownFunctionRule
extends PHPRule {
    private static final Collection<String> IGNORED = new TreeSet<String>(Arrays.asList("die", "empty", "eval", "exit", "isset", "print", "unset"));

    public void visit(FunctionInvocation functionInvocation) {
        Collection<IndexedFunction> collection;
        String string;
        ASTNode aSTNode = this.context.path.get(0);
        if (!(aSTNode instanceof MethodInvocation || aSTNode instanceof StaticMethodInvocation || IGNORED.contains((string = CodeUtils.extractFunctionName(functionInvocation)).toLowerCase()) || (collection = this.context.index.getFunctions((PHPParseResult)this.context.parserResult, string, NameKind.EXACT_NAME)).size() != 0)) {
            FunctionName functionName = functionInvocation.getFunctionName();
            OffsetRange offsetRange = new OffsetRange(functionName.getStartOffset(), functionName.getEndOffset());
            Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.compilationInfo.getFileObject(), offsetRange, null, 500);
            this.addResult(hint);
        }
        super.visit(functionInvocation);
    }

    public String getId() {
        return "unknown.function";
    }

    public String getDescription() {
        return NbBundle.getMessage(UnknownFunctionRule.class, (String)"UnknownFunctionDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UnknownFunctionRule.class, (String)"UnknownFunctionDispName");
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean getDefaultEnabled() {
        return false;
    }
}

