/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesFinderImpl
implements OccurrencesFinder {
    private int offset;
    private Map<OffsetRange, ColoringAttributes> range2Attribs;

    public void setCaretPosition(int n) {
        this.offset = n;
        this.range2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void cancel() {
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        for (OffsetRange offsetRange : OccurrencesFinderImpl.compute(compilationInfo, this.offset)) {
            this.range2Attribs.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
        }
    }

    static Collection<OffsetRange> compute(CompilationInfo compilationInfo, int n) {
        Object object;
        SemiAttribute semiAttribute;
        LinkedList<OffsetRange> linkedList = new LinkedList<OffsetRange>();
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
        final SemiAttribute.AttributedElement attributedElement = NavUtils.findElement(compilationInfo, list, n, semiAttribute = SemiAttribute.semiAttribute(compilationInfo));
        if (attributedElement == null) {
            return linkedList;
        }
        Object object4 = null;
        Collections.reverse(list);
        for (ASTNode object32 : list) {
            if (!(object32 instanceof Identifier) || (object = (Identifier)object32) == null) continue;
            String string = ((Identifier)object).getName();
            if (string.equals("self")) {
                return linkedList;
            }
            if (string.equals("parent")) {
                return linkedList;
            }
            if (string.equals("this")) {
                return linkedList;
            }
            object4 = object;
            break;
        }
        Iterator<ASTNode> iterator = object4;
        final LinkedList linkedList2 = new LinkedList();
        object = new LinkedList();
        new DefaultVisitor((List)object){
            private String clsName = null;
            private String superClsName = null;
            final /* synthetic */ List val$memberDeclaration;
            {
                this.val$memberDeclaration = list2;
            }

            public void visit(StaticMethodInvocation staticMethodInvocation) {
                StaticMethodInvocation staticMethodInvocation2 = staticMethodInvocation;
                Identifier identifier = staticMethodInvocation2.getClassName();
                if (!identifier.getName().equals("self") && !identifier.getName().equals("parent") && attributedElement == semiAttribute.getElement(identifier)) {
                    linkedList2.add(identifier);
                }
                super.visit(staticMethodInvocation);
            }

            public void visit(StaticFieldAccess staticFieldAccess) {
                StaticFieldAccess staticFieldAccess2 = staticFieldAccess;
                Identifier identifier = staticFieldAccess2.getClassName();
                if (!identifier.getName().equals("self") && !identifier.getName().equals("parent") && attributedElement == semiAttribute.getElement(identifier)) {
                    linkedList2.add(identifier);
                }
                super.visit(staticFieldAccess);
            }

            public void visit(StaticConstantAccess staticConstantAccess) {
                boolean bl = false;
                Identifier identifier = staticConstantAccess.getClassName();
                String string = identifier.getName().equals("self") ? this.clsName : (identifier.getName().equals("parent") ? this.superClsName : staticConstantAccess.getClassName().getName());
                if (attributedElement instanceof SemiAttribute.ClassMemberElement) {
                    SemiAttribute.ClassMemberElement classMemberElement = (SemiAttribute.ClassMemberElement)attributedElement;
                    String string2 = staticConstantAccess.getConstant().getName();
                    Identifier identifier2 = staticConstantAccess.getConstant();
                    if (string != null && classMemberElement.getClassName().equals(string) && classMemberElement.getName().equals(string2)) {
                        linkedList2.add(identifier2);
                        bl = true;
                    }
                }
                if (!bl) {
                    super.visit(staticConstantAccess);
                }
            }

            public void visit(MethodDeclaration methodDeclaration) {
                boolean bl = false;
                if (attributedElement instanceof SemiAttribute.ClassMemberElement) {
                    SemiAttribute.ClassMemberElement classMemberElement = (SemiAttribute.ClassMemberElement)attributedElement;
                    String string = CodeUtils.extractMethodName(methodDeclaration);
                    Identifier identifier = methodDeclaration.getFunction().getFunctionName();
                    if (this.clsName != null && classMemberElement.getClassName().equals(this.clsName) && classMemberElement.getName().equals(string)) {
                        this.val$memberDeclaration.add(identifier);
                        linkedList2.add(identifier);
                        bl = true;
                    }
                    for (SemiAttribute.ClassElement classElement = classMemberElement.getClassElement().getSuperClass(); !bl && classElement != null; classElement = classElement.getSuperClass()) {
                        if (classElement == null || this.clsName == null || !classElement.getName().equals(this.clsName) || !classMemberElement.getName().equals(string)) continue;
                        this.val$memberDeclaration.add(0, identifier);
                        linkedList2.add(identifier);
                        bl = true;
                    }
                }
                if (!bl) {
                    super.visit(methodDeclaration);
                }
            }

            public void visit(SingleFieldDeclaration singleFieldDeclaration) {
                boolean bl = false;
                if (attributedElement instanceof SemiAttribute.ClassMemberElement) {
                    SemiAttribute.ClassMemberElement classMemberElement = (SemiAttribute.ClassMemberElement)attributedElement;
                    Variable variable = singleFieldDeclaration.getName();
                    String string = CodeUtils.extractVariableName(variable);
                    if (string.startsWith("$")) {
                        string = string.substring(1);
                    }
                    if (this.clsName != null && classMemberElement.getClassName().equals(this.clsName) && classMemberElement.getName().equals(string)) {
                        this.val$memberDeclaration.add(variable);
                        linkedList2.add(variable);
                        bl = true;
                    }
                    for (SemiAttribute.ClassElement classElement = classMemberElement.getClassElement().getSuperClass(); !bl && classElement != null; classElement = classElement.getSuperClass()) {
                        if (classElement == null || this.clsName == null || !classElement.getName().equals(this.clsName) || !classMemberElement.getName().equals(string)) continue;
                        this.val$memberDeclaration.add(0, variable);
                        linkedList2.add(variable);
                        bl = true;
                    }
                }
                if (!bl) {
                    super.visit(singleFieldDeclaration);
                }
            }

            public void visit(FunctionDeclaration functionDeclaration) {
                if (!(attributedElement instanceof SemiAttribute.ClassMemberElement) && attributedElement == semiAttribute.getElement(functionDeclaration)) {
                    linkedList2.add(functionDeclaration.getFunctionName());
                }
                super.visit(functionDeclaration);
            }

            public void visit(InterfaceDeclaration interfaceDeclaration) {
                if (attributedElement == semiAttribute.getElement(interfaceDeclaration)) {
                    linkedList2.add(interfaceDeclaration.getName());
                } else {
                    List<Identifier> list = interfaceDeclaration.getInterfaes();
                    for (Identifier identifier : list) {
                        if (attributedElement != semiAttribute.getElement(identifier)) continue;
                        linkedList2.add(identifier);
                        break;
                    }
                }
                super.visit(interfaceDeclaration);
            }

            public void visit(ClassDeclaration classDeclaration) {
                Identifier identifier = classDeclaration.getSuperClass();
                if (attributedElement == semiAttribute.getElement(classDeclaration)) {
                    linkedList2.add(classDeclaration.getName());
                } else if (attributedElement == semiAttribute.getElement(identifier)) {
                    linkedList2.add(identifier);
                } else {
                    List<Identifier> list = classDeclaration.getInterfaes();
                    for (Identifier identifier2 : list) {
                        if (attributedElement != semiAttribute.getElement(identifier2)) continue;
                        linkedList2.add(identifier2);
                        break;
                    }
                }
                this.clsName = CodeUtils.extractClassName(classDeclaration);
                this.superClsName = CodeUtils.extractSuperClassName(classDeclaration);
                super.visit(classDeclaration);
                while (this.val$memberDeclaration.size() > 1) {
                    linkedList2.remove(this.val$memberDeclaration.remove(0));
                }
            }

            public void visit(FormalParameter formalParameter) {
                String string;
                Identifier identifier = formalParameter.getParameterType();
                if (identifier != null && (string = identifier.getName()) != null && attributedElement == semiAttribute.getElement(identifier)) {
                    linkedList2.add(identifier);
                }
                super.visit(formalParameter);
            }

            public void visit(InstanceOfExpression instanceOfExpression) {
                String string;
                ClassName className = instanceOfExpression.getClassName();
                Expression expression = className != null ? className.getName() : null;
                String string2 = string = expression instanceof Identifier ? ((Identifier)expression).getName() : null;
                if (string != null && attributedElement == semiAttribute.getElement(expression)) {
                    linkedList2.add(expression);
                }
                super.visit(instanceOfExpression);
            }

            public void visit(CatchClause catchClause) {
                String string;
                Identifier identifier = catchClause.getClassName();
                if (identifier != null && (string = identifier.getName()) != null && attributedElement == semiAttribute.getElement(identifier)) {
                    linkedList2.add(identifier);
                }
                super.visit(catchClause);
            }

            public void visit(FunctionInvocation functionInvocation) {
                if (attributedElement == semiAttribute.getElement(functionInvocation)) {
                    linkedList2.add(functionInvocation.getFunctionName());
                }
                super.visit(functionInvocation);
            }

            public void visit(Variable variable) {
                if (!(variable instanceof ArrayAccess)) {
                    if (attributedElement == semiAttribute.getElement(variable)) {
                        linkedList2.add(variable);
                    }
                    super.visit(variable);
                }
            }

            public void visit(ArrayAccess arrayAccess) {
                if (attributedElement == semiAttribute.getElement(arrayAccess)) {
                    String string;
                    VariableBase variableBase = arrayAccess.getName();
                    String string2 = string = variableBase instanceof Variable ? CodeUtils.extractVariableName((Variable)variableBase) : null;
                    if (attributedElement.getName().equals(string)) {
                        linkedList2.add(variableBase);
                        return;
                    }
                } else {
                    Expression expression = arrayAccess.getIndex();
                    if (expression != null && !(expression instanceof Scalar) && attributedElement == semiAttribute.getElement(expression)) {
                        linkedList2.add(expression);
                        return;
                    }
                }
                super.visit(arrayAccess);
            }

            public void visit(Scalar scalar) {
                if (attributedElement == semiAttribute.getElement(scalar)) {
                    linkedList2.add(scalar);
                }
                super.visit(scalar);
            }

            public void visit(ClassInstanceCreation classInstanceCreation) {
                if (attributedElement == semiAttribute.getElement(classInstanceCreation)) {
                    linkedList2.add(classInstanceCreation.getClassName());
                }
                super.visit(classInstanceCreation);
            }
        }.scan(Utils.getRoot(compilationInfo));
        for (ASTNode aSTNode : linkedList2) {
            OffsetRange offsetRange = OccurrencesFinderImpl.forNode(aSTNode, attributedElement.getKind());
            if (offsetRange == null) continue;
            linkedList.add(offsetRange);
        }
        return linkedList;
    }

    private static OffsetRange forNode(ASTNode aSTNode, SemiAttribute.AttributedElement.Kind kind) {
        OffsetRange offsetRange = null;
        if (aSTNode instanceof Scalar && ((Scalar)aSTNode).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(((Scalar)aSTNode).getStringValue())) {
            offsetRange = new OffsetRange(aSTNode.getStartOffset() + 1, aSTNode.getEndOffset() - 1);
        } else if (aSTNode instanceof Variable && ((Variable)aSTNode).isDollared()) {
            offsetRange = new OffsetRange(aSTNode.getStartOffset() + 1, aSTNode.getEndOffset());
        } else if (aSTNode instanceof ArrayAccess && kind == SemiAttribute.AttributedElement.Kind.VARIABLE) {
            ArrayAccess arrayAccess = (ArrayAccess)aSTNode;
            Expression expression = arrayAccess.getIndex();
            offsetRange = OccurrencesFinderImpl.forNode(expression, kind);
        } else if (aSTNode != null) {
            offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        }
        return offsetRange;
    }
}

