/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocPropertyTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndexer
implements Indexer {
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final FileSystem MEM_FS = FileUtil.createMemoryFileSystem();
    private static final Map<String, FileObject> EXT2FO = new HashMap<String, FileObject>();
    private static final Collection<String> INDEXABLE_EXTENSIONS = Arrays.asList("php", "php3", "php4", "php5", "phtml", "inc");
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    static final String FIELD_IFACE = "iface";
    static final String FIELD_CONST = "const";
    static final String FIELD_CLASS_CONST = "clz.const";
    static final String FIELD_FIELD = "field";
    static final String FIELD_METHOD = "method";
    static final String FIELD_INCLUDE = "include";
    static final String FIELD_IDENTIFIER = "identifier_used";
    static final String FIELD_IDENTIFIER_DECLARATION = "identifier_declaration";
    static final String FIELD_VAR = "var";
    static final String FIELD_TOP_LEVEL = "top";
    private static FileObject preindexedDb;

    public boolean isIndexable(ParserFile parserFile) {
        if (INDEXABLE_EXTENSIONS.contains(parserFile.getExtension().toLowerCase())) {
            return true;
        }
        return this.isPhpFile(parserFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPhpFile(ParserFile parserFile) {
        FileObject fileObject = null;
        String string = parserFile.getExtension();
        Map<String, FileObject> map = EXT2FO;
        synchronized (map) {
            FileObject fileObject2 = fileObject = string != null ? EXT2FO.get(string) : null;
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createData((FileObject)MEM_FS.getRoot(), (String)parserFile.getNameExt());
                    if (string != null && fileObject != null) {
                        EXT2FO.put(string, fileObject);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        assert (fileObject != null);
        return "text/x-php5".equals(FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{"text/x-php5"}));
    }

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return PHPIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    public List<IndexDocument> index(ParserResult parserResult, IndexDocumentFactory indexDocumentFactory) throws IOException {
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        if (pHPParseResult.getProgram() == null) {
            return Collections.emptyList();
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(pHPParseResult, indexDocumentFactory);
        treeAnalyzer.analyze();
        return treeAnalyzer.getDocuments();
    }

    public String getIndexVersion() {
        return "0.5.6";
    }

    public String getIndexerName() {
        return "php";
    }

    static boolean isQuotedString(String string) {
        if (string.length() < 2) {
            return false;
        }
        char c = string.charAt(0);
        return c == string.charAt(string.length() - 1) && c == '\'' || c == '\"';
    }

    static String dequote(String string) {
        assert (PHPIndexer.isQuotedString(string));
        return string.substring(1, string.length() - 1);
    }

    public File getPreindexedData() {
        return null;
    }

    public static void setPreindexedDb(FileObject fileObject) {
        preindexedDb = fileObject;
    }

    public FileObject getPreindexedDb() {
        return null;
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("jsstubs") == -1 && string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final ParserFile file;
        private String url;
        private final PHPParseResult result;
        private Program root;
        private IndexDocumentFactory factory;
        private List<IndexDocument> documents = new ArrayList<IndexDocument>();

        private TreeAnalyzer(PHPParseResult pHPParseResult, IndexDocumentFactory indexDocumentFactory) {
            this.result = pHPParseResult;
            this.file = pHPParseResult.getFile();
            this.factory = indexDocumentFactory;
            try {
                this.url = this.file.getFile().toURI().toURL().toExternalForm();
                this.url = PHPIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        private void indexFieldsDeclaration(FieldsDeclaration fieldsDeclaration, IndexDocument indexDocument) {
            for (SingleFieldDeclaration singleFieldDeclaration : fieldsDeclaration.getFields()) {
                if (!(singleFieldDeclaration.getName().getName() instanceof Identifier)) continue;
                Identifier identifier = (Identifier)singleFieldDeclaration.getName().getName();
                String string = this.getFieldTypeFromPHPDoc(singleFieldDeclaration);
                String string2 = this.createFieldsDeclarationRecord(identifier.getName(), string, fieldsDeclaration.getModifier(), singleFieldDeclaration.getStartOffset());
                indexDocument.addPair(PHPIndexer.FIELD_FIELD, string2, false);
            }
        }

        private String createFieldsDeclarationRecord(String string, String string2, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string + ";");
            stringBuilder.append(n2 + ";");
            stringBuilder.append(n + ";");
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        public void analyze() throws IOException {
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            this.root = this.result.getProgram();
            IndexerVisitor indexerVisitor = new IndexerVisitor(this.documents, indexDocument);
            this.root.accept(indexerVisitor);
            indexerVisitor.addIdentifierPairs();
            String string = null;
            try {
                string = this.result.getFile().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            assert (string.startsWith("file:"));
            String string2 = string.substring("file:".length());
            StringBuilder stringBuilder = new StringBuilder();
            for (Statement statement : this.root.getStatements()) {
                String string3;
                Expression expression;
                Expression expression2;
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                if (expressionStatement.getExpression() instanceof Assignment) {
                    expression2 = (Assignment)expressionStatement.getExpression();
                    this.indexVarsInAssignment((Assignment)expression2, indexDocument);
                }
                if (!(expressionStatement.getExpression() instanceof Include)) continue;
                expression2 = (Include)expressionStatement.getExpression();
                Expression expression3 = ((Include)expression2).getExpression();
                if (expression3 instanceof ParenthesisExpression) {
                    expression = (ParenthesisExpression)((Include)expression2).getExpression();
                    expression3 = ((ParenthesisExpression)expression).getExpression();
                }
                if (!(expression3 instanceof Scalar) || !PHPIndexer.isQuotedString(string3 = ((Scalar)(expression = (Scalar)expression3)).getStringValue())) continue;
                String string4 = PHPIndex.resolveRelativeURL(string2, PHPIndexer.dequote(string3));
                stringBuilder.append(string4 + ";");
            }
            indexDocument.addPair(PHPIndexer.FIELD_INCLUDE, stringBuilder.toString(), false);
        }

        private void indexClass(ClassDeclaration classDeclaration, IndexDocument indexDocument) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(classDeclaration.getName().getName().toLowerCase() + ";");
            stringBuilder.append(classDeclaration.getName().getName() + ";");
            stringBuilder.append(classDeclaration.getStartOffset() + ";");
            String string = "";
            if (classDeclaration.getSuperClass() instanceof Identifier) {
                Iterator<PHPDocPropertyTag> iterator = classDeclaration.getSuperClass();
                string = ((Identifier)((Object)iterator)).getName();
            }
            stringBuilder.append(string + ";");
            indexDocument.addPair(PHPIndexer.FIELD_CLASS, stringBuilder.toString(), true);
            indexDocument.addPair(PHPIndexer.FIELD_TOP_LEVEL, classDeclaration.getName().getName().toLowerCase(), true);
            for (Statement aSTNode : classDeclaration.getBody().getStatements()) {
                if (aSTNode instanceof MethodDeclaration) {
                    object = (MethodDeclaration)aSTNode;
                    this.indexMethod(((MethodDeclaration)object).getFunction(), ((BodyDeclaration)object).getModifier(), indexDocument);
                    continue;
                }
                if (aSTNode instanceof FieldsDeclaration) {
                    object = (FieldsDeclaration)aSTNode;
                    this.indexFieldsDeclaration((FieldsDeclaration)object, indexDocument);
                    continue;
                }
                if (!(aSTNode instanceof ClassConstantDeclaration)) continue;
                object = (ClassConstantDeclaration)aSTNode;
                for (Identifier identifier : ((ClassConstantDeclaration)object).getNames()) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(identifier.getName() + ";");
                    stringBuilder2.append(((ASTNode)object).getStartOffset() + ";");
                    indexDocument.addPair(PHPIndexer.FIELD_CLASS_CONST, stringBuilder2.toString(), false);
                }
            }
            for (PHPDocPropertyTag pHPDocPropertyTag : Utils.getPropertyTags(this.root, classDeclaration)) {
                object = this.createFieldsDeclarationRecord(pHPDocPropertyTag.getFieldName(), pHPDocPropertyTag.getFieldType(), 1, pHPDocPropertyTag.getStartOffset());
                indexDocument.addPair(PHPIndexer.FIELD_FIELD, (String)object, false);
            }
        }

        private void indexInterface(InterfaceDeclaration interfaceDeclaration, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(interfaceDeclaration.getName().getName().toLowerCase() + ";");
            stringBuilder.append(interfaceDeclaration.getName().getName() + ";");
            stringBuilder.append(interfaceDeclaration.getStartOffset() + ";");
            Iterator<ASTNode> iterator = interfaceDeclaration.getInterfaes().iterator();
            while (iterator.hasNext()) {
                Identifier aSTNode = iterator.next();
                stringBuilder.append(aSTNode.getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(';');
            indexDocument.addPair(PHPIndexer.FIELD_IFACE, stringBuilder.toString(), true);
            indexDocument.addPair(PHPIndexer.FIELD_TOP_LEVEL, interfaceDeclaration.getName().getName().toLowerCase(), true);
            for (Statement statement : interfaceDeclaration.getBody().getStatements()) {
                Statement statement2;
                if (statement instanceof MethodDeclaration) {
                    statement2 = (MethodDeclaration)statement;
                    this.indexMethod(((MethodDeclaration)statement2).getFunction(), ((BodyDeclaration)statement2).getModifier(), indexDocument);
                    continue;
                }
                if (statement instanceof FieldsDeclaration) {
                    statement2 = (FieldsDeclaration)statement;
                    this.indexFieldsDeclaration((FieldsDeclaration)statement2, indexDocument);
                    continue;
                }
                if (!(statement instanceof ClassConstantDeclaration)) continue;
                statement2 = (ClassConstantDeclaration)statement;
                for (Identifier identifier : ((ClassConstantDeclaration)statement2).getNames()) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(identifier.getName() + ";");
                    stringBuilder2.append(statement2.getStartOffset() + ";");
                    indexDocument.addPair(PHPIndexer.FIELD_CLASS_CONST, stringBuilder2.toString(), false);
                }
            }
        }

        private void indexVarsInAssignment(Assignment assignment, IndexDocument indexDocument) {
            Expression expression;
            if (assignment.getLeftHandSide() instanceof Variable) {
                expression = (Variable)assignment.getLeftHandSide();
                String string = CodeUtils.extractVariableTypeFromAssignment(assignment);
                String string2 = CodeUtils.extractVariableName((Variable)expression);
                if (string2 != null) {
                    String string3;
                    String string4 = string3 = string2.startsWith("$") ? string2.substring(1) : string2;
                    if (!PredefinedSymbols.isSuperGlobalName(string3)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string2.toLowerCase() + ";" + string2 + ";");
                        if (string != null) {
                            stringBuilder.append(string);
                        }
                        stringBuilder.append(";");
                        stringBuilder.append(expression.getStartOffset() + ";");
                        indexDocument.addPair(PHPIndexer.FIELD_VAR, stringBuilder.toString(), true);
                        indexDocument.addPair(PHPIndexer.FIELD_TOP_LEVEL, string2.toLowerCase(), true);
                    }
                }
            }
            if (assignment.getRightHandSide() instanceof Assignment) {
                expression = (Assignment)assignment.getRightHandSide();
                this.indexVarsInAssignment((Assignment)expression, indexDocument);
            }
        }

        private void indexConstant(Statement statement, IndexDocument indexDocument) {
            String string;
            Expression expression;
            Identifier identifier;
            FunctionInvocation functionInvocation;
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            Expression expression2 = expressionStatement.getExpression();
            if (expression2 instanceof FunctionInvocation && (functionInvocation = (FunctionInvocation)expression2).getFunctionName().getName() instanceof Identifier && "define".equals((identifier = (Identifier)functionInvocation.getFunctionName().getName()).getName()) && functionInvocation.getParameters().size() >= 2 && (expression = functionInvocation.getParameters().get(0)) instanceof Scalar && PHPIndexer.isQuotedString(string = ((Scalar)expression).getStringValue())) {
                String string2 = PHPIndexer.dequote(string);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2.toLowerCase());
                stringBuilder.append(';');
                stringBuilder.append(string2);
                stringBuilder.append(';');
                stringBuilder.append(functionInvocation.getStartOffset());
                stringBuilder.append(';');
                indexDocument.addPair(PHPIndexer.FIELD_CONST, stringBuilder.toString(), true);
                indexDocument.addPair(PHPIndexer.FIELD_TOP_LEVEL, string2.toLowerCase(), true);
            }
        }

        private void indexFunction(FunctionDeclaration functionDeclaration, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder(functionDeclaration.getFunctionName().getName().toLowerCase() + ";");
            stringBuilder.append(this.getBaseSignatureForFunctionDeclaration(functionDeclaration));
            indexDocument.addPair(PHPIndexer.FIELD_BASE, stringBuilder.toString(), true);
            indexDocument.addPair(PHPIndexer.FIELD_TOP_LEVEL, functionDeclaration.getFunctionName().getName().toLowerCase(), true);
        }

        private void indexMethod(FunctionDeclaration functionDeclaration, int n, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getBaseSignatureForFunctionDeclaration(functionDeclaration));
            stringBuilder.append(n + ";");
            indexDocument.addPair(PHPIndexer.FIELD_METHOD, stringBuilder.toString(), false);
        }

        private String getBaseSignatureForFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(functionDeclaration.getFunctionName().getName() + ";");
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < n; ++i) {
                FormalParameter formalParameter = functionDeclaration.getFormalParameters().get(i);
                String string = CodeUtils.getParamDisplayName(formalParameter);
                stringBuilder.append(string);
                if (i < n - 1) {
                    stringBuilder.append(",");
                }
                if (formalParameter.getDefaultValue() == null) continue;
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(',');
                }
                stringBuilder2.append(Integer.toString(i));
            }
            stringBuilder.append(';');
            stringBuilder.append(functionDeclaration.getStartOffset() + ";");
            stringBuilder.append(stringBuilder2 + ";");
            String string = this.getReturnTypeFromPHPDoc(functionDeclaration);
            if (string != null && !"mixed".equalsIgnoreCase(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        private String getReturnTypeFromPHPDoc(FunctionDeclaration functionDeclaration) {
            return this.getTypeFromPHPDoc(functionDeclaration, PHPDocTag.Type.RETURN);
        }

        private String getFieldTypeFromPHPDoc(SingleFieldDeclaration singleFieldDeclaration) {
            return this.getTypeFromPHPDoc(singleFieldDeclaration, PHPDocTag.Type.VAR);
        }

        private String getTypeFromPHPDoc(ASTNode aSTNode, PHPDocTag.Type type) {
            Comment comment = Utils.getCommentForNode(this.root, aSTNode);
            if (comment instanceof PHPDocBlock) {
                PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
                for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                    if (pHPDocTag.getKind() != type) continue;
                    String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                    if (stringArray.length <= 0) break;
                    String string = stringArray[0].split("\\;", 2)[0];
                    return string;
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class IndexerVisitor
        extends DefaultTreePathVisitor {
            private List<IndexDocument> documents;
            private IndexDocument defaultDocument;
            private final IndexDocument identifierDocument;
            private Map<String, IdentifierSignature> identifiers;

            public IndexerVisitor(List<IndexDocument> list, IndexDocument indexDocument) {
                this.identifierDocument = TreeAnalyzer.this.factory.createDocument(10);
                this.identifiers = new HashMap<String, IdentifierSignature>();
                this.documents = list;
                this.defaultDocument = indexDocument;
                list.add(this.identifierDocument);
            }

            public void addIdentifierPairs() {
                Collection<IdentifierSignature> collection = this.identifiers.values();
                for (IdentifierSignature identifierSignature : collection) {
                    this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER, identifierSignature.getSignature(), true);
                }
            }

            @Override
            public void visit(Identifier identifier) {
                IdentifierSignature.add(identifier, this.identifiers);
                super.visit(identifier);
            }

            @Override
            public void visit(ClassDeclaration classDeclaration) {
                IndexDocument indexDocument = TreeAnalyzer.this.factory.createDocument(10);
                this.documents.add(indexDocument);
                TreeAnalyzer.this.indexClass(classDeclaration, indexDocument);
                ArrayList<IdentifierSignature> arrayList = new ArrayList<IdentifierSignature>();
                IdentifierSignature.add(classDeclaration, Utils.getPropertyTags(TreeAnalyzer.this.root, classDeclaration), arrayList);
                for (IdentifierSignature identifierSignature : arrayList) {
                    this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER_DECLARATION, identifierSignature.getSignature(), true);
                }
                super.visit(classDeclaration);
            }

            @Override
            public void visit(FunctionDeclaration functionDeclaration) {
                if (this.getPath().get(0) instanceof MethodDeclaration) {
                    super.visit(functionDeclaration);
                    return;
                }
                TreeAnalyzer.this.indexFunction(functionDeclaration, this.defaultDocument);
                super.visit(functionDeclaration);
            }

            @Override
            public void visit(ExpressionStatement expressionStatement) {
                TreeAnalyzer.this.indexConstant(expressionStatement, this.defaultDocument);
                super.visit(expressionStatement);
            }

            @Override
            public void visit(InterfaceDeclaration interfaceDeclaration) {
                IndexDocument indexDocument = TreeAnalyzer.this.factory.createDocument(10);
                this.documents.add(indexDocument);
                TreeAnalyzer.this.indexInterface(interfaceDeclaration, indexDocument);
                ArrayList<IdentifierSignature> arrayList = new ArrayList<IdentifierSignature>();
                IdentifierSignature.add(interfaceDeclaration, arrayList);
                for (IdentifierSignature identifierSignature : arrayList) {
                    this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER_DECLARATION, identifierSignature.getSignature(), true);
                }
                super.visit(interfaceDeclaration);
            }
        }
    }
}

