/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocPropertyTag;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierSignature {
    private static final int DECLARATION = 1;
    private static final int IFACE_MEMBER = 2;
    private static final int CLS_MEMBER = 4;
    private static final int MODIFIER_STATIC = 8;
    private static final int MODIFIER_ABSTRACT = 16;
    private static final int MODIFIER_PROTECTED = 32;
    private static final int MODIFIER_PUBLIC = 64;
    private static final int KIND_FNC = 128;
    private static final int KIND_VAR = 256;
    private static final int KIND_CONST = 512;
    private static final int KIND_CLASS = 1024;
    private String name;
    private int mask;
    private String typeName;

    private IdentifierSignature(String string) {
        this(string, null, 0);
    }

    private IdentifierSignature(String string, String string2, int n) {
        this.name = string.toLowerCase();
        while (string.startsWith("$")) {
            string = string.substring(1);
        }
        this.mask = n;
        if (this.isDeclaration()) {
            this.typeName = string2;
        }
    }

    private IdentifierSignature(Identifier identifier, int n, ElementKind elementKind, String string, boolean bl, Boolean bl2) {
        this.name = identifier.getName().toLowerCase();
        while (this.name.startsWith("$")) {
            this.name = this.name.substring(1);
        }
        if (bl) {
            this.mask |= 1;
        }
        if (bl2 != null && bl2.booleanValue()) {
            this.mask |= 4;
        }
        if (bl2 != null && !bl2.booleanValue()) {
            this.mask |= 2;
        }
        switch (elementKind) {
            case METHOD: {
                this.mask |= 0x80;
                break;
            }
            case FIELD: {
                this.mask |= 0x100;
                break;
            }
            case CONSTANT: {
                this.mask |= 0x200;
                break;
            }
            case CLASS: {
                this.mask |= 0x400;
                break;
            }
            default: {
                throw new IllegalStateException(elementKind.toString());
            }
        }
        if (BodyDeclaration.Modifier.isAbstract(n)) {
            this.mask |= 0x10;
        } else if (BodyDeclaration.Modifier.isStatic(n)) {
            this.mask |= 8;
        }
        if (BodyDeclaration.Modifier.isPublic(n)) {
            this.mask |= 0x40;
        } else if (BodyDeclaration.Modifier.isProtected(n)) {
            this.mask |= 0x20;
        }
        if (this.isDeclaration()) {
            this.typeName = string;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isDeclaration() {
        return (this.mask & 1) != 0;
    }

    public boolean isClassMember() {
        return (this.mask & 4) != 0;
    }

    public boolean isIfaceMember() {
        return (this.mask & 2) != 0;
    }

    public boolean isStatic() {
        return (this.mask & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.mask & 0x10) != 0;
    }

    public boolean isPublic() {
        return (this.mask & 0x40) != 0;
    }

    public boolean isProtected() {
        return (this.mask & 0x20) != 0;
    }

    public boolean isPrivate() {
        return !this.isPublic() && !this.isProtected();
    }

    public boolean isFunction() {
        return (this.mask & 0x80) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isMethod() {
        return (this.mask & 0x80) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public boolean isVariable() {
        return (this.mask & 0x100) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isField() {
        return (this.mask & 0x100) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public boolean isClass() {
        return (this.mask & 0x400) != 0;
    }

    public boolean isConstant() {
        return (this.mask & 0x200) != 0 && !this.isClassMember() && !this.isIfaceMember();
    }

    public boolean isClassConstant() {
        return (this.mask & 0x200) != 0 && (this.isClassMember() || this.isIfaceMember());
    }

    public String getSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(";");
        if (this.mask != 0) {
            stringBuilder.append(this.mask).append(";");
        } else assert (!this.isDeclaration());
        if (this.isDeclaration()) {
            stringBuilder.append(this.typeName).append(";");
        }
        return stringBuilder.toString();
    }

    public static IdentifierSignature createDeclaration(Signature signature) {
        String string = signature.string(0);
        int n = signature.integer(1);
        String string2 = (n & 1) != 0 ? signature.string(2) : null;
        return new IdentifierSignature(string, string2, n);
    }

    public static IdentifierSignature createInvocation(Signature signature) {
        String string = signature.string(0);
        return new IdentifierSignature(string);
    }

    public static void add(ClassDeclaration classDeclaration, List<PHPDocPropertyTag> list, List<IdentifierSignature> list2) {
        String string = CodeUtils.extractClassName(classDeclaration);
        IdentifierSignature.add(classDeclaration.getBody().getStatements(), string, true, list2);
        IdentifierSignature.add(list, string, (Boolean)true, list2);
    }

    public static void add(InterfaceDeclaration interfaceDeclaration, List<IdentifierSignature> list) {
        IdentifierSignature.add(interfaceDeclaration.getBody().getStatements(), interfaceDeclaration.getName().getName(), false, list);
    }

    public static void add(List<Statement> list, String string, boolean bl, List<IdentifierSignature> list2) {
        for (Statement statement : list) {
            Statement statement2;
            if (statement instanceof MethodDeclaration) {
                statement2 = (MethodDeclaration)statement;
                IdentifierSignature.add(statement2, string, (Boolean)bl, list2);
                continue;
            }
            if (statement instanceof FieldsDeclaration) {
                statement2 = (FieldsDeclaration)statement;
                IdentifierSignature.add((FieldsDeclaration)statement2, string, (Boolean)bl, list2);
                continue;
            }
            if (!(statement instanceof ClassConstantDeclaration)) continue;
            statement2 = (ClassConstantDeclaration)statement;
            IdentifierSignature.add((ClassConstantDeclaration)statement2, string, (Boolean)bl, list2);
        }
    }

    private static void add(MethodDeclaration methodDeclaration, String string, Boolean bl, List<IdentifierSignature> list) {
        IdentifierSignature identifierSignature = new IdentifierSignature(methodDeclaration.getFunction().getFunctionName(), methodDeclaration.getModifier(), ElementKind.METHOD, string, true, bl);
        list.add(identifierSignature);
    }

    private static void add(FieldsDeclaration fieldsDeclaration, String string, Boolean bl, List<IdentifierSignature> list) {
        List<SingleFieldDeclaration> list2 = fieldsDeclaration.getFields();
        for (SingleFieldDeclaration singleFieldDeclaration : list2) {
            IdentifierSignature.add(singleFieldDeclaration, fieldsDeclaration.getModifier(), string, bl, list);
        }
    }

    private static void add(SingleFieldDeclaration singleFieldDeclaration, int n, String string, Boolean bl, List<IdentifierSignature> list) {
        IdentifierSignature identifierSignature;
        Variable variable = singleFieldDeclaration.getName();
        Identifier identifier = IdentifierSignature.get(variable);
        IdentifierSignature identifierSignature2 = identifierSignature = identifier != null ? new IdentifierSignature(identifier, n, ElementKind.FIELD, string, true, bl) : null;
        if (identifierSignature != null) {
            list.add(identifierSignature);
        }
    }

    private static void add(List<PHPDocPropertyTag> list, String string, Boolean bl, List<IdentifierSignature> list2) {
        int n = 1;
        n |= 0x40;
        if (bl.booleanValue()) {
            n |= 4;
        }
        for (PHPDocPropertyTag pHPDocPropertyTag : list) {
            list2.add(new IdentifierSignature(pHPDocPropertyTag.getFieldName(), string, n));
        }
    }

    private static void add(ClassConstantDeclaration classConstantDeclaration, String string, Boolean bl, List<IdentifierSignature> list) {
        List<Identifier> list2 = classConstantDeclaration.getNames();
        for (Identifier identifier : list2) {
            list.add(new IdentifierSignature(identifier, 0, ElementKind.CONSTANT, string, true, bl));
        }
    }

    public static void add(Identifier identifier, Map<String, IdentifierSignature> map) {
        String string = identifier.getName().toLowerCase();
        map.put(string, new IdentifierSignature(string));
    }

    private static Identifier get(Variable variable) {
        Expression expression = variable.getName();
        if (expression instanceof Identifier) {
            return (Identifier)expression;
        }
        if (expression instanceof Variable) {
            return IdentifierSignature.get((Variable)expression);
        }
        return null;
    }
}

