/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.php.editor.codegen.DatabaseURL;
import org.netbeans.modules.php.editor.codegen.ui.ErrorLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConnectionGeneratorPanel
extends JPanel {
    private DialogDescriptor descriptor;
    private DatabaseConnection dbconn;
    private JComboBox dbconnComboBox;
    private JLabel dbconnLabel;
    private JLabel errorLabel;

    public static DatabaseConnection selectConnection() {
        ConnectionGeneratorPanel connectionGeneratorPanel = new ConnectionGeneratorPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)connectionGeneratorPanel, NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"MSG_SelectConnection"));
        connectionGeneratorPanel.initialize(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ACSD_SelectConnection"));
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return connectionGeneratorPanel.dbconn;
        }
        return null;
    }

    private ConnectionGeneratorPanel() {
        this.initComponents();
    }

    private void initialize(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        DatabaseExplorerUIs.connect((JComboBox)this.dbconnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.setErrorMessage(NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ERR_SelectConnection"));
    }

    private void databaseConnectionChanged() {
        this.dbconn = null;
        Object object = this.dbconnComboBox.getSelectedItem();
        if (!(object instanceof DatabaseConnection)) {
            return;
        }
        this.dbconn = (DatabaseConnection)object;
        DatabaseURL databaseURL = DatabaseURL.detect(this.dbconn.getDatabaseURL());
        String string = null;
        if (databaseURL == null || databaseURL.getServer() != DatabaseURL.Server.MYSQL) {
            string = NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ERR_UnknownServer");
            this.dbconn = null;
        }
        if (this.dbconn != null) {
            if (this.dbconn.getPassword() == null) {
                ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            }
            if (this.dbconn.getPassword() == null) {
                string = NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ERR_NoPassword");
                this.dbconn = null;
            }
        }
        this.setErrorMessage(string);
    }

    private void setErrorMessage(String string) {
        this.errorLabel.setText(string);
        this.descriptor.setValid(string == null);
    }

    private void initComponents() {
        this.dbconnLabel = new JLabel();
        this.dbconnComboBox = new JComboBox();
        this.errorLabel = new ErrorLabel();
        Mnemonics.setLocalizedText((JLabel)this.dbconnLabel, (String)NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ConnectionGeneratorPanel.dbconnLabel.text"));
        this.dbconnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionGeneratorPanel.this.dbconnComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ConnectionGeneratorPanel.errorLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.dbconnLabel).add((Component)this.dbconnComboBox, 0, 518, Short.MAX_VALUE).add((Component)this.errorLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.dbconnLabel).addPreferredGap(0).add((Component)this.dbconnComboBox, -2, -1, -2).addPreferredGap(1, -1, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.dbconnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ConnectionGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleName"));
        this.dbconnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ConnectionGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleDescription"));
    }

    private void dbconnComboBoxActionPerformed(ActionEvent actionEvent) {
        this.databaseConnectionChanged();
    }
}

