/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.IOException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPCodeTemplateFilter
implements CodeTemplateFilter,
CancellableTask<CompilationInfo> {
    private boolean accept = false;
    private int caretOffset;
    private CompletionContextFinder.CompletionContext context;

    public PHPCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        SourceModel sourceModel;
        this.caretOffset = n;
        FileObject fileObject = GsfUtilities.findFileObject((JTextComponent)jTextComponent);
        if (fileObject != null && (sourceModel = SourceModelFactory.getInstance().getModel(fileObject)) != null && !sourceModel.isScanInProgress()) {
            try {
                sourceModel.runUserActionTask((CancellableTask)this, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public boolean accept(CodeTemplate codeTemplate) {
        if (codeTemplate.getContexts().contains("php-code")) {
            if (this.context == CompletionContextFinder.CompletionContext.CLASS_CONTEXT_KEYWORDS) {
                return codeTemplate.getAbbreviation().equals("fnc");
            }
            return this.accept;
        }
        return true;
    }

    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(CompilationInfo compilationInfo) throws Exception {
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        baseDocument.readLock();
        try {
            this.context = CompletionContextFinder.findCompletionContext(compilationInfo, this.caretOffset);
            switch (this.context) {
                case EXPRESSION: {
                    this.accept = true;
                    return;
                }
                case CLASS_CONTEXT_KEYWORDS: {
                    this.accept = true;
                    return;
                }
            }
            return;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new PHPCodeTemplateFilter(jTextComponent, n);
        }
    }
}

