/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompletionContextFinder {
    private static final List<PHPTokenId[]> CLASS_NAME_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> TYPE_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_CATCH, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}});
    private static final List<PHPTokenId[]> CLASS_MEMBER_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_OBJECT_OPERATOR}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}});
    private static final List<PHPTokenId[]> STATIC_CLASS_MEMBER_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}});
    private static final PHPTokenId[] COMMENT_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_COMMENT_END};
    private static final List<PHPTokenId[]> PHPDOC_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHPDOC_COMMENT_START}, {PHPTokenId.PHPDOC_COMMENT}});
    private static final List<PHPTokenId[]> FUNCTION_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> CLASS_CONTEXT_KEYWORDS_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_PRIVATE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STATIC}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ABSTRACT}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_FINAL}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_LINE_COMMENT}, {PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_COMMENT_END}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_STRING}, {PHPTokenId.PHPDOC_COMMENT_END}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.WHITESPACE}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_CLOSE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_SEMICOLON}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> SERVER_ARRAY_TOKENCHAINS = Collections.singletonList(new PHPTokenId[]{PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_TOKEN});
    private static final List<String> SERVER_ARRAY_TOKENTEXTS = Arrays.asList("$_SERVER", "[");

    CompletionContextFinder() {
    }

    @NonNull
    static CompletionContext findCompletionContext(CompilationInfo compilationInfo, int n) {
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return CompletionContext.NONE;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(document, n);
        if (tokenSequence == null) {
            return CompletionContext.NONE;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token token = tokenSequence.token();
        PHPTokenId pHPTokenId = (PHPTokenId)token.id();
        int n2 = tokenSequence.token().offset(tokenHierarchy);
        CompletionContext completionContext = CompletionContextFinder.getClsIfaceDeclContext((Token<PHPTokenId>)token, n - n2, tokenSequence);
        if (completionContext != null) {
            return completionContext;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_NAME_TOKENCHAINS)) {
            return CompletionContext.CLASS_NAME;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_TOKENCHAINS)) {
            return CompletionContext.CLASS_MEMBER;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, STATIC_CLASS_MEMBER_TOKENCHAINS)) {
            return CompletionContext.STATIC_CLASS_MEMBER;
        }
        if (CompletionContextFinder.isOneOfTokens(tokenSequence, COMMENT_TOKENS)) {
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, PHPDOC_TOKENCHAINS)) {
            return CompletionContext.PHPDOC;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, TYPE_TOKENCHAINS)) {
            return CompletionContext.TYPE_NAME;
        }
        if (CompletionContextFinder.isInsideClassIfaceDeclarationBlock(compilationInfo, n, tokenSequence)) {
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_CONTEXT_KEYWORDS_TOKENCHAINS)) {
                return CompletionContext.CLASS_CONTEXT_KEYWORDS;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, FUNCTION_TOKENCHAINS)) {
                return CompletionContext.METHOD_NAME;
            }
            return CompletionContext.NONE;
        }
        switch (pHPTokenId) {
            case T_INLINE_HTML: {
                return CompletionContext.HTML;
            }
            case PHP_CONSTANT_ENCAPSED_STRING: {
                char c = tokenSequence.token().text().charAt(0);
                if (c == '\"') {
                    if (CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                        return CompletionContext.SERVER_ENTRY_CONSTANTS;
                    }
                    return CompletionContext.STRING;
                }
                if (c == '\'' && CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                    return CompletionContext.SERVER_ENTRY_CONSTANTS;
                }
                return CompletionContext.NONE;
            }
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean isOneOfTokens(TokenSequence tokenSequence, PHPTokenId[] pHPTokenIdArray) {
        TokenId tokenId = tokenSequence.token().id();
        for (PHPTokenId pHPTokenId : pHPTokenIdArray) {
            if (!((Object)((Object)pHPTokenId)).equals(tokenId)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChainTexts(TokenSequence tokenSequence, List<String> list) {
        Token[] tokenArray = CompletionContextFinder.getPreceedingTokens(tokenSequence, list.size());
        if (tokenArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < tokenArray.length; ++i) {
            String string = list.get(i);
            if (string.contentEquals(tokenArray[i].text())) continue;
            return false;
        }
        return true;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<PHPTokenId[]> list) {
        int n = 0;
        for (PHPTokenId[] object : list) {
            if (n >= object.length) continue;
            n = object.length;
        }
        Token[] tokenArray = CompletionContextFinder.getPreceedingTokens(tokenSequence, n);
        block1: for (PHPTokenId[] pHPTokenIdArray : list) {
            int n2 = tokenArray.length - pHPTokenIdArray.length;
            if (n2 < 0) continue;
            for (int i = 0; i < pHPTokenIdArray.length; ++i) {
                if (pHPTokenIdArray[i] != tokenArray[i + n2].id()) continue block1;
            }
            return true;
        }
        return false;
    }

    private static Token[] getPreceedingTokens(TokenSequence tokenSequence, int n) {
        int n2 = tokenSequence.offset();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        for (int i = 0; i < n && tokenSequence.movePrevious(); ++i) {
            linkedList.addFirst(tokenSequence.token());
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return linkedList.toArray(new Token[linkedList.size()]);
    }

    @CheckForNull
    private static CompletionContext getClsIfaceDeclContext(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Token<PHPTokenId> token2 = null;
        List<? extends Token<PHPTokenId>> list = CompletionContextFinder.getPreceedingLineTokens(token, n, tokenSequence);
        for (Token<PHPTokenId> token3 : list) {
            boolean bl6;
            TokenId tokenId = token3.id();
            boolean bl7 = bl6 = !bl2 && !bl && !bl3 && !bl4;
            if (tokenId.equals((Object)PHPTokenId.PHP_CLASS)) {
                bl = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) {
                bl2 = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_EXTENDS)) {
                bl3 = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_IMPLEMENTS)) {
                bl4 = true;
                continue;
            }
            if (bl6 && tokenId.equals((Object)PHPTokenId.PHP_STRING)) {
                bl5 = true;
                token2 = token3;
                continue;
            }
            if (!bl6 || !tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) continue;
            return null;
        }
        if (bl || bl2) {
            if (bl4) {
                return CompletionContext.INTERFACE_NAME;
            }
            if (bl3) {
                if (bl5 && bl && token2 != null && n == 0 && list.size() > 0 && list.get(0).text().equals(token2.text())) {
                    return CompletionContext.CLASS_NAME;
                }
                if (bl5 && bl) {
                    return CompletionContext.IMPLEMENTS;
                }
                if (!bl5 && bl) {
                    return CompletionContext.CLASS_NAME;
                }
                if (bl2) {
                    return CompletionContext.INTERFACE_NAME;
                }
                return !bl5 ? (bl ? CompletionContext.CLASS_NAME : CompletionContext.INTERFACE_NAME) : (bl ? CompletionContext.IMPLEMENTS : CompletionContext.INTERFACE_NAME);
            }
            if (bl2) {
                return !bl5 ? CompletionContext.NONE : CompletionContext.EXTENDS;
            }
            if (bl) {
                return !bl5 ? CompletionContext.NONE : CompletionContext.INHERITANCE;
            }
        }
        return null;
    }

    static boolean lineContainsAny(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence, List<PHPTokenId> list) {
        List<? extends Token<PHPTokenId>> list2 = CompletionContextFinder.getPreceedingLineTokens(token, n, tokenSequence);
        for (Token<PHPTokenId> token2 : list2) {
            if (!list.contains(token2.id())) continue;
            return true;
        }
        return false;
    }

    private static List<? extends Token<PHPTokenId>> getPreceedingLineTokens(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence) {
        int n2 = tokenSequence.offset();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        if (token.id() != PHPTokenId.WHITESPACE || ((Object)token.text().subSequence(0, Math.min(token.text().length(), n))).toString().indexOf("\n") == -1) {
            Token token2;
            while (tokenSequence.movePrevious() && ((token2 = tokenSequence.token()).id() != PHPTokenId.WHITESPACE || ((Object)token2.text()).toString().indexOf("\n") == -1)) {
                linkedList.addLast(token2);
            }
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isInsideClassIfaceDeclarationBlock(CompilationInfo compilationInfo, int n, TokenSequence tokenSequence) {
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, CompletionContextFinder.lexerToASTOffset(compilationInfo, n));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (ASTNode aSTNode : list) {
            if (aSTNode instanceof FunctionDeclaration) {
                bl2 = true;
                if (!bl3) continue;
                bl5 = true;
                continue;
            }
            if (aSTNode instanceof MethodDeclaration) {
                bl = true;
                continue;
            }
            if (aSTNode instanceof ClassDeclaration) {
                bl3 = true;
                if (!bl2) continue;
                bl4 = true;
                continue;
            }
            if (!(aSTNode instanceof InterfaceDeclaration)) continue;
            bl3 = true;
        }
        if (bl2 && !bl && !bl3) {
            final StringBuilder stringBuilder = new StringBuilder();
            new DefaultVisitor(){

                public void visit(ASTError aSTError) {
                    super.visit(aSTError);
                    stringBuilder.append(aSTError.toString());
                }
            }.scan(Utils.getRoot(compilationInfo));
            if (stringBuilder.length() == 0) {
                return false;
            }
        }
        if (bl4 && !bl5) {
            return true;
        }
        int n2 = tokenSequence.offset();
        try {
            int n3 = 0;
            int n4 = 0;
            while (tokenSequence.movePrevious()) {
                boolean bl6;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                    ++n3;
                    continue;
                }
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                    ++n4;
                    continue;
                }
                if ((tokenId.equals((Object)PHPTokenId.PHP_FUNCTION) || tokenId.equals((Object)PHPTokenId.PHP_WHILE) || tokenId.equals((Object)PHPTokenId.PHP_IF) || tokenId.equals((Object)PHPTokenId.PHP_FOR) || tokenId.equals((Object)PHPTokenId.PHP_FOREACH) || tokenId.equals((Object)PHPTokenId.PHP_TRY) || tokenId.equals((Object)PHPTokenId.PHP_CATCH)) && n3 > n4) {
                    boolean bl7 = false;
                    return bl7;
                }
                if (!tokenId.equals((Object)PHPTokenId.PHP_CLASS) && !tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) continue;
                boolean bl8 = bl6 = n3 > 0 && n3 > n4;
                return bl8;
            }
        }
        finally {
            tokenSequence.move(n2);
            tokenSequence.moveNext();
        }
        return false;
    }

    static int lexerToASTOffset(PHPParseResult pHPParseResult, int n) {
        if (pHPParseResult.getTranslatedSource() != null) {
            return pHPParseResult.getTranslatedSource().getAstOffset(n);
        }
        return n;
    }

    static int lexerToASTOffset(CompilationInfo compilationInfo, int n) {
        PHPParseResult pHPParseResult = (PHPParseResult)compilationInfo.getEmbeddedResult("text/x-php5", n);
        return CompletionContextFinder.lexerToASTOffset(pHPParseResult, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum KeywordCompletionType {
        SIMPLE,
        CURSOR_INSIDE_BRACKETS,
        ENDS_WITH_CURLY_BRACKETS,
        ENDS_WITH_SPACE,
        ENDS_WITH_SEMICOLON,
        ENDS_WITH_COLON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompletionContext {
        EXPRESSION,
        HTML,
        CLASS_NAME,
        INTERFACE_NAME,
        TYPE_NAME,
        STRING,
        CLASS_MEMBER,
        STATIC_CLASS_MEMBER,
        PHPDOC,
        INHERITANCE,
        EXTENDS,
        IMPLEMENTS,
        METHOD_NAME,
        CLASS_CONTEXT_KEYWORDS,
        SERVER_ENTRY_CONSTANTS,
        NONE;

    }
}

