/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core;

import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

abstract class BadgedIconCache {
    private static Map<String, Image> theCache = Collections.synchronizedMap(new WeakHashMap(101));
    public static final int NW_BADGE_X = 8;
    public static final int NW_BADGE_Y = 0;
    public static final int NE_BADGE_X = 16;
    public static final int NE_BADGE_Y = 0;
    public static final int SE_BADGE_X = 16;
    public static final int SE_BADGE_Y = 8;
    public static final int SW_BADGE_X = 8;
    public static final int SW_BADGE_Y = 8;
    public static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    public static final String DEFAULT_ERROR_BADGE = "org/netbeans/modules/bpel/core/resources/errorbadge.gif";
    public static final String DEFAULT_WARNING_BADGE = "org/netbeans/modules/bpel/core/resources/warningbadge.gif";
    private static final String ERROR_KEY_PREFIX = "ERR";
    private static final String WARNING_KEY_PREFIX = "WRN";

    BadgedIconCache() {
    }

    public static Image getErrorIcon(String string) {
        return BadgedIconCache.getBadgedIcon(string, null, null, null, DEFAULT_ERROR_BADGE);
    }

    public static Image getWarningIcon(String string) {
        return BadgedIconCache.getBadgedIcon(string, null, null, null, DEFAULT_WARNING_BADGE);
    }

    public static Image getErrorIcon(Image image) {
        if (null == image) {
            return null;
        }
        String string = ERROR_KEY_PREFIX + image.toString();
        Image image2 = theCache.get(string);
        if (image2 == null) {
            image2 = BadgedIconCache.createBadgedIcon(image, null, null, null, DEFAULT_ERROR_BADGE);
            theCache.put(string, image2);
        }
        return image2;
    }

    public static Image getWarningIcon(Image image) {
        if (null == image) {
            return null;
        }
        String string = WARNING_KEY_PREFIX + image.toString();
        Image image2 = theCache.get(string);
        if (image2 == null) {
            image2 = BadgedIconCache.createBadgedIcon(image, null, null, null, DEFAULT_WARNING_BADGE);
            theCache.put(string, image2);
        }
        return image2;
    }

    public static Image getBadgedIcon(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            return null;
        }
        String string6 = BadgedIconCache.buildIconKey(string, string2, string3, string4, string5);
        Image image = theCache.get(string6);
        if (image == null) {
            image = BadgedIconCache.createBadgedIcon(string, string2, string3, string4, string5);
            theCache.put(string6, image);
        }
        return image;
    }

    public static Image getBadgedIcon(String string, Image image, String string2, String string3, String string4, String string5) {
        if (string == null) {
            return null;
        }
        String string6 = BadgedIconCache.buildIconKey(string, string2, string3, string4, string5);
        Image image2 = theCache.get(string6);
        if (image2 == null) {
            image2 = BadgedIconCache.createBadgedIcon(image, string2, string3, string4, string5);
            theCache.put(string6, image2);
        }
        return image2;
    }

    private static String buildIconKey(String string, String string2, String string3, String string4, String string5) {
        String string6 = new String("null");
        Object[] objectArray = new Object[]{BadgedIconCache.normalizeGifPath(string), string2 == null ? string6 : BadgedIconCache.normalizeGifPath(string2), string3 == null ? string6 : BadgedIconCache.normalizeGifPath(string3), string4 == null ? string6 : BadgedIconCache.normalizeGifPath(string4), string5 == null ? string6 : BadgedIconCache.normalizeGifPath(string5)};
        return MessageFormat.format("{0};{1};{2};{3};{4}", objectArray);
    }

    public static Image createBadgedIcon(String string, String string2, String string3, String string4, String string5) {
        Image image = BadgedIconCache.getIcon(string);
        if (image == null) {
            image = BadgedIconCache.getIcon(DEFAULT_ICON);
        }
        return BadgedIconCache.createBadgedIcon(image, string2, string3, string4, string5);
    }

    public static Image createBadgedIcon(Image image, String string, String string2, String string3, String string4) {
        if (null == image) {
            return null;
        }
        Image image2 = image;
        if (string != null) {
            image2 = BadgedIconCache.mergeSingleImage(image2, string, 8, 0);
        }
        if (string2 != null) {
            image2 = BadgedIconCache.mergeSingleImage(image2, string2, 16, 0);
        }
        if (string3 != null) {
            image2 = BadgedIconCache.mergeSingleImage(image2, string3, 16, 8);
        }
        if (string4 != null) {
            image2 = BadgedIconCache.mergeSingleImage(image2, string4, 8, 8);
        }
        return image2;
    }

    public static Image mergeSingleImage(Image image, String string, int n, int n2) {
        Image image2 = BadgedIconCache.getIcon(string);
        if (image2 == null) {
            return image;
        }
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)n, (int)n2);
    }

    public static Image getIcon(String string) {
        String string2 = BadgedIconCache.normalizeGifPath(string);
        Image image = theCache.get(string2);
        if (image != null) {
            return image;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            return null;
        }
        image = new ImageIcon(uRL).getImage();
        theCache.put(string2, image);
        return image;
    }

    public static String normalizeGifPath(String string) {
        if (string == null) {
            return string;
        }
        String string2 = "/";
        String string3 = ".";
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (string.indexOf(string3) == -1) {
            string = string.concat(".gif");
        }
        return string;
    }
}

