/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.multiview.tree;

import java.beans.PropertyChangeEvent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.nodes.LogicalTreeHandler;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class MultiviewTreeHandler
extends LogicalTreeHandler {
    public MultiviewTreeHandler(ExplorerManager explorerManager, TMapModel tMapModel, Lookup lookup) {
        super(explorerManager, tMapModel, lookup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = this.getCurrentTopComponent();
        if (topComponent == null) {
            return;
        }
        if (string.equals("activated")) {
            if (TopComponent.getRegistry().getActivated() == topComponent) {
                // empty if block
            }
        } else {
            if (string.equals("activatedNodes")) {
                if (TopComponent.getRegistry().getActivated() != topComponent) {
                    this.doTreeNodeSelectionByActiveNode();
                }
                return;
            }
            if (string.equals("selectedNodes")) {
                topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
            } else if (string.equals("rootContext")) {
                this.doTreeNodeSelectionByActiveNode();
            }
        }
    }

    private TopComponent getCurrentTopComponent() {
        BeanTreeView beanTreeView = this.getBeanTreeView();
        if (beanTreeView == null) {
            return null;
        }
        TopComponent topComponent = null;
        Object object = beanTreeView;
        while ((object = object.getParent()) != null) {
            if (!(object instanceof TopComponent)) continue;
            topComponent = (TopComponent)object;
            break;
        }
        return topComponent;
    }
}

