/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.validation;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.validation.TransformmapValidator;
import org.netbeans.modules.xslt.tmap.util.TMapUtil;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class TransformmapValidatorImpl
implements TransformmapValidator {
    private static TransformmapValidator INSTANCE = new TransformmapValidatorImpl();
    private ValidationRule[] myValidationRules = new ValidationRule[]{new NoTransformationDescriptor(), new IsXsltMap(), new IsOldTransformmap()};
    private ComplexValidationRule[] myComplexValidationRules = new ComplexValidationRule[]{new CantResolveTransform(), new CantResolveInputType(), new CantResolveOutputType()};

    private TransformmapValidatorImpl() {
    }

    public static TransformmapValidator getInstance() {
        return INSTANCE;
    }

    private String validate(Object object) {
        ValidationRule validationRule;
        String string = null;
        ValidationRule[] validationRuleArray = this.myValidationRules;
        int n = validationRuleArray.length;
        for (int i = 0; i < n && (string = (validationRule = validationRuleArray[i]).validate(object)) == null; ++i) {
        }
        return string;
    }

    private String validate(Object object, Object object2) {
        ComplexValidationRule complexValidationRule;
        String string = null;
        ComplexValidationRule[] complexValidationRuleArray = this.myComplexValidationRules;
        int n = complexValidationRuleArray.length;
        for (int i = 0; i < n && (string = (complexValidationRule = complexValidationRuleArray[i]).validate(object, object2)) == null; ++i) {
        }
        return string;
    }

    public String validate(File file) {
        return this.validate((Object)file);
    }

    public String validate(Project project) {
        return this.validate((Object)project);
    }

    public String validate(TMapModel tMapModel, FileObject fileObject) {
        return this.validate((Object)tMapModel, (Object)fileObject);
    }

    public String validate(AXIComponent aXIComponent, String string) {
        if (aXIComponent == null || aXIComponent.getModel() == null || aXIComponent.getModel().getState() != Model.State.VALID) {
            return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"MSG_Error_BadSchema", (Object)string);
        }
        return null;
    }

    private class CantResolveOutputType
    implements ComplexValidationRule {
        private CantResolveOutputType() {
        }

        private String validate(TMapModel tMapModel, FileObject fileObject) {
            if (tMapModel == null || fileObject == null) {
                return null;
            }
            Transform transform = TMapUtil.getTransform(tMapModel, fileObject);
            if (transform == null) {
                return null;
            }
            if (TMapUtil.getTargetComponent(transform) == null) {
                return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"Msg_CantResolveTargetType", (Object)fileObject.getNameExt());
            }
            return null;
        }

        public boolean accept(Object object, Object object2) {
            return object instanceof TMapModel && object2 instanceof FileObject;
        }

        public String validate(Object object, Object object2) {
            if (!this.accept(object, object2)) {
                return null;
            }
            return this.validate((TMapModel)object, (FileObject)object2);
        }
    }

    private class CantResolveInputType
    implements ComplexValidationRule {
        private CantResolveInputType() {
        }

        private String validate(TMapModel tMapModel, FileObject fileObject) {
            if (tMapModel == null || fileObject == null) {
                return null;
            }
            Transform transform = TMapUtil.getTransform(tMapModel, fileObject);
            if (transform == null) {
                return null;
            }
            if (TMapUtil.getSourceComponent(transform) == null) {
                return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"Msg_CantResolveSourceType", (Object)fileObject.getNameExt());
            }
            return null;
        }

        public boolean accept(Object object, Object object2) {
            return object instanceof TMapModel && object2 instanceof FileObject;
        }

        public String validate(Object object, Object object2) {
            if (!this.accept(object, object2)) {
                return null;
            }
            return this.validate((TMapModel)object, (FileObject)object2);
        }
    }

    private class CantResolveTransform
    implements ComplexValidationRule {
        private CantResolveTransform() {
        }

        private String validate(TMapModel tMapModel, FileObject fileObject) {
            if (tMapModel == null || fileObject == null) {
                return null;
            }
            if (TMapUtil.getTransform(tMapModel, fileObject) == null) {
                return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"Msg_CantResolveTransformation", (Object)fileObject.getNameExt());
            }
            return null;
        }

        public boolean accept(Object object, Object object2) {
            return object instanceof TMapModel && object2 instanceof FileObject;
        }

        public String validate(Object object, Object object2) {
            if (!this.accept(object, object2)) {
                return null;
            }
            return this.validate((TMapModel)object, (FileObject)object2);
        }
    }

    private class IsOldTransformmap
    implements ValidationRule {
        private IsOldTransformmap() {
        }

        private String validate(File file) {
            return null;
        }

        private String validate(Project project) {
            return this.validate(Util.getTransformationDescriptor(project));
        }

        public boolean accept(Object object) {
            return object instanceof File || object instanceof Project;
        }

        public String validate(Object object) {
            if (!this.accept(object)) {
                return null;
            }
            return object instanceof File ? this.validate((File)object) : this.validate((Project)object);
        }
    }

    private class IsXsltMap
    implements ValidationRule {
        private IsXsltMap() {
        }

        private String validate(File file) {
            if (file == null) {
                return null;
            }
            String string = "xsltmap.xml";
            if (string.equals(file.getName())) {
                return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"Msg_OldXsltmap");
            }
            return null;
        }

        private String validate(Project project) {
            if (project == null) {
                return null;
            }
            return this.validate(Util.getTransformationDescriptor(project));
        }

        public boolean accept(Object object) {
            return object instanceof File || object instanceof Project;
        }

        public String validate(Object object) {
            if (!this.accept(object)) {
                return null;
            }
            return object instanceof File ? this.validate((File)object) : this.validate((Project)object);
        }
    }

    private class NoTransformationDescriptor
    implements ValidationRule {
        private NoTransformationDescriptor() {
        }

        private String validate(Project project) {
            if (project == null) {
                return null;
            }
            File file = Util.getTransformationDescriptor(project);
            if (file == null) {
                return NbBundle.getMessage(TransformmapValidatorImpl.class, (String)"Msg_NoTransformationDescriptor");
            }
            return null;
        }

        public boolean accept(Object object) {
            return object instanceof Project;
        }

        public String validate(Object object) {
            if (!this.accept(object)) {
                return null;
            }
            return this.validate((Project)object);
        }
    }

    private static interface ComplexValidationRule {
        public boolean accept(Object var1, Object var2);

        public String validate(Object var1, Object var2);
    }

    private static interface ValidationRule {
        public boolean accept(Object var1);

        public String validate(Object var1);
    }
}

