/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.spi;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;

public abstract class NameGenerator {
    private static NameGenerator[] NAME_GENERATORS = new NameGenerator[]{new ServiceNameGenerator(), new InvokeNameGenerator(), new TransformNameGenerator()};

    protected abstract boolean isApplicable(TMapComponent var1);

    abstract String getName(TMapComponent var1, String var2);

    abstract String getName(TMapComponent var1);

    public static NameGenerator getDefault(TMapComponent tMapComponent) {
        for (NameGenerator nameGenerator : NAME_GENERATORS) {
            if (!nameGenerator.isApplicable(tMapComponent)) continue;
            return nameGenerator;
        }
        return null;
    }

    public static String getUniqueName(TMapComponent tMapComponent) {
        NameGenerator nameGenerator = NameGenerator.getDefault(tMapComponent);
        if (nameGenerator != null) {
            // empty if block
        }
        return nameGenerator != null ? nameGenerator.getName(tMapComponent) : null;
    }

    private static String getCamelCase(String string) {
        assert (string != null);
        if (string.length() <= 0) {
            return string;
        }
        String string2 = string.substring(1);
        string2 = string2.toLowerCase();
        char c = string.charAt(0);
        if (!Character.isUpperCase(c)) {
            c = Character.toUpperCase(c);
        }
        return Character.toString(c) + string2;
    }

    private static class TransformNameGenerator
    extends NameGenerator {
        private TransformNameGenerator() {
        }

        protected boolean isApplicable(TMapComponent tMapComponent) {
            return tMapComponent instanceof Transform;
        }

        String getName(TMapComponent tMapComponent, String string) {
            if (tMapComponent == null || string == null || !this.isApplicable(tMapComponent)) {
                return null;
            }
            string = NameGenerator.getCamelCase(string);
            Transform transform = (Transform)tMapComponent;
            TMapModel tMapModel = transform.getModel();
            if (tMapModel == null) {
                return null;
            }
            TransformMap transformMap = tMapModel.getTransformMap();
            if (transformMap == null) {
                return null;
            }
            List<Service> list = transformMap.getServices();
            if (list == null) {
                return null;
            }
            ArrayList<Transform> arrayList = new ArrayList<Transform>();
            for (Service service : list) {
                List<Operation> list2;
                if (service == null || (list2 = service.getOperations()) == null) continue;
                for (Operation referenceCollection : list2) {
                    if (referenceCollection == null) continue;
                    arrayList.addAll(referenceCollection.getTransforms());
                }
            }
            Object object = null;
            boolean bl = false;
            int n = 0;
            block2: while (object == null) {
                object = string + n;
                for (Transform transform2 : arrayList) {
                    if (!((String)object).equalsIgnoreCase(transform2.getName())) continue;
                    ++n;
                    object = null;
                    continue block2;
                }
            }
            return object;
        }

        String getName(TMapComponent tMapComponent) {
            if (!this.isApplicable(tMapComponent)) {
                return null;
            }
            Transform cfr_ignored_0 = (Transform)tMapComponent;
            return this.getName(tMapComponent, Transform.TYPE.getTagName());
        }
    }

    private static class InvokeNameGenerator
    extends NameGenerator {
        private InvokeNameGenerator() {
        }

        protected boolean isApplicable(TMapComponent tMapComponent) {
            return tMapComponent instanceof Invoke;
        }

        String getName(TMapComponent tMapComponent, String string) {
            if (tMapComponent == null || string == null || !this.isApplicable(tMapComponent)) {
                return null;
            }
            string = NameGenerator.getCamelCase(string);
            Invoke invoke = (Invoke)tMapComponent;
            TMapModel tMapModel = invoke.getModel();
            if (tMapModel == null) {
                return null;
            }
            TransformMap transformMap = tMapModel.getTransformMap();
            if (transformMap == null) {
                return null;
            }
            List<Service> list = transformMap.getServices();
            if (list == null) {
                return null;
            }
            ArrayList<Invoke> arrayList = new ArrayList<Invoke>();
            for (Service service : list) {
                List<Operation> list2;
                if (service == null || (list2 = service.getOperations()) == null) continue;
                for (Operation variableDeclarator : list2) {
                    if (variableDeclarator == null) continue;
                    arrayList.addAll(variableDeclarator.getInvokes());
                }
            }
            Object object = null;
            boolean bl = false;
            int n = 1;
            block2: while (object == null) {
                object = string + n;
                for (Invoke invoke2 : arrayList) {
                    if (!((String)object).equalsIgnoreCase(invoke2.getName())) continue;
                    ++n;
                    object = null;
                    continue block2;
                }
            }
            return object;
        }

        String getName(TMapComponent tMapComponent) {
            if (!this.isApplicable(tMapComponent)) {
                return null;
            }
            Invoke cfr_ignored_0 = (Invoke)tMapComponent;
            return this.getName(tMapComponent, Invoke.TYPE.getTagName());
        }
    }

    private static class ServiceNameGenerator
    extends NameGenerator {
        private ServiceNameGenerator() {
        }

        protected boolean isApplicable(TMapComponent tMapComponent) {
            return tMapComponent instanceof Service;
        }

        String getName(TMapComponent tMapComponent, String string) {
            if (tMapComponent == null || string == null || !this.isApplicable(tMapComponent)) {
                return null;
            }
            string = NameGenerator.getCamelCase(string);
            Service service = (Service)tMapComponent;
            TMapModel tMapModel = service.getModel();
            if (tMapModel == null) {
                return null;
            }
            TransformMap transformMap = tMapModel.getTransformMap();
            if (transformMap == null) {
                return null;
            }
            List<Service> list = transformMap.getServices();
            if (list == null) {
                return null;
            }
            String string2 = null;
            boolean bl = false;
            int n = 1;
            block0: while (string2 == null) {
                string2 = string + n;
                for (Service service2 : list) {
                    if (!string2.equalsIgnoreCase(service2.getName())) continue;
                    ++n;
                    string2 = null;
                    continue block0;
                }
            }
            return string2;
        }

        String getName(TMapComponent tMapComponent) {
            if (!this.isApplicable(tMapComponent)) {
                return null;
            }
            Service cfr_ignored_0 = (Service)tMapComponent;
            return this.getName(tMapComponent, Service.TYPE.getTagName());
        }
    }
}

