/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.api.completion;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xslt.tmap.model.api.completion.CompletionModelImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMapCompletionModelProvider
extends CompletionModelProvider {
    public List<CompletionModelProvider.CompletionModel> getModels(CompletionContext completionContext) {
        if (!this.isTMapFile(completionContext)) {
            return null;
        }
        SchemaModel schemaModel = this.getTMapSchemaModel();
        if (schemaModel == null) {
            return null;
        }
        CompletionModelImpl completionModelImpl = new CompletionModelImpl(schemaModel);
        return Collections.singletonList(completionModelImpl);
    }

    private boolean isTMapFile(CompletionContext completionContext) {
        FileObject fileObject = completionContext.getPrimaryFile();
        if (!"transformmap.xml".equals(fileObject.getNameExt())) {
            return false;
        }
        return "http://xml.netbeans.org/schema/transformmap".equals(completionContext.getDefaultNamespace());
    }

    private SchemaModel getTMapSchemaModel() {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-xsltpro/transformmap.xsd");
            if (fileObject == null) {
                return null;
            }
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)false);
            if (modelSource == null) {
                return null;
            }
            SchemaModel schemaModel = (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(modelSource);
            schemaModel.sync();
            return schemaModel;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

