/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserQueue {
    private static ParserQueue instance = new ParserQueue(false);
    private PriorityQueue<Entry> queue = new PriorityQueue();
    private State state;
    private final Object suspendLock = new String("suspendLock");
    private Map<ProjectBase, ProjectData> projectData = new HashMap<ProjectBase, ProjectData>();
    private final Map<CsmProject, Object> projectLocks = new HashMap<CsmProject, Object>();
    private int serial = 0;
    private final Object lock = new Object();
    private final boolean addAlways;
    private Diagnostic.StopWatch stopWatch = TraceFlags.TIMING ? new Diagnostic.StopWatch(false) : null;

    static String tracePreprocStates(Collection<APTPreprocHandler.State> collection) {
        StringBuilder stringBuilder = new StringBuilder(40);
        boolean bl = false;
        for (APTPreprocHandler.State state : collection) {
            stringBuilder.append('(');
            if (!bl) {
                stringBuilder.append(';');
            }
            bl = false;
            stringBuilder.append(ParserQueue.tracePreprocState(state));
            stringBuilder.append(')');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static String tracePreprocState(APTPreprocHandler.State state) {
        if (state == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        if (!state.isCleaned()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" cleaned, ");
        if (!state.isValid()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" valid, ");
        if (!state.isCompileContext()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" correct State]");
        return stringBuilder.toString();
    }

    private ParserQueue(boolean bl) {
        this.addAlways = bl;
    }

    public static ParserQueue instance() {
        return instance;
    }

    public static ParserQueue testInstance() {
        return new ParserQueue(true);
    }

    private String traceState4File(FileImpl fileImpl, Set set) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        stringBuilder.append(fileImpl);
        stringBuilder.append("\n of project ").append(fileImpl.getProjectImpl(true));
        stringBuilder.append("\n content of projects files set:\n");
        stringBuilder.append(set);
        stringBuilder.append("\nqueue content is:\n");
        stringBuilder.append(this.toString(this.queue, false));
        stringBuilder.append("\nprojectData content is:\n");
        stringBuilder.append(this.projectData);
        return stringBuilder.toString();
    }

    public void add(FileImpl fileImpl, APTPreprocHandler.State state, Position position) {
        this.add(fileImpl, Collections.singleton(state), position, true, FileAction.NOTHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FileImpl fileImpl, Collection<APTPreprocHandler.State> collection, Position position, boolean bl, FileAction fileAction) {
        if (collection.isEmpty()) {
            Utils.LOG.severe("Adding a file with an emty preprocessor state set");
        }
        assert (this.state != null);
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: add " + fileImpl.getAbsolutePath() + " as " + (Object)((Object)position));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.OFF) {
                return;
            }
            switch (fileAction) {
                case MARK_MORE_PARSE: {
                    fileImpl.markMoreParseNeeded();
                    break;
                }
                case MARK_REPARSE: {
                    fileImpl.markReparseNeeded(false);
                    break;
                }
                case MARK_REPARSE_AND_INVALIDATE: {
                    fileImpl.markReparseNeeded(true);
                }
            }
            if (!this.needEnqueue(fileImpl)) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: do not add parsing or parsed " + fileImpl.getAbsolutePath());
                }
                return;
            }
            if (this.queue.isEmpty()) {
                this.serial = 0;
            }
            Set set = this.getProjectFiles(fileImpl.getProjectImpl(true));
            Entry entry = null;
            boolean bl2 = false;
            if (set.contains(fileImpl)) {
                entry = this.findEntry(fileImpl);
                if (entry == null) {
                    assert (false) : "ProjectData contains file " + fileImpl + ", but there is no matching entry in the queue";
                } else {
                    if (bl) {
                        entry.setStates(collection);
                    } else {
                        entry.addStates(collection);
                    }
                    if (position.compareTo(entry.getPosition()) < 0) {
                        this.queue.remove(entry);
                        entry.setPosition(position);
                        entry.setSerial(++this.serial);
                        bl2 = true;
                    }
                }
            } else {
                assert (this.findEntry(fileImpl) == null) : "The queue should not contain the file " + this.traceState4File(fileImpl, set);
                set.add(fileImpl);
            }
            if (entry == null) {
                entry = new Entry(fileImpl, collection, position, ++this.serial);
                bl2 = true;
            }
            if (bl2) {
                this.queue.add(entry);
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: added entry " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileInvalidated(fileImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waitReady() ...");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.queue.isEmpty() && this.state != State.OFF) {
                this.lock.wait();
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waiting finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: suspending");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: resuming");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.ON;
            this.suspendLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry poll(AtomicReference<FileImpl.State> atomicReference) throws InterruptedException {
        boolean bl;
        boolean bl2;
        ProjectBase projectBase;
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.state == State.SUSPENDED) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: waiting for resume");
                }
                this.suspendLock.wait();
            }
        }
        object = null;
        FileImpl fileImpl = null;
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.queue.poll();
            if (object == null) {
                return null;
            }
            fileImpl = ((Entry)object).getFile();
            if (atomicReference != null) {
                atomicReference.set(fileImpl.getState());
            }
            projectBase = fileImpl.getProjectImpl(true);
            ProjectData projectData = this.getProjectData(projectBase, true);
            projectData.filesInQueue.remove(fileImpl);
            projectData.filesBeingParsed.add(fileImpl);
            boolean bl3 = bl2 = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
            if (bl2) {
                this.removeProjectData(projectBase);
            }
            boolean bl4 = bl = bl2 && projectData.notifyListeners;
            if (TraceFlags.TIMING && this.stopWatch != null && !this.stopWatch.isRunning()) {
                this.stopWatch.start();
                System.err.println("=== Starting parser queue stopwatch");
            }
        }
        ProgressSupport.instance().fireFileParsingStarted(fileImpl);
        if (bl2) {
            projectBase.onParseFinish();
            if (bl) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE_POLL) {
            System.err.printf("ParserQueue: polling %s with %d states in thread %s\n", ((Entry)object).getFile().getAbsolutePath(), ((Entry)object).getPreprocStates().size(), Thread.currentThread().getName());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileImpl fileImpl) {
        ProjectBase projectBase;
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl(true);
            ProjectData projectData = this.getProjectData(projectBase, true);
            if (projectData.filesInQueue.contains(fileImpl)) {
                Entry entry = this.findEntry(fileImpl);
                if (entry != null) {
                    this.queue.remove(entry);
                }
                projectData.filesInQueue.remove(fileImpl);
                boolean bl3 = bl = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
                if (bl) {
                    this.removeProjectData(projectBase);
                }
                bl2 = bl && projectData.notifyListeners;
            }
        }
        if (bl) {
            projectBase.onParseFinish();
            if (bl2) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: clearing");
        }
        ArrayList<ProjectBase> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.state = State.OFF;
            this.queue.clear();
            arrayList = new ArrayList<ProjectBase>(this.projectData.keySet());
            this.lock.notifyAll();
        }
        for (ProjectBase projectBase : arrayList) {
            ProgressSupport.instance().fireProjectParsingFinished(projectBase);
        }
    }

    public void startup() {
        this.state = State.ON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ProjectBase projectBase) {
        boolean bl;
        ProjectData projectData;
        Object object = this.lock;
        synchronized (object) {
            projectData = this.getProjectData(projectBase, true);
            for (Object e : projectData.filesInQueue) {
                Entry entry = this.findEntry((FileImpl)e);
                this.queue.remove(entry);
            }
            projectData.filesInQueue.clear();
            bl = projectData.filesBeingParsed.isEmpty();
            if (bl) {
                this.removeProjectData(projectBase);
            }
        }
        if (bl) {
            projectBase.onParseFinish();
            if (projectData.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsing(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, false);
            if (projectData != null) {
                return !projectData.filesBeingParsed.isEmpty();
            }
        }
        return false;
    }

    public boolean hasFiles(ProjectBase projectBase, FileImpl fileImpl) {
        return this.hasFiles(projectBase, fileImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFiles(ProjectBase projectBase, FileImpl fileImpl, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, bl);
            if (projectData == null || projectData.isEmpty()) {
                return false;
            }
            if (fileImpl == null) {
                return true;
            }
            if (projectData.filesBeingParsed.contains(fileImpl) || projectData.filesInQueue.contains(fileImpl)) {
                return projectData.filesBeingParsed.size() + projectData.filesInQueue.size() > 1;
            }
            return !projectData.isEmpty();
        }
    }

    private Set getProjectFiles(ProjectBase projectBase) {
        return this.getProjectData((ProjectBase)projectBase, (boolean)true).filesInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectData getProjectData(ProjectBase projectBase, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectBase projectBase2 = projectBase;
            ProjectData projectData = this.projectData.get(projectBase2);
            if (projectData == null && bl) {
                projectData = new ProjectData(false);
                this.projectData.put(projectBase2, projectData);
            }
            return projectData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectData(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            this.projectData.remove(projectBase);
        }
    }

    private boolean needEnqueue(FileImpl fileImpl) {
        return !fileImpl.isParsed() && !fileImpl.getProjectImpl(true).isDisposing() || this.addAlways;
    }

    public void onStartAddingProjectFiles(ProjectBase projectBase) {
        this.getProjectData((ProjectBase)projectBase, (boolean)true).notifyListeners = true;
        ProgressSupport.instance().fireProjectParsingStarted(projectBase);
    }

    public void onEndAddingProjectFiles(ProjectBase projectBase) {
        int n = this.getProjectFiles(projectBase).size();
        ProgressSupport.instance().fireProjectFilesCounted(projectBase, n);
        if (n == 0) {
            ProgressSupport.instance().fireProjectParsingFinished(projectBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFileParsingFinished(FileImpl fileImpl) {
        boolean bl;
        ProjectData projectData;
        ProjectBase projectBase;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl(true);
            projectData = this.getProjectData(projectBase, true);
            projectData.filesBeingParsed.remove(fileImpl);
            boolean bl3 = bl = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
            if (bl) {
                this.removeProjectData(projectBase);
                bl2 = this.projectData.isEmpty();
                if (TraceFlags.TIMING && this.stopWatch != null && this.stopWatch.isRunning()) {
                    this.stopWatch.stopAndReport("=== Stopping parser queue stopwatch: \t");
                }
            }
        }
        ProgressSupport.instance().fireFileParsingFinished(fileImpl);
        if (bl) {
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Last file in project " + projectBase.getName());
            }
            projectBase.onParseFinish();
            if (projectData.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
            if (bl2) {
                ProgressSupport.instance().fireIdle();
            }
            this.notifyWaitEmpty(projectBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitEmpty(ProjectBase projectBase) {
        Object object;
        Object object2 = this.projectLocks;
        synchronized (object2) {
            object = this.projectLocks.remove(projectBase);
        }
        if (object != null) {
            object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitEmpty(ProjectBase projectBase) {
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Waiting Empty Project " + projectBase.getName());
        }
        while (this.hasFiles(projectBase, null, false)) {
            Object object;
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Waiting Empty Project 2 " + projectBase.getName());
            }
            Object object2 = this.projectLocks;
            synchronized (object2) {
                object = this.projectLocks.get(projectBase);
                if (object == null) {
                    object = new String(((Object)projectBase.getName()).toString());
                    this.projectLocks.put(projectBase, object);
                }
            }
            object2 = object;
            synchronized (object2) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Finished waiting on Empty Project " + projectBase.getName());
        }
    }

    public long getStopWatchTime() {
        return TraceFlags.TIMING ? this.stopWatch.getTime() : -1L;
    }

    private String toString(PriorityQueue<Entry> priorityQueue, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : priorityQueue) {
            stringBuilder.append(entry.toString(bl)).append("\n");
        }
        return stringBuilder.toString();
    }

    private Entry findEntry(FileImpl fileImpl) {
        for (Entry entry : this.queue) {
            if (entry.getFile() != fileImpl) continue;
            return entry;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ON,
        OFF,
        SUSPENDED;

    }

    private static final class ProjectData {
        public Set filesInQueue = new HashSet();
        public Collection filesBeingParsed = new LinkedList();
        public boolean notifyListeners;

        ProjectData(boolean bl) {
            this.notifyListeners = bl;
        }

        public boolean isEmpty() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty();
        }

        public int size() {
            return this.filesInQueue.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileAction {
        NOTHING,
        MARK_MORE_PARSE,
        MARK_REPARSE,
        MARK_REPARSE_AND_INVALIDATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Comparable<Entry> {
        private FileImpl file;
        private Object ppState;
        private Position position;
        private int serial;

        private Entry(FileImpl fileImpl, Collection<APTPreprocHandler.State> collection, Position position, int n) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("creating entry for " + fileImpl.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(collection));
            }
            this.file = fileImpl;
            this.ppState = collection.size() == 1 ? collection.iterator().next() : new ArrayList<APTPreprocHandler.State>(collection);
            this.position = position;
            this.serial = n;
        }

        public FileImpl getFile() {
            return this.file;
        }

        public Collection<APTPreprocHandler.State> getPreprocStates() {
            Object object = this.ppState;
            if (object instanceof APTPreprocHandler.State || object == null) {
                return Collections.singleton((APTPreprocHandler.State)object);
            }
            return (Collection)object;
        }

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            this.position = position;
        }

        public void setSerial(int n) {
            this.serial = n;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ParserQueue.Entry " + this.file + " of project " + this.file.getProject());
            if (bl) {
                stringBuilder.append("\nposition: ").append((Object)this.position);
                stringBuilder.append(", serial: ").append(this.serial);
                stringBuilder.append("\nwith PreprocStates:");
                for (APTPreprocHandler.State state : this.getPreprocStates()) {
                    stringBuilder.append('\n');
                    stringBuilder.append(state);
                }
            }
            return stringBuilder.toString();
        }

        private synchronized void addStates(Collection<APTPreprocHandler.State> collection) {
            Object object;
            if (this.ppState instanceof APTPreprocHandler.State) {
                object = (APTPreprocHandler.State)this.ppState;
                this.ppState = new ArrayList();
                ((Collection)this.ppState).add(object);
            }
            object = (Collection)this.ppState;
            for (APTPreprocHandler.State state : collection) {
                if (state == FileImpl.DUMMY_STATE) continue;
                object.add(state);
            }
        }

        private synchronized void setStates(Collection<APTPreprocHandler.State> collection) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("setPreprocStateIfNeed for " + this.file.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(collection) + " with current " + ParserQueue.tracePreprocStates(this.getPreprocStates()));
            }
            this.ppState = new ArrayList<APTPreprocHandler.State>(collection);
        }

        @Override
        public int compareTo(Entry entry) {
            int n = this.position.compareTo(entry.position);
            if (n == 0) {
                n = this.serial - entry.serial;
                return this.position == Position.HEAD ? -n : n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        IMMEDIATE,
        HEAD,
        TAIL;

    }
}

