/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmVariable<T>,
Disposable {
    private final CharSequence name;
    private final CsmType type;
    private boolean _static = false;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final boolean _extern;
    private ExpressionBase initExpr;

    public VariableImpl(AST aST, CsmFile csmFile, CsmType csmType, String string, boolean bl) {
        this(aST, csmFile, csmType, string, null, bl);
    }

    public VariableImpl(AST aST, CsmFile csmFile, CsmType csmType, String string, CsmScope csmScope, boolean bl) {
        super(aST, csmFile);
        this.initInitialValue(aST);
        this._static = AstUtil.hasChildOfType(aST, 48);
        this._extern = AstUtil.hasChildOfType(aST, 35);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
        this.type = csmType;
        this._setScope(csmScope);
        if (bl) {
            this.registerInProject();
        }
    }

    public VariableImpl(CsmOffsetable csmOffsetable, CsmFile csmFile, CsmType csmType, String string, CsmScope csmScope, boolean bl, boolean bl2, boolean bl3) {
        super(csmFile, csmOffsetable);
        this._static = bl;
        this._extern = bl2;
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
        this.type = csmType;
        this._setScope(csmScope);
        if (bl3) {
            this.registerInProject();
        }
    }

    protected final void registerInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration((CsmDeclaration)this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmScope csmScope = this.getScope();
        if (csmScope instanceof CsmNamespace || csmScope instanceof CsmClass) {
            return CharSequenceKey.create((CharSequence)(((CsmQualifiedNamedElement)csmScope).getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        if (this.isExtern()) {
            return this.getQualifiedName() + " (EXTERN)";
        }
        return this.getQualifiedName();
    }

    public CsmType getType() {
        return this.type;
    }

    private final void initInitialValue(AST aST) {
        if (aST != null) {
            AST aST2;
            Object object;
            int n = 0;
            int n2 = 0;
            AST aST3 = AstUtil.findChildOfType(aST, 131);
            if (aST3 != null) {
                aST3 = aST3.getNextSibling();
            }
            if (aST3 != null && (object = AstUtil.getFirstCsmAST(aST3)) != null) {
                n = ((CsmAST)object).getOffset();
            }
            object = aST3;
            while (aST3 != null && aST3.getType() != 135) {
                object = aST3;
                aST3 = aST3.getNextSibling();
            }
            if (object != null && (aST2 = AstUtil.getLastChildRecursively((AST)object)) != null && aST2 instanceof CsmAST) {
                n2 = ((CsmAST)aST2).getEndOffset();
                this.initExpr = new ExpressionBase(n, n2, this.getContainingFile(), null, this._getScope());
            }
        }
    }

    public CsmExpression getInitialValue() {
        return this.initExpr;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE;
    }

    public String getDeclarationText() {
        return "";
    }

    public boolean isAuto() {
        return true;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean bl) {
        this._static = bl;
    }

    public boolean isExtern() {
        return this._extern;
    }

    public boolean isConst() {
        CsmType csmType = this.getType();
        if (csmType != null) {
            return csmType.isConst();
        }
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public void setScope(CsmScope csmScope) {
        this.unregisterInProject();
        this._setScope(csmScope);
        this.registerInProject();
    }

    public synchronized CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if (this._getScope() instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)this._getScope()).removeDeclaration(this);
        }
        this.unregisterInProject();
    }

    private synchronized void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public CsmVariableDefinition getDefinition() {
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.VARIABLE_DEFINITION) + ':' + this.getQualifiedName();
        CsmDeclaration csmDeclaration = this.getContainingFile().getProject().findDeclaration((CharSequence)string);
        return csmDeclaration == null ? null : (CsmVariableDefinition)csmDeclaration;
    }

    private CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    private void _setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public CharSequence getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        CsmType csmType = this.getType();
        if (csmType instanceof TypeImpl) {
            return ((TypeImpl)csmType).getText(false, this.getName()).toString();
        }
        if (csmType != null) {
            stringBuilder.append(csmType.getText());
            CharSequence charSequence = this.getName();
            if (charSequence != null && charSequence.length() > 0) {
                stringBuilder.append(' ');
                stringBuilder.append(charSequence);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeBoolean(this._static);
        dataOutput.writeBoolean(this._extern);
        PersistentUtils.writeExpression(this.initExpr, dataOutput);
        PersistentUtils.writeType(this.type, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public VariableImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this._static = dataInput.readBoolean();
        this._extern = dataInput.readBoolean();
        this.initExpr = (ExpressionBase)PersistentUtils.readExpression(dataInput);
        this.type = PersistentUtils.readType(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeRef = null;
    }

    @Override
    public String toString() {
        return (this.isExtern() ? "EXTERN " : "") + super.toString();
    }
}

