/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.SystemMacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroImpl
extends OffsetableIdentifiableBase<CsmMacro>
implements CsmMacro {
    private final CharSequence name;
    private final CharSequence body;
    private final boolean system;
    private final List<? extends CharSequence> params;

    public MacroImpl(String string, List<String> list, String string2, CsmOffsetable csmOffsetable) {
        this(string, list, string2, null, csmOffsetable);
    }

    private MacroImpl(String string, String string2, CsmFile csmFile) {
        this(string, null, string2, csmFile, Utils.createOffsetable(csmFile, 0, 0), true);
    }

    public static SystemMacroImpl createSystemMacro(String string, String string2, CsmFile csmFile) {
        return new SystemMacroImpl(string, string2, null, csmFile, false);
    }

    public MacroImpl(String string, List<String> list, String string2, CsmFile csmFile, CsmOffsetable csmOffsetable, boolean bl) {
        super(csmFile, csmOffsetable);
        assert (string != null);
        assert (string.length() > 0);
        assert (string2 != null);
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.system = bl;
        this.body = string2;
        this.params = list != null ? Collections.unmodifiableList(list) : null;
    }

    public MacroImpl(String string, List<String> list, String string2, CsmFile csmFile, CsmOffsetable csmOffsetable) {
        this(string, list, string2, csmFile, csmOffsetable, false);
    }

    public List<? extends CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.body;
    }

    public boolean isSystem() {
        return this.system;
    }

    public CharSequence getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.getParameters() != null) {
            stringBuilder.append("[");
            Iterator<? extends CharSequence> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = iterator.next();
                stringBuilder.append(charSequence);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        }
        if (this.getBody().length() > 0) {
            stringBuilder.append("'='");
            stringBuilder.append(this.getBody());
        }
        stringBuilder.append("' [");
        stringBuilder.append(this.getStartPosition()).append("-").append(this.getEndPosition());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof MacroImpl)) {
            bl = false;
        } else {
            MacroImpl macroImpl = (MacroImpl)object;
            bl = MacroImpl.equals(this, macroImpl);
        }
        return bl;
    }

    private static final boolean equals(MacroImpl macroImpl, MacroImpl macroImpl2) {
        return macroImpl.getStartOffset() == macroImpl2.getStartOffset() && CharSequenceKey.Comparator.compare(macroImpl.getName(), macroImpl2.getName()) == 0;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.getStartOffset();
        n = 31 * n + this.getName().hashCode();
        return n;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        assert (this.body != null);
        dataOutput.writeUTF(((Object)this.body).toString());
        dataOutput.writeBoolean(this.system);
        String[] stringArray = this.params == null ? null : this.params.toArray(new String[this.params.size()]);
        PersistentUtils.writeStrings(stringArray, dataOutput);
    }

    public MacroImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.body = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.body != null);
        this.system = dataInput.readBoolean();
        CharSequence[] charSequenceArray = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.params = charSequenceArray == null ? null : Collections.unmodifiableList(Arrays.asList(charSequenceArray));
    }

    @Override
    protected CsmUID createUID() {
        return UIDUtilities.createMacroUID(this);
    }
}

