/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.bracematch;

import java.util.Stack;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public class XMLBraceMatcher
implements BracesMatcher {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String DECLARATION_START = "<!DOCTYPE";
    private static final String DECLARATION_END = ">";
    int searchOffset;
    Document document;

    public XMLBraceMatcher(MatcherContext matcherContext) {
        this(matcherContext.getDocument(), matcherContext.getSearchOffset());
    }

    XMLBraceMatcher(Document document, int n) {
        this.document = document;
        this.searchOffset = n;
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        try {
            return this.doFindOrigin();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] doFindOrigin() throws InterruptedException, BadLocationException {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)abstractDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = XMLBraceMatcher.findTokenAtContext(tokenSequence, this.searchOffset);
            int n = tokenSequence.offset();
            if (token == null) {
                int[] nArray = null;
                return nArray;
            }
            XMLTokenId xMLTokenId = (XMLTokenId)token.id();
            switch (xMLTokenId) {
                case PI_START: 
                case PI_END: {
                    int[] nArray = new int[]{n, n + token.length()};
                    return nArray;
                }
                case TAG: {
                    if (DECLARATION_END.equals(((Object)tokenSequence.token().text()).toString())) {
                        while (tokenSequence.movePrevious() && tokenSequence.token().id() != XMLTokenId.TAG) {
                        }
                    }
                    int[] nArray = this.findTagPosition(tokenSequence);
                    return nArray;
                }
                case BLOCK_COMMENT: {
                    if (!((Object)token.text()).toString().startsWith(COMMENT_START) && !((Object)token.text()).toString().endsWith(COMMENT_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(tokenSequence, COMMENT_START, COMMENT_END);
                    return nArray;
                }
                case CDATA_SECTION: {
                    if (!((Object)token.text()).toString().startsWith(CDATA_START) && !((Object)token.text()).toString().endsWith(CDATA_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(tokenSequence, CDATA_START, CDATA_END);
                    return nArray;
                }
                case DECLARATION: {
                    if (!((Object)token.text()).toString().startsWith(DECLARATION_START) && !((Object)token.text()).toString().endsWith(DECLARATION_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(tokenSequence, DECLARATION_START, DECLARATION_END);
                    return nArray;
                }
            }
            return null;
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        try {
            return this.doFindMatches();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] doFindMatches() throws InterruptedException, BadLocationException {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)abstractDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = XMLBraceMatcher.findTokenAtContext(tokenSequence, this.searchOffset);
            if (token == null) {
                int[] nArray = null;
                return nArray;
            }
            XMLTokenId xMLTokenId = (XMLTokenId)token.id();
            switch (xMLTokenId) {
                case PI_START: {
                    int[] nArray = this.findMatchingPair(tokenSequence, XMLTokenId.PI_END, true);
                    return nArray;
                }
                case PI_END: {
                    int[] nArray = this.findMatchingPair(tokenSequence, XMLTokenId.PI_START, false);
                    return nArray;
                }
                case TAG: {
                    Object object;
                    if (DECLARATION_END.equals(((Object)tokenSequence.token().text()).toString())) {
                        while (tokenSequence.movePrevious() && tokenSequence.token().id() != XMLTokenId.TAG) {
                        }
                    }
                    if (((String)(object = (Object)((Object)tokenSequence.token().text()).toString())).startsWith("</")) {
                        int[] nArray = this.findMatchingTagBackward(tokenSequence, ((String)object).substring(2));
                        return nArray;
                    }
                    if (((String)object).startsWith("<")) {
                        int[] nArray = this.findMatchingTagForward(tokenSequence, ((String)object).substring(1));
                        return nArray;
                    }
                }
                case BLOCK_COMMENT: {
                    Object object = this.findGenericMatch(tokenSequence, COMMENT_START, COMMENT_END);
                    return object;
                }
                case CDATA_SECTION: {
                    int[] nArray = this.findGenericMatch(tokenSequence, CDATA_START, CDATA_END);
                    return nArray;
                }
                case DECLARATION: {
                    int[] nArray = this.findGenericMatch(tokenSequence, DECLARATION_START, DECLARATION_END);
                    return nArray;
                }
            }
            return null;
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    private static Token findTokenAtContext(TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        Token token = tokenSequence.token();
        if (token == null) {
            tokenSequence.moveNext();
            token = tokenSequence.token();
        }
        return token;
    }

    private int[] findTagPosition(TokenSequence tokenSequence) {
        if ("/>".equals(((Object)tokenSequence.token().text()).toString())) {
            return null;
        }
        Token token = tokenSequence.token();
        int n = tokenSequence.offset();
        int n2 = n + token.length();
        while (tokenSequence.moveNext()) {
            Token token2 = tokenSequence.token();
            n2 += token2.length();
            if (token2.id() != XMLTokenId.TAG) continue;
            if ("/>".equals(((Object)token2.text()).toString())) {
                return null;
            }
            if (DECLARATION_END.equals(((Object)token2.text()).toString())) {
                return new int[]{n, n2};
            }
            return new int[]{n, n + token.length()};
        }
        return null;
    }

    private int[] findMatchingPair(TokenSequence tokenSequence, XMLTokenId xMLTokenId, boolean bl) {
        while (bl ? tokenSequence.moveNext() : tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (token.id() == XMLTokenId.TAG) {
                return null;
            }
            if (token.id() != xMLTokenId) continue;
            int n = tokenSequence.offset();
            int n2 = n + token.length();
            return new int[]{n, n2};
        }
        return null;
    }

    private int[] findMatchingTagForward(TokenSequence tokenSequence, String string) {
        Stack<String> stack = new Stack<String>();
        while (tokenSequence.moveNext()) {
            String string2;
            Token token = tokenSequence.token();
            if (XMLTokenId.TAG != token.id() || DECLARATION_END.equals(string2 = ((Object)token.text()).toString())) continue;
            if (stack.empty()) {
                if (("</" + string).equals(string2)) {
                    return this.findTagPosition(tokenSequence);
                }
            } else if (string2.equals("/>") || ("</" + (String)stack.peek()).equals(string2)) {
                stack.pop();
                continue;
            }
            stack.push(string2.substring(1));
        }
        return null;
    }

    private int[] findMatchingTagBackward(TokenSequence tokenSequence, String string) {
        Stack<String> stack = new Stack<String>();
        while (tokenSequence.movePrevious()) {
            String string2;
            Token token = tokenSequence.token();
            if (XMLTokenId.TAG != token.id() || DECLARATION_END.equals(string2 = ((Object)token.text()).toString()) || "/>".equals(string2)) continue;
            if (stack.empty()) {
                if (("<" + string).equals(string2)) {
                    return this.findTagPosition(tokenSequence);
                }
            } else if (string2.startsWith("<") && ("<" + (String)stack.peek()).equals(string2)) {
                stack.pop();
            }
            if (!string2.startsWith("</")) continue;
            stack.push(string2.substring(2));
        }
        return null;
    }

    private int[] findGenericOrigin(TokenSequence tokenSequence, String string, String string2) {
        Token token = tokenSequence.token();
        int n = tokenSequence.offset();
        int n2 = n + string.length();
        if (((Object)token.text()).toString().startsWith(string) && n <= this.searchOffset && n2 > this.searchOffset) {
            return new int[]{n, n2};
        }
        n = tokenSequence.offset() + token.length() - string2.length();
        n2 = n + string2.length();
        if (((Object)token.text()).toString().endsWith(string2) && n <= this.searchOffset && n2 >= this.searchOffset) {
            return new int[]{n, n2};
        }
        return null;
    }

    private int[] findGenericMatch(TokenSequence tokenSequence, String string, String string2) {
        int n;
        Token token = tokenSequence.token();
        int n2 = n = tokenSequence.offset();
        int n3 = n2 + string.length();
        if (((Object)token.text()).toString().startsWith(string) && n2 <= this.searchOffset && n3 > this.searchOffset) {
            return this.findGenericMatchForward(tokenSequence, string2);
        }
        n2 = n + token.length() - string2.length();
        n3 = n2 + string2.length();
        if (((Object)token.text()).toString().endsWith(string2) && n2 <= this.searchOffset && n3 >= this.searchOffset) {
            return this.findGenericMatchBackward(tokenSequence, string);
        }
        return null;
    }

    private int[] findGenericMatchForward(TokenSequence tokenSequence, String string) {
        Token token = tokenSequence.token();
        int n = tokenSequence.offset() + token.length() - string.length();
        int n2 = n + string.length();
        if (((Object)token.text()).toString().endsWith(string)) {
            return new int[]{n, n2};
        }
        while (tokenSequence.moveNext()) {
            Token token2 = tokenSequence.token();
            if (token2.id() != token.id() || !((Object)token2.text()).toString().endsWith(string)) continue;
            n = tokenSequence.offset() + token2.length() - string.length();
            n2 = n + string.length();
            return new int[]{n, n2};
        }
        return null;
    }

    private int[] findGenericMatchBackward(TokenSequence tokenSequence, String string) {
        Token token = tokenSequence.token();
        int n = tokenSequence.offset();
        int n2 = n + string.length();
        if (((Object)token.text()).toString().startsWith(string)) {
            return new int[]{n, n2};
        }
        while (tokenSequence.movePrevious()) {
            Token token2 = tokenSequence.token();
            if (token2.id() != token.id() || !((Object)token2.text()).toString().startsWith(string)) continue;
            n = tokenSequence.offset();
            return new int[]{n, n + string.length()};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEndTag(Document document, int n, String string) {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)abstractDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = XMLBraceMatcher.findTokenAtContext(tokenSequence, n);
            Stack<String> stack = new Stack<String>();
            while (tokenSequence.moveNext()) {
                String string2;
                Token token2 = tokenSequence.token();
                if (XMLTokenId.TAG != token2.id() || DECLARATION_END.equals(string2 = ((Object)token2.text()).toString())) continue;
                if (stack.empty()) {
                    if (("</" + string).equals(string2)) {
                        stack.empty();
                        stack = null;
                        boolean bl = true;
                        return bl;
                    }
                } else if (string2.equals("/>") || ("</" + (String)stack.peek()).equals(string2)) {
                    stack.pop();
                    continue;
                }
                stack.push(string2.substring(1));
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
        return false;
    }
}

