/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.refactoring.FindWSDLUsageVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringElement;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringEngine;
import org.netbeans.modules.xml.wsdl.refactoring.xsd.FindSchemaUsageVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.xsd.SchemaUsageRefactoringEngine;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSDLRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
XMLRefactoringPlugin {
    List<ErrorItem> findErrors;
    RefactoringSession session;
    XMLRefactoringTransaction transaction;
    public static final String WSDL_MIME_TYPE = "text/x-wsdl+xml";

    public List<WSDLRefactoringElement> find(Referenceable referenceable, Component component) {
        if (referenceable instanceof Model) {
            return this.findUsages((Model)referenceable, component);
        }
        if (referenceable instanceof Component) {
            return this.findUsages((Component)referenceable, component);
        }
        return null;
    }

    public List<WSDLRefactoringElement> findUsages(Model model, Component component) {
        Object object;
        SchemaUsageRefactoringEngine schemaUsageRefactoringEngine;
        ArrayList<WSDLRefactoringElement> arrayList = new ArrayList<WSDLRefactoringElement>();
        if (model instanceof WSDLModel && component instanceof Definitions) {
            schemaUsageRefactoringEngine = (Definitions)component;
            object = ((WSDLModel)model).getDefinitions().getTargetNamespace();
            for (Import import_ : schemaUsageRefactoringEngine.getImports()) {
                WSDLModel wSDLModel = null;
                if (((String)object).equals(import_.getNamespace())) {
                    try {
                        wSDLModel = import_.getImportedWSDLModel();
                    }
                    catch (CatalogModelException catalogModelException) {
                        this.findErrors.add(new ErrorItem((Object)component, catalogModelException.getMessage()));
                    }
                }
                if (wSDLModel != model) continue;
                arrayList.add(new WSDLRefactoringElement(component.getModel(), (Referenceable)model, (Component)import_));
            }
        }
        if ((object = (schemaUsageRefactoringEngine = new SchemaUsageRefactoringEngine()).findUsages(model, component)) != null) {
            arrayList.addAll((Collection<WSDLRefactoringElement>)object);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return Collections.emptyList();
    }

    public List<WSDLRefactoringElement> findUsages(Component component, Component component2) {
        ArrayList<WSDLRefactoringElement> arrayList = new ArrayList<WSDLRefactoringElement>();
        List<WSDLRefactoringElement> list = null;
        if (component instanceof ReferenceableWSDLComponent && component2 instanceof Definitions && (list = new FindWSDLUsageVisitor().findUsages((ReferenceableWSDLComponent)component, (Definitions)component2)) != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        if (component instanceof ReferenceableSchemaComponent && component2 instanceof Definitions && (list = new FindSchemaUsageVisitor().findUsages((ReferenceableSchemaComponent)component, (Definitions)component2, this.session, this.transaction)) != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        if (arrayList.size() == 0) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public List<Model> getModels(List<WSDLRefactoringElement> list) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (WSDLRefactoringElement wSDLRefactoringElement : list) {
            arrayList.add(((Component)wSDLRefactoringElement.getLookup().lookup(Component.class)).getModel());
        }
        return arrayList;
    }

    public Set<Component> getSearchRoots(Referenceable referenceable) {
        HashSet<Component> hashSet = new HashSet<Component>();
        Set set = SharedUtils.getSearchFiles((Referenceable)referenceable);
        for (FileObject fileObject : set) {
            WSDLRefactoringEngine wSDLRefactoringEngine = new WSDLRefactoringEngine();
            try {
                Component component = wSDLRefactoringEngine.getSearchRoot(fileObject);
                hashSet.add(component);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(1, iOException.getMessage());
            }
        }
        return hashSet;
    }

    public Map<Model, Set<RefactoringElementImplementation>> getModelMap(List<RefactoringElementImplementation> list) {
        HashMap<Model, Set<RefactoringElementImplementation>> hashMap = new HashMap<Model, Set<RefactoringElementImplementation>>();
        for (RefactoringElementImplementation refactoringElementImplementation : list) {
            Object object;
            Component component = (Component)refactoringElementImplementation.getLookup().lookup(Component.class);
            Model model = null;
            if (component instanceof org.netbeans.modules.xml.schema.model.Import) {
                Component component2;
                object = (SchemaModel)component.getModel();
                if (object != null && (component2 = object.getSchema().getForeignParent()) != null) {
                    model = component2.getModel();
                }
            } else {
                model = component.getModel();
            }
            if (model == null) continue;
            object = (Set)hashMap.get(model);
            if (object == null) {
                object = new HashSet();
                object.add(refactoringElementImplementation);
                hashMap.put(model, (Set<RefactoringElementImplementation>)object);
                continue;
            }
            object.add(refactoringElementImplementation);
        }
        return hashMap;
    }

    public boolean isFatal(ErrorItem errorItem) {
        return errorItem.getLevel() == ErrorItem.Level.FATAL;
    }

    public Problem processErrors(List<ErrorItem> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Problem problem = null;
        Problem problem2 = null;
        Problem problem3 = null;
        for (ErrorItem errorItem : list) {
            if (problem == null) {
                problem2 = problem = new Problem(this.isFatal(errorItem), errorItem.getMessage());
                problem3 = problem;
                continue;
            }
            problem2 = new Problem(this.isFatal(errorItem), errorItem.getMessage());
            problem.setNext(problem2);
            problem = problem2;
        }
        return problem3;
    }

    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }

    public void setModelReference(Component component, String string) {
    }

    public Collection<Component> getExternalReferences(Model model) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (model instanceof WSDLModel) {
            arrayList.addAll(((WSDLModel)model).getDefinitions().getImports());
        }
        return arrayList;
    }

    public Model getModel(ModelSource modelSource) {
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (WSDL_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            return wSDLModel;
        }
        return null;
    }
}

