/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.html.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.html.lexer.HTMLLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HTMLTokenId implements TokenId
{
    TEXT("text"),
    SCRIPT("script"),
    STYLE("style"),
    WS("ws"),
    ERROR("error"),
    TAG_OPEN("tag"),
    TAG_CLOSE("tag"),
    ARGUMENT("argument"),
    OPERATOR("operator"),
    VALUE("value"),
    VALUE_JAVASCRIPT("value"),
    BLOCK_COMMENT("block-comment"),
    SGML_COMMENT("sgml-comment"),
    DECLARATION("sgml-declaration"),
    CHARACTER("character"),
    EOL("text"),
    TAG_OPEN_SYMBOL("tag"),
    TAG_CLOSE_SYMBOL("tag");

    private final String primaryCategory;
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final String STYLE_MIMETYPE = "text/x-css";
    private static final Language<HTMLTokenId> language;

    private HTMLTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public static Language<HTMLTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    static {
        language = new LanguageHierarchy<HTMLTokenId>(){

            protected Collection<HTMLTokenId> createTokenIds() {
                return EnumSet.allOf(HTMLTokenId.class);
            }

            protected Map<String, Collection<HTMLTokenId>> createTokenCategories() {
                return null;
            }

            protected Lexer<HTMLTokenId> createLexer(LexerRestartInfo<HTMLTokenId> lexerRestartInfo) {
                return new HTMLLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding embedding(Token<HTMLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                String string = null;
                switch ((HTMLTokenId)token.id()) {
                    case VALUE_JAVASCRIPT: {
                        string = HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        if (string == null) break;
                        Language language = Language.find((String)string);
                        if (language == null) {
                            return null;
                        }
                        PartType partType = token.partType();
                        int n = partType == PartType.COMPLETE || partType == PartType.START ? 1 : 0;
                        int n2 = partType == PartType.COMPLETE || partType == PartType.END ? 1 : 0;
                        return LanguageEmbedding.create((Language)language, (int)n, (int)n2, (boolean)true);
                    }
                    case SCRIPT: {
                        string = HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        break;
                    }
                    case STYLE: {
                        string = HTMLTokenId.STYLE_MIMETYPE;
                    }
                }
                if (string != null) {
                    Language language = Language.find((String)string);
                    if (language == null) {
                        return null;
                    }
                    return LanguageEmbedding.create((Language)language, (int)0, (int)0, (boolean)true);
                }
                return null;
            }

            protected String mimeType() {
                return "text/html";
            }
        }.language();
    }
}

