/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPU
extends ProfilerRuntime {
    private static final boolean DEBUG = false;
    private static int nProfiledThreadsLimit;
    protected static int nProfiledThreadsAllowed;
    protected static volatile boolean recursiveInstrumentationDisabled;
    protected static boolean absoluteTimerOn;
    protected static boolean threadCPUTimerOn;
    protected static boolean[] instrMethodInvoked;
    private static boolean javaLangReflectMethodInvokeInterceptEnabled;
    private static Method getRequestedSessionIdMethod;
    private static Method getMethodMethod;
    private static Method getServletPathMethod;

    public static long getAbsTimeStampInCollectedFormat() {
        return Timers.getCurrentTimeInCounts() & 0xFFFFFFFFFFFFFFL;
    }

    public static void setInstrMethodsInvoked(boolean[] blArray) {
        instrMethodInvoked = blArray;
    }

    public static void setJavaLangReflectMethodInvokeInterceptEnabled(boolean bl) {
        javaLangReflectMethodInvokeInterceptEnabled = bl;
    }

    public static void setNProfiledThreadsLimit(int n) {
        nProfiledThreadsLimit = nProfiledThreadsAllowed = n;
    }

    public static void setTimerTypes(boolean bl, boolean bl2) {
        String string;
        if (bl2 != threadCPUTimerOn && ((string = System.getProperty("os.name")).startsWith("SunOS") || string.startsWith("Solaris"))) {
            Timers.enableMicrostateAccounting((boolean)bl2);
        }
        absoluteTimerOn = bl;
        threadCPUTimerOn = bl2;
    }

    public static void createThreadInfoForCurrentThread() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        threadInfo.initialize();
        threadInfo.useEventBuffer();
        threadInfo.inCallGraph = false;
    }

    public static void handleJavaLangReflectMethodInvoke(Method method) {
        if (!javaLangReflectMethodInvokeInterceptEnabled) {
            return;
        }
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        externalActionsHandler.handleReflectiveInvoke(method);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void handleServletDoMethod(Object object) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized()) {
            System.out.println("No thread for servlet request");
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilerRuntimeCPU.servletDoMethodHook(threadInfo, object);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void resetProfilerCollectors() {
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    public static void resumeCurrentThreadTimer() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        ProfilerRuntimeCPU.writeAdjustTimeEvent(threadInfo, threadInfo.absEntryTime, threadInfo.threadEntryTime);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static ThreadInfo suspendCurrentThreadTimer() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return threadInfo;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        long l = Timers.getCurrentTimeInCounts();
        long l2 = Timers.getThreadCPUTimeInNanos();
        threadInfo.absEntryTime = l;
        threadInfo.threadEntryTime = l2;
        return threadInfo;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void copyLocalBuffer(ThreadInfo threadInfo) {
        byte[] byArray;
        long l = 0L;
        long l2 = 0L;
        if (eventBuffer == null) {
            return;
        }
        boolean bl = false;
        if (sendingBuffer) {
            l = Timers.getCurrentTimeInCounts();
            l2 = Timers.getThreadCPUTimeInNanos();
            byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            if (sendingBuffer) {
                System.err.println("*** Sanity check failed - sendingBuffer where should have been already sent");
            }
            bl = true;
            // MONITOREXIT : byArray
        }
        byArray = eventBuffer;
        // MONITORENTER : eventBuffer
        if (!threadInfo.isInitialized()) {
            // MONITOREXIT : byArray
            return;
        }
        int n = threadInfo.evBufPos;
        int n2 = threadInfo.evBufDumpLastPos;
        if (globalEvBufPos + n - n2 > globalEvBufPosThreshold) {
            sendingBuffer = true;
            if (!bl) {
                l = Timers.getCurrentTimeInCounts();
                l2 = Timers.getThreadCPUTimeInNanos();
                bl = true;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
        }
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 13;
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
        System.arraycopy(threadInfo.evBuf, n2, eventBuffer, globalEvBufPos, n - n2);
        globalEvBufPos += n - n2;
        threadInfo.evBufPos = 0;
        threadInfo.evBufDumpLastPos = 0;
        if (bl) {
            ProfilerRuntimeCPU.writeAdjustTimeEvent(threadInfo, l, l2);
        }
        // MONITOREXIT : byArray
    }

    protected static long currentTimeInCounts() {
        return Timers.getCurrentTimeInCounts();
    }

    protected static void enableProfiling(boolean bl) {
        recursiveInstrumentationDisabled = !bl;
    }

    protected static void monitorEntryCPU(Thread thread, Object object) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)22, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    protected static void monitorExitCPU(Thread thread, Object object) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)23, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    protected static void sleepEntryCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)24, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    protected static void sleepExitCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)25, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    protected static void waitEntryCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)20, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    protected static void waitExitCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)21, threadInfo);
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void writeAdjustTimeEvent(ThreadInfo threadInfo, long l, long l2) {
        byte[] byArray = threadInfo.evBuf;
        int n = threadInfo.evBufPos;
        if (n > ThreadInfo.evBufPosThreshold) {
            if (eventBuffer == null) {
                return;
            }
            byte[] byArray2 = eventBuffer;
            // MONITORENTER : eventBuffer
            n = threadInfo.evBufPos;
            boolean bl = false;
            int n2 = threadInfo.evBufDumpLastPos;
            if (globalEvBufPos + n - n2 > globalEvBufPosThreshold) {
                bl = true;
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 13;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
            System.arraycopy(byArray, n2, eventBuffer, globalEvBufPos, n - n2);
            globalEvBufPos += n - n2;
            threadInfo.evBufPos = 0;
            threadInfo.evBufDumpLastPos = 0;
            // MONITOREXIT : byArray2
        }
        n = threadInfo.evBufPos;
        byArray[n++] = 5;
        long l3 = Timers.getCurrentTimeInCounts() - l;
        byArray[n++] = (byte)(l3 >> 48 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 40 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 32 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 24 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 16 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 8 & 0xFFL);
        byArray[n++] = (byte)(l3 & 0xFFL);
        long l4 = Timers.getThreadCPUTimeInNanos() - l2;
        byArray[n++] = (byte)(l4 >> 48 & 0xFFL);
        byArray[n++] = (byte)(l4 >> 40 & 0xFFL);
        byArray[n++] = (byte)(l4 >> 32 & 0xFFL);
        byArray[n++] = (byte)(l4 >> 24 & 0xFFL);
        byArray[n++] = (byte)(l4 >> 16 & 0xFFL);
        byArray[n++] = (byte)(l4 >> 8 & 0xFFL);
        byArray[n++] = (byte)(l4 & 0xFFL);
        threadInfo.evBufPos = n;
    }

    static void writeServletDoMethod(ThreadInfo threadInfo, String string, String string2, String string3) {
        int n = threadInfo.evBufPos;
        int n2 = 2 + string2.length() * 2 + 4;
        if (n + n2 > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        int n3 = -1;
        int n4 = -1;
        if ("GET".equals(string)) {
            n3 = 1;
        } else if ("POST".equals(string)) {
            n3 = 2;
        } else if ("PUT".equals(string)) {
            n3 = 3;
        } else if ("DELETE".equals(string)) {
            n3 = 4;
        }
        if (string3 != null) {
            n4 = string3.hashCode();
        }
        byArray[n++] = 27;
        byArray[n++] = n3;
        byte[] byArray2 = string2.getBytes();
        int n5 = byArray2.length;
        byArray[n++] = (byte)(n5 >> 8 & 0xFF);
        byArray[n++] = (byte)(n5 & 0xFF);
        System.arraycopy(byArray2, 0, byArray, n, n5);
        n += n5;
        byArray[n++] = (byte)(n4 >> 24 & 0xFF);
        byArray[n++] = (byte)(n4 >> 16 & 0xFF);
        byArray[n++] = (byte)(n4 >> 8 & 0xFF);
        byArray[n++] = (byte)(n4 & 0xFF);
        threadInfo.evBufPos = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeThreadCreationEvent(ThreadInfo threadInfo) {
        Thread thread = threadInfo.thread;
        String string = thread.getName();
        String string2 = thread.getClass().getName();
        int n = (string.length() + string2.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + n > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 11;
            int n2 = threadInfo.getThreadId();
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n2 >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n2 & 0xFF);
            byte[] byArray2 = string.getBytes();
            int n3 = byArray2.length;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            byArray2 = string2.getBytes();
            n3 = byArray2.length;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    static void writeTimeStampedEvent(byte by, ThreadInfo threadInfo, char c) {
        long l;
        int n = threadInfo.evBufPos;
        if (n > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        if (!threadInfo.isInitialized()) {
            return;
        }
        byArray[n++] = by;
        byArray[n++] = (byte)(c >> 8 & 0xFF);
        byArray[n++] = (byte)(c & 0xFF);
        if (absoluteTimerOn || by < 6) {
            l = Timers.getCurrentTimeInCounts();
            byArray[n++] = (byte)(l >> 48 & 0xFFL);
            byArray[n++] = (byte)(l >> 40 & 0xFFL);
            byArray[n++] = (byte)(l >> 32 & 0xFFL);
            byArray[n++] = (byte)(l >> 24 & 0xFFL);
            byArray[n++] = (byte)(l >> 16 & 0xFFL);
            byArray[n++] = (byte)(l >> 8 & 0xFFL);
            byArray[n++] = (byte)(l & 0xFFL);
        }
        if (threadCPUTimerOn || by < 6) {
            l = Timers.getThreadCPUTimeInNanos();
            byArray[n++] = (byte)(l >> 48 & 0xFFL);
            byArray[n++] = (byte)(l >> 40 & 0xFFL);
            byArray[n++] = (byte)(l >> 32 & 0xFFL);
            byArray[n++] = (byte)(l >> 24 & 0xFFL);
            byArray[n++] = (byte)(l >> 16 & 0xFFL);
            byArray[n++] = (byte)(l >> 8 & 0xFFL);
            byArray[n++] = (byte)(l & 0xFFL);
        }
        threadInfo.evBufPos = n;
    }

    static void writeWaitTimeEvent(byte by, ThreadInfo threadInfo) {
        int n = threadInfo.evBufPos;
        if (n > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        byArray[n++] = by;
        long l = Timers.getCurrentTimeInCounts();
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        threadInfo.evBufPos = n;
    }

    private static void servletDoMethodHook(ThreadInfo threadInfo, Object object) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (getRequestedSessionIdMethod == null) {
            try {
                Class<?> clazz = object.getClass();
                getRequestedSessionIdMethod = clazz.getMethod("getRequestedSessionId", null);
                getMethodMethod = clazz.getMethod("getMethod", null);
                getServletPathMethod = clazz.getMethod("getServletPath", null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        try {
            string3 = (String)getRequestedSessionIdMethod.invoke(object, null);
            string2 = (String)getMethodMethod.invoke(object, null);
            string = (String)getServletPathMethod.invoke(object, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        ProfilerRuntimeCPU.writeServletDoMethod(threadInfo, string2, string, string3);
    }

    static {
        recursiveInstrumentationDisabled = false;
        javaLangReflectMethodInvokeInterceptEnabled = false;
    }
}

