/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support.managers;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.remote.support.RemoteScriptSupport;
import org.netbeans.modules.cnd.remote.support.managers.ScriptManager;

public class CompilerSetScriptManager
implements ScriptManager {
    private RemoteScriptSupport support;
    private BufferedReader in;
    private StringWriter out;
    private StringTokenizer st;
    private String platform;
    private static Logger log = Logger.getLogger("cnd.remote.logger");
    private static int emulateFailure = Integer.getInteger("cnd.remote.failure", 0);
    public static final String SCRIPT = ".netbeans/6.5/cnd2/scripts/getCompilerSets.bash";

    public void setSupport(RemoteScriptSupport remoteScriptSupport) {
        this.support = remoteScriptSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript() {
        if (!this.support.isFailedOrCancelled()) {
            ChannelExec channelExec = (ChannelExec)this.support.getChannel();
            channelExec.setInputStream(null);
            channelExec.setErrStream((OutputStream)System.err);
            try {
                String string;
                channelExec.connect();
                InputStream inputStream = channelExec.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(inputStream));
                this.out = new StringWriter();
                if (emulateFailure > 0) {
                    log.warning("CSSM.runScript: failure emulation [" + emulateFailure + "]");
                    this.support.setFailed("failure emulation in CompilerSetScriptManager");
                    --emulateFailure;
                    return;
                }
                this.platform = this.in.readLine();
                log.fine("CSSM.runScript: Reading input from getCompilerSets.bash");
                log.fine("    platform [" + this.platform + "]");
                while ((string = this.in.readLine()) != null) {
                    log.fine("    line [" + string + "]");
                    this.out.write(string + '\n');
                    this.out.flush();
                }
                this.in.close();
                inputStream.close();
                this.st = new StringTokenizer(this.out.toString());
            }
            catch (IOException iOException) {
                log.warning("CSSM.runScript: IOException [" + iOException.getMessage() + "]");
                this.support.setFailed(iOException.getMessage());
            }
            catch (JSchException jSchException) {
                log.warning("CSSM.runScript: JSchException");
                this.support.setFailed(jSchException.getMessage());
            }
            finally {
                this.support.disconnect();
            }
        }
    }

    public String getScript() {
        return SCRIPT;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasMoreCompilerSets() {
        return this.st != null && this.st.hasMoreTokens();
    }

    public String getNextCompilerSetData() {
        String string = this.st.nextToken();
        return string;
    }

    public String toString() {
        if (this.out != null) {
            return this.out.toString();
        }
        return "";
    }
}

